/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.finsubscribe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.formplugin.resource.CimFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevDetailCardPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        String fromDeposit = (String)this.getView().getFormShowParameter().getCustomParams().get("fromDeposit");
        if (EmptyUtil.isNoEmpty((String)fromDeposit)) {
            DecimalEdit control = (DecimalEdit)this.getControl("finamount");
            control.setCaption(new LocaleString(CimFormResourceEnum.RevDetailCardPlugin_2.loadKDString()));
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("intdetail_tag")) {
            this.loanIntDetailInfo(customParams);
        } else if (customParams.containsKey("RevEstimateReport")) {
            this.revEstimateDetailInfo(customParams);
        } else {
            this.loanIntRevenueDetailInfo(customParams);
        }
    }

    private void loanIntDetailInfo(Map<String, Object> customParams) {
        Object currency = customParams.get("currency");
        String callIntStr = (String)customParams.get("intdetail_tag");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        details.sort(new Comparator<IntBillDetailInfo>(){

            @Override
            public int compare(IntBillDetailInfo arg0, IntBillDetailInfo arg1) {
                return arg0.getBeginDate().compareTo(arg1.getBeginDate());
            }
        });
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("startdate", intDetail.getBeginDate());
            data.put("enddate", intDetail.getEndDate());
            data.put("days", intDetail.getDays());
            data.put("finamount", intDetail.getPrinciple());
            data.put("eplanrevenue", intDetail.getRate());
            data.put("currency", currency);
            data.put("convertdays", intDetail.getBasisDay());
            data.put("erevenueamount", intDetail.getAmount());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entryentity");
    }

    private void loanIntRevenueDetailInfo(Map<String, Object> customParams) {
        Object pkId = customParams.get("finBillId");
        Object revenueEntryId = customParams.get("revenueEntryId");
        String fromDeposit = (String)customParams.get("fromDeposit");
        DynamicObject finBillDO = EmptyUtil.isNoEmpty((String)fromDeposit) ? TmcDataServiceHelper.loadSingle((Object)pkId, (String)"cim_deposit") : TmcDataServiceHelper.loadSingle((Object)pkId, (String)CimEntityEnum.cim_finsubscribe.getValue());
        Object currencyId = finBillDO.getDynamicObject("currency").getPkValue();
        DynamicObjectCollection revenueEntrys = finBillDO.getDynamicObjectCollection("revenue_entry");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("startdate", new Object[0]);
        vs.addField("enddate", new Object[0]);
        vs.addField("days", new Object[0]);
        vs.addField("finamount", new Object[0]);
        vs.addField("eplanrevenue", new Object[0]);
        vs.addField("convertdays", new Object[0]);
        vs.addField("erevenueamount", new Object[0]);
        vs.addField("currency", new Object[0]);
        for (DynamicObject revenueEntry : revenueEntrys) {
            if (!StringUtils.equals((CharSequence)revenueEntry.getPkValue().toString(), (CharSequence)revenueEntryId.toString())) continue;
            DynamicObjectCollection revenueSubentrys = revenueEntry.getDynamicObjectCollection("revenue_subentry");
            for (DynamicObject revenueSubentry : revenueSubentrys) {
                vs.addRow(new Object[]{revenueSubentry.get("startdate"), revenueSubentry.get("enddate"), revenueSubentry.get("days"), revenueSubentry.get("finamount"), revenueSubentry.get("eplanrevenue"), revenueSubentry.get("convertdays"), revenueSubentry.get("erevenueamount"), currencyId});
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        if (vs.getCount() == 0) {
            if (EmptyUtil.isNoEmpty((String)fromDeposit)) {
                String tipMsg = finBillDO.getBoolean("handinstplan") ? CimFormResourceEnum.RevDetailCardPlugin_3.loadKDString() : CimFormResourceEnum.RevDetailCardPlugin_4.loadKDString();
                this.getView().showTipNotification(tipMsg);
            } else {
                this.getView().showTipNotification(CimFormResourceEnum.RevDetailCardPlugin_1.loadKDString());
            }
        }
    }

    private void revEstimateDetailInfo(Map<String, Object> customParams) {
        Object currency = customParams.get("currency");
        String callIntStr = (String)customParams.get("RevEstimateReport");
        if (EmptyUtil.isEmpty((String)callIntStr)) {
            return;
        }
        IntBillInfo intBillInfo = (IntBillInfo)SerializationUtils.fromJsonString((String)callIntStr, IntBillInfo.class);
        List details = intBillInfo.getDetails();
        ArrayList dataMap = new ArrayList(details.size());
        for (IntBillDetailInfo intDetail : details) {
            if (EmptyUtil.isEmpty((BigDecimal)intDetail.getPrinciple())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("startdate", intDetail.getBeginDate());
            data.put("enddate", intDetail.getEndDate());
            data.put("days", intDetail.getDays());
            data.put("finamount", intDetail.getPrinciple());
            data.put("eplanrevenue", intDetail.getRate());
            data.put("currency", currency);
            data.put("convertdays", intDetail.getBasisDay());
            data.put("erevenueamount", intDetail.getAmount());
            dataMap.add(data);
        }
        TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), dataMap);
        this.getView().updateView("entryentity");
    }
}

