/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.init;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositInitEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setHandLastRedeemDateMustInput();
        this.setHandLastRedeemDateRange("intdate", false);
        this.setHandLastRedeemDateRange("expiredate", true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field;
        switch (field = e.getProperty().getName()) {
            case "handredeemamt": {
                this.getModel().setValue("redeemamount", this.getModel().getValue("handredeemamt"));
                this.setSurplusamount();
                this.setHandLastRedeemDateMustInput();
                break;
            }
            case "handrevenueamt": {
                this.getModel().setValue("totalamount", this.getModel().getValue("handrevenueamt"));
                break;
            }
            case "handlastrevenuedate": {
                this.getModel().setValue("lastrevenuedate", this.getModel().getValue("handlastrevenuedate"));
                this.getModel().setValue("handendpredate", this.getModel().getValue("handlastrevenuedate"));
                break;
            }
            case "handendpredate": {
                this.getModel().setValue("endpreinstdate", this.getModel().getValue("handendpredate"));
                break;
            }
            case "intdate": {
                this.setHandLastRedeemDateRange("intdate", false);
                break;
            }
            case "expiredate": {
                this.setHandLastRedeemDateRange("expiredate", true);
                break;
            }
            case "handlastredeemdate": {
                this.getModel().setValue("lastredeemdate", this.getModel().getValue("handlastredeemdate"));
                break;
            }
            case "amount": {
                this.setSurplusamount();
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String field;
        switch (field = e.getKey()) {
            case "handendpredate": {
                this.validateHandEndPreDate(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "audit": 
            case "unaudit": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void validateHandEndPreDate(BeforeFieldPostBackEvent e) {
        Object newVal = e.getValue();
        Date handLstRevDate = (Date)this.getModel().getValue("handlastrevenuedate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{handLstRevDate, newVal})) {
            return;
        }
        if (DateUtils.stringToDate((String)String.valueOf(newVal), (String)"yyyy-MM-dd").compareTo(handLstRevDate) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u6b21\u9884\u63d0\u7ed3\u675f\u65e5(\u521d\u59cb\u5316)\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u6b21\u6536\u76ca\u65e5(\u521d\u59cb\u5316)\u3002", (String)"FinSubscribeInitEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(e.getKey());
        }
    }

    private void setHandLastRedeemDateMustInput() {
        BigDecimal handRedeemAmt = (BigDecimal)this.getModel().getValue("handredeemamt");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)EmptyUtil.isNoEmpty((BigDecimal)handRedeemAmt), (String[])new String[]{"handlastredeemdate"});
    }

    private void setHandLastRedeemDateRange(String fieldProp, boolean isUp) {
        Date limitDate = (Date)this.getModel().getValue(fieldProp);
        if (EmptyUtil.isEmpty((Object)limitDate)) {
            return;
        }
        DateEdit dateControl = (DateEdit)this.getControl("handlastredeemdate");
        if (isUp) {
            dateControl.setMaxDate(limitDate);
        } else {
            dateControl.setMinDate(limitDate);
        }
    }

    private void setSurplusamount() {
        BigDecimal depAmt = Optional.ofNullable((BigDecimal)this.getModel().getValue("amount")).orElse(BigDecimal.ZERO);
        BigDecimal rerAmt = Optional.ofNullable((BigDecimal)this.getModel().getValue("handredeemamt")).orElse(BigDecimal.ZERO);
        BigDecimal surpAmt = depAmt.subtract(rerAmt);
        this.getModel().setValue("surplusamount", (Object)(surpAmt.compareTo(BigDecimal.ZERO) > 0 ? surpAmt : BigDecimal.ZERO));
    }
}

