/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.intbatch;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.PreIntOperateTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public abstract class AbstractNavigateAddPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CALCINTRESULT = "calcIntResult";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"finbillno"});
        BasedataEdit org = (BasedataEdit)this.getControl("company");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String baseField;
        switch (baseField = evt.getProperty().getName()) {
            case "company": {
                this.setOrgFilter(evt);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterView();
    }

    public void initFilterView() {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object initParams = customParam.get("initParams");
        if (EmptyUtil.isNoEmpty(initParams)) {
            Map params = (Map)initParams;
            if (params.containsKey("settlecenterdpt")) {
                this.getModel().setValue("settlecenterdpt", params.get("settlecenterdpt"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenterdpt"});
                this.getView().updateView("settlecenterdpt");
                if (Boolean.parseBoolean(params.get("settlecenterdpt").toString()) && params.containsKey("settlecenter")) {
                    this.getModel().setValue("settlecenter", params.get("settlecenter"));
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenter"});
                    this.getView().updateView("settlecenter");
                }
            }
            if ("ifm_depositprebatch".equals(this.getView().getParentView().getEntityId())) {
                this.getModel().setValue("settlecenter", params.get("settlecenter"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settlecenter"});
                this.getView().updateView("settlecenter");
            }
            if (params.containsKey("endintdate")) {
                this.getModel().setValue("endintdate", (Object)DateUtils.stringToDate((String)((String)params.get("endintdate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"endintdate"});
                this.getView().updateView("endintdate");
            }
            if (params.containsKey("revenuedate")) {
                this.getModel().setValue("endintdate", (Object)DateUtils.stringToDate((String)((String)params.get("revenuedate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"endintdate"});
                this.getView().updateView("endintdate");
            }
            if (params.containsKey("orgs")) {
                Set orgs = (Set)SerializationUtils.fromJsonString((String)params.get("orgs").toString(), Set.class);
                this.getModel().setValue("company", (Object)orgs.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("company");
            }
            if (params.containsKey("currencys")) {
                Set currencys = (Set)SerializationUtils.fromJsonString((String)params.get("currencys").toString(), Set.class);
                this.getModel().setValue("currency", (Object)currencys.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("currency");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String chgPropName;
        super.propertyChanged(e);
        switch (chgPropName = e.getProperty().getName()) {
            case "company": {
                this.setBaseCurrency();
                this.getModel().setValue("finbillno", null);
                break;
            }
            case "currency": 
            case "endintdate": {
                FormShowParameter showParameter = this.getView().getFormShowParameter();
                Map paraMap = showParameter.getCustomParams();
                Object depositId = paraMap.get("loanbill");
                if (!EmptyUtil.isEmpty(depositId)) break;
                this.getModel().setValue("finbillno", null);
                this.getPageCache().remove("finbill");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Control && "finbillno".equals(key = ((Control)evt.getSource()).getKey())) {
            if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"endintdate")) {
                return;
            }
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)this.chooseOpenFinBillId(), (boolean)true, (int)0, (boolean)true);
            parameter.getListFilterParameter().getQFilters().add(this.setOpenFinBillFilter());
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "finbill"));
            parameter.setCustomParam("dataInclude", (Object)"fixedAndNotice");
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next")) {
            if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"endintdate", "finbillno"})) {
                args.setCancel(true);
                return;
            }
            Map<Object, IntBillInfo> intMap = this.calcInterest();
            this.validateExistsDoingBatch(args, intMap, this.getFunction());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (StringUtils.equals((CharSequence)"next", (CharSequence)evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            Map<String, Object> valMap = this.buildReturnData();
            this.getView().returnDataToParent(valMap);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
        if (StringUtils.equals((CharSequence)"finbill", (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)selectedRow)) {
            List billIds = selectedRow.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            List billnos = selectedRow.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
            this.getModel().setValue("finbillno", (Object)String.join((CharSequence)";", billnos));
            this.getPageCache().put("finbill", SerializationUtils.toJsonString(billIds));
        }
    }

    private void setBaseCurrency() {
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            List collect = company.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            HashSet currId = new HashSet(2);
            for (Long orgId : collect) {
                Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
                currId.add(result.get("baseCurrencyID"));
            }
            DynamicObject[] currencys = TmcDataServiceHelper.load((Object[])currId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
            DynamicObjectCollection currencyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])currencys);
            this.getModel().setValue("currency", (Object)currencyColls);
        }
    }

    protected abstract String chooseOpenFinBillId();

    protected abstract String chooseBatchPreFormId();

    protected abstract Date getStartIntDate(DynamicObject var1);

    protected abstract String getFunction();

    protected QFilter setOpenFinBillFilter() {
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    protected void validateExistsDoingBatch(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> intMap, String type) {
        String functionMsg = "";
        if ("preint".equals(type)) {
            functionMsg = ResManager.loadKDString((String)"\u9884\u63d0", (String)"AbstractNavigateAddPlugin_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
        } else if ("getint".equals(type)) {
            functionMsg = ResManager.loadKDString((String)"\u6536\u76ca", (String)"AbstractNavigateAddPlugin_2", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
        }
        if (EmptyUtil.isEmpty(intMap) || intMap.size() == 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef%s\u7684\u6570\u636e\u3002", (String)"AbstractNavigateAddPlugin_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]), functionMsg));
            args.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        if ("preint".equals(type)) {
            qFilter.and("operatetype", "=", (Object)PreIntOperateTypeEnum.PREINT.getValue());
        }
        qFilter.and("entry.loanbillid", "in", intMap.keySet());
        Map waiteHandleBillMap = TmcDataServiceHelper.loadFromCache((String)this.chooseBatchPreFormId(), (QFilter[])qFilter.toArray());
        if (waiteHandleBillMap.size() > 0) {
            StringJoiner errorBuilder = new StringJoiner("\n");
            HashMap<String, String> loanNumMap = new HashMap<String, String>(waiteHandleBillMap.size());
            for (Map.Entry entry : waiteHandleBillMap.entrySet()) {
                DynamicObject waiteHandleBill = (DynamicObject)entry.getValue();
                String batchNo = waiteHandleBill.getString("billno");
                DynamicObjectCollection entrys = waiteHandleBill.getDynamicObjectCollection("entry");
                for (DynamicObject entryObj : entrys) {
                    if (!intMap.containsKey(entryObj.getLong("loanbillid"))) continue;
                    if ("cim_dptrevenuebatch".equals(this.chooseBatchPreFormId())) {
                        loanNumMap.put(entryObj.getString("loanbillno"), batchNo);
                        continue;
                    }
                    loanNumMap.put(entryObj.getString("loannum"), batchNo);
                }
            }
            for (Map.Entry entry : loanNumMap.entrySet()) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u5355%1$s\u5728\u6279\u91cf%2$s\u5904\u7406\u5355%3$s\u4e2d\u5b58\u5728\u6b63\u5728\u5904\u7406\u7684%4$s\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractNavigateAddPlugin_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]), entry.getKey(), functionMsg, entry.getValue(), functionMsg);
                errorBuilder.add(errorMsg);
            }
            this.getView().showErrorNotification(errorBuilder.toString());
            args.setCancel(true);
            return;
        }
        this.getPageCache().put(CALCINTRESULT, JSON.toJSONString(intMap));
    }

    protected Map<Object, IntBillInfo> calcInterest() {
        DynamicObject[] finBills;
        List finBillIds;
        HashMap<Object, IntBillInfo> finMap = new HashMap<Object, IntBillInfo>(16);
        String idsCache = this.getPageCache().get("finbill");
        if (EmptyUtil.isEmpty((String)idsCache)) {
            QFilter qFilter = this.setOpenFinBillFilter();
            finBillIds = QueryServiceHelper.queryPrimaryKeys((String)this.chooseOpenFinBillId(), (QFilter[])qFilter.toArray(), (String)"", (int)-1);
        } else {
            finBillIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("finbill"), List.class);
        }
        if (EmptyUtil.isEmpty((Collection)finBillIds)) {
            return finMap;
        }
        Date endIntDate = (Date)this.getModel().getValue("endintdate");
        for (DynamicObject finBill : finBills = TmcDataServiceHelper.load((Object[])finBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.chooseOpenFinBillId()))) {
            IntBillInfo intBillInfo;
            Date lastRedeemDate = finBill.getDate("lastredeemdate");
            if (FinServiceStatusEnum.isSubscribeNorevenue((String)finBill.getString("bizstatus")) && EmptyUtil.isNoEmpty((Object)lastRedeemDate)) {
                endIntDate = lastRedeemDate;
            }
            if ((intBillInfo = this.calInterest(finBill, endIntDate)) == null || !EmptyUtil.isNoEmpty((BigDecimal)intBillInfo.getAmount())) continue;
            finMap.put(finBill.getPkValue(), intBillInfo);
        }
        return finMap;
    }

    private IntBillInfo calInterest(DynamicObject finBill, Date endIntDate) {
        Date beginDate = this.getStartIntDate(finBill);
        if (EmptyUtil.isNoEmpty((Object)beginDate) && endIntDate.compareTo(beginDate) <= 0) {
            return null;
        }
        return DepositHelper.calcDepositBillInt((DynamicObject)finBill, (Date)beginDate, (Date)endIntDate);
    }

    protected Map<String, Object> buildReturnData() {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put("company", this.getModel().getValue("company"));
        valMap.put("currency", this.getModel().getValue("currency"));
        Date endDate = (Date)this.getModel().getValue("endintdate");
        valMap.put("endintdate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
        valMap.put(CALCINTRESULT, this.getPageCache().get(CALCINTRESULT));
        valMap.put("operatetype", PreIntOperateTypeEnum.PREINT.getValue());
        valMap.put("formid", "cim_depositprebatch");
        return valMap;
    }

    private void setOrgFilter(BeforeF7SelectEvent evt) {
        List authOrgIds;
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        String formId = this.getView().getParentView().getEntityId();
        if (this.getView().getParentView() instanceof IListView) {
            formId = ((IListView)this.getView().getParentView()).getBillFormId();
        }
        if (EmptyUtil.isEmpty((Collection)(authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)formId, (String)"47150e89000000ac")))) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
        } else {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)authOrgIds));
        }
    }
}

