/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.intbatch;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.OperaTypeEnum;
import kd.tmc.cim.common.helper.IntBillBatchHelper;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class IntNavAddNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(IntNavAddNewPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"finbillno"});
        BasedataEdit company = (BasedataEdit)this.getControl("company");
        company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterView();
    }

    public void initFilterView() {
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        Object initParams = customParam.get("initParams");
        if (EmptyUtil.isNoEmpty(initParams)) {
            Map params = (Map)initParams;
            if (params.containsKey("endintdate")) {
                this.getModel().setValue("endintdate", (Object)DateUtils.stringToDate((String)((String)params.get("endintdate")), (String)"yyyy-MM-dd"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"endintdate"});
                this.getView().updateView("endintdate");
            }
            if (params.containsKey("orgs")) {
                Set orgs = (Set)SerializationUtils.fromJsonString((String)params.get("orgs").toString(), Set.class);
                this.getModel().setValue("company", (Object)orgs.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("company");
            }
            if (params.containsKey("currencys")) {
                Set currencys = (Set)SerializationUtils.fromJsonString((String)params.get("currencys").toString(), Set.class);
                this.getModel().setValue("currency", (Object)currencys.stream().map(s -> Long.parseLong(s.toString())).toArray());
                this.getView().updateView("currency");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String chgPropName;
        super.propertyChanged(e);
        switch (chgPropName = e.getProperty().getName()) {
            case "company": {
                this.setBaseCurrency();
                this.getModel().setValue("finbillno", null);
                break;
            }
            case "currency": 
            case "endintdate": {
                this.getModel().setValue("finbillno", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String baseField;
        switch (baseField = evt.getProperty().getName()) {
            case "company": {
                this.setOrgFilter(evt);
                break;
            }
        }
    }

    private void setBaseCurrency() {
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            List collect = company.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            HashSet currId = new HashSet(2);
            for (Long orgId : collect) {
                Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
                currId.add(result.get("baseCurrencyID"));
            }
            DynamicObject[] currencys = TmcDataServiceHelper.load((Object[])currId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
            DynamicObjectCollection currencyColls = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])currencys);
            this.getModel().setValue("currency", (Object)currencyColls);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Control && "finbillno".equals(key = ((Control)evt.getSource()).getKey())) {
            if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"company", "currency", "endintdate"})) {
                return;
            }
            this.showFinBillF7();
        }
    }

    private void showFinBillF7() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)CimEntityEnum.cim_finsubscribe.getValue(), (boolean)true, (int)0, (boolean)true);
        parameter.getListFilterParameter().getQFilters().add(this.getFinBillsQfilter());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "finbill"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private QFilter getFinBillsQfilter() {
        List<String> finStatus = Arrays.asList(FinServiceStatusEnum.subscribe_done.getValue(), FinServiceStatusEnum.subscribe_part.getValue());
        QFilter qFilter = new QFilter("finservicestatus", "in", finStatus);
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        List companyIds = company.stream().map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
        qFilter.and("org", "in", companyIds);
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        Set ids = currency.stream().map(c -> c.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        qFilter.and("currency", "in", ids);
        Date endintdate = (Date)this.getModel().getValue("endintdate");
        qFilter.and(QFilter.isNotNull((String)"lastpayinstdate").and("lastpayinstdate", "<", (Object)DateUtils.getLastDay((Date)endintdate, (int)1)).or(QFilter.isNull((String)"lastpayinstdate").and("intdate", "<=", (Object)DateUtils.getLastDay((Date)endintdate, (int)1))).or(QFilter.isNull((String)"lastpayinstdate").and(QFilter.isNull((String)"intdate").and("valuedate", "<=", (Object)DateUtils.getLastDay((Date)endintdate, (int)1)))));
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qFilter.and("id", "not in", loanIds);
        }
        logger.info("Qfilter=============" + qFilter);
        return qFilter;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
        if (StringUtils.equals((CharSequence)"finbill", (CharSequence)actionId) && EmptyUtil.isNoEmpty((Object)selectedRow)) {
            List billIds = selectedRow.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            List billnos = selectedRow.stream().map(ListSelectedRow::getBillNo).collect(Collectors.toList());
            this.getModel().setValue("finbillno", (Object)String.join((CharSequence)";", billnos));
            this.getPageCache().put("finbill", SerializationUtils.toJsonString(billIds));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("next")) {
            Map<Object, IntBillInfo> calcInterests = this.calcInterest();
            this.validate(args, calcInterests);
            if (!args.isCancel()) {
                this.getPageCache().put("calcIntResult", JSON.toJSONString(calcInterests));
            }
        }
    }

    protected void validate(BeforeDoOperationEventArgs args, Map<Object, IntBillInfo> calcInterests) {
        if (null == calcInterests || calcInterests.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u9884\u63d0\u7684\u6570\u636e\u3002", (String)"IntNavAddNewPlugin_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List intObjectIds = calcInterests.keySet().stream().map(intBillInfo -> ((DynamicObject)DynamicObjectSerializeUtil.deserialize((String)intBillInfo.toString(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CimEntityEnum.cim_finsubscribe.getValue()))[0]).getPkValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("operatype", "=", (Object)OperaTypeEnum.INTERESTREV.getValue());
        qFilter.and("entry.finbillid", "in", intObjectIds);
        Map waiteHandleBillMap = TmcDataServiceHelper.loadFromCache((String)"cim_intbill_batch", (QFilter[])qFilter.toArray());
        if (waiteHandleBillMap.size() > 0) {
            StringJoiner intObjectNumbers = new StringJoiner(",");
            for (Map.Entry entry : waiteHandleBillMap.entrySet()) {
                DynamicObject waiteHandleBill = (DynamicObject)entry.getValue();
                DynamicObjectCollection rows = waiteHandleBill.getDynamicObjectCollection("entry");
                rows.forEach(v -> intObjectNumbers.add(v.getString("finbillno")));
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728%s\u6b63\u5728\u5904\u7406\u7684\u9884\u63d0\u64cd\u4f5c\uff0c\u8bf7\u5148\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"IntNavAddNewPlugin_2", (String)"tmc-cim-formplugin", (Object[])new Object[]{intObjectNumbers}));
            args.setCancel(true);
        }
    }

    protected Map<Object, IntBillInfo> calcInterest() {
        List finBillIds;
        HashMap<Object, IntBillInfo> finInt = new HashMap<Object, IntBillInfo>(16);
        if (this.getPageCache().getAll().containsKey("finbill")) {
            finBillIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("finbill"), List.class);
        } else {
            DynamicObject[] intCallFins = this.getIntCallFins();
            finBillIds = Arrays.stream(intCallFins).map(row -> row.getLong("id")).collect(Collectors.toList());
        }
        Date endIntDate = (Date)this.getModel().getValue("endintdate");
        for (Object finBillId : finBillIds) {
            DynamicObject finBill = TmcDataServiceHelper.loadSingle(finBillId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CimEntityEnum.cim_finsubscribe.getValue()));
            Date beginDate = IntNavAddNewPlugin.getStartIntDate(finBill);
            if (!EmptyUtil.isEmpty((Object)beginDate) && endIntDate.compareTo(beginDate) <= 0) continue;
            IntBillInfo callInt = RevenueCalcHelper.callInt((Long)Long.valueOf(finBillId.toString()), (Date)beginDate, (Date)endIntDate);
            String mapKey = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{finBill}, (DynamicObjectType)finBill.getDynamicObjectType());
            if (!EmptyUtil.isNoEmpty((Object)callInt)) continue;
            finInt.put(mapKey, callInt);
        }
        return finInt;
    }

    public static Date getStartIntDate(DynamicObject finBill) {
        boolean isAutoRed = IntBillBatchHelper.isAutoWriteRed((DynamicObject)finBill);
        if (isAutoRed) {
            Date startDate = Optional.ofNullable(finBill.getDate("endinstdate")).map(r -> DateUtils.getNextDay((Date)r, (int)1)).orElseGet(() -> finBill.getDate("intdate"));
            return Optional.ofNullable(startDate).orElseGet(() -> finBill.getDate("valuedate"));
        }
        Date lastPayinstDate = finBill.getDate("lastpayinstdate");
        Date intDate = finBill.getDate("intdate");
        if (EmptyUtil.isNoEmpty((Object)lastPayinstDate)) {
            return DateUtils.getNextDay((Date)lastPayinstDate, (int)1);
        }
        if (EmptyUtil.isEmpty((Object)lastPayinstDate) && EmptyUtil.isNoEmpty((Object)intDate)) {
            return intDate;
        }
        return finBill.getDate("valuedate");
    }

    public DynamicObject[] getIntCallFins() {
        QFilter filter = this.getFinBillsQfilter();
        return TmcDataServiceHelper.load((String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"id,org,billno,currency,endinstdate,lastpayinstdate,intdate,valuedates,productfactory", (QFilter[])filter.toArray());
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (StringUtils.equals((CharSequence)"next", (CharSequence)evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            Map<String, Object> valMap = this.getNavFilterMap();
            this.getView().returnDataToParent(valMap);
            this.getView().close();
        }
    }

    protected Map<String, Object> getNavFilterMap() {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put("company", this.getModel().getValue("company"));
        valMap.put("currency", this.getModel().getValue("currency"));
        Date endDate = (Date)this.getModel().getValue("endintdate");
        valMap.put("endintdate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
        valMap.put("calcIntResult", this.getPageCache().get("calcIntResult"));
        return valMap;
    }

    private void setOrgFilter(BeforeF7SelectEvent evt) {
        List authOrgIds;
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String appId = this.getView().getFormShowParameter().getAppId();
        String formId = this.getView().getParentView().getEntityId();
        if (this.getView().getParentView() instanceof IListView) {
            formId = ((IListView)this.getView().getParentView()).getBillFormId();
        }
        if (EmptyUtil.isEmpty((Collection)(authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)formId, (String)"47150e89000000ac")))) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
        } else {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)authOrgIds));
        }
    }
}

