/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.online;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.helper.OnlineServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.dync.AbstractTmcDyncListPlugin;

public abstract class AbstractOnlineList
extends AbstractTmcDyncListPlugin
implements HyperLinkClickListener {
    protected FilterContainerInitArgs initArgs;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entrysGrid = (EntryGrid)this.getControl("entryentity");
        entrysGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void filterContainerInit(FilterContainerInitEvent event) {
        this.initArgs = new FilterContainerInitArgs(event);
        if (EmptyUtil.isEmpty((String)this.getPageCache().get("isFirstInit"))) {
            this.getPageCache().put("isFirstInit", "true");
            this.initFilterItem();
            this.fillPageData();
        }
    }

    public void filterSearchClickEvent(SearchClickEvent event) {
        super.filterSearchClickEvent(event);
        this.initFilterItem();
        this.getPageCache().remove("qfilters");
        Map filterMap = event.getFilterValues();
        List<String> commonFilterColumns = this.getCommonFilterColumns();
        List filterJsonList = OnlineServiceHelper.getDynamicListFilters((Map)filterMap, commonFilterColumns);
        if (EmptyUtil.isNoEmpty((Object)filterJsonList)) {
            this.getPageCache().put("qfilters", SerializationUtils.toJsonString((Object)filterJsonList));
        }
        this.fillPageData();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"billno")) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", evt.getRowIndex());
            BillShowParameter parameter = new BillShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setFormId(this.getEntityName());
            parameter.setPkId((Object)entryRowEntity.getLong("id"));
            parameter.setCaption(this.getEntityCaption());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"modifystatus", (CharSequence)operateKey)) {
            this.validateBeforeModifyStatus(args);
        } else if (StringUtils.equals((CharSequence)"syncstatus", (CharSequence)operateKey)) {
            List selectedIdList = this.getSelectedIdList();
            if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
                args.setCancel(true);
                return;
            }
            operate.getOption().setVariableValue("selectRowId", SerializationUtils.toJsonString((Object)selectedIdList.toArray(new Long[0])));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"refresh")) {
            this.fillPageData();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"modifystatus") && eventArgs.getOperationResult().isSuccess()) {
            this.showModifyPage();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"syncstatus") && eventArgs.getOperationResult().isSuccess()) {
            this.refreshData();
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"modifyrecord") && eventArgs.getOperationResult().isSuccess()) {
            this.showModifyRecord();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (StringUtils.equals((CharSequence)"CLOASECALLBACKID_MODIFYSTATUS", (CharSequence)event.getActionId())) {
            this.refreshData();
        }
    }

    protected void fillPageData() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("bebankstatus", "in", (Object)new String[]{BebankStatusEnum.OS.getValue(), BebankStatusEnum.BP.getValue(), BebankStatusEnum.TS.getValue(), BebankStatusEnum.TF.getValue(), BebankStatusEnum.NC.getValue()}));
        qFilters.add(this.getInvestTypeQFilter());
        if (!CollectionUtils.isEmpty((Collection)this.getQFilterFromPagCache())) {
            qFilters.addAll(this.getQFilterFromPagCache());
        }
        List permOrgList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getEntityName(), (String)"47150e89000000ac");
        qFilters.add(new QFilter(this.getBillMainBizeOrg(), "in", (Object)permOrgList));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"currentToFixedQuery", (String)this.getEntityName(), (String)String.join((CharSequence)",", this.getQueryAttributes()), (QFilter[])qFilters.toArray(new QFilter[0]), (String)"submittime desc");
        this.batchInsertListData(dataSet);
    }

    protected void initFilterItem() {
        this.modifyFilterCaption();
        IPageCache pageCache = this.getPageCache();
        ArrayList<String> filterJsonList = new ArrayList<String>();
        this.initArgs.getFilterContainerInitEvent().getSchemeFilterColumns().clear();
        List commonFilterColumns = this.initArgs.getFilterContainerInitEvent().getCommonFilterColumns();
        commonFilterColumns.removeIf(v -> v.getFieldName().equals("bizdate"));
        for (FilterColumn filterColumn : commonFilterColumns) {
            QFilter subtimeFilter;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List defaultValues = commonFilterColumn.getDefaultValues();
            if (EmptyUtil.isEmpty((Collection)defaultValues)) continue;
            if (StringUtils.equals((CharSequence)(this.getBillMainBizeOrg() + ".name"), (CharSequence)fieldName)) {
                Object[] orgList = defaultValues.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.toString())).map(v -> Long.valueOf(v.toString())).toArray();
                filterJsonList.add(new QFilter(this.getBillMainBizeOrg() + ".id", "in", (Object)orgList).toSerializedString());
                continue;
            }
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"bebankstatus")) {
                filterJsonList.add(new QFilter("bebankstatus", "in", (Object)defaultValues).toSerializedString());
                continue;
            }
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"submittime") || !EmptyUtil.isNoEmpty((Object)(subtimeFilter = OnlineServiceHelper.getDateQfilter((String)fieldName, (List)defaultValues)))) continue;
            filterJsonList.add(subtimeFilter.toSerializedString());
        }
        pageCache.put("qfilters", SerializationUtils.toJsonString(filterJsonList));
    }

    private void showModifyPage() {
        List selectedIdList = this.getSelectedIdList();
        if (CollectionUtils.isEmpty((Collection)selectedIdList)) {
            return;
        }
        String formId = this.getModifyFormId();
        Object showParameter = "cim_modifystatus".equals(formId) ? new FormShowParameter() : new BillShowParameter();
        showParameter.setFormId(this.getModifyFormId());
        showParameter.getOpenStyle().setShowType(this.getShowType());
        showParameter.getCustomParams().put("selectedId", selectedIdList.get(0));
        showParameter.getCustomParams().put("entityName", this.getEntityName());
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CLOASECALLBACKID_MODIFYSTATUS"));
        this.getView().showForm(showParameter);
    }

    private void showModifyRecord() {
        List selectedIdList = this.getSelectedIdList();
        if (CollectionUtils.isEmpty((Collection)selectedIdList)) {
            return;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(this.getModifyFormId());
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(this.getShowType());
        showParameter.getCustomParams().put("selectedId", selectedIdList.get(0));
        showParameter.getCustomParams().put("entityName", this.getEntityName());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void validateBeforeModifyStatus(BeforeDoOperationEventArgs args) {
        List selectedIdList = this.getSelectedIdList();
        if (EmptyUtil.isEmpty((Collection)selectedIdList)) {
            args.setCancel(true);
            return;
        }
        if (selectedIdList.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"AbstractOnlineList_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String operatestatus = this.getOperateStatus((Long)selectedIdList.get(0));
        if (!StringUtils.equals((CharSequence)operatestatus, (CharSequence)BebankStatusEnum.NC.getValue())) {
            this.getView().showErrorNotification(this.getErrorMsg());
            args.setCancel(true);
        }
    }

    protected String getErrorMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u64cd\u4f5c\u72b6\u6001\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u7684\u5355\u636e\u3002", (String)"AbstractOnlineList_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]);
    }

    protected abstract String getOperateStatus(Long var1);

    protected void refreshData() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        ArrayList<Long> selectedIdList = new ArrayList<Long>(rows.length);
        for (int index : rows) {
            selectedIdList.add((Long)this.getModel().getValue("id", index));
        }
        this.fillPageData();
        this.reSelectData(selectedIdList);
    }

    private void reSelectData(List<Long> selectDataIds) {
        if (EmptyUtil.isEmpty(selectDataIds)) {
            return;
        }
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectIndexs = new ArrayList<Integer>();
        int len = entryEntity.size();
        for (int i = 0; i < len; ++i) {
            if (!selectDataIds.contains(((DynamicObject)entryEntity.get(i)).getLong("id"))) continue;
            selectIndexs.add(i);
        }
        int[] selectIndexArr = selectIndexs.stream().mapToInt(Integer::intValue).toArray();
        entry.selectRows(selectIndexArr, 0);
    }

    private void batchInsertListData(DataSet dataSet) {
        String[] queryAttributes = this.getQueryAttributes();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int len = queryAttributes.length;
        for (int i = 0; i < len; ++i) {
            vs.addField(queryAttributes[i], new Object[0]);
        }
        for (Row row : dataSet) {
            Object[] values = new Object[queryAttributes.length];
            int len2 = queryAttributes.length;
            for (int i = 0; i < len2; ++i) {
                values[i] = row.get(queryAttributes[i]);
            }
            vs.addRow(values);
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    protected void removeSpareFilter(List<FilterColumn> filterColumns) {
        List<String> commonFilterNames = Arrays.asList(this.getBillMainBizeOrg() + ".name", "finorginfo.name", "bebankstatus", "submittime");
        filterColumns.removeIf(v -> !commonFilterNames.contains(v.getFieldName()));
    }

    protected void modifyFilterCaption() {
        List commonFilterColumns = this.initArgs.getFilterContainerInitEvent().getCommonFilterColumns();
        this.removeSpareFilter(commonFilterColumns);
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"bebankstatus")) continue;
            commonFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c\u72b6\u6001", (String)"AbstractOnlineList_3", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        }
        List fastFilterColumns = this.initArgs.getFilterContainerInitEvent().getFastFilterColumns();
        for (FilterColumn filterColumn : fastFilterColumns) {
            String filterFieldName = filterColumn.getFilterFieldName();
            if (StringUtils.equals((CharSequence)filterFieldName, (CharSequence)"billno")) {
                filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AbstractOnlineList_4", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
                continue;
            }
            if (!StringUtils.equals((CharSequence)filterFieldName, (CharSequence)(this.getBillMainBizeOrg() + ".name"))) continue;
            filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7", (String)"AbstractOnlineList_5", (String)"tmc-cim-formplugin", (Object[])new Object[0])));
        }
    }

    protected abstract String getEntityCaption();

    protected abstract String[] getQueryAttributes();

    protected abstract QFilter getInvestTypeQFilter();

    protected abstract String getModifyFormId();

    protected abstract ShowType getShowType();

    protected abstract List<String> getCommonFilterColumns();

    protected String getBillMainBizeOrg() {
        return "org";
    }
}

