/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.overnight;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.CasBusinessHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.service.servicehlper.BankServiceHelper;

public class OverNightBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finorginfoF7 = (BasedataEdit)this.getControl("finorginfo");
        finorginfoF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accountbankF7 = (BasedataEdit)this.getControl("accountbank");
        accountbankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
        currencyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEntrysEnable();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (propName) {
            case "finorgtype": {
                this.getModel().setValue("finorginfo", null);
                this.getModel().setValue("accountbank", null);
                break;
            }
            case "operation": {
                this.setRevenueAmountStatus(rowIndex);
                break;
            }
            case "opamount": 
            case "revenueamount": {
                this.calRevenueRate(rowIndex);
                break;
            }
            case "currency": {
                this.getBalance();
                break;
            }
            case "accountbank": {
                this.getModel().setValue("currency", null);
                break;
            }
            case "finorginfo": {
                this.getModel().setValue("accountbank", null);
                this.getModel().setValue("currency", null);
                this.getModel().setValue("amount", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "newentry": {
                this.createNewEntry(args);
            }
        }
    }

    private void createNewEntry(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (entrys != null && entrys.size() > 0) {
            BigDecimal opAmount;
            DynamicObject entry = (DynamicObject)entrys.get(entrys.size() - 1);
            Date bizDate = entry.getDate("bizdate");
            boolean cancel = false;
            if (bizDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6700\u540e\u4e00\u884c\u8d2d\u4e70/\u8d4e\u56de\u65e5\u671f\u3002", (String)"OverNightBillEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
            if (BigDecimal.ZERO.compareTo(opAmount = entry.getBigDecimal("opamount")) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6700\u540e\u4e00\u884c\u8d2d\u4e70/\u8d4e\u56de\u91d1\u989d\u3002", (String)"OverNightBillEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
            args.setCancel(cancel);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (entrys != null && entrys.size() > 0) {
            String operation = "buy";
            if (entrys.size() > 1) {
                String lastOperation = (String)this.getModel().getValue("operation", entrys.size() - 2);
                operation = "buy".equals(lastOperation) ? "redeem" : "buy";
            }
            this.setEntrysEnable();
            this.getModel().setValue("operation", (Object)operation, entrys.size() - 1);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection entrys;
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex("entrys");
        if (currRowIndex != (entrys = this.getModel().getEntryEntity("entrys")).size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u6700\u540e\u4e00\u884c\u5206\u5f55\u3002", (String)"OverNightBillEdit_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        this.getView().updateView("entrys");
        this.setEntrysEnable();
    }

    private void getBalance() {
        BigDecimal amt = BigDecimal.ZERO;
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)accountBank) && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            boolean isSetBank = accountBank.getBoolean("issetbankinterface");
            if (isSetBank) {
                amt = BankServiceHelper.getCurBalance((Long)((Long)accountBank.getPkValue()), (Long)((Long)currency.getPkValue()));
            } else {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
                    amt = CasBusinessHelper.getBalance((long)((Long)org.getPkValue()), (long)((Long)accountBank.getPkValue()), (long)((Long)currency.getPkValue()));
                }
            }
        }
        this.getModel().setValue("amount", (Object)amt);
    }

    private void setRevenueAmountStatus(int rowIndex) {
        String operation = (String)this.getModel().getValue("operation", rowIndex);
        if ("buy".equals(operation)) {
            this.getModel().setValue("revenueamount", (Object)BigDecimal.ZERO, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"revenueamount"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"revenueamount"});
        }
    }

    private void calRevenueRate(int rowIndex) {
        BigDecimal opAmount = (BigDecimal)this.getModel().getValue("opamount", rowIndex);
        if (BigDecimal.ZERO.compareTo(opAmount) < 0) {
            BigDecimal revenueAmount = (BigDecimal)this.getModel().getValue("revenueamount", rowIndex);
            BigDecimal rate = revenueAmount.divide(opAmount, 10, 4).multiply(new BigDecimal("360"));
            this.getModel().setValue("revenuerate", (Object)rate);
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        this.verifyInput(key, value, e);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "bizdate": {
                this.checkBizDate(value, e);
            }
        }
    }

    private void checkBizDate(Object value, BeforeFieldPostBackEvent e) {
        int index = e.getRowIndex();
        if (value != null) {
            Date currBizDate = DateUtils.stringToDate((String)String.valueOf(value), (String)"yyyy-MM-dd");
            Date lastBizDate = (Date)this.getModel().getValue("bizdate", index - 1);
            if (lastBizDate != null && !currBizDate.after(lastBizDate)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d2d\u4e70/\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e%s\u3002", (String)"OverNightBillEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]), DateUtils.formatString((Date)lastBizDate, (String)"yyyy-MM-dd")));
                e.setCancel(true);
            }
            this.getView().updateView("bizdate", index);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String property;
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ListFilterParameter filterParam = showParameter.getListFilterParameter();
        List qFilters = filterParam.getQFilters();
        switch (property = evt.getProperty().getName()) {
            case "accountbank": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                DynamicObject finorginfo = (DynamicObject)this.getModel().getValue("finorginfo");
                if (EmptyUtil.isEmpty((DynamicObject)org) || EmptyUtil.isEmpty((DynamicObject)finorginfo)) {
                    evt.setCancel(true);
                    TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"org", "finorginfo"});
                    break;
                }
                Long orgId = org.getLong("id");
                qFilters.add(TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId));
                qFilters.add(new QFilter("bank", "=", finorginfo.getPkValue()));
                break;
            }
            case "currency": {
                DynamicObject account = (DynamicObject)this.getModel().getValue("accountbank");
                if (EmptyUtil.isEmpty((DynamicObject)account)) {
                    evt.setCancel(true);
                    TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"accountbank");
                    break;
                }
                DynamicObjectCollection currencyCol = account.getDynamicObjectCollection("currency");
                HashSet<Long> currencyIDs = new HashSet<Long>();
                for (DynamicObject prop : currencyCol) {
                    currencyIDs.add((Long)((DataEntityBase)prop.get("fbasedataid")).getPkValue());
                }
                QFilter qFilter = new QFilter("id", "in", currencyIDs);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        }
    }

    private void setEntrysEnable() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        for (int i = 0; i < entrys.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"bizdate", "opamount", "revenueamount"});
            if (i != entrys.size() - 1) continue;
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"bizdate", "opamount"});
            DynamicObject entry = (DynamicObject)entrys.get(i);
            String operation = entry.getString("operation");
            if (!"redeem".equals(operation)) continue;
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"revenueamount"});
        }
    }
}

