/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.redeem;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class RedeemBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String[] repayProps = new String[]{"revenueamount", "entrys", "entrys.startdate", "entrys.enddate", "entrys.days", "entrys.finamount", "entrys.eplanrevenue", "entrys.convertdays", "entrys.erevenueamount"};

    public void registerListener(EventObject e) {
        BasedataEdit apply = (BasedataEdit)this.getControl("redeemapply");
        apply.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDateRange();
        this.setMustInput();
        this.isRenewalSetMustInput();
        this.calExpireDate();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getValue(), (CharSequence)billStatus)) {
            this.calRevenuePlanInfoNotSave();
        } else {
            this.calRevenuePlanInfo();
            this.setRenewalAmount();
        }
        this.calAmount();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName;
        switch (fieldName = event.getProperty().getName()) {
            case "redeemapply": {
                this.addF7SelectFilter(event);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String field;
        switch (field = e.getKey()) {
            case "redeemdate": {
                if (!EmptyUtil.isEmpty((Object)this.getModel().getValue("finbillno"))) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1\u7f16\u53f7\u3002", (String)"RedeemBillEdit_5", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                this.getView().updateView(field);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "amount": {
                this.checkAmount();
                this.calRealRevenue();
                break;
            }
            case "tradechannel": 
            case "redeemway": {
                this.setMustInput();
                break;
            }
            case "copies": {
                this.checkCopies();
                this.calAmount();
                this.calRealRevenue();
                break;
            }
            case "iopv": {
                this.calAmount();
                this.setRenewalCopiesAndIopv();
                break;
            }
            case "redeempattern": {
                this.calExpireDate();
                this.setDateRange();
                break;
            }
            case "redeemdate": {
                this.calExpireDate();
                this.setDateRange();
                this.calRevenuePlanInfo();
                this.calRealRevenue();
                break;
            }
            case "finbillno": {
                this.FinBillNoChgEvt();
                break;
            }
            case "isrevenue": {
                this.calRevenuePlanInfo();
                if (!((Boolean)this.getModel().getValue("isrevenue")).booleanValue()) {
                    this.getModel().setValue("realrevenue", null);
                    this.getModel().setValue("renewalamount", this.getModel().getValue("amount"));
                }
                this.calRealRevenue();
                break;
            }
            case "isrenewal": {
                this.checkCanIsRenewal();
                this.isRenewalSetMustInput();
                this.setRenewalAmount();
                this.setRenewalCopiesAndIopv();
                break;
            }
            case "isrollcapital": 
            case "realrevenue": {
                this.setRenewalAmount();
                this.setCombineInstDuringChange();
                break;
            }
            case "renewalcopies": 
            case "renewaliopv": {
                this.calRenewalAmount();
                break;
            }
            case "redeemapply": {
                DynamicObject redeemApply = (DynamicObject)this.getModel().getValue("redeemapply");
                if (EmptyUtil.isEmpty((DynamicObject)redeemApply)) {
                    return;
                }
                this.getModel().setValue("finbillno", (Object)redeemApply.getLong("finsubscribe.id"));
                this.getModel().setValue("redeemdate", (Object)redeemApply.getDate("redemptiondate"));
                this.getModel().setValue("amount", (Object)redeemApply.getBigDecimal("redemptionamount"));
                this.getModel().setValue("copies", (Object)redeemApply.getBigDecimal("redemptioncopies"));
                this.getModel().setValue("iopv", (Object)redeemApply.getBigDecimal("redemptioniopv"));
                String redeemWay = (String)this.getModel().getValue("redeemway");
                String prop = RedeemWayEnum.isAmountRedeem((String)redeemWay) ? "surplusamount" : "surpluscopies";
                BigDecimal surp = (BigDecimal)this.getModel().getValue(prop);
                this.getModel().setValue("isrenewal", (Object)(surp.compareTo(BigDecimal.ZERO) == 0 ? 1 : 0));
                break;
            }
        }
    }

    private void FinBillNoChgEvt() {
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            DynamicObject settleAccount;
            DynamicObjectCollection lastRedeem;
            QFilter qFilter = new QFilter("finbillno", "=", finBillNoF7.getPkValue());
            if (OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
                qFilter.and("id", "!=", this.getModel().getValue("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(lastRedeem = QueryServiceHelper.query((String)CimEntityEnum.cim_redeem.getValue(), (String)"redeemdate", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)1)))) {
                this.getModel().setValue("lastredeemdate", (Object)((DynamicObject)lastRedeem.get(0)).getDate("redeemdate"));
            }
            this.getModel().setValue("isrevenue", (Object)Boolean.FALSE);
            this.getModel().setValue("tradechannel", (Object)finBillNoF7.getString("tradechannel"));
            this.getModel().setValue("securitiesaccno", (Object)finBillNoF7.getString("securitiesaccno"));
            String redeemWay = (String)this.getModel().getValue("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                this.getModel().setValue("amount", (Object)finBillNoF7.getBigDecimal("surplusamount"));
            } else {
                this.getModel().setValue("copies", (Object)finBillNoF7.getBigDecimal("surpluscopies"));
                this.getModel().setValue("iopv", (Object)finBillNoF7.getBigDecimal("iopv"));
            }
            String expireRedeposit = finBillNoF7.getString("expireredeposit");
            if (StringUtils.equals((CharSequence)ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue(), (CharSequence)expireRedeposit) || StringUtils.equals((CharSequence)ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue(), (CharSequence)expireRedeposit)) {
                this.getModel().setValue("isrenewal", (Object)Boolean.TRUE);
            }
            if (EmptyUtil.isEmpty((DynamicObject)(settleAccount = finBillNoF7.getDynamicObject("settleaccount")))) {
                this.getModel().setValue("recaccount", (Object)finBillNoF7.getString("finaccount"));
                this.getModel().setValue("recaccountf7", (Object)finBillNoF7.getDynamicObject("finaccountf7"));
            } else {
                this.getModel().setValue("recaccount", (Object)finBillNoF7.getString("settleaccount.bankaccountnumber"));
                this.getModel().setValue("recaccountf7", (Object)finBillNoF7.getDynamicObject("settleaccount"));
            }
        }
    }

    private void checkAmount() {
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            String redeemWay = (String)this.getModel().getValue("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                BigDecimal surplusAmount;
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                if (amount.compareTo(surplusAmount = finBillNoF7.getBigDecimal("surplusamount")) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d4e\u56de\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u7406\u8d22\u5269\u4f59\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RedeemBillEdit_0", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)BigDecimal.ZERO);
                    return;
                }
                this.getModel().setValue("surplusamount", (Object)surplusAmount.subtract(amount));
                if (BigDecimal.ZERO.compareTo(amount) < 0) {
                    this.calRevenuePlanInfo();
                }
            }
        } else {
            TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"finbillno");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)BigDecimal.ZERO);
        }
    }

    private void checkCopies() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal surplusCopies;
            BigDecimal copies = (BigDecimal)this.getModel().getValue("copies");
            if (copies.compareTo(surplusCopies = finBillNoF7.getBigDecimal("surpluscopies")) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d4e\u56de\u4efd\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7\u7406\u8d22\u5269\u4f59\u4efd\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RedeemBillEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"copies", (Object)0);
                return;
            }
            this.getModel().setValue("surpluscopies", (Object)surplusCopies.subtract(copies));
        }
    }

    private void setMustInput() {
        String tradeChannel = (String)this.getModel().getValue("tradechannel");
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"copies", "surpluscopies", "iopv"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"surplusamount"});
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (TradeChannelEnum.ONLINE.getValue().equals(tradeChannel) || !RedeemWayEnum.copies_redeem.getValue().equals(redeemWay) ? 1 : 0) != 0, (String[])new String[]{"amount"});
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"copies", "surpluscopies", "iopv"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"surplusamount", "realrevenue"});
        }
    }

    private void setDateRange() {
        Object redeemDate;
        Date lastRedeemDate = (Date)this.getModel().getValue("lastredeemdate");
        if (EmptyUtil.isNoEmpty((Object)lastRedeemDate)) {
            redeemDate = (DateEdit)this.getControl("redeemdate");
            redeemDate.setMinDate(lastRedeemDate);
        }
        if (EmptyUtil.isNoEmpty((Object)(redeemDate = (Date)this.getModel().getValue("redeemdate")))) {
            DateEdit expireDate = (DateEdit)this.getControl("expiredate");
            expireDate.setMinDate((Date)redeemDate);
        }
    }

    private void calAmount() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            BigDecimal buyCopies = (BigDecimal)this.getModel().getValue("copies");
            BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
            BigDecimal amount = iopv.multiply(buyCopies);
            this.getModel().setValue("amount", (Object)amount);
        }
    }

    private void calRenewalAmount() {
        BigDecimal renewalCopies = (BigDecimal)this.getModel().getValue("renewalcopies");
        BigDecimal renewalIopv = (BigDecimal)this.getModel().getValue("renewaliopv");
        BigDecimal renewalAmount = renewalIopv.multiply(renewalCopies);
        this.getModel().setValue("renewalamount", (Object)renewalAmount);
    }

    private void calExpireDate() {
        Date redeemDate = (Date)this.getModel().getValue("redeemdate");
        if (EmptyUtil.isNoEmpty((Object)redeemDate)) {
            int redeemPattern = (Integer)this.getModel().getValue("redeempattern");
            this.getModel().setValue("expiredate", (Object)DateUtils.getNextDay((Date)redeemDate, (int)redeemPattern));
        }
    }

    private void checkCanIsRenewal() {
        boolean isRenewal = (Boolean)this.getModel().getValue("isrenewal");
        if (isRenewal) {
            if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"finbillno")) {
                this.getModel().setValue("isrenewal", (Object)Boolean.FALSE);
                return;
            }
            DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
            Date expireDate = finBillNoF7.getDate("expiredate");
            if (EmptyUtil.isEmpty((Object)expireDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8d2d\u5355\u7684\u5230\u671f\u65e5\u4e3a\u7a7a\u65f6\uff0c\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u7406\u8d22\u7eed\u671f\u201d\u3002", (String)"RedeemBillEdit_3", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("isrenewal", (Object)Boolean.FALSE);
                return;
            }
            BigDecimal surplusAmount = (BigDecimal)this.getModel().getValue("surplusamount");
            BigDecimal surplusCopies = (BigDecimal)this.getModel().getValue("surpluscopies");
            if (BigDecimal.ZERO.compareTo(surplusAmount) != 0 || BigDecimal.ZERO.compareTo(surplusCopies) != 0) {
                this.getModel().setValue("isrenewal", (Object)Boolean.FALSE);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u6700\u540e\u4e00\u6b21\u8d4e\u56de\u65f6\u5f00\u542f\u7406\u8d22\u7eed\u671f\u3002", (String)"RedeemBillEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void isRenewalSetMustInput() {
        boolean isRenewal = (Boolean)this.getModel().getValue("isrenewal");
        if (isRenewal) {
            String redeemWay = (String)this.getModel().getValue("redeemway");
            if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"isrollcapital", "renewalamount"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"renewalcopies", "renewaliopv"});
            }
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"isrollcapital", "renewalamount", "renewalcopies", "renewaliopv"});
        }
    }

    private void setRenewalAmount() {
        boolean isRenewal = (Boolean)this.getModel().getValue("isrenewal");
        BigDecimal renewalAmount = BigDecimal.ZERO;
        if (isRenewal) {
            boolean isRollCapital = (Boolean)this.getModel().getValue("isrollcapital");
            DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
            renewalAmount = finBillNoF7.getBigDecimal("surplusamount");
            if (isRollCapital) {
                BigDecimal realRevenue = (BigDecimal)this.getModel().getValue("realrevenue");
                renewalAmount = renewalAmount.add(realRevenue);
            }
        }
        this.getModel().setValue("renewalamount", (Object)renewalAmount);
    }

    private void setRenewalCopiesAndIopv() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            boolean isRenewal = (Boolean)this.getModel().getValue("isrenewal");
            int renewalCopies = 0;
            BigDecimal renewalIopv = BigDecimal.ZERO;
            if (isRenewal) {
                DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
                renewalCopies = finBillNoF7.getInt("surpluscopies");
                renewalIopv = (BigDecimal)this.getModel().getValue("iopv");
            }
            this.getModel().setValue("renewalcopies", (Object)renewalCopies);
            this.getModel().setValue("renewaliopv", (Object)renewalIopv);
        }
    }

    private void calRevenuePlanInfoNotSave() {
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue) {
            this.getModel().deleteEntryData("entrys");
            Long id = (Long)this.getModel().getValue("id");
            QFilter qFilter = new QFilter("redeemid", "=", (Object)id);
            DynamicObject revenueBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_revenue.getValue(), (String)String.join((CharSequence)",", repayProps), (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)revenueBill)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"revenueamount", (Object)revenueBill.getBigDecimal("revenueamount"));
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("startdate", new Object[0]);
                vs.addField("enddate", new Object[0]);
                vs.addField("days", new Object[0]);
                vs.addField("finamount", new Object[0]);
                vs.addField("eplanrevenue", new Object[0]);
                vs.addField("convertdays", new Object[0]);
                vs.addField("erevenueamount", new Object[0]);
                DynamicObjectCollection interestCals = revenueBill.getDynamicObjectCollection("entrys");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestCals)) {
                    for (DynamicObject interestCal : interestCals) {
                        vs.addRow(new Object[]{interestCal.getDate("startdate"), interestCal.getDate("enddate"), interestCal.getInt("days"), interestCal.getBigDecimal("finamount"), interestCal.getBigDecimal("eplanrevenue"), interestCal.getInt("convertdays"), interestCal.getBigDecimal("erevenueamount")});
                    }
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("entrys", vs);
                model.endInit();
                this.getView().updateView("entrys");
            }
        }
    }

    private void calRevenuePlanInfo() {
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue) {
            if (!this.vailMustInput()) {
                this.getModel().setValue("isrevenue", (Object)Boolean.FALSE);
                return;
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"revenueamount", (Object)BigDecimal.ZERO);
            this.getModel().deleteEntryData("entrys");
            DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
            Long finBillId = (Long)finBillNoF7.getPkValue();
            DynamicObject finBill = TmcDataServiceHelper.loadSingle((Object)finBillNoF7.getPkValue(), (String)CimEntityEnum.cim_finsubscribe.getValue());
            Date lastEndIntDate = finBill.getDate("endinstdate");
            Date redeemDate = (Date)this.getModel().getValue("redeemdate");
            if (lastEndIntDate != null && redeemDate.before(lastEndIntDate)) {
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (!BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d4e\u56de\u5355\u7684\u8d4e\u56de\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u7533\u8d2d\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5%s\u3002", (String)"RedeemBillEdit_2", (String)"tmc-cim-formplugin", (Object[])new Object[]{DateUtils.formatString((Date)lastEndIntDate, (String)"yyyy-MM-dd")}));
                return;
            }
            IntBillInfo intBill = this.getIntBillInfo(finBillId, lastEndIntDate, redeemDate);
            if (intBill != null) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"revenueamount", (Object)intBill.getAmount());
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("startdate", new Object[0]);
                vs.addField("enddate", new Object[0]);
                vs.addField("days", new Object[0]);
                vs.addField("finamount", new Object[0]);
                vs.addField("eplanrevenue", new Object[0]);
                vs.addField("convertdays", new Object[0]);
                vs.addField("erevenueamount", new Object[0]);
                for (IntBillDetailInfo detail : intBill.getDetails()) {
                    vs.addRow(new Object[]{detail.getBeginDate(), detail.getEndDate(), detail.getDays(), detail.getPrinciple(), detail.getRate(), detail.getBasisDay(), detail.getAmount()});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.batchCreateNewEntryRow("entrys", vs);
                this.getView().updateView("entrys");
                this.getModel().setDataChanged(false);
            }
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"revenueamount", (Object)BigDecimal.ZERO);
            this.getModel().deleteEntryData("entrys");
        }
    }

    private IntBillInfo getIntBillInfo(Long finBillId, Date lastEndIntDate, Date redeemDate) {
        IntBillInfo intBill;
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal surplusAmount = (BigDecimal)this.getModel().getValue("surplusamount");
        if (BigDecimal.ZERO.compareTo(surplusAmount) != 0) {
            intBill = RevenueCalcHelper.callInt((Long)finBillId, (Date)redeemDate, (BigDecimal)amount);
        } else {
            if (EmptyUtil.isNoEmpty((Object)lastEndIntDate)) {
                lastEndIntDate = DateUtils.getNextDay((Date)lastEndIntDate, (int)1);
            }
            intBill = RevenueCalcHelper.callInt((Long)finBillId, (Date)lastEndIntDate, (Date)redeemDate);
        }
        return intBill;
    }

    private void calRealRevenue() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)finBillNoF7)) {
            return;
        }
        Long finBillId = (Long)finBillNoF7.getPkValue();
        DynamicObject finBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_finsubscribe.getValue(), (String)"endinstdate,iopv", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finBillId)});
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            Date redeemDate;
            Date lastEndIntDate;
            IntBillInfo intBill;
            boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
            if (isRevenue && (intBill = this.getIntBillInfo(finBillId, lastEndIntDate = finBill.getDate("endinstdate"), redeemDate = (Date)this.getModel().getValue("redeemdate"))) != null) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"realrevenue", (Object)intBill.getAmount());
            }
        } else {
            BigDecimal redeemAmount = (BigDecimal)this.getModel().getValue("amount");
            BigDecimal copies = (BigDecimal)this.getModel().getValue("copies");
            BigDecimal iopv = finBill.getBigDecimal("iopv");
            BigDecimal realRevenue = redeemAmount.subtract(iopv.multiply(copies));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"realrevenue", (Object)realRevenue);
        }
    }

    private boolean vailMustInput() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"finbillno", "amount", "redeemdate", "expiredate"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "save": {
                this.setIsPushRevValue();
                break;
            }
            case "submit": {
                this.beforeDoSubmit(args);
            }
        }
    }

    private void beforeDoSubmit(BeforeDoOperationEventArgs args) {
        Object pkId;
        this.setIsPushRevValue();
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue && !TmcDataServiceHelper.exists((Object)(pkId = this.getModel().getValue("id")), (String)CimEntityEnum.cim_redeem.getValue())) {
            args.setCancel(true);
            String newNumber = CodeRuleServiceHelper.getNumber((String)CimEntityEnum.cim_redeem.getValue(), (DynamicObject)this.getModel().getDataEntity(), null);
            this.getModel().setValue("billno", (Object)newNumber);
            OperationResult invokeSave = this.getView().invokeOperation("beforesubmit");
            if (invokeSave.isSuccess()) {
                this.getView().invokeOperation("submit");
            }
        }
    }

    private void setIsPushRevValue() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrys");
        if (entryEntity.size() > 0) {
            this.getModel().setValue("ispushrev", (Object)Boolean.TRUE);
        } else {
            this.getModel().setValue("ispushrev", (Object)Boolean.FALSE);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.calRevenuePlanInfo();
        }
    }

    private void setCombineInstDuringChange() {
        String redeemWay = (String)this.getModel().getValue("redeemway");
        BigDecimal realRevAmt = (BigDecimal)this.getModel().getValue("realrevenue");
        if (RedeemWayEnum.isAmountRedeem((String)redeemWay) && realRevAmt.compareTo(BigDecimal.ZERO) < 0) {
            this.getModel().setValue("combineinst", (Object)Boolean.TRUE);
        }
    }

    private void addF7SelectFilter(BeforeF7SelectEvent event) {
        List qFilters = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d4e\u56de\u7ec4\u7ec7\u3002", (String)"RedeemBillEdit_6", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
            return;
        }
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter redeemFilter = new QFilter("sourcebilltype", "=", (Object)"cim_finapply");
        redeemFilter.or("redeemapply", ">", (Object)0);
        DynamicObjectCollection redeemBills = QueryServiceHelper.query((String)"cim_redeem", (String)"sourcebillid,redeemapply", (QFilter[])new QFilter[]{redeemFilter});
        HashSet<Long> dbApplyIds = new HashSet<Long>(redeemBills.size());
        for (DynamicObject redeemBill : redeemBills) {
            if (EmptyUtil.isNoEmpty((Long)redeemBill.getLong("sourcebillid"))) {
                dbApplyIds.add(redeemBill.getLong("sourcebillid"));
            }
            if (!EmptyUtil.isNoEmpty((Long)redeemBill.getLong("redeemapply"))) continue;
            dbApplyIds.add(redeemBill.getLong("redeemapply"));
        }
        orgFilter.and(new QFilter("id", "not in", dbApplyIds));
        qFilters.add(orgFilter);
    }
}

