/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.formplugin.revenue;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.tmc.cim.common.enums.BonusWayEnum;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RevenueBillEdit
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            this.setRevenueEndDate();
            this.FinBillNoChgEvt();
        }
        this.getModel().setDataChanged(false);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"amount"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "expiredate": {
                this.setRevenueEndDate();
                break;
            }
            case "finbillno": {
                this.FinBillNoChgEvt();
                this.setRevenueEndDate();
                this.calRealRate();
                break;
            }
            case "revenuestartdate": 
            case "revenueenddate": {
                DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
                if (!EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) break;
                this.calRevenuePlanInfo(finBillNoF7);
                this.calRealRate();
                break;
            }
            case "copies": {
                this.checkCopies();
                this.calAmount();
                break;
            }
            case "iopv": {
                this.calAmount();
                break;
            }
            case "amount": {
                this.calRealRate();
                break;
            }
        }
    }

    private void FinBillNoChgEvt() {
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            Date endInstDate = finBillNoF7.getDate("endinstdate");
            Date revenueStartDate = EmptyUtil.isEmpty((Object)endInstDate) ? finBillNoF7.getDate("intdate") : DateUtils.getNextDay((Date)endInstDate, (int)1);
            this.getModel().setValue("revenuestartdate", (Object)revenueStartDate);
            Date purchaseDate = finBillNoF7.getDate("valuedate");
            DateEdit expireDate = (DateEdit)this.getControl("expiredate");
            expireDate.setMinDate(purchaseDate);
            Date date = finBillNoF7.getDate("expiredate");
            expireDate.setMaxDate(date);
            Date endinstDate = finBillNoF7.getDate("endinstdate");
            if (EmptyUtil.isNoEmpty((Object)endinstDate)) {
                expireDate.setMinDate(endinstDate);
            }
            this.calRevenuePlanInfo(finBillNoF7);
        }
    }

    private void calRevenuePlanInfo(DynamicObject finBillNoF7) {
        String bonusWay = (String)this.getModel().getValue("bonusway");
        if (BonusWayEnum.amount_bonus.getValue().equals(bonusWay)) {
            this.getModel().deleteEntryData("entrys");
            Date beginDate = (Date)this.getModel().getValue("revenuestartdate");
            Date endDate = (Date)this.getModel().getValue("expiredate");
            if (EmptyUtil.isEmpty((Object)endDate)) {
                return;
            }
            IntBillInfo intBill = RevenueCalcHelper.callInt((Long)((Long)finBillNoF7.getPkValue()), (Date)beginDate, (Date)endDate);
            if (EmptyUtil.isNoEmpty((Object)intBill) && EmptyUtil.isNoEmpty((Object)intBill.getDetails())) {
                this.getModel().setValue("revenueamount", (Object)intBill.getAmount());
                TableValueSetter vs = new TableValueSetter(new String[0]);
                vs.addField("startdate", new Object[0]);
                vs.addField("enddate", new Object[0]);
                vs.addField("days", new Object[0]);
                vs.addField("finamount", new Object[0]);
                vs.addField("eplanrevenue", new Object[0]);
                vs.addField("convertdays", new Object[0]);
                vs.addField("erevenueamount", new Object[0]);
                for (IntBillDetailInfo detail : intBill.getDetails()) {
                    vs.addRow(new Object[]{detail.getBeginDate(), detail.getEndDate(), detail.getDays(), detail.getPrinciple(), detail.getRate(), detail.getBasisDay(), detail.getAmount()});
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                boolean dataChanged = this.getModel().getDataChanged();
                model.batchCreateNewEntryRow("entrys", vs);
                this.getModel().setDataChanged(dataChanged);
                this.getView().updateView("entrys");
                Integer revDays = intBill.getDetails().stream().map(r -> r.getDays()).reduce(0, Integer::sum);
                this.getModel().setValue("revenuedays", (Object)revDays);
            }
        }
    }

    private void setRevenueEndDate() {
        Date expireDate = (Date)this.getModel().getValue("expiredate");
        if (expireDate != null) {
            DynamicObject productFactory;
            IntHTRuleEnum intHTRuleEnum = IntHTRuleEnum.headnotail;
            DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
            if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7) && EmptyUtil.isNoEmpty((DynamicObject)(productFactory = finBillNoF7.getDynamicObject("productfactory"))) && "cash".equals((productFactory = TmcDataServiceHelper.loadSingle((Object)productFactory.getPkValue(), (String)"cim_investmodel", (String)"profittype,intheadtailrule")).getString("profittype"))) {
                intHTRuleEnum = IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule"));
            }
            switch (intHTRuleEnum) {
                case headnotail: 
                case noheadnotail: {
                    expireDate = DateUtils.getLastDay((Date)expireDate, (int)1);
                }
            }
            this.getModel().setValue("revenueenddate", (Object)expireDate);
        }
    }

    private void checkCopies() {
        int surplusCopies;
        int copies;
        String bonusWay = (String)this.getModel().getValue("bonusway");
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (BonusWayEnum.copies_bonus.getValue().equals(bonusWay) && (copies = ((Integer)this.getModel().getValue("copies")).intValue()) > (surplusCopies = finBillNoF7.getInt("surpluscopies"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ea2\u4efd\u6570\u4e0d\u5141\u8bb8\u8d85\u8fc7\u7406\u8d22\u5269\u4f59\u4efd\u6570\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RevenueBillEdit_1", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"copies", (Object)0);
            return;
        }
    }

    private void calAmount() {
        DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
        if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
            String bonusWay = (String)this.getModel().getValue("bonusway");
            if (BonusWayEnum.copies_bonus.getValue().equals(bonusWay)) {
                int buyCopies = (Integer)this.getModel().getValue("copies");
                BigDecimal iopv = (BigDecimal)this.getModel().getValue("iopv");
                BigDecimal finIopv = finBillNoF7.getBigDecimal("iopv");
                BigDecimal amount = new BigDecimal(buyCopies).multiply(finIopv.subtract(iopv));
                this.getModel().setValue("revenueamount", (Object)amount);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObject finBillNoF7 = (DynamicObject)this.getModel().getValue("finbillno");
            if (EmptyUtil.isNoEmpty((DynamicObject)finBillNoF7)) {
                this.calRevenuePlanInfo(finBillNoF7);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private void calRealRate() {
        BigDecimal revenueAmt = (BigDecimal)this.getModel().getValue("amount");
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{revenueAmt, rows})) {
            this.getModel().setValue("realrate", null);
            return;
        }
        this.getModel().setValue("realrate", (Object)RevenueCalcHelper.calcRealRate((DynamicObjectCollection)rows, (BigDecimal)revenueAmt));
    }
}

