/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.opplugin.init;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.opplugin.init.AbstractDepositInitImportPlugin;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FixedDepositInitInnerImportPlugin
extends AbstractDepositInitImportPlugin {
    @Override
    protected void selfValidate(Map<String, Object> data) {
        JSONObject finOrg = (JSONObject)data.get("finorginfo");
        QFilter qFilter = new QFilter("number", "=", (Object)finOrg.getString("number"));
        qFilter.or(new QFilter("name", "=", (Object)finOrg.getString("name")));
        DynamicObject finOrgDyn = TmcDataServiceHelper.loadSingleFromCache((String)"bd_finorginfo", (String)"finorgtype", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObject)finOrgDyn)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u652f\u6301\u7684\u5b58\u6b3e\u673a\u6784\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedDepositInitInnerImportPlugin_0", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
        String type = Optional.ofNullable(finOrgDyn.getDynamicObject("finorgtype")).map(r -> r.getString("type")).orElse("");
        if (!FinOrgTypeEnum.CLEARINGHOUSE.getValue().equals(type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u7ed3\u7b97\u4e2d\u5fc3\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5728\u6b64\u5904\u5bfc\u5165\u3002", (String)"FixedDepositInitInnerImportPlugin_1", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
        JSONObject product = (JSONObject)data.get("product");
        QFilter productQFilter = new QFilter("number", "=", (Object)product.getString("number"));
        DynamicObject productDyn = TmcDataServiceHelper.loadSingleFromCache((String)"ifm_ldproduct", (String)"enable,servicecategory,ratetype", (QFilter[])new QFilter[]{productQFilter});
        if (EmptyUtil.isEmpty((DynamicObject)productDyn)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u652f\u6301\u7684\u5b58\u6b3e\u4ea7\u54c1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedDepositInitInnerImportPlugin_2", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
        String enable = Optional.ofNullable(productDyn).map(r -> r.getString("enable")).orElse("");
        if (BaseEnableEnum.DISABLE.getValue().equals(enable)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u652f\u6301\u7684\u53ef\u7528\u7684\u5b58\u6b3e\u4ea7\u54c1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedDepositInitInnerImportPlugin_3", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
        String serviceCategory = Optional.ofNullable(productDyn).map(r -> r.getString("servicecategory")).orElse("");
        if (!"A".equals(serviceCategory)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u652f\u6301\u7684\u5b9a\u671f\u5b58\u6b3e\u7684\u5b58\u6b3e\u4ea7\u54c1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedDepositInitInnerImportPlugin_4", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
        String rateType = Optional.ofNullable(productDyn).map(r -> r.getString("ratetype")).orElse("");
        if (InterestTypeEnum.AGREE.getValue().equals(rateType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u652f\u6301\u7684\u975e\u534f\u8bae\u5229\u7387\u7684\u5b58\u6b3e\u4ea7\u54c1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedDepositInitInnerImportPlugin_5", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
        JSONObject investVar = (JSONObject)data.get("investvarieties");
        QFilter investQFilter = new QFilter("number", "=", (Object)investVar.getString("number"));
        DynamicObject investVarDyn = TmcDataServiceHelper.loadSingleFromCache((String)"cim_investvarieties", (String)"investtype", (QFilter[])new QFilter[]{investQFilter});
        String investType = Optional.ofNullable(investVarDyn).map(r -> r.getString("investtype")).orElse("");
        if (!InvestTypeEnum.isFixed((String)investType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u652f\u6301\u7684\u5b58\u6b3e\u54c1\u79cd\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FixedDepositInitInnerImportPlugin_6", (String)"tmc-cim-opplugin", (Object[])new Object[0]));
        }
    }

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        Object finAccount;
        JSONObject product = (JSONObject)data.get("product");
        DynamicObject investVarietiesDyn = TmcDataServiceHelper.loadSingleFromCache((String)"cim_investvarieties", (QFilter[])new QFilter("number", "=", (Object)product.getString("number")).toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)investVarietiesDyn)) {
            JSONObject investVarieties = new JSONObject();
            investVarieties.put("importprop", (Object)"number");
            investVarieties.put("number", (Object)investVarietiesDyn.getString("number"));
            investVarieties.put("name", (Object)investVarietiesDyn.getString("name"));
            data.put("investvarieties", investVarieties);
        }
        if (EmptyUtil.isNoEmpty((Object)(finAccount = data.get("finaccount")))) {
            JSONObject finAccountF7 = new JSONObject();
            finAccountF7.put("importprop", (Object)"number");
            finAccountF7.put("number", (Object)finAccount.toString());
            data.put("finaccountf7", finAccountF7);
        }
        return super.beforeImportData(data, option, importlogs);
    }

    @Override
    protected void selfValueSet(DynamicObject bill) {
        Date expireDate = bill.getDate("expiredate");
        Date startDate = bill.getDate("intdate");
        String term = TermHelper.callTermLargeEqualZore((Date)startDate, (Date)expireDate);
        bill.set("term", (Object)term);
    }
}

