/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RevenueConvertParam
implements Serializable {
    private String operateSource;
    private List<SourceParam> params = new ArrayList<SourceParam>(4);

    public RevenueConvertParam addParam(SourceParam param) {
        this.params.add(param);
        return this;
    }

    public Map<Long, SourceParam> getSourceParamMap() {
        return this.params.stream().collect(Collectors.toMap(SourceParam::getSourceBillId, d -> d));
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public RevenueConvertParam(String operateSource) {
        this.operateSource = operateSource;
    }

    public RevenueConvertParam() {
    }

    public String getOperateSource() {
        return this.operateSource;
    }

    public RevenueConvertParam setOperateSource(String operateSource) {
        this.operateSource = operateSource;
        return this;
    }

    public List<SourceParam> getParams() {
        return this.params;
    }

    public RevenueConvertParam setParams(List<SourceParam> params) {
        this.params = params;
        return this;
    }

    public static class SourceParam
    implements Serializable {
        private Long sourceBillId;
        private Map<String, String> option = new HashMap<String, String>(10);

        public SourceParam addOption(String key, String value) {
            this.option.put(key, value);
            return this;
        }

        public String getValue(String key) {
            return this.option.get(key);
        }

        public SourceParam() {
        }

        public SourceParam(Long sourceBillId) {
            this.sourceBillId = sourceBillId;
        }

        public Long getSourceBillId() {
            return this.sourceBillId;
        }

        public SourceParam setSourceBillId(Long sourceBillId) {
            this.sourceBillId = sourceBillId;
            return this;
        }

        public Map<String, String> getOption() {
            return this.option;
        }
    }
}

