/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.cim.common.bean.RevenueConvertParam;
import kd.tmc.cim.common.enums.DepositApplyStatusEnum;
import kd.tmc.cim.common.enums.DepositApplyTypeEnum;
import kd.tmc.cim.common.enums.ExpireRedepositTypeEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.InterestTypeEnum;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.cim.common.helper.CimParameterHelper;
import kd.tmc.cim.common.service.deposit.DepositCalcIntService;
import kd.tmc.cim.common.service.deposit.DepositIntPlanService;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.deposit.DepositDetail;
import org.apache.commons.lang3.tuple.Pair;

public class DepositHelper {
    public static final BigDecimal RATE_MAX = BigDecimal.valueOf(Math.pow(10.0, 13.0));
    private static final Log LOG = LogFactory.getLog(DepositHelper.class);
    private static final DepositCalcIntService depositCalcIntService = new DepositCalcIntService();
    public static final DepositIntPlanService depositIntPlanService = new DepositIntPlanService();

    public static IntBillInfo calcDepositBillInt(DynamicObject releaseBill, boolean isHuge) {
        return depositCalcIntService.calcDepositBillInt(releaseBill, isHuge);
    }

    public static IntBillInfo calcDepositBillInt(DynamicObject depositBill, Date beginDate, Date endDate) {
        return depositCalcIntService.calcDepositBillInt(depositBill, beginDate, endDate);
    }

    public static Map<Long, IntBillInfo> calcDepositBillInt(List<Long> depositIds, Date beginDate, Date endDate) {
        return depositCalcIntService.calcDepositBillInt(depositIds, beginDate, endDate);
    }

    public static IntBillInfo calcDepositBillIntForReport(Long depositId, Date beginDate, Date endDate) {
        DynamicObject depositBill = TmcDataServiceHelper.loadSingleFromCache((Object)depositId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
        QFilter filter = new QFilter("finbillno", "=", (Object)depositId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        QFilter online = new QFilter("tradechannel", "=", (Object)TradeChannelEnum.ONLINE.getValue());
        online.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
        QFilter tradeChannel = online.or(new QFilter("tradechannel", "!=", (Object)TradeChannelEnum.ONLINE.getValue()));
        filter.and(tradeChannel);
        filter.and(new QFilter("redeemdate", "<=", (Object)endDate));
        DynamicObjectCollection releaseCols = QueryServiceHelper.query((String)"cim_release", (String)"finbillno,isrevenue,redeemdate,amount", (QFilter[])filter.toArray());
        ArrayList<PlanCallResult> repayPlanList = new ArrayList<PlanCallResult>(releaseCols.size());
        for (DynamicObject releaseBill : releaseCols) {
            PlanCallResult info = new PlanCallResult();
            info.setBizDate(releaseBill.getDate("redeemdate"));
            info.setPrinciple(releaseBill.getBigDecimal("amount"));
            info.setPayInt(false);
            repayPlanList.add(info);
        }
        return depositCalcIntService.calcDepositBillIntForReport(depositBill, beginDate, endDate, repayPlanList);
    }

    public static void addRevenueCalDetailEntry(DynamicObjectCollection intDetails, List<IntBillDetailInfo> details) {
        intDetails.clear();
        if (EmptyUtil.isEmpty(details)) {
            return;
        }
        for (IntBillDetailInfo detail : details) {
            DynamicObject intDetail = intDetails.addNew();
            intDetail.set("estartdate", (Object)detail.getBeginDate());
            intDetail.set("eenddate", (Object)detail.getEndDate());
            intDetail.set("edays", (Object)detail.getDays());
            intDetail.set("efinamount", (Object)detail.getPrinciple());
            intDetail.set("eplanrevenue", (Object)detail.getRate());
            intDetail.set("econvertdays", (Object)detail.getBasisDay());
            intDetail.set("erevenueamount", (Object)detail.getAmount());
        }
    }

    private static KDBizException refferRateNotExistException() {
        return new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"DepositHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]));
    }

    public static boolean judgeUseDemandRate(DynamicObject depositF7, String releaseType, Date redeemDate) {
        Date expireDate;
        boolean isNoticeTemporary = StringUtils.equals((CharSequence)ReleaseTypeEnum.temporary.getValue(), (CharSequence)releaseType);
        boolean isFixInAdvance = StringUtils.equals((CharSequence)ReleaseTypeEnum.inadvance.getValue(), (CharSequence)releaseType);
        boolean isFixAgreeOnAndExpire = false;
        if (StringUtils.equals((CharSequence)ReleaseTypeEnum.expire.getValue(), (CharSequence)releaseType) && EmptyUtil.isNoEmpty((Object)(expireDate = depositF7.getDate("expiredate"))) && redeemDate.compareTo(expireDate) > 0) {
            isFixAgreeOnAndExpire = true;
        }
        return isNoticeTemporary || isFixInAdvance || isFixAgreeOnAndExpire;
    }

    public static Date getExpireDate(Date intDate, String term, DynamicObject productFactory, DynamicObjectCollection workCalendars) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{intDate, term})) {
            return null;
        }
        if (EmptyUtil.isEmpty((DynamicObject)productFactory)) {
            return TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate);
        }
        String adjustRule = productFactory.getString("graceadjustrule");
        return TermHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendars, (Date)TermHelper.getDateByBaseDate4ymd((String)term, (Date)intDate), (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)adjustRule));
    }

    public static BigDecimal getBigDecima(String convert) {
        if (EmptyUtil.isNoEmpty((String)convert)) {
            double convertDouble = Double.parseDouble(convert);
            return BigDecimal.valueOf(convertDouble);
        }
        return null;
    }

    public static void dealResponseResult(List<DepositDetail> details, DynamicObject depositBill, String entityName) {
        DepositDetail detail = details.get(0);
        if (detail.getDetailSeqID().equals(depositBill.getPkValue().toString())) {
            BeBillStatusEnum status = BeServiceHelper.transferState((String)detail.getStatus());
            depositBill.set("bebankstatus", (Object)status.getValue());
            depositBill.set("returnmsg", (Object)detail.getStatusMsg());
            depositBill.set("submittime", (Object)new Date());
            if (BeBillStatusEnum.TS.getValue().equals(status.getValue())) {
                switch (entityName) {
                    case "cim_deposit": {
                        DepositHelper.writeBackDeposit(detail, depositBill);
                        break;
                    }
                    case "cim_release": 
                    case "cim_noticerelease": {
                        DepositHelper.writeBackRelease(detail, depositBill);
                        break;
                    }
                    case "cim_noticedeposit": {
                        DepositHelper.writeBackNoticeDeposit(detail, depositBill);
                        break;
                    }
                    case "cim_deposit_apply": {
                        DepositHelper.writeBackDepositApply(depositBill);
                        depositBill.set("notifyid", (Object)detail.getNotifyId());
                        depositBill.set("reqnbr", (Object)detail.getReqNbr());
                        break;
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{depositBill});
    }

    private static void writeBackDeposit(DepositDetail detail, DynamicObject depositBill) {
        String rate;
        String repRateDate = detail.getRateDate();
        String repEndDate = detail.getEndDate();
        if (EmptyUtil.isNoEmpty((String)repRateDate)) {
            Date intDate = DateUtils.stringToDate((String)repRateDate, (String)"yyyyMMdd");
            depositBill.set("intdate", (Object)intDate);
        }
        if (EmptyUtil.isNoEmpty((String)repEndDate)) {
            Date endDate = DateUtils.stringToDate((String)repEndDate, (String)"yyyyMMdd");
            depositBill.set("expiredate", (Object)endDate);
        }
        if (EmptyUtil.isNoEmpty((String)(rate = detail.getRate()))) {
            depositBill.set("interestrate", (Object)DepositHelper.getBigDecima(rate));
        }
        depositBill.set("expireredeposit", (Object)ExpireRedepositTypeEnum.getValueByEbStatus(detail.getNextDepositType()));
        depositBill.set("finaccount", (Object)detail.getFixedAccNo());
        DepositHelper.writeBackDepositApply(new DynamicObject[]{depositBill}, false);
        depositBill.set("reqnbr", (Object)detail.getReqNbr());
    }

    private static void writeBackRelease(DepositDetail detail, DynamicObject depositBill) {
        String investType;
        String tranDate;
        BigDecimal realRevenue;
        String repEndDate = detail.getEndDate();
        if (EmptyUtil.isNoEmpty((String)repEndDate)) {
            depositBill.set("redeemdate", (Object)DateUtils.stringToDate((String)repEndDate, (String)"yyyyMMdd"));
        }
        if (EmptyUtil.isNoEmpty((BigDecimal)(realRevenue = DepositHelper.getBigDecima(detail.getFixActInt())))) {
            depositBill.set("realrevenue", (Object)realRevenue);
        }
        if (EmptyUtil.isNoEmpty((String)(tranDate = detail.getTranDate()))) {
            depositBill.set("accountdate", (Object)DateUtils.stringToDate((String)tranDate, (String)"yyyyMMdd"));
        }
        if (InvestTypeEnum.isNotice((String)(investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse(""))) && ReleaseTypeEnum.isAgreeon(depositBill.getString("releasetype")) && depositBill.getBoolean("isautodraw")) {
            return;
        }
        Object depositId = depositBill.getDynamicObject("finbillno").getPkValue();
        DynamicObject deposit = TmcDataServiceHelper.loadSingle((Object)depositId, (String)"cim_deposit");
        DepositHelper.setSrcDepositBillValues(deposit, depositBill);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{deposit});
    }

    private static void writeBackNoticeDeposit(DepositDetail detail, DynamicObject depositBill) {
        String fixedAccNo;
        String rate;
        String repRateDate = detail.getRateDate();
        if (EmptyUtil.isNoEmpty((String)repRateDate)) {
            Date intDate = DateUtils.stringToDate((String)repRateDate, (String)"yyyyMMdd");
            depositBill.set("intdate", (Object)intDate);
        }
        if (EmptyUtil.isNoEmpty((String)(rate = detail.getRate()))) {
            depositBill.set("interestrate", (Object)DepositHelper.getBigDecima(rate));
        }
        if (EmptyUtil.isNoEmpty((String)(fixedAccNo = detail.getFixedAccNo()))) {
            depositBill.set("finaccount", (Object)fixedAccNo);
        }
        DepositHelper.writeBackDepositApply(new DynamicObject[]{depositBill}, false);
        depositBill.set("reqnbr", (Object)detail.getReqNbr());
        depositBill.set("notifyid", (Object)detail.getNotifyId());
    }

    public static Long getBankCateId(DynamicObject depositBill, String entityName) {
        DynamicObject bankAcct = null;
        switch (entityName) {
            case "cim_deposit": 
            case "cim_noticedeposit": {
                bankAcct = depositBill.getDynamicObject("settleaccount");
                break;
            }
            case "cim_release": 
            case "cim_noticerelease": {
                bankAcct = depositBill.getDynamicObject("finaccountf7");
            }
        }
        long bankCateId = 0L;
        if (bankAcct == null) {
            return bankCateId;
        }
        DynamicObject bank = bankAcct.getDynamicObject("bank");
        if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
            bank = BusinessDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)bank.getDynamicObjectType().getName(), (String)"bank_cate");
            bankCateId = bank.getDynamicObject("bank_cate").getLong("id");
        }
        return bankCateId;
    }

    public static void setBaseCurrency(IDataModel model) {
        Optional.ofNullable((DynamicObject)model.getValue("org")).map(r -> r.getLong("id")).ifPresent(orgId -> model.setValue("currency", BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId).get("baseCurrencyID")));
    }

    public static void setSrcDepositBillValues(DynamicObject depositBill, DynamicObject releaseBill) {
        Date redeemDate = releaseBill.getDate("redeemdate");
        depositBill.set("lastredeemdate", (Object)redeemDate);
        depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
        BigDecimal redeemAmount = depositBill.getBigDecimal("redeemamount").add(releaseBill.getBigDecimal("amount"));
        depositBill.set("redeemamount", (Object)redeemAmount);
        BigDecimal finAmount = depositBill.getBigDecimal("amount");
        if (redeemAmount.compareTo(finAmount) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6d3b\u91d1\u989d\u8d85\u8fc7\u4e86\u5b58\u6b3e\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepositHelper_0", (String)"tmc-cim-common", (Object[])new Object[0]));
        }
        BigDecimal surplusAmount = finAmount.subtract(redeemAmount);
        depositBill.set("surplusamount", (Object)surplusAmount);
        boolean isRevenue = releaseBill.getBoolean("isrevenue");
        if (BigDecimal.ZERO.compareTo(surplusAmount) == 0) {
            String bizStat = isRevenue ? FinServiceStatusEnum.subscribe_end.getValue() : FinServiceStatusEnum.subscribe_norevenue.getValue();
            depositBill.set("bizstatus", (Object)bizStat);
            Date clearDate = isRevenue ? redeemDate : null;
            depositBill.set("cleardate", (Object)clearDate);
        }
        if (isRevenue && EmptyUtil.isNoEmpty((BigDecimal)releaseBill.getBigDecimal("realrevenue"))) {
            List revenueIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_dptrevenue", (QFilter[])new QFilter[]{new QFilter("srcreleaseid", "=", releaseBill.getPkValue())}, (String)"", (int)-1);
            OperateOption option = OperateOption.create();
            option.setVariableValue("fromReleaseAudit", "true");
            String dtpRevenueName = depositBill.getDynamicObjectType().getName().startsWith("ifm") ? "ifm_dptrevenue" : "cim_dptrevenue";
            TmcOperateServiceHelper.execOperate((String)"audit", (String)dtpRevenueName, (Object[])revenueIds.toArray(), (OperateOption)option);
        }
        DepositHelper.resetRevenueProjectEntry(depositBill);
    }

    public static Date calEndDate(Date startDate, String term) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, term})) {
            return null;
        }
        Calendar temp = Calendar.getInstance();
        temp.setTime(startDate);
        temp.add(2, Integer.parseInt(term));
        return temp.getTime();
    }

    public static Date calStartDate(Date endDate, String term) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{endDate, term})) {
            return null;
        }
        Calendar temp = Calendar.getInstance();
        temp.setTime(endDate);
        temp.add(2, -Integer.parseInt(term));
        return temp.getTime();
    }

    public static String getReleaseEntityName(DynamicObject apply) {
        DynamicObject investVarieties = apply.getDynamicObject("investvarieties");
        String investType = investVarieties.getString("investtype");
        if (InvestTypeEnum.notice.getValue().equals(investType)) {
            return "cim_noticerelease";
        }
        return "cim_release";
    }

    public static String getDepositEntityName(DynamicObject apply) {
        DynamicObject investVarieties = apply.getDynamicObject("investvarieties");
        String investType = "";
        if (EmptyUtil.isNoEmpty((DynamicObject)investVarieties)) {
            investType = investVarieties.getString("investtype");
        }
        if (InvestTypeEnum.notice.getValue().equals(investType)) {
            return "cim_noticedeposit";
        }
        return "cim_deposit";
    }

    public static void showBillForm(Object pkid, IFormView formView, String entityName) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId(pkid);
        parameter.setFormId(entityName);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        formView.showForm((FormShowParameter)parameter);
    }

    public static void showBillListForm(Long[] collectId, IFormView formView, String entityName) {
        QFilter qFilter = new QFilter("id", "in", (Object)collectId);
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)entityName, (boolean)true, (int)0, (boolean)false);
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        parameter.getCustomParams().put("clearSubmitTime", "true");
        formView.showForm((FormShowParameter)parameter);
    }

    public static boolean isSettleCenterBill(DynamicObject depositBill) {
        DynamicObject finOrgInfo = depositBill.getDynamicObject("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return false;
        }
        finOrgInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)finOrgInfo.getPkValue(), (String)"bd_finorginfo", (String)"finorgtype.type");
        return StringUtils.equals((CharSequence)finOrgInfo.getDynamicObject("finorgtype").getString("type"), (CharSequence)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
    }

    public static void matchPayBillByBankCheckFlag(Set<String> bankCheckFlags, boolean isPay) {
        String detailEntity;
        String string = detailEntity = isPay ? "bei_intelpay" : "bei_intelrec";
        if (EmptyUtil.isEmpty(bankCheckFlags)) {
            return;
        }
        List bks = bankCheckFlags.stream().filter(s -> EmptyUtil.isNoEmpty((String)s)).collect(Collectors.toList());
        QFilter detailQF = new QFilter("datasource", "=", (Object)"fromifm");
        detailQF.and(new QFilter("bankcheckflag", "in", bks));
        DynamicObjectCollection details = QueryServiceHelper.query((String)"ifm_transdetail", (String)"id", (QFilter[])detailQF.toArray());
        if (details == null) {
            return;
        }
        Object[] detailids = details.stream().map(o -> o.getLong("id")).toArray();
        ThreadPools.executeOnceIncludeRequestContext((String)"matchbillintelpay", () -> TmcOperateServiceHelper.execOperateWithoutThrow((String)"matchbill", (String)detailEntity, (Object[])detailids, (OperateOption)OperateOption.create()));
    }

    public static String validateSettleBill(DynamicObject data, String operateName) {
        String entityName = data.getDynamicObjectType().getName();
        DynamicObject finOrgInfo = data.getDynamicObject("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return "";
        }
        String errorMsg = "";
        if (DepositHelper.isSettleCenterBill(data)) {
            if (StringUtils.equals((CharSequence)"cim_deposit", (CharSequence)entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u4e1a\u52a1\u5904\u7406\u5355\u7684\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\uff0c%s\u5931\u8d25\uff0c\u8bf7\u5728\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u5217\u8868\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DepositHelper_3", (String)"tmc-cim-common", (Object[])new Object[]{operateName});
            } else if (StringUtils.equals((CharSequence)"cim_noticedeposit", (CharSequence)entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u4e1a\u52a1\u5904\u7406\u5355\u7684\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\uff0c%s\u5931\u8d25\uff0c\u8bf7\u5728\u5185\u90e8\u901a\u77e5\u5b58\u6b3e\u5217\u8868\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DepositHelper_4", (String)"tmc-cim-common", (Object[])new Object[]{operateName});
            } else if (StringUtils.equals((CharSequence)"cim_release", (CharSequence)entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u89e3\u6d3b\u5904\u7406\u5355\u7684\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\uff0c%s\u5931\u8d25\uff0c\u8bf7\u5728\u5185\u90e8\u5b9a\u671f\u5b58\u6b3e\u89e3\u6d3b\u5904\u7406\u5217\u8868\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DepositHelper_5", (String)"tmc-cim-common", (Object[])new Object[]{operateName});
            } else if (StringUtils.equals((CharSequence)"cim_noticerelease", (CharSequence)entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u89e3\u6d3b\u5904\u7406\u5355\u7684\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\uff0c%s\u5931\u8d25\uff0c\u8bf7\u5728\u5185\u90e8\u901a\u77e5\u5b58\u6b3e\u89e3\u6d3b\u5904\u7406\u5217\u8868\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DepositHelper_6", (String)"tmc-cim-common", (Object[])new Object[]{operateName});
            } else if (StringUtils.equals((CharSequence)"cim_deposit_apply", (CharSequence)entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\u7684\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u5b58\u6b3e\u767b\u8bb0\uff0c\u8bf7\u63d0\u4ea4\u7ed3\u7b97\u4e2d\u5fc3\u53d7\u7406\u3002", (String)"DepositHelper_7", (String)"tmc-cim-common", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)"cim_dptrevenue", (CharSequence)entityName)) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5b58\u6b3e\u6536\u76ca\u5355\u7684\u5b58\u6b3e\u673a\u6784\u4e3a\u7ed3\u7b97\u4e2d\u5fc3\uff0c%s\u5931\u8d25\uff0c\u8bf7\u5728\u5185\u90e8\u5b58\u6b3e\u6536\u76ca\u5355\u5217\u8868\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DepositHelper_12", (String)"tmc-cim-common", (Object[])new Object[]{operateName});
            }
        }
        return errorMsg;
    }

    public static void setDepositRateWhenFloat(DynamicObject bill) {
        DynamicObject depositBill = bill.getDynamicObject("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        String intertestType = depositBill.getString("interesttype");
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)intertestType)) {
            Date redeemDate;
            String referRateNumber = Optional.ofNullable(depositBill.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
            if (EmptyUtil.isEmpty((String)referRateNumber)) {
                return;
            }
            Date intStartDate = depositBill.getDate("intdate");
            Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)intStartDate, (Date)(redeemDate = bill.getDate("redeemdate")));
            if (CollectionUtils.isEmpty((Map)rateDateVal)) {
                throw DepositHelper.refferRateNotExistException();
            }
            String rateSign = depositBill.getString("ratesign");
            BigDecimal rateFloatPoint = depositBill.getBigDecimal("ratefloatpoint");
            BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
            if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                rateFloat = rateFloat.negate();
            }
            Object rate = ((TreeMap)rateDateVal).lastEntry().getValue();
            bill.set("interestrate", (Object)((BigDecimal)rate).add(rateFloat));
        }
    }

    public static void setReleaseBillValue(DynamicObject releaseBill) {
        BigDecimal releaseAmt = releaseBill.getBigDecimal("amount");
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt(releaseBill, false);
        DepositHelper.addRevenueCalDetailEntry(releaseBill.getDynamicObjectCollection("entrys"), intBillInfo.getDetails());
        BigDecimal rateAmt = intBillInfo.getAmount().setScale(releaseBill.getDynamicObject("currency").getInt("amtprecision"), RoundingMode.HALF_UP);
        releaseBill.set("predictinstamt", (Object)rateAmt);
        releaseBill.set("realrevenue", (Object)rateAmt);
        releaseBill.set("totalamount", (Object)releaseAmt.add(rateAmt));
        BigDecimal redepositAmt = releaseAmt;
        if (StringUtils.equals((CharSequence)ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue(), (CharSequence)releaseBill.getString("expireredeposit"))) {
            redepositAmt = releaseBill.getBigDecimal("totalamount");
        }
        releaseBill.set("redepositamount", (Object)redepositAmt);
    }

    public static void removeSpareFilter(FilterContainerInitArgs args, String billFormId) {
        List commonFilterColumns = args.getCommonFilterColumns();
        ArrayList<String> removeFeilds = new ArrayList<String>(4);
        removeFeilds.add("bebankstatus");
        removeFeilds.add("submittime");
        if (!billFormId.startsWith("ifm")) {
            removeFeilds.add("finorginfo.name");
        }
        commonFilterColumns.removeIf(v -> removeFeilds.contains(v.getFieldName()));
        args.getFastFilterColumns().removeIf(v -> StringUtils.equalsAny(v.getFieldName(), "finorginfo.name"));
    }

    public static void setDepositBillValues(DynamicObject depositBill) {
        depositBill.set("surplusamount", (Object)depositBill.getBigDecimal("amount"));
        Date startDate = DateUtils.truncateDate((Date)depositBill.getDate("intdate"));
        depositBill.set("intdate", (Object)startDate);
        Date endDate = DateUtils.truncateDate((Date)depositBill.getDate("expiredate"));
        depositBill.set("expiredate", (Object)endDate);
        DepositHelper.setDepositBillType(depositBill);
    }

    public static boolean isExistsRedepositBill(String depositBillNo) {
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("srcdepositno", "=", (Object)depositBillNo));
        return QueryServiceHelper.exists((String)"cim_deposit", (QFilter[])new QFilter[]{qFilter});
    }

    public static Map<String, Boolean> isExistsRedepositBill(List<String> depositBillNos) {
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("srcdepositno", "in", depositBillNos));
        DynamicObjectCollection deposits = QueryServiceHelper.query((String)"cim_deposit", (String)"srcdepositno", (QFilter[])new QFilter[]{qFilter});
        Map<String, Boolean> map = deposits.stream().collect(Collectors.toMap(d -> d.getString("srcdepositno"), d -> Boolean.TRUE));
        depositBillNos.forEach(d -> map.putIfAbsent((String)d, Boolean.FALSE));
        return map;
    }

    public static Map<Long, Boolean> isExistsReleaseBill(String curEntity, List<Long> billIds, String targetEntity) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(billIds.size());
        HashMap<String, QFilter> filterMap = new HashMap<String, QFilter>(1);
        filterMap.put(targetEntity, new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        Map targetBillNoMap = TmcBotpHelper.getTargetBillNoMap((String)curEntity, billIds, null, Collections.singleton(targetEntity), filterMap);
        for (Map.Entry entry : targetBillNoMap.entrySet()) {
            map.put((Long)entry.getKey(), EmptyUtil.isNoEmpty(entry.getValue()));
        }
        billIds.forEach(d -> map.putIfAbsent((Long)d, Boolean.FALSE));
        return map;
    }

    public static boolean isExistsReleaseBill(String curEntity, Long curPkId, String targetEntity) {
        return DepositHelper.isExistsReleaseBill(curEntity, Collections.singletonList(curPkId), targetEntity).get(curPkId);
    }

    public static String getTargetEntity(String curEntity) {
        String targetEntity = "";
        switch (curEntity) {
            case "cim_deposit": {
                targetEntity = "cim_release";
                break;
            }
            case "ifm_deposit": {
                targetEntity = "ifm_release";
                break;
            }
            case "cim_noticedeposit": {
                targetEntity = "cim_noticerelease";
                break;
            }
            case "ifm_notice_deposit": {
                targetEntity = "ifm_notice_release";
                break;
            }
            default: {
                targetEntity = "cim_release";
            }
        }
        return targetEntity;
    }

    public static String getUpstreamEntity(String releaseEntity) {
        String upstreamEntity;
        switch (releaseEntity) {
            case "cim_release": {
                upstreamEntity = "cim_deposit";
                break;
            }
            case "cim_noticerelease": {
                upstreamEntity = "cim_noticedeposit";
                break;
            }
            case "ifm_release": {
                upstreamEntity = "ifm_deposit";
                break;
            }
            case "ifm_notice_release": {
                upstreamEntity = "ifm_notice_deposit";
                break;
            }
            default: {
                upstreamEntity = "cim_deposit";
            }
        }
        return upstreamEntity;
    }

    public static Map<Long, Boolean> isExistsReleaseBill(List<DynamicObject> depositBills) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(depositBills.size());
        depositBills.forEach(d -> map.putIfAbsent(d.getLong("id"), Boolean.FALSE));
        List deposits = depositBills.stream().filter(d -> EmptyUtil.isNoEmpty((String)d.getString("srcdepositno"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(deposits)) {
            return map;
        }
        Map<String, DynamicObject> depositMap = deposits.stream().collect(Collectors.toMap(d -> d.getString("srcdepositno"), d -> d, (d1, d2) -> d1));
        String curEntity = depositBills.get(0).getDataEntityType().getName();
        DynamicObjectCollection srcBills = QueryServiceHelper.query((String)curEntity, (String)"id,billno", (QFilter[])new QFilter("billno", "in", depositMap.keySet()).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)srcBills)) {
            return map;
        }
        Map<Long, String> srcBillNoMap = srcBills.stream().collect(Collectors.toMap(d -> d.getLong("id"), d -> d.getString("billno")));
        String targetEntity = DepositHelper.getTargetEntity(curEntity);
        List<Long> srcBillIds = srcBills.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
        Map<Long, Boolean> existMap = DepositHelper.isExistsReleaseBill(curEntity, srcBillIds, targetEntity);
        for (Map.Entry<Long, Boolean> entry : existMap.entrySet()) {
            DynamicObject depositBill;
            if (!entry.getValue().booleanValue() || (depositBill = depositMap.get(srcBillNoMap.get(entry.getKey()))) == null) continue;
            map.put(depositBill.getLong("id"), Boolean.TRUE);
        }
        return map;
    }

    public static boolean isExistsReleaseBill(DynamicObject depositBill) {
        return DepositHelper.isExistsReleaseBill(Collections.singletonList(depositBill)).get(depositBill.getLong("id"));
    }

    public static void updateSrcAgreeDepositBill(DynamicObject[] dataEntities, String status) {
        List srcBillList = Arrays.stream(dataEntities).filter(r -> r.getBoolean("isredepositgenerate")).map(r -> r.getString("srcdepositno")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(srcBillList)) {
            DynamicObject[] srcBills;
            QFilter qFilter = new QFilter("billno", "in", srcBillList);
            for (DynamicObject srcBill : srcBills = TmcDataServiceHelper.load((String)"cim_agreement_deposit", (String)"status", (QFilter[])new QFilter[]{qFilter})) {
                srcBill.set("status", (Object)status);
            }
            SaveServiceHelper.update((DynamicObject[])srcBills);
        }
    }

    public static void updateSrcDepositApply(DynamicObject[] dataEntities, boolean isAudit) {
        List srcBillIds = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("apply"))).filter(r -> !r.getBoolean("isredepositgenerate")).map(r -> r.getDynamicObject("apply")).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(srcBillIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", srcBillIds);
        Object[] srcBills = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"applystatus", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])srcBills)) {
            return;
        }
        for (Object srcBill : srcBills) {
            srcBill.set("applystatus", (Object)(isAudit ? DepositApplyStatusEnum.HANDLED.getValue() : DepositApplyStatusEnum.HANDING.getValue()));
        }
        SaveServiceHelper.update((DynamicObject[])srcBills);
    }

    public static Map<Long, Boolean> validateRedeposit(List<DynamicObject> deposits) {
        if (EmptyUtil.isEmpty(deposits)) {
            return Collections.emptyMap();
        }
        Set srcDepositNos = deposits.stream().filter(d -> EmptyUtil.isNoEmpty((String)d.getString("srcdepositno"))).map(d -> d.getString("srcdepositno")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(srcDepositNos)) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection depositColl = QueryServiceHelper.query((String)deposits.get(0).getDataEntityType().getName(), (String)"id,srcdepositno", (QFilter[])new QFilter("srcdepositno", "in", srcDepositNos).toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)depositColl)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(deposits.size());
        Map srcDepositNoMap = depositColl.stream().collect(Collectors.groupingBy(d -> d.getString("srcdepositno"), Collectors.mapping(d -> d.getLong("id"), Collectors.toSet())));
        for (DynamicObject deposit : deposits) {
            long depositId = deposit.getLong("id");
            Set depositIds = srcDepositNoMap.get(deposit.getString("srcdepositno"));
            if (!EmptyUtil.isNoEmpty(depositIds) || depositIds.size() <= 1 && depositIds.contains(depositId)) continue;
            map.put(depositId, Boolean.FALSE);
        }
        return map;
    }

    public static boolean validateRedeposit(DynamicObject deposit) {
        if (EmptyUtil.isEmpty((DynamicObject)deposit)) {
            return true;
        }
        String srcDepositNo = deposit.getString("srcdepositno");
        if (EmptyUtil.isEmpty((String)srcDepositNo)) {
            return true;
        }
        String entityName = deposit.getDataEntityType().getName();
        return !TmcDataServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("srcdepositno", "=", (Object)srcDepositNo), new QFilter("id", "!=", deposit.getPkValue())});
    }

    public static Date getAutoReDepositDate(DynamicObject depositBill) {
        String preNoticeDay = depositBill.getString("prenoticeday");
        Date intDate = depositBill.getDate("intdate");
        if (null == intDate) {
            return null;
        }
        if (StringUtils.equals((CharSequence)preNoticeDay, (CharSequence)"01")) {
            return DateUtils.getNextDay((Date)intDate, (int)1);
        }
        if (StringUtils.equals((CharSequence)preNoticeDay, (CharSequence)"07")) {
            return DateUtils.getNextDay((Date)intDate, (int)7);
        }
        return null;
    }

    public static boolean isNoticeDeposit(DynamicObject depositBill) {
        if (null == depositBill) {
            return false;
        }
        DynamicObject investVarieties = depositBill.getDynamicObject("investvarieties");
        if (null == investVarieties) {
            return false;
        }
        investVarieties = TmcDataServiceHelper.loadSingleFromCache((Object)investVarieties.getPkValue(), (String)investVarieties.getDynamicObjectType().getName());
        return StringUtils.equals((CharSequence)investVarieties.getString("investtype"), (CharSequence)InvestTypeEnum.notice.getValue());
    }

    public static void writeBackDepositApply(DynamicObject[] depositBills, boolean unAudit) {
        if (EmptyUtil.isEmpty((Object[])depositBills)) {
            return;
        }
        DepositHelper.dealRedepositScene(depositBills, unAudit);
        DepositHelper.writeBackApplyByDepoitApply(depositBills, unAudit);
    }

    private static void writeBackApplyByDepoitApply(DynamicObject[] depositBills, boolean unAudit) {
        Set applyIdSet = Arrays.stream(depositBills).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("apply"))).map(r -> r.getDynamicObject("apply")).filter(r -> DepositApplyTypeEnum.isDeposit(r.getString("applytype"))).map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(applyIdSet)) {
            return;
        }
        QFilter qFilter = new QFilter("apply", "in", applyIdSet);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        DynamicObjectCollection existDepositCols = QueryServiceHelper.query((String)"cim_deposit", (String)"apply,amount", (QFilter[])new QFilter[]{qFilter}, (String)"");
        Map<Long, BigDecimal> apply2AmtMap = existDepositCols.stream().collect(Collectors.groupingBy(r -> r.getLong("apply"), Collectors.mapping(r -> r.getBigDecimal("amount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        LOG.info("\u67e5\u8be2\u5230\u5df2\u5ba1\u6838\u7684\u5b58\u6b3e\u5355apply2AmtMap\uff1a{}", apply2AmtMap);
        Object[] applyArr = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"id,applystatus,lastamount,addamount,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIdSet)});
        if (EmptyUtil.isEmpty((Object[])applyArr)) {
            return;
        }
        for (Object depositApply : applyArr) {
            depositApply.set("applystatus", (Object)(unAudit ? DepositApplyStatusEnum.HANDING.getValue() : DepositApplyStatusEnum.HANDLED.getValue()));
            BigDecimal totalDepositAmt = apply2AmtMap.getOrDefault(depositApply.getLong("id"), BigDecimal.ZERO);
            LOG.info("\u5f53\u524d\u5b58\u6b3e\u5355id={}\u7684\u7d2f\u8ba1\u5df2\u7533\u8bf7\u91d1\u989d\u4e3a{}", (Object)depositApply.getLong("id"), (Object)totalDepositAmt);
            BigDecimal applyAmount = depositApply.getBigDecimal("amount");
            if (totalDepositAmt.compareTo(applyAmount) < 0 && totalDepositAmt.compareTo(BigDecimal.ZERO) > 0) {
                depositApply.set("applystatus", (Object)DepositApplyStatusEnum.PARTHANDLED.getValue());
            }
            depositApply.set("addamount", (Object)totalDepositAmt);
            depositApply.set("lastamount", (Object)applyAmount.subtract(totalDepositAmt));
        }
        SaveServiceHelper.update((DynamicObject[])applyArr);
    }

    private static void dealRedepositScene(DynamicObject[] depositBills, boolean unAudit) {
        Set applyIdSet = Arrays.stream(depositBills).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("apply"))).map(r -> r.getDynamicObject("apply")).filter(r -> DepositApplyTypeEnum.isSubsist(r.getString("applytype"))).map(r -> r.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(applyIdSet)) {
            return;
        }
        Object[] applyArr = TmcDataServiceHelper.load((String)"cim_deposit_apply", (String)"applystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIdSet)});
        if (EmptyUtil.isEmpty((Object[])applyArr)) {
            return;
        }
        for (Object apply : applyArr) {
            apply.set("applystatus", (Object)(unAudit ? DepositApplyStatusEnum.HANDING.getValue() : DepositApplyStatusEnum.HANDLED.getValue()));
        }
        SaveServiceHelper.update((DynamicObject[])applyArr);
    }

    public static void setRevenueEntry(DynamicObject revenueBill, IntBillInfo intBillInfo) {
        if (EmptyUtil.isEmpty((Object)intBillInfo)) {
            return;
        }
        revenueBill.set("prestartdate", (Object)intBillInfo.getBeginDate());
        revenueBill.set("prestenddate", (Object)intBillInfo.getEndDate());
        revenueBill.set("predictpreinstamt", (Object)intBillInfo.getAmount());
        revenueBill.set("actpreinstamt", (Object)intBillInfo.getAmount());
        List details = intBillInfo.getDetails();
        DynamicObjectCollection entrys = revenueBill.getDynamicObjectCollection("entrys");
        entrys.clear();
        if (EmptyUtil.isEmpty((Collection)details)) {
            return;
        }
        for (IntBillDetailInfo intDetail : details) {
            DynamicObject newRow = entrys.addNew();
            newRow.set("inststartdate", (Object)intDetail.getBeginDate());
            newRow.set("instenddate", (Object)intDetail.getEndDate());
            newRow.set("instdays", (Object)intDetail.getDays());
            newRow.set("instprincipalamt", (Object)intDetail.getPrinciple());
            newRow.set("rate", (Object)intDetail.getRate());
            newRow.set("ratetrandays", (Object)intDetail.getBasisDay());
            newRow.set("instamt", (Object)intDetail.getAmount());
        }
    }

    public static void resetRevenueProjectEntry(List<DynamicObject> depositBills) {
        depositIntPlanService.resetRevenueProjectEntry(depositBills, "");
    }

    public static void resetRevenueProjectEntry(DynamicObject depositBill) {
        depositIntPlanService.resetRevenueProjectEntry(depositBill);
    }

    public static void resetRevenueProjectEntry(DynamicObject depositBill, String operateKey) {
        depositIntPlanService.resetRevenueProjectEntry(depositBill, operateKey);
    }

    public static Map<Long, DynamicObject> getDepositId2BillMap(DynamicObject[] dataEntity) {
        Object[] depositIds = Arrays.stream(dataEntity).map(r -> r.getLong("sourcebillid")).toArray();
        DynamicObject[] depositBills = TmcDataServiceHelper.load((Object[])depositIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"));
        return Arrays.stream(depositBills).collect(Collectors.toMap(r -> r.getLong("id"), r -> r));
    }

    public static Object pushtoRevenueAndSubmit(DynamicObject row, Map<Long, DynamicObject> depositMap, Date revenueDate) {
        String intComment;
        DynamicObject depositBill = depositMap.get(row.getLong("loanbillid"));
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return null;
        }
        String batchBillName = row.getDynamicObjectType().getParent().getName();
        Pair<String, String> batchRevenuePair = DepositHelper.getBatchRevenuePair(batchBillName, depositBill);
        OperateOption option = OperateOption.create();
        Object[] depositIds = new Object[]{depositBill.getLong("id")};
        OperationResult result = null;
        String entityName = (String)batchRevenuePair.getRight();
        try {
            DepositHelper.push2Revenue(row, revenueDate, option, batchRevenuePair, depositIds);
            QFilter qFilter = new QFilter("sourcebillid", "in", (Object)depositIds);
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
            List intBillIds = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])new QFilter[]{qFilter}, (String)"bizdate", (int)1);
            option.setVariableValue("WF", "TRUE");
            result = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (Object[])new Object[]{intBillIds.get(0)}, (OperateOption)option, (boolean)false);
        }
        catch (Exception e) {
            row.set("status", (Object)"fail");
            intComment = String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u6536\u76ca\u5355\u751f\u6210\u5931\u8d25\uff1a%s\u3002", (String)"DepositHelper_10", (String)"tmc-cim-common", (Object[])new Object[0]), e.getMessage());
            row.set("intcomment", (Object)(intComment.length() > 255 ? intComment.substring(0, 254) : intComment));
        }
        if (result == null) {
            return null;
        }
        Object intBillId = result.getSuccessPkIds().toArray()[0];
        row.set("status", (Object)"success");
        row.set("intdetailnum", result.getBillNos().values().toArray()[0]);
        row.set("intbillid", intBillId);
        intComment = DepositHelper.buildIntComment(depositBill, row.getBigDecimal("actualinstamt"), revenueDate);
        row.set("intcomment", (Object)intComment);
        return intBillId;
    }

    public static boolean revenueAudit(DynamicObject row, Map<Long, DynamicObject> depositMap, Date revenueDate) {
        DynamicObject depositBill = depositMap.get(row.getLong("loanbillid"));
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return false;
        }
        String batchBillName = row.getDynamicObjectType().getParent().getName();
        Pair<String, String> batchRevenuePair = DepositHelper.getBatchRevenuePair(batchBillName, depositBill);
        OperateOption option = OperateOption.create();
        String entityName = (String)batchRevenuePair.getRight();
        try {
            DynamicObject revenueBill = TmcDataServiceHelper.loadSingle((Object)row.getLong("intbillid"), (String)entityName);
            revenueBill.set("actpreinstamt", (Object)row.getBigDecimal("actualinstamt"));
            TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (DynamicObject[])new DynamicObject[]{revenueBill}, (OperateOption)option, (boolean)false);
            row.set("status", (Object)"success");
            String intComment = DepositHelper.buildIntComment(depositBill, row.getBigDecimal("actualinstamt"), revenueDate);
            row.set("intcomment", (Object)intComment);
        }
        catch (Exception e) {
            row.set("status", (Object)"fail");
            row.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u6536\u76ca\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s\u3002", (String)"DepositHelper_11", (String)"tmc-cim-common", (Object[])new Object[0]), e.getMessage().length() > 255 ? e.getMessage().substring(0, 254) : e.getMessage()));
            return false;
        }
        return true;
    }

    public static boolean pushToRevenueAndAudit(DynamicObject row, Map<Long, DynamicObject> depositMap, Date revenueDate) {
        DynamicObject depositBill = depositMap.get(row.getLong("loanbillid"));
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return false;
        }
        String batchBillName = row.getDynamicObjectType().getParent().getName();
        Pair<String, String> batchRevenuePair = DepositHelper.getBatchRevenuePair(batchBillName, depositBill);
        OperateOption option = OperateOption.create();
        Object[] depositIds = new Object[]{depositBill.getLong("id")};
        OperationResult result = null;
        String entityName = (String)batchRevenuePair.getRight();
        try {
            DepositHelper.push2Revenue(row, revenueDate, option, batchRevenuePair, depositIds);
            QFilter qFilter = new QFilter("sourcebillid", "in", (Object)depositIds);
            qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
            List intBillIds = QueryServiceHelper.queryPrimaryKeys((String)"cim_dptrevenue", (QFilter[])new QFilter[]{qFilter}, (String)"bizdate", (int)1);
            option.setVariableValue("WF", "TRUE");
            result = TmcOperateServiceHelper.execOperate((String)"submit", (String)entityName, (Object[])new Object[]{intBillIds.get(0)}, (OperateOption)option);
        }
        catch (Exception e) {
            row.set("status", (Object)"fail");
            row.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u6536\u76ca\u5355\u751f\u6210\u5931\u8d25\uff1a%s\u3002", (String)"DepositHelper_10", (String)"tmc-cim-common", (Object[])new Object[0]), e.getMessage().length() > 255 ? e.getMessage().substring(0, 254) : e.getMessage()));
        }
        if (result == null) {
            return false;
        }
        Object intBillId = result.getSuccessPkIds().toArray()[0];
        try {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)entityName, (Object[])new Object[]{intBillId}, (OperateOption)option);
            row.set("status", (Object)"success");
            row.set("intdetailnum", result.getBillNos().values().toArray()[0]);
            row.set("intbillid", intBillId);
            String intComment = DepositHelper.buildIntComment(depositBill, row.getBigDecimal("actualinstamt"), revenueDate);
            row.set("intcomment", (Object)intComment);
        }
        catch (Exception e) {
            TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)entityName, (Object[])new Object[]{intBillId}, (OperateOption)option);
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityName, (Object[])new Object[]{intBillId}, (OperateOption)option);
            row.set("status", (Object)"fail");
            row.set("intcomment", (Object)String.format(ResManager.loadKDString((String)"\u5b58\u6b3e\u6536\u76ca\u5355\u5ba1\u6838\u5931\u8d25\uff1a%s\u3002", (String)"DepositHelper_11", (String)"tmc-cim-common", (Object[])new Object[0]), e.getMessage().length() > 255 ? e.getMessage().substring(0, 254) : e.getMessage()));
            return false;
        }
        return true;
    }

    private static void push2Revenue(DynamicObject row, Date revenueDate, OperateOption option, Pair<String, String> batchRevenuePair, Object[] depositIds) {
        RevenueConvertParam.SourceParam sourceParam = new RevenueConvertParam.SourceParam((Long)depositIds[0]);
        sourceParam.addOption("intdetail_tag", row.getString("intdetail_tag")).addOption("startdate", DateUtils.formatString((Date)row.getDate("startdate"), (String)"yyyy-MM-dd")).addOption("actualinstamt", row.getBigDecimal("actualinstamt").toString()).addOption("revenuedate", DateUtils.formatString((Date)revenueDate, (String)"yyyy-MM-dd"));
        RevenueConvertParam convertParam = new RevenueConvertParam("fromBatch");
        convertParam.addParam(sourceParam);
        option.setVariableValue("const_operate_var", "fromBatch");
        option.setVariableValue("const_operate_params", SerializationUtils.toJsonString((Object)convertParam));
        TmcOperateServiceHelper.execOperate((String)"push2revenue", (String)((String)batchRevenuePair.getLeft()), (Object[])depositIds, (OperateOption)option, (boolean)true);
    }

    public static BigDecimal calcRealRate(DynamicObjectCollection rows, BigDecimal revenueAmt) {
        BigDecimal totalPlanAmt = BigDecimal.ZERO;
        BigDecimal totalFinAmt = BigDecimal.ZERO;
        for (Object row : rows) {
            totalPlanAmt = totalPlanAmt.add(row.getBigDecimal("instamt"));
            totalFinAmt = totalFinAmt.add(row.getBigDecimal("instprincipalamt"));
        }
        ArrayList<BigDecimal> realRateList = new ArrayList<BigDecimal>(rows.size());
        for (DynamicObject row : rows) {
            BigDecimal dividedAmt = row.getBigDecimal("instprincipalamt").multiply(new BigDecimal(row.getInt("instdays"))).multiply(totalPlanAmt);
            if (EmptyUtil.isEmpty((BigDecimal)dividedAmt)) {
                return BigDecimal.ZERO;
            }
            BigDecimal realRatePerRow = revenueAmt.multiply(row.getBigDecimal("instamt")).multiply(new BigDecimal(row.getInt("ratetrandays"))).divide(dividedAmt, 10, 4);
            BigDecimal perRate = realRatePerRow.multiply(row.getBigDecimal("instprincipalamt")).multiply(new BigDecimal("100")).divide(totalFinAmt, 10, 4);
            realRateList.add(perRate);
        }
        BigDecimal realRate = realRateList.stream().reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        DepositHelper.validateIntMaxValue(realRate);
        return realRate;
    }

    private static void validateIntMaxValue(BigDecimal amount) {
        if (amount.compareTo(RATE_MAX) > 0) {
            LOG.info("\u5b9e\u9645\u6536\u76ca\u7387\u503c:{}", (Object)amount);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u9645\u6536\u76ca\u7387\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RevenueCalcHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]));
        }
    }

    public static boolean isNeedConfirm(DynamicObject revenueBill) {
        String entityName = revenueBill.getDataEntityType().getName();
        return StringUtils.equals((CharSequence)entityName, (CharSequence)"cim_dptrevenue") && DepositHelper.isSettleBill(revenueBill);
    }

    public static void writeBackDptRevAmt(List<DynamicObject> revenueBills, String operateKey) {
        if (EmptyUtil.isEmpty(revenueBills)) {
            return;
        }
        Map<Long, DynamicObject> depositId2BillMap = DepositHelper.getDepositId2BillMap(revenueBills.toArray(new DynamicObject[0]));
        HashSet<DynamicObject> depositList = new HashSet<DynamicObject>(revenueBills.size());
        for (DynamicObject revenue : revenueBills) {
            String revenueSort = revenue.getString("revenuesort");
            DynamicObject depositBill = depositId2BillMap.get(revenue.getLong("sourcebillid"));
            if (RevenueSortEnum.isNeedResetProjectEntry(revenueSort)) {
                DepositHelper.resetRevenueProjectEntry(depositBill, operateKey);
            }
            BigDecimal totalAmt = depositBill.getBigDecimal("totalamount").add(revenue.getBigDecimal("actpreinstamt"));
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"substract")) {
                totalAmt = depositBill.getBigDecimal("totalamount").subtract(revenue.getBigDecimal("actpreinstamt"));
            }
            depositBill.set("totalamount", (Object)totalAmt);
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"add")) {
                if (FinServiceStatusEnum.isSubscribeNorevenue(depositBill.getString("bizstatus"))) {
                    depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
                    depositBill.set("cleardate", (Object)revenue.getDate("bizdate"));
                }
            } else if (EmptyUtil.isEmpty((BigDecimal)depositBill.getBigDecimal("surplusamount"))) {
                depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_norevenue.getValue());
                depositBill.set("cleardate", null);
            }
            depositList.add(depositBill);
        }
        if (EmptyUtil.isNoEmpty(depositList)) {
            SaveServiceHelper.save((DynamicObject[])depositList.toArray(new DynamicObject[0]));
        }
    }

    public static Set<Long> getRevPlanAuthedOrgIds(String appId, String formId) {
        HashSet<Long> orgSet = new HashSet<Long>(16);
        long userId = RequestContext.get().getCurrUserId();
        String fixedEntity = formId.startsWith("cim_") ? "cim_deposit" : "ifm_deposit";
        List fixedList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)fixedEntity, (String)"47150e89000000ac");
        orgSet.addAll(fixedList);
        String noticeEntity = formId.startsWith("cim_") ? "cim_noticedeposit" : "ifm_notice_deposit";
        List noticeList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userId, (String)appId, (String)noticeEntity, (String)"47150e89000000ac");
        orgSet.addAll(noticeList);
        return orgSet;
    }

    public static Pair<String, String> getBatchRevenuePair(String batchBillName, DynamicObject depositBill) {
        String revenueBillName;
        String depositBillName;
        DynamicObject investVarieties = null == depositBill ? null : depositBill.getDynamicObject("investvarieties");
        String investType = "";
        if (null != investVarieties) {
            investType = investVarieties.getString("investtype");
        }
        if (StringUtils.equals((CharSequence)batchBillName, (CharSequence)"cim_dptrevenuebatch")) {
            depositBillName = InvestTypeEnum.notice.getValue().equals(investType) ? "cim_noticedeposit" : "cim_deposit";
            revenueBillName = "cim_dptrevenue";
        } else {
            depositBillName = InvestTypeEnum.notice.getValue().equals(investType) ? "ifm_notice_deposit" : "ifm_deposit";
            revenueBillName = "ifm_dptrevenue";
        }
        return Pair.of((Object)depositBillName, (Object)revenueBillName);
    }

    public static Pair<String, String> getOtherSideBotpPair(DynamicObject revenueBill) {
        String revBillName;
        String dptBillName;
        String revenueBillName = revenueBill.getDynamicObjectType().getName();
        DynamicObject investVarieties = revenueBill.getDynamicObject("investvarieties");
        String investType = investVarieties.getString("investtype");
        if (StringUtils.equals((CharSequence)revenueBillName, (CharSequence)"cim_dptrevenue")) {
            dptBillName = StringUtils.equals((CharSequence)investType, (CharSequence)"fixed") ? "ifm_deposit" : "ifm_notice_deposit";
            revBillName = "ifm_dptrevenue";
        } else {
            dptBillName = StringUtils.equals((CharSequence)investType, (CharSequence)"fixed") ? "cim_deposit" : "cim_noticedeposit";
            revBillName = "cim_dptrevenue";
        }
        return Pair.of((Object)dptBillName, (Object)revBillName);
    }

    private static void setDepositBillType(DynamicObject depositBill) {
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        boolean isSettleCenter = DepositHelper.isSettleCenterBill(depositBill);
        String billType = "";
        if (!isSettleCenter) {
            if (InvestTypeEnum.isFixed((String)investType)) {
                billType = "cim_deposit";
            } else if (InvestTypeEnum.isNotice((String)investType)) {
                billType = "cim_noticedeposit";
            }
        } else if (InvestTypeEnum.isFixed((String)investType)) {
            billType = "ifm_deposit";
        } else if (InvestTypeEnum.isNotice((String)investType)) {
            billType = "ifm_notice_deposit";
        }
        depositBill.set("billtype", (Object)billType);
    }

    public static boolean isSettleBill(DynamicObject revenueBill) {
        DynamicObject finOrgInfo = revenueBill.getDynamicObject("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrgInfo)) {
            return false;
        }
        finOrgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)finOrgInfo.getPkValue(), (String)"bd_finorginfo");
        String type = finOrgInfo.getDynamicObject("finorgtype").getString("type");
        return StringUtils.equals((CharSequence)type, (CharSequence)"1");
    }

    public static String buildIntComment(DynamicObject depositBill, BigDecimal revenueAmt, Date revenueDate) {
        String baseComment = ResManager.loadKDString((String)"\u5b58\u6b3e\u5355\u7f16\u53f7%1$s,%2$s\u6536\u76ca%3$s%4$s", (String)"DepositHelper_13", (String)"tmc-cim-common", (Object[])new Object[0]);
        return String.format(baseComment, depositBill.getString("billno"), DateUtils.formatString((Date)revenueDate, (String)"yyyyMMdd"), depositBill.getDynamicObject("currency").getString("name"), revenueAmt);
    }

    public static boolean validateHandRedeemAmt(BigDecimal handReleaseAmt, BigDecimal depositAmt) {
        return handReleaseAmt.compareTo(depositAmt) > 0;
    }

    public static boolean validateHandEndPre(Date lastPreDate, Date startDate) {
        return EmptyUtil.isNoEmpty((Object)lastPreDate) && lastPreDate.compareTo(startDate) <= 0;
    }

    public static boolean validateHandLastRev(Date lastRevenueDate, Date startDate) {
        return EmptyUtil.isNoEmpty((Object)lastRevenueDate) && lastRevenueDate.compareTo(startDate) < 0;
    }

    public static boolean validateHandAmtAndDate(Date lastRevenueDate, BigDecimal handRevenueAmt) {
        return EmptyUtil.isEmpty((Object)lastRevenueDate) && EmptyUtil.isNoEmpty((BigDecimal)handRevenueAmt) || EmptyUtil.isNoEmpty((Object)lastRevenueDate) && EmptyUtil.isEmpty((BigDecimal)handRevenueAmt);
    }

    public static boolean validateHandReleaseAndRevenue(BigDecimal handReleaseAmt, BigDecimal handRevenueAmt) {
        return EmptyUtil.isNoEmpty((BigDecimal)handReleaseAmt) && EmptyUtil.isEmpty((BigDecimal)handRevenueAmt);
    }

    public static boolean validateHandEndPreAndRev(Date lastPreDate, Date lastRevenueDate) {
        return EmptyUtil.isNoEmpty((Object)lastRevenueDate) && EmptyUtil.isEmpty((Object)lastPreDate) || EmptyUtil.isNoEmpty((Object)lastRevenueDate) && EmptyUtil.isNoEmpty((Object)lastPreDate) && lastPreDate.compareTo(lastRevenueDate) < 0;
    }

    public static void doPush2ReleaseBill(DynamicObject apply) {
        DynamicObject depositF7 = apply.getDynamicObject("deposit");
        DynamicObject depositBill = TmcDataServiceHelper.loadSingle((Object)depositF7.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)DepositHelper.getDepositEntityName(apply)));
        DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)depositBill, (String)DepositHelper.getReleaseEntityName(apply));
        DynamicObject targetBill = targetBills[0];
        targetBill.set("amount", apply.get("releaseamount"));
        Date estimateDate = apply.getDate("estimatedate");
        if (EmptyUtil.isNoEmpty((Object)estimateDate)) {
            targetBill.set("redeemdate", (Object)estimateDate);
        }
        targetBill.set("releasetype", apply.get("releasetype"));
        targetBill.set("apply", (Object)apply);
        targetBill.set("finaccountf7", apply.getDynamicObject("finaccountf7").getPkValue());
        targetBill.set("interestrate", (Object)apply.getBigDecimal("interestrate"));
        DepositHelper.setDepositRateWhenFloatRate(targetBill);
        DepositHelper.setTransferInfo(targetBill, apply);
        DepositHelper.reCalInterest(targetBill, depositBill);
        targetBill.set("realrevenue", (Object)apply.getBigDecimal("profitamount"));
        targetBill.set("totalamount", (Object)targetBill.getBigDecimal("amount").add(targetBill.getBigDecimal("realrevenue")));
        targetBill.set("isautodraw", (Object)apply.getBoolean("isautodraw"));
        targetBill.set("accountdate", (Object)apply.getDate("accountdate"));
        TmcOperateServiceHelper.execOperate((String)"save", (String)DepositHelper.getReleaseEntityName(apply), (DynamicObject[])targetBills, (OperateOption)OperateOption.create(), (boolean)true);
        TmcBotpHelper.saveRelation((DynamicObject)apply, (DynamicObject)targetBill);
    }

    public static void setDepositRateWhenFloatRate(DynamicObject releaseBill) {
        DynamicObject depositBill = releaseBill.getDynamicObject("finbillno");
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        String interestType = depositBill.getString("interesttype");
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) {
            Date redeemDate;
            String referRateNumber = Optional.ofNullable(depositBill.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
            if (EmptyUtil.isEmpty((String)referRateNumber)) {
                return;
            }
            Date intStartDate = depositBill.getDate("intdate");
            Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)intStartDate, (Date)(redeemDate = releaseBill.getDate("redeemdate")));
            if (EmptyUtil.isEmpty((Object)rateDateVal)) {
                throw DepositHelper.refferRateNotExistException();
            }
            String rateSign = depositBill.getString("ratesign");
            BigDecimal rateFloatPoint = depositBill.getBigDecimal("ratefloatpoint");
            BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
            if (kd.tmc.cim.common.enums.RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
                rateFloat = rateFloat.negate();
            }
            Object rate = ((TreeMap)rateDateVal).lastEntry().getValue();
            releaseBill.set("interestrate", (Object)((BigDecimal)rate).add(rateFloat));
        }
    }

    private static void reCalInterest(DynamicObject releaseBill, DynamicObject deposit) {
        IntBillInfo intBillInfo = DepositHelper.calcDepositBillInt(releaseBill, releaseBill.getBoolean("accepttransfer"));
        if (!releaseBill.getBoolean("isrevenue")) {
            releaseBill.set("predictinstamt", null);
            releaseBill.getDynamicObjectCollection("entrys").clear();
            return;
        }
        BigDecimal rateAmt = intBillInfo.getAmount().setScale(releaseBill.getDynamicObject("currency").getInt("amtprecision"), RoundingMode.HALF_UP);
        releaseBill.set("predictinstamt", (Object)rateAmt);
        DynamicObject depositF7 = releaseBill.getDynamicObject("finbillno");
        Date redeemDate = releaseBill.getDate("redeemdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{depositF7, redeemDate})) {
            return;
        }
        DepositHelper.addRevenueCalDetailEntry(releaseBill.getDynamicObjectCollection("entrys"), intBillInfo.getDetails());
        DepositHelper.setRedepositAmount(depositF7, releaseBill);
    }

    private static void setRedepositAmount(DynamicObject depositBill, DynamicObject releaseBill) {
        if (EmptyUtil.isEmpty((DynamicObject)depositBill)) {
            return;
        }
        String expireRedeposit = releaseBill.getString("expireredeposit");
        BigDecimal depositSurplusAmt = releaseBill.getBigDecimal("amount");
        BigDecimal redepositAmt = BigDecimal.ZERO;
        if (ExpireRedepositTypeEnum.PRINCIPALREDEPOSIT.getValue().equals(expireRedeposit)) {
            redepositAmt = depositSurplusAmt;
        } else if (ExpireRedepositTypeEnum.PRINCIPALINTREDEPOSIT.getValue().equals(expireRedeposit)) {
            redepositAmt = depositSurplusAmt.add(releaseBill.getBigDecimal("realrevenue"));
        }
        releaseBill.set("redepositamount", (Object)redepositAmt);
    }

    private static void writeBackDepositApply(DynamicObject depositBill) {
        DepositHelper.doPush2ReleaseBill(depositBill);
        Object[] noticeReleaseIds = TmcBotpHelper.getTargetBillIds((String)"cim_deposit_apply", (Object)depositBill.getPkValue(), (String)"cim_noticerelease");
        if (EmptyUtil.isEmpty((Object[])noticeReleaseIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("fromApplySync", "true");
        option.setVariableValue("WF", "TRUE");
        OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"cim_noticerelease", (Object[])noticeReleaseIds, (OperateOption)option);
        if (submitResult.isSuccess()) {
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"cim_noticerelease", (Object[])noticeReleaseIds, (OperateOption)option);
        }
    }

    public static void initInterestTypeEnum(IFormView view, IDataModel model, String invar, String rateControl) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        ComboItem item1 = new ComboItem();
        item1.setValue(InterestTypeEnum.FIXED.getValue());
        item1.setCaption(new LocaleString(InterestTypeEnum.getName(InterestTypeEnum.FIXED.getValue())));
        comboItems.add(item1);
        ComboItem item2 = new ComboItem();
        item2.setValue(InterestTypeEnum.FLOAT.getValue());
        item2.setCaption(new LocaleString(InterestTypeEnum.getName(InterestTypeEnum.FLOAT.getValue())));
        comboItems.add(item2);
        String investVar = "";
        DynamicObject invariDyn = (DynamicObject)model.getValue(invar);
        if (EmptyUtil.isNoEmpty((DynamicObject)invariDyn)) {
            if (invariDyn.getDynamicObjectType().getProperties().containsKey((Object)"investtype")) {
                investVar = invariDyn.getString("investtype");
            } else {
                DynamicObject investVarieties = QueryServiceHelper.queryOne((String)"cim_investvarieties", (String)"investtype", (QFilter[])new QFilter[]{new QFilter("id", "=", invariDyn.getPkValue())});
                investVar = Optional.ofNullable(investVarieties).map(r -> r.getString("investtype")).orElse("");
            }
        }
        if (InvestTypeEnum.isStructure((String)investVar)) {
            ComboItem item3 = new ComboItem();
            item3.setValue(InterestTypeEnum.RANGE.getValue());
            item3.setCaption(new LocaleString(InterestTypeEnum.getName(InterestTypeEnum.RANGE.getValue())));
            comboItems.add(item3);
        }
        ComboEdit rateType = (ComboEdit)view.getControl(rateControl);
        rateType.setComboItems(comboItems);
    }

    public static List<String> validateRangeRate(DynamicObject apply, boolean isEntryProp) {
        ArrayList<String> list = new ArrayList<String>(8);
        if (!InterestTypeEnum.isRange(apply.getString(isEntryProp ? "c_interesttype" : "interesttype"))) {
            return list;
        }
        BigDecimal rangeMin = apply.getBigDecimal(isEntryProp ? "c_rangemin" : "rangemin");
        BigDecimal rangeMax = apply.getBigDecimal(isEntryProp ? "c_rangemax" : "rangemax");
        if (EmptyUtil.isEmpty((BigDecimal)rangeMin) && EmptyUtil.isEmpty((BigDecimal)rangeMax)) {
            return list;
        }
        if (EmptyUtil.isEmpty((BigDecimal)rangeMin) && EmptyUtil.isNoEmpty((BigDecimal)rangeMax) || EmptyUtil.isNoEmpty((BigDecimal)rangeMin) && EmptyUtil.isEmpty((BigDecimal)rangeMax)) {
            list.add(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u5f55\u5165\u5229\u7387\u533a\u95f4\u3002", (String)"DepositApplySubmitValidator_15", (String)"tmc-cim-business", (Object[])new Object[0]));
        } else if (rangeMin.compareTo(rangeMax) >= 0) {
            list.add(ResManager.loadKDString((String)"\u5229\u7387\u533a\u95f4\u8d77\u59cb\u503c\u9700\u5c0f\u4e8e\u7ec8\u6b62\u503c\u3002", (String)"DepositApplySubmitValidator_16", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        BigDecimal interestRate = apply.getBigDecimal(isEntryProp ? "c_interestrate" : "interestrate");
        if (EmptyUtil.isEmpty((BigDecimal)interestRate)) {
            return list;
        }
        if (interestRate.compareTo(rangeMin) < 0 || interestRate.compareTo(rangeMax) > 0) {
            list.add(ResManager.loadKDString((String)"\u5b58\u6b3e\u5229\u7387\u9700\u5728\u5229\u7387\u533a\u95f4\u8303\u56f4\u5185\u3002", (String)"DepositApplySubmitValidator_17", (String)"tmc-cim-business", (Object[])new Object[0]));
        }
        return list;
    }

    public static void setScOrg(DynamicObject depositBill) {
        DynamicObject finOrgInfo = depositBill.getDynamicObject("finorginfo");
        if (!DepositHelper.isScFinOrg(finOrgInfo)) {
            LOG.info("\u5b58\u6b3e\u673a\u6784\u4e3a\u7a7a\u6216\u5b58\u6b3e\u673a\u6784\u4e1a\u52a1\u5355\u5143\u975e\u7ed3\u7b97\u4e2d\u5fc3\uff0c\u4e0d\u9700\u8981\u8d4b\u503c");
            return;
        }
        DynamicObject scOrg = finOrgInfo.getDynamicObject("org");
        if (null != scOrg) {
            LOG.info("\u7ed3\u7b97\u4e2d\u5fc3\uff1a{}", scOrg.getPkValue());
            depositBill.set("scorg", scOrg.getPkValue());
        }
    }

    private static boolean isScFinOrg(DynamicObject finOrgInfo) {
        if (null == finOrgInfo) {
            LOG.error("\u5b58\u6b3e\u673a\u6784\u4e3a\u7a7a");
            return false;
        }
        finOrgInfo = QueryServiceHelper.queryOne((String)"bd_finorginfo", (String)"finorgtype.type", (QFilter[])new QFilter[]{new QFilter("id", "=", finOrgInfo.getPkValue())});
        return StringUtils.equals((CharSequence)finOrgInfo.getString("finorgtype.type"), (CharSequence)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
    }

    public static List<Object> getScFinOrgTypeIds() {
        QFilter finOrgFilter = new QFilter("type", "=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
        finOrgFilter.and("enable", "=", (Object)"1");
        List finOrgTypeIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_finorgtype", (QFilter[])finOrgFilter.toArray(), (String)"", (int)-1);
        return finOrgTypeIds;
    }

    private static void setTransferInfo(DynamicObject targetBill, DynamicObject apply) {
        if (apply.getBoolean("accepttransfer")) {
            targetBill.set("accepttransfer", (Object)true);
            targetBill.set("transferertype", apply.get("transferertype"));
            targetBill.set("transferer", apply.get("transferer"));
            targetBill.set("transfererid", apply.get("transfererid"));
            targetBill.set("transferdate", apply.get("transferdate"));
            targetBill.set("transferterm", apply.get("transferterm"));
            targetBill.set("transferamount", apply.get("transferamount"));
            targetBill.set("transferrevenue", apply.get("transferrevenue"));
            targetBill.set("combineinst", (Object)true);
        }
    }

    public static boolean isCimRelateAppSet() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        long orgId = null != rootNode ? Long.parseLong(rootNode.getId()) : 0L;
        Set<String> cimAppSet = CimParameterHelper.getParameterComboxs(TmcAppEnum.IFM.getId(), orgId, "ifm003");
        return null != cimAppSet && cimAppSet.contains(TmcAppEnum.CIM.getValue());
    }

    public static void setRecAmount(DynamicObject releaseBill) {
        BigDecimal releaseAmt = releaseBill.getBigDecimal("amount");
        if (releaseBill.getBoolean("isrevenue") && releaseBill.getBoolean("combineinst")) {
            releaseBill.set("recamount", (Object)releaseAmt.add(releaseBill.getBigDecimal("realrevenue")));
        } else {
            releaseBill.set("recamount", (Object)releaseAmt);
        }
    }

    public static void setInterestRateShowName(IFormView view) {
        String investType = Optional.ofNullable((DynamicObject)view.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        FieldEdit intRate = (FieldEdit)view.getControl("interestrate");
        if (InvestTypeEnum.isStructure((String)investType)) {
            intRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u8ba1\u5b58\u6b3e\u5229\u7387\uff08%\uff09", (String)"DepositHelper_14", (String)"tmc-cim-common", (Object[])new Object[0])));
        } else {
            intRate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b58\u6b3e\u5229\u7387\uff08%\uff09", (String)"DepositHelper_15", (String)"tmc-cim-common", (Object[])new Object[0])));
        }
    }

    public static boolean isHugeAndNeedDoBusiness(DynamicObject release) {
        if (!release.getBoolean("accepttransfer")) {
            return false;
        }
        if (!"bos_org".equals(release.getString("transferertype"))) {
            return false;
        }
        long transferOrgId = Optional.ofNullable(release.getLong("transfererid")).orElse(0L);
        if (EmptyUtil.isEmpty((Long)transferOrgId)) {
            return false;
        }
        boolean deposittransfer = (Boolean)TmcParameterHelper.getAppParameter((String)TmcAppEnum.CIM.getId(), (Long)transferOrgId, (String)"deposittransfer");
        return deposittransfer;
    }

    public static Date getIntCalcStartDate(DynamicObject depositBill) {
        return Optional.ofNullable(depositBill.getDate("lastrevenuedate")).map(r -> DateUtils.getNextDay((Date)r, (int)1)).orElseGet(() -> depositBill.getDate("intdate"));
    }

    public static Date getIntCalcStartDateForHugePre(DynamicObject depositBill) {
        Date transferDate = depositBill.getDate("transferdate");
        Optional<Date> revenueDateOp = Optional.ofNullable(depositBill.getDate("lastrevenuedate")).map(r -> DateUtils.getNextDay((Date)r, (int)1));
        if (!revenueDateOp.isPresent()) {
            return transferDate;
        }
        Date lastRevDate = revenueDateOp.get();
        return transferDate.compareTo(lastRevDate) >= 0 ? transferDate : lastRevDate;
    }

    public static void deleteBotpRation(String currEntity, Long currBillId, String sourceEntity, Long srcBillId) {
        boolean isDbExists = QueryServiceHelper.exists((String)currEntity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currBillId), new QFilter("apply", "!=", (Object)srcBillId)});
        if (!isDbExists) {
            return;
        }
        DynamicObject sourBill = TmcBotpHelper.getSourceBill((String)currEntity, (Object)currBillId, (String)sourceEntity);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            TmcBotpHelper.deleteRation((String)currEntity, (Long)sourBill.getLong("id"), (Long)currBillId);
        }
    }

    public static Pair<Date, AdjustMethodEnum> getAdjustExpireDate(DynamicObject deposit, Date expireDate) {
        DynamicObjectCollection workCalendarCols = deposit.getDynamicObjectCollection("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workCalendarCols)) {
            return Pair.of((Object)expireDate, (Object)AdjustMethodEnum.no_adjust);
        }
        DynamicObject productFactory = (deposit = TmcDataServiceHelper.loadSingle((Object)deposit.getPkValue(), (String)"cim_deposit", (String)"id,workcalendar,productfactory")).getDynamicObject("productfactory");
        if (EmptyUtil.isEmpty((DynamicObject)productFactory)) {
            return Pair.of((Object)expireDate, (Object)AdjustMethodEnum.no_adjust);
        }
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)productFactory.getString("graceadjustrule"));
        Date adjustDate = TermHelper.callAdjustSettleDate((DynamicObjectCollection)deposit.getDynamicObjectCollection("workcalendar"), (Date)expireDate, (AdjustMethodEnum)adjustMethod);
        return Pair.of((Object)adjustDate, (Object)adjustMethod);
    }
}

