/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class OnlineServiceHelper {
    public static QFilter getDateQfilter(String fieldName, List<Object> values) {
        if (EmptyUtil.isEmpty(values)) {
            return null;
        }
        Date startDate = null;
        Date endDate = null;
        if (values.size() == 2) {
            startDate = DateUtils.stringToDate((String)values.get(0).toString(), (String)"yyyy-MM-dd HH:mm:ss");
            endDate = DateUtils.stringToDate((String)values.get(1).toString(), (String)"yyyy-MM-dd HH:mm:ss");
            return new QFilter(fieldName, ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true)).and(new QFilter(fieldName, "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
        }
        String value = values.get(0).toString();
        if (EmptyUtil.isEmpty((String)value)) {
            return new QFilter("1", "=", (Object)1);
        }
        switch (value) {
            case "13": {
                startDate = DateUtils.getCurrentDate();
                endDate = DateUtils.getCurrentDate();
                break;
            }
            case "10": {
                Map weekDate = DateUtils.getWeekDate();
                startDate = (Date)weekDate.get("beginDate");
                endDate = (Date)weekDate.get("endDate");
                break;
            }
            case "63": {
                startDate = DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate());
                endDate = DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate());
                break;
            }
            case "24": {
                startDate = DateUtils.getLastMonth((Date)DateUtils.getCurrentDate(), (int)3);
                endDate = DateUtils.getCurrentDate();
                break;
            }
        }
        return new QFilter(fieldName, ">=", (Object)DateUtils.getDataFormat((Date)startDate, (boolean)true)).and(new QFilter(fieldName, "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)false)));
    }

    public static List<String> getDynamicListFilters(Map<String, List<Map<String, List<Object>>>> filterMap, List<String> commonFilterColumns) {
        ArrayList<String> qfilters = new ArrayList<String>();
        OnlineServiceHelper.addCustomFilter(filterMap.get("customfilter"), qfilters, commonFilterColumns);
        OnlineServiceHelper.addFastFilter(filterMap.get("fastfilter"), qfilters);
        return qfilters;
    }

    private static void addCustomFilter(List<Map<String, List<Object>>> customfilter, List<String> qfilters, List<String> commonFilterColumns) {
        if (EmptyUtil.isEmpty(customfilter)) {
            return;
        }
        for (Map<String, List<Object>> customfilterMap : customfilter) {
            String fieldName;
            List values = customfilterMap.get("Value").stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(values) || EmptyUtil.isEmpty((String)(fieldName = customfilterMap.get("FieldName").get(0).toString()))) continue;
            String mainField = fieldName;
            if (fieldName.indexOf(".") > 0) {
                mainField = fieldName.substring(0, fieldName.indexOf("."));
            }
            if (!commonFilterColumns.contains(mainField)) continue;
            if (StringUtils.endsWith((CharSequence)fieldName, (CharSequence)".id")) {
                qfilters.add(new QFilter(fieldName, "in", values.stream().map(v -> Long.valueOf(v.toString())).collect(Collectors.toList())).toSerializedString());
                continue;
            }
            List compareStrs = customfilterMap.get("Compare").stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(compareStrs) && !fieldName.equals("submittime")) {
                qfilters.add(new QFilter(fieldName, "in", values).toSerializedString());
                continue;
            }
            QFilter dateQfilter = OnlineServiceHelper.getDateQfilter(fieldName, values.stream().map(Object::toString).collect(Collectors.toList()));
            if (null == dateQfilter) continue;
            qfilters.add(dateQfilter.toSerializedString());
        }
    }

    private static void addFastFilter(List<Map<String, List<Object>>> fastFilter, List<String> qfilters) {
        if (EmptyUtil.isEmpty(fastFilter)) {
            return;
        }
        Map<String, List<Object>> fastFilterMap = fastFilter.get(0);
        List values = fastFilterMap.get("Value").stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(values)) {
            return;
        }
        List<Object> fieldNames = fastFilterMap.get("FieldName");
        QFilter qfilter = null;
        for (Object fieldName : fieldNames) {
            for (Object value : values) {
                QFilter orFilter = new QFilter(fieldName.toString(), "like", (Object)("%" + value + "%"));
                qfilter = null == qfilter ? orFilter : qfilter.or(orFilter);
            }
        }
        if (null != qfilter) {
            qfilters.add(qfilter.toSerializedString());
        }
    }
}

