/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PushPayBillVerifyHelper {
    public static String verifyDepositBill(DynamicObject bizBill, BigDecimal payBillAmt, String innerAutoPushFlag) {
        if (bizBill.getBoolean("isredepositgenerate")) {
            return ResManager.loadKDString((String)"\u7eed\u5b58\u751f\u6210\u7684\u5b58\u6b3e\u5355\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (bizBill.getBoolean("isinit")) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u5b58\u6b3e\u5355\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_2", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (EmptyUtil.isNoEmpty((String)bizBill.getString("eassrcid"))) {
            return ResManager.loadKDString((String)"EAS\u540c\u6b65\u8fc7\u6765\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_3", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (TradeChannelEnum.isOnLine(bizBill.getString("tradechannel")) && !BebankStatusEnum.TS.getValue().equals(bizBill.getString("bebankstatus"))) {
            return ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u65f6\uff0c\u53ea\u6709\u201c\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u201d\u4e3a\u6210\u529f\u7684\u624d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_4", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (!StringUtils.equals((CharSequence)innerAutoPushFlag, (CharSequence)"true")) {
            if (!BillStatusEnum.isAudit((String)bizBill.getString("billstatus"))) {
                return ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"DepositPushPayValidator_3", (String)"tmc-cim-business", (Object[])new Object[0]);
            }
            if (!FinServiceStatusEnum.isSubscribeDone(bizBill.getString("bizstatus"))) {
                return ResManager.loadKDString((String)"\u5b58\u6b3e\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u5b58\u6b3e\u624d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"DepositPushPayValidator_4", (String)"tmc-cim-business", (Object[])new Object[0]);
            }
        }
        if (bizBill.getBoolean("accepttransfer")) {
            BigDecimal transferAmount;
            String investType = Optional.ofNullable(bizBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
            if (!InvestTypeEnum.huge.getValue().equals(investType)) {
                return ResManager.loadKDString((String)"\u53d7\u8ba9\u5f00\u542f\u65f6\uff0c\u5b58\u6b3e\u54c1\u79cd\u5fc5\u987b\u4e3a\u5927\u989d\u5b58\u5355\u3002", (String)"PushPayBillVerifyHelper_5", (String)"tmc-cim-common", (Object[])new Object[0]);
            }
            DynamicObject releaseBill = TmcBotpHelper.getSourceBill((String)bizBill.getDynamicObjectType().getName(), (Object)bizBill.getPkValue(), (String)"cim_release");
            if (EmptyUtil.isNoEmpty((DynamicObject)releaseBill) && EmptyUtil.isNoEmpty((BigDecimal)(transferAmount = releaseBill.getBigDecimal("transferamount"))) && (bizBill.getBigDecimal("transferamount").compareTo(transferAmount) != 0 || payBillAmt.compareTo(transferAmount) != 0)) {
                return ResManager.loadKDString((String)"\u89e3\u6d3b\u5355\u5ba1\u6838\u81ea\u52a8\u751f\u6210\u7684\u53d7\u8ba9\u7684\u5b58\u6b3e\u5355\uff0c\u5176\u8f6c\u8ba9\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u89e3\u6d3b\u5355\u4e0a\u7684\u8f6c\u8ba9\u91d1\u989d\u3002", (String)"PushPayBillVerifyHelper_6", (String)"tmc-cim-common", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String verifyFinsubBill(DynamicObject bizBill) {
        if (!BillStatusEnum.isAudit((String)bizBill.getString("billstatus"))) {
            return ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u5355\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_10", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (!FinServiceStatusEnum.isSubscribeDone(bizBill.getString("finservicestatus"))) {
            return ResManager.loadKDString((String)"\u7406\u8d22\u4e1a\u52a1\u72b6\u6001\u4e3a\u5df2\u7533\u8d2d\u624d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_11", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (bizBill.getBoolean("isinit")) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u7406\u8d22\u7533\u8d2d\u5355\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_7", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (bizBill.getBoolean("isrenewal")) {
            return ResManager.loadKDString((String)"\u7eed\u671f\u751f\u6210\u7684\u7533\u8d2d\u5355\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_8", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (EmptyUtil.isNoEmpty((String)bizBill.getString("eassrcid"))) {
            return ResManager.loadKDString((String)"EAS\u540c\u6b65\u8fc7\u6765\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_3", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (TradeChannelEnum.isOnLine(bizBill.getString("tradechannel")) && !BebankStatusEnum.TS.getValue().equals(bizBill.getString("bebankstatus"))) {
            return ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u65f6\uff0c\u53ea\u6709\u201c\u5728\u7ebf\u7406\u8d22\u529e\u7406\u72b6\u6001\u201d\u4e3a\u6210\u529f\u7684\u624d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"PushPayBillVerifyHelper_9", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        return null;
    }
}

