/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PushRecBillVerifyHelper {
    public static String verifyRedeemBill(DynamicObject redeem) {
        if (!BillStatusEnum.isAudit((String)redeem.getString("billstatus"))) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"PushRecBillVerifyHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (redeem.getBoolean("isrenewal")) {
            return ResManager.loadKDString((String)"\u5df2\u5f00\u542f\u7406\u8d22\u7eed\u671f\uff0c\u4e0d\u80fd\u4e0b\u63a8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_2", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (redeem.getBoolean("isinit")) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u8d4e\u56de\u5355\u4e0d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_3", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (TradeChannelEnum.isOnLine(redeem.getString("tradechannel")) && !BebankStatusEnum.TS.getValue().equals(redeem.getString("bebankstatus"))) {
            return ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u65f6\uff0c\u53ea\u6709\u201c\u5728\u7ebf\u7406\u8d22\u529e\u7406\u72b6\u6001\u201d\u4e3a\u6210\u529f\u7684\u624d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_4", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static String verifyRevenueBill(DynamicObject revenueBill) {
        DynamicObject redeemBill;
        if (!BillStatusEnum.isAudit((String)revenueBill.getString("billstatus"))) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6838\u7684\u5355\u636e\u3002", (String)"PushRecBillVerifyHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (revenueBill.getBoolean("isinit")) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u6536\u76ca\u5355\u4e0d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_6", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        String revenueSort = revenueBill.getString("revenuesort");
        if (RevenueSortEnum.redeem_revenue.getValue().equals(revenueSort) && EmptyUtil.isNoEmpty((DynamicObject)(redeemBill = QueryServiceHelper.queryOne((String)"cim_redeem", (String)"isrollcapital", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)revenueBill.getLong("redeemid"))}))) && redeemBill.getBoolean("isrollcapital")) {
            return ResManager.loadKDString((String)"\u8d4e\u56de\u5355\u5f00\u542f\u672c\u606f\u7eed\u5b58\u65f6\uff0c\u6536\u76ca\u5355\u4e0d\u5141\u8bb8\u4e0b\u63a8\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_7", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (revenueBill.getBigDecimal("amount").compareTo(BigDecimal.ZERO) <= 0) {
            return ResManager.loadKDString((String)"\u5b9e\u9645\u6536\u76ca\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_8", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (revenueBill.getBoolean("combineinst")) {
            return ResManager.loadKDString((String)"\u6536\u76ca\u5355\u5df2\u7ecf\u4e0e\u8d4e\u56de\u5355\u751f\u6210\u4e00\u7b14\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"PushRecBillVerifyHelper_9", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static String verifyReleaseBill(DynamicObject releaseBill, String innerAutoPushFlag) {
        if (!StringUtils.equals((CharSequence)innerAutoPushFlag, (CharSequence)"true") && !BillStatusEnum.isAudit((String)releaseBill.getString("billstatus"))) {
            return ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u72b6\u6001\u624d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"PushRecBillVerifyHelper_10", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (releaseBill.getBoolean("isinit")) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u89e3\u6d3b\u5355\u4e0d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_11", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (TradeChannelEnum.isOnLine(releaseBill.getString("tradechannel")) && !BebankStatusEnum.TS.getValue().equals(releaseBill.getString("bebankstatus"))) {
            return ResManager.loadKDString((String)"\u4ea4\u6613\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\u65f6\uff0c\u53ea\u6709\u201c\u76f4\u8054\u63d0\u4ea4\u72b6\u6001\u201d\u4e3a\u6210\u529f\u7684\u624d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_12", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static String verifyDptRevenueBill(DynamicObject revenue, String innerAutoPushFlag, Set<Long> releaseSet) {
        if (EmptyUtil.isEmpty((String)revenue.getString("recaccount"))) {
            return ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_13", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (!StringUtils.equals((CharSequence)innerAutoPushFlag, (CharSequence)"true") && !BillStatusEnum.isAudit((String)revenue.getString("billstatus"))) {
            return ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_14", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (revenue.getBoolean("isinit")) {
            return ResManager.loadKDString((String)"\u521d\u59cb\u5316\u751f\u6210\u7684\u6536\u76ca\u5355\u4e0d\u80fd\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_15", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (revenue.getBoolean("ishistorybuild")) {
            return ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u751f\u6210\u7684\u6536\u76ca\u5355\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_16", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (revenue.getBoolean("combineinst")) {
            return ResManager.loadKDString((String)"\u6536\u76ca\u5355\u5df2\u7ecf\u4e0e\u89e3\u6d3b\u5355\u751f\u6210\u4e00\u7b14\u6536\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"PushRecBillVerifyHelper_17", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        if (RevenueSortEnum.redeem_revenue.getValue().equals(revenue.getString("revenuesort")) && releaseSet.contains(revenue.getLong("srcreleaseid"))) {
            return ResManager.loadKDString((String)"\u8f6c\u8ba9\u89e3\u6d3b\u751f\u6210\u7684\u6536\u76ca\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u6536\u6b3e\u5355\u3002", (String)"PushRecBillVerifyHelper_18", (String)"tmc-cim-common", (Object[])new Object[0]);
        }
        return null;
    }
}

