/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinBizStatusEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.helper.RevenuePlanCalHelper;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.ebservice.data.EBResult;
import kd.tmc.fbp.service.ebservice.data.EBResultStatusCode;
import kd.tmc.fbp.service.ebservice.utils.BeServiceHelper;
import kd.tmc.fbp.webapi.ebentity.biz.finsubscribe.FinsubscribeDetail;

public class RedeemBillHelper {
    private static final Log logger = LogFactory.getLog(RedeemBillHelper.class);

    public static String checkLastRedeemDate(Object finBillNo, Date redeemDate) {
        Date lastRedDate;
        QFilter qFilter = new QFilter("finbillno", "=", finBillNo);
        qFilter.and("billstatus", "not in", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObjectCollection redeemBills = QueryServiceHelper.query((String)CimEntityEnum.cim_redeem.getValue(), (String)"redeemdate", (QFilter[])qFilter.toArray(), (String)"createtime desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)redeemBills) && redeemDate.before(lastRedDate = ((DynamicObject)redeemBills.get(0)).getDate("redeemdate"))) {
            return DateUtils.formatString((Date)lastRedDate, (String)"yyyy-MM-dd");
        }
        return "";
    }

    public static Map<String, String> checkLastEndIntDate(Object finBillId, Date redeemDate) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        DynamicObject finBill = TmcDataServiceHelper.loadSingle((Object)finBillId, (String)CimEntityEnum.cim_finsubscribe.getValue());
        Date lastEndIntDate = finBill.getDate("endinstdate");
        if (lastEndIntDate != null && redeemDate.compareTo(lastEndIntDate) <= 0) {
            returnMap.put("lastEndIntDate", DateUtils.formatString((Date)lastEndIntDate, (String)"yyyy-MM-dd"));
        }
        Date purchaseDate = finBill.getDate("purchasedate");
        if (lastEndIntDate == null && !redeemDate.after(purchaseDate)) {
            returnMap.put("purchaseDate", DateUtils.formatString((Date)purchaseDate, (String)"yyyy-MM-dd"));
        }
        return returnMap;
    }

    public static String checkIsLastRevenue(Object finBillId, DynamicObject revenue, String dataSource) {
        QFilter qFilter = new QFilter("finbillno", "=", finBillId);
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("datasource", "=", (Object)dataSource);
        qFilter.and("operatype", "!=", (Object)"writeoffrev");
        DynamicObjectCollection lastRevenue = QueryServiceHelper.query((String)CimEntityEnum.cim_revenue.getValue(), (String)"id,billno", (QFilter[])qFilter.toArray(), (String)"auditdate desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)lastRevenue) && ((DynamicObject)lastRevenue.get(0)).getLong("id") != revenue.getLong("id") && !((DynamicObject)lastRevenue.get(0)).get("id").equals(revenue.getPkValue())) {
            if ("revenue".equals(dataSource)) {
                return ResManager.loadKDString((String)"\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u6536\u76ca\uff0c\u8bf7\u6309\u7167\u65f6\u95f4\u987a\u5e8f\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillHelper_0", (String)"tmc-cim-common", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u7f16\u53f7%s\u7406\u8d22\u9884\u63d0\u6536\u76ca\u5355\u4e0d\u662f\u6700\u540e\u4e00\u7b14\u9884\u63d0\uff0c\u8bf7\u5148\u4ece\u6700\u540e\u4e00\u7b14\u9884\u63d0\u5355\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"RedeemBillHelper_1", (String)"tmc-cim-common", (Object[])new Object[]{revenue.getString("billno")});
        }
        return "";
    }

    public static BigDecimal calPlanAmount(ModelAgent model) {
        Date expireDate = (Date)model.getValue("expiredate");
        BigDecimal amount = (BigDecimal)model.getValue("amount");
        return RedeemBillHelper.calPlanAmount(model, amount, expireDate);
    }

    public static EBResult dealResponseResult(List<FinsubscribeDetail> details, DynamicObject redeemBill, boolean isUpdate) {
        FinsubscribeDetail detail = details.get(0);
        EBResult ebResult = new EBResult();
        if (detail.getDetailSeqID().equals(redeemBill.getPkValue().toString())) {
            BeBillStatusEnum status = BeServiceHelper.transferState((String)(isUpdate ? detail.getUpdateStatus() : detail.getEbStatus()));
            if (BeBillStatusEnum.TS.getValue().equals(status.getValue())) {
                RedeemBillHelper.setStatus(redeemBill, detail, status);
                if (BeBillStatusEnum.TS.getValue().equals(status.getValue())) {
                    RedeemBillHelper.writeBackRedeemBill(detail, redeemBill);
                    RedeemBillHelper.writeBackFinBill(redeemBill);
                    RedeemBillHelper.revenueBillAudit(redeemBill);
                    RedeemBillHelper.calRevenuePlan(redeemBill);
                }
                ebResult.setStatusCode(EBResultStatusCode.SUCCESS);
            } else {
                ebResult.setStatusCode(EBResultStatusCode.ERROR);
                ebResult.setErrMsg(detail.getEbStatusMsg());
                if (isUpdate) {
                    redeemBill.set("returnmsg", (Object)detail.getEbStatusMsg());
                } else {
                    RedeemBillHelper.setStatus(redeemBill, detail, status);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{redeemBill});
        return ebResult;
    }

    private static void setStatus(DynamicObject redeemBill, FinsubscribeDetail detail, BeBillStatusEnum status) {
        redeemBill.set("bebankstatus", (Object)status.getValue());
        redeemBill.set("returnmsg", (Object)detail.getEbStatusMsg());
        redeemBill.set("lastmodifier", (Object)RequestContext.get().getCurrUserId());
        redeemBill.set("lastmodifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{redeemBill});
    }

    private static void revenueBillAudit(DynamicObject redeemBill) {
        boolean isRevenue = redeemBill.getBoolean("isrevenue");
        logger.info("\u5728\u7ebf\u7406\u8d22\u8d4e\u56de\u4ea4\u6613\u6210\u529f\uff0c\u6536\u76ca\u5355\u5ba1\u6838\u64cd\u4f5cstart... isRevenue: " + isRevenue);
        if (isRevenue) {
            QFilter qFilter = new QFilter("redeemid", "=", redeemBill.getPkValue());
            DynamicObject revenueBill = TmcDataServiceHelper.loadSingle((String)CimEntityEnum.cim_revenue.getValue(), (String)"id", (QFilter[])qFilter.toArray());
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("redeemAudit", "true");
            TmcOperateServiceHelper.execOperate((String)"audit", (String)CimEntityEnum.cim_revenue.getValue(), (Object[])new Object[]{revenueBill.getPkValue()}, (OperateOption)operateOption);
        }
    }

    private static void writeBackFinBill(DynamicObject redeemBill) {
        DynamicObject finBillF7 = redeemBill.getDynamicObject("finbillno");
        DynamicObject finSubscribe = TmcDataServiceHelper.loadSingle((Object)finBillF7.getPkValue(), (String)CimEntityEnum.cim_finsubscribe.getValue());
        String redeemWay = redeemBill.getString("redeemway");
        finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            boolean isRevenue;
            BigDecimal redeemAmount = finSubscribe.getBigDecimal("redeemamount").add(redeemBill.getBigDecimal("amount"));
            finSubscribe.set("redeemamount", (Object)redeemAmount);
            BigDecimal finAmount = finSubscribe.getBigDecimal("amount");
            BigDecimal surplusAmount = finAmount.subtract(redeemAmount);
            finSubscribe.set("surplusamount", (Object)surplusAmount);
            if (BigDecimal.ZERO.compareTo(surplusAmount) == 0) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
                finSubscribe.set("cleardate", (Object)redeemBill.getDate("redeemdate"));
            }
            if (isRevenue = redeemBill.getBoolean("isrevenue")) {
                BigDecimal realRevenue = redeemBill.getBigDecimal("realrevenue");
                finSubscribe.set("totalamount", (Object)finSubscribe.getBigDecimal("totalamount").add(realRevenue));
            }
        }
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            int redeemCopies = finSubscribe.getInt("redeemcopies") + redeemBill.getInt("copies");
            finSubscribe.set("redeemcopies", (Object)redeemCopies);
            int finCopies = finSubscribe.getInt("buycopies");
            int surplusCopies = finCopies - redeemCopies;
            finSubscribe.set("surpluscopies", (Object)surplusCopies);
            if (surplusCopies == 0) {
                finSubscribe.set("finservicestatus", (Object)FinServiceStatusEnum.subscribe_end.getValue());
                finSubscribe.set("cleardate", (Object)redeemBill.getDate("redeemdate"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{finSubscribe});
    }

    private static void calRevenuePlan(DynamicObject redeemBill) {
        boolean isRevenue = redeemBill.getBoolean("isrevenue");
        logger.info("\u5728\u7ebf\u7406\u8d22\u8d4e\u56de\u4ea4\u6613\u6210\u529f\uff0c\u8ba1\u7b97\u6536\u76ca\u8ba1\u5212start... isRevenue: " + isRevenue);
        DynamicObject finBillF7 = redeemBill.getDynamicObject("finbillno");
        if (isRevenue) {
            RevenuePlanCalHelper.calRevenuePlan((Long)finBillF7.getPkValue(), CimEntityEnum.cim_finsubscribe.getValue(), Collections.emptyMap());
        }
    }

    private static void writeBackRedeemBill(FinsubscribeDetail detail, DynamicObject redeemBill) {
        if (EmptyUtil.isNoEmpty((String)detail.getBackAmount())) {
            redeemBill.set("amount", (Object)RedeemBillHelper.getBigDecimal(detail.getBackAmount()));
        }
        redeemBill.set("notifyid", (Object)detail.getEbSeqId());
        redeemBill.set("reqnbr", (Object)detail.getBankFinancingSeqId());
        redeemBill.set("securitiesaccno", (Object)detail.getSecuritiesAccNo());
    }

    public static BigDecimal getBigDecimal(String convert) {
        if (EmptyUtil.isNoEmpty((String)convert)) {
            double convertDouble = Double.parseDouble(convert);
            return BigDecimal.valueOf(convertDouble);
        }
        return BigDecimal.ZERO;
    }

    public static void setRecAmount(DynamicObject redeemBill) {
        BigDecimal redeemAmt = redeemBill.getBigDecimal("amount");
        if (RedeemWayEnum.isAmountRedeem(redeemBill.getString("redeemway")) && redeemBill.getBoolean("isrevenue") && redeemBill.getBoolean("combineinst")) {
            redeemBill.set("recamount", (Object)redeemAmt.add(redeemBill.getBigDecimal("realrevenue")));
        } else {
            redeemBill.set("recamount", (Object)redeemAmt);
        }
    }

    private static BigDecimal calPlanAmount(ModelAgent model, BigDecimal amount, Date expireDate) {
        String basis;
        BigDecimal planRevenue = (BigDecimal)model.getValue("planrevenue");
        Date startDate = (Date)model.getValue("valuedate");
        String redeemWay = (String)model.getValue("redeemway");
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            startDate = (Date)model.getValue("intdate");
        }
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, planRevenue, startDate, expireDate, basis = (String)model.getValue("basis")})) {
            IntHTRuleEnum intHTRuleEnum = IntHTRuleEnum.headnotail;
            DynamicObject productFactory = (DynamicObject)model.getValue("productfactory");
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && "cash".equals(productFactory.getString("profittype"))) {
                intHTRuleEnum = IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule"));
            }
            switch (intHTRuleEnum) {
                case headnotail: {
                    expireDate = DateUtils.getLastDay((Date)expireDate, (int)1);
                    break;
                }
                case noheadnotail: {
                    startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                    expireDate = DateUtils.getLastDay((Date)expireDate, (int)1);
                    break;
                }
                case noheadtail: {
                    startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                }
            }
            int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)expireDate);
            int yearDay = TermHelper.getBasis_YearDay((Date)startDate, (Date)expireDate, (BasisEnum)BasisEnum.getEnum((String)basis));
            BigDecimal planAmount = amount.multiply(BigDecimal.valueOf(diffDays)).multiply(planRevenue).divide(BigDecimal.valueOf(yearDay).multiply(Constants.ONE_HUNDRED), 10, RoundingMode.HALF_UP);
            planAmount = planAmount.compareTo(BigDecimal.ZERO) > 0 ? planAmount : BigDecimal.ZERO;
            return planAmount;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal calPlanAmountForRedeem(DynamicObject bizBill) {
        String basis;
        Date expireDate = bizBill.getDate("redemptiondate");
        BigDecimal amount = bizBill.getBigDecimal("redemptionamount");
        DynamicObject finsubBill = bizBill.getDynamicObject("finsubscribe");
        BigDecimal planRevenue = bizBill.getBigDecimal("planrevenue");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, planRevenue, finsubBill, expireDate, basis = bizBill.getString("basis")})) {
            Date startDate = FinSubscribeCalcIntHelper.getIntBeginDate(finsubBill);
            IntHTRuleEnum intHTRuleEnum = IntHTRuleEnum.headnotail;
            DynamicObject productFactory = bizBill.getDynamicObject("productfactory");
            if (EmptyUtil.isNoEmpty((DynamicObject)productFactory) && "cash".equals(productFactory.getString("profittype"))) {
                intHTRuleEnum = IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule"));
            }
            switch (intHTRuleEnum) {
                case headnotail: {
                    expireDate = DateUtils.getLastDay((Date)expireDate, (int)1);
                    break;
                }
                case noheadnotail: {
                    startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                    expireDate = DateUtils.getLastDay((Date)expireDate, (int)1);
                    break;
                }
                case noheadtail: {
                    startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                }
            }
            int diffDays = DateUtils.getDiffDays((Date)startDate, (Date)expireDate);
            int yearDay = TermHelper.getBasis_YearDay((Date)startDate, (Date)expireDate, (BasisEnum)BasisEnum.getEnum((String)basis));
            BigDecimal planAmount = amount.multiply(BigDecimal.valueOf(diffDays)).multiply(planRevenue).divide(BigDecimal.valueOf(yearDay).multiply(Constants.ONE_HUNDRED), 10, RoundingMode.HALF_UP);
            planAmount = planAmount.compareTo(BigDecimal.ZERO) > 0 ? planAmount : BigDecimal.ZERO;
            return planAmount;
        }
        return BigDecimal.ZERO;
    }

    public static void deleteBotpRation(String currEntity, Long currBillId, String sourceEntity, Long srcBillId) {
        boolean isDbExists = QueryServiceHelper.exists((String)currEntity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currBillId), new QFilter("redeemapply", "!=", (Object)srcBillId)});
        if (!isDbExists) {
            return;
        }
        DynamicObject sourBill = TmcBotpHelper.getSourceBill((String)currEntity, (Object)currBillId, (String)sourceEntity);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            TmcBotpHelper.deleteRation((String)currEntity, (Long)sourBill.getLong("id"), (Long)currBillId);
        }
    }

    public static void dealBotpRelation(DynamicObject redeemBill) {
        DynamicObject redeemApply = redeemBill.getDynamicObject("redeemapply");
        RedeemBillHelper.deleteBotpRation("cim_redeem", redeemBill.getLong("id"), "cim_finapply", EmptyUtil.isEmpty((DynamicObject)redeemApply) ? 0L : redeemApply.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)redeemApply)) {
            TmcBotpHelper.saveRelation((String)"cim_finapply", (Long)((Long)redeemApply.getPkValue()), (String)CimEntityEnum.cim_redeem.getValue(), (Long)((Long)redeemBill.getPkValue()));
        }
    }

    public static void writeBackFinApply(DynamicObject[] dataEntities) {
        List billids = Arrays.stream(dataEntities).filter(r -> EmptyUtil.isNoEmpty((DynamicObject)r.getDynamicObject("redeemapply"))).map(v -> v.getLong("redeemapply.id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(billids)) {
            DynamicObject[] finApplys;
            for (DynamicObject finApply : finApplys = TmcDataServiceHelper.load((String)"cim_finapply", (String)"issubscribe,finservicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billids)})) {
                finApply.set("issubscribe", (Object)true);
                finApply.set("finservicestatus", (Object)FinBizStatusEnum.HANDLED.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])finApplys);
        }
    }
}

