/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntHelper;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntService;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeIntPlanService;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RevenueCalcHelper {
    public static final BigDecimal RATE_MAX = BigDecimal.valueOf(Math.pow(10.0, 13.0));
    private static final Log LOG = LogFactory.getLog(RevenueCalcHelper.class);
    public static final FinSubscribeCalcIntService finSubscribeCalcIntService = new FinSubscribeCalcIntService();
    private static final FinSubscribeIntPlanService finSubscribeIntPlanService = new FinSubscribeIntPlanService();

    public static IntBillInfo callInt(Long sourcebillid, Date beginDate, Date endDate) {
        return finSubscribeCalcIntService.calcFinSubBillInt(sourcebillid, beginDate, endDate);
    }

    public static IntBillInfo callIntForReport(Long sourcebillid, Date beginDate, Date endDate) {
        return finSubscribeCalcIntService.calcFinSubBillIntForReport(sourcebillid, beginDate, endDate);
    }

    public static IntBillInfo callInt(Long sourcebillid, Date endDate, BigDecimal repayAmt) {
        return finSubscribeCalcIntService.calcFinSubBillInt(sourcebillid, endDate, repayAmt);
    }

    public static Pair<BigDecimal, List<IntBillInfo>> callIntPlan(DynamicObject finBill) {
        return RevenueCalcHelper.callIntPlanByPreInt(finBill, null);
    }

    public static Pair<BigDecimal, List<IntBillInfo>> callIntPlanByPreInt(DynamicObject finBill, Boolean isPreInt) {
        return finSubscribeIntPlanService.callIntPlanByPreInt(finBill, isPreInt);
    }

    public static Pair<BigDecimal, List<IntBillInfo>> callIntPlanByPreInt(DynamicObject finBill, Boolean isPreInt, List<PlanCallResult> repayPlanList) {
        return finSubscribeIntPlanService.callIntPlanByPreInt(finBill, isPreInt, repayPlanList);
    }

    public static Pair<BigDecimal, List<IntBillInfo>> callIntPlanByHand(DynamicObject finBill, List<PlanCallResult> intPlanList) {
        return finSubscribeIntPlanService.callIntPlanByHand(finBill, intPlanList);
    }

    public static Date getStartIntDate(DynamicObject finBill) {
        return FinSubscribeCalcIntHelper.getStartIntDate(finBill);
    }

    public static Date getIntBeginDate(DynamicObject finBill) {
        return FinSubscribeCalcIntHelper.getIntBeginDate(finBill);
    }

    public static void addDetail(DynamicObjectCollection intDetails, List<IntBillDetailInfo> details) {
        intDetails.clear();
        int seq = 1;
        for (IntBillDetailInfo detail : details) {
            DynamicObject intDetail = intDetails.addNew();
            Date inststartdate = detail.getBeginDate();
            Date instenddate = detail.getEndDate();
            int instdays = detail.getDays();
            BigDecimal instprincipalamt = detail.getPrinciple();
            BigDecimal rate = detail.getRate();
            int ratetrandays = detail.getBasisDay();
            BigDecimal instamt = detail.getAmount();
            intDetail.set("seq", (Object)seq++);
            intDetail.set("startdate", (Object)inststartdate);
            intDetail.set("enddate", (Object)instenddate);
            intDetail.set("days", (Object)instdays);
            intDetail.set("finamount", (Object)instprincipalamt);
            intDetail.set("eplanrevenue", (Object)rate);
            intDetail.set("convertdays", (Object)ratetrandays);
            intDetail.set("erevenueamount", (Object)instamt);
        }
    }

    public static List<PlanCallResult> updateBizDateByPayIntAdjustRule(DynamicObject loanBill, List<PlanCallResult> callResults) {
        return finSubscribeIntPlanService.updateBizDateByPayIntAdjustRule(loanBill, callResults);
    }

    public static BigDecimal calcRealRate(DynamicObjectCollection rows, BigDecimal revenueAmt) {
        BigDecimal totalPlanAmt = BigDecimal.ZERO;
        BigDecimal totalFinAmt = BigDecimal.ZERO;
        for (Object row : rows) {
            totalPlanAmt = totalPlanAmt.add(row.getBigDecimal("erevenueamount"));
            totalFinAmt = totalFinAmt.add(row.getBigDecimal("finamount"));
        }
        ArrayList<BigDecimal> realRateList = new ArrayList<BigDecimal>(rows.size());
        for (DynamicObject row : rows) {
            BigDecimal dividedAmt = row.getBigDecimal("finamount").multiply(new BigDecimal(row.getInt("days"))).multiply(totalPlanAmt);
            if (EmptyUtil.isEmpty((BigDecimal)dividedAmt)) {
                return BigDecimal.ZERO;
            }
            BigDecimal realRatePerRow = revenueAmt.multiply(row.getBigDecimal("erevenueamount")).multiply(new BigDecimal(row.getInt("convertdays"))).divide(dividedAmt, 10, 4);
            BigDecimal perRate = realRatePerRow.multiply(row.getBigDecimal("finamount")).multiply(new BigDecimal("100")).divide(totalFinAmt, 10, 4);
            realRateList.add(perRate);
        }
        BigDecimal realRate = realRateList.stream().reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
        RevenueCalcHelper.validateIntMaxValue(realRate);
        return realRate;
    }

    private static void validateIntMaxValue(BigDecimal amount) {
        if (amount.compareTo(RATE_MAX) > 0) {
            LOG.info("\u5b9e\u9645\u6536\u76ca\u7387\u503c:{}", (Object)amount);
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u9645\u6536\u76ca\u7387\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RevenueCalcHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]));
        }
    }
}

