/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.helper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.CimEntityEnum;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.enums.OperaTypeEnum;
import kd.tmc.cim.common.enums.RedeemWayEnum;
import kd.tmc.cim.common.enums.RevenueSortEnum;
import kd.tmc.cim.common.enums.RevenueStatEnum;
import kd.tmc.cim.common.enums.WriteOffStatusEnum;
import kd.tmc.cim.common.helper.CimRateAdjustHelper;
import kd.tmc.cim.common.helper.RevenueCalcHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class RevenuePlanCalHelper {
    public static void calRevenuePlan(Long finBillId, String entity, Map<String, String> operationVariable) {
        if (!TmcDataServiceHelper.exists((Object)finBillId, (String)CimEntityEnum.cim_finsubscribe.getValue())) {
            return;
        }
        DynamicObject finBill = TmcDataServiceHelper.loadSingle((Object)finBillId, (String)CimEntityEnum.cim_finsubscribe.getValue());
        String redeemWay = finBill.getString("redeemway");
        if (CimEntityEnum.cim_revenue.getValue().equals(entity)) {
            if ("interestrev".equals(operationVariable.get("datasource"))) {
                RevenuePlanCalHelper.preInterestBillDo(finBill);
            } else if (RedeemWayEnum.isAmountRedeem(redeemWay)) {
                RevenuePlanCalHelper.interestBillDo(finBill, operationVariable);
            }
        }
        CimRateAdjustHelper.updateRateAdjustList(finBill, operationVariable);
        if (RedeemWayEnum.isAmountRedeem(redeemWay)) {
            Pair<BigDecimal, List<IntBillInfo>> intBills = RevenueCalcHelper.callIntPlan(finBill);
            RevenuePlanCalHelper.finBillWriteBack(intBills, finBill);
        } else {
            RevenuePlanCalHelper.setPlanRevenueNull(finBill);
        }
        SaveServiceHelper.save((IDataEntityType)finBill.getDataEntityType(), (Object[])new DynamicObject[]{finBill});
    }

    private static void interestBillDo(DynamicObject finBill, Map<String, String> operationVariable) {
        QFilter qFilter = new QFilter("finbillno", "=", finBill.getPkValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("datasource", "=", (Object)"revenue");
        DynamicObjectCollection revenueBills = QueryServiceHelper.query((String)CimEntityEnum.cim_revenue.getValue(), (String)"id,amount,revenuesort,revenueenddate", (QFilter[])qFilter.toArray(), (String)"expiredate desc");
        BigDecimal totalAmount = revenueBills.stream().map(s -> s.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        DynamicObject revBill = null;
        Date endDate = null;
        for (DynamicObject revenueBill : revenueBills) {
            if (revBill == null && RevenueSortEnum.revenue.getValue().equals(revenueBill.getString("revenuesort"))) {
                revBill = revenueBill;
            }
            endDate = revBill == null ? null : revBill.getDate("revenueenddate");
        }
        if (endDate == null) {
            finBill.set("endinstdate", finBill.get("handlastrevenuedate"));
        } else {
            finBill.set("endinstdate", endDate);
        }
        Date lstRevenueDate = finBill.getDate("endinstdate");
        Date date = Optional.ofNullable(lstRevenueDate).map(r -> DateUtils.getNextDay((Date)r, (int)1)).orElse(null);
        finBill.set("lastinstdate", (Object)date);
        Date lstPayIntDate = RevenuePlanCalHelper.getLastPreIntDate(finBill, operationVariable);
        finBill.set("lastpayinstdate", (Object)lstPayIntDate);
        finBill.set("totalamount", (Object)totalAmount);
    }

    public static void preInterestBillDo(DynamicObject finBill) {
        QFilter qFilter = new QFilter("finbillno", "=", finBill.getPkValue());
        qFilter.and("operatype", "=", (Object)OperaTypeEnum.INTERESTREV.getValue());
        qFilter.and("datasource", "=", (Object)OperaTypeEnum.INTERESTREV.getValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("writeoffstatus", "!=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
        Object[] preInterests = TmcDataServiceHelper.load((String)"cim_intbill_revenue", (String)"id,finbillno,operatype,datasource,entrys,entrys.enddate,revenueenddate", (QFilter[])qFilter.toArray(), (String)"revenueenddate  desc");
        Date preInstEndDate = null;
        if (EmptyUtil.isNoEmpty((Object[])preInterests)) {
            preInstEndDate = preInterests[0].getDynamicObjectCollection("entrys").stream().map(v -> v.getDate("enddate")).max(Comparator.naturalOrder()).orElse(null);
        }
        if ((preInstEndDate = RevenuePlanCalHelper.getLastEndInstDate(finBill, preInstEndDate)) == null) {
            finBill.set("lastpayinstdate", finBill.get("handendpredate"));
        } else {
            finBill.set("lastpayinstdate", (Object)preInstEndDate);
        }
    }

    private static void finBillWriteBack(List<IntBillInfo> intBills, DynamicObject finBill) {
        DynamicObjectCollection interestEntryDC = finBill.getDynamicObjectCollection("revenue_entry");
        int seq = interestEntryDC.size() + 1;
        intBills.sort(Comparator.comparing(IntBillInfo::getBizDate));
        for (IntBillInfo intBill : intBills) {
            DynamicObject interestEntryDO = interestEntryDC.addNew();
            Date interestDate = intBill.getBizDate();
            BigDecimal interestAmount = intBill.getAmount();
            interestEntryDO.set("seq", (Object)seq);
            interestEntryDO.set("revenueseq", (Object)seq);
            interestEntryDO.set("revenuedate", (Object)interestDate);
            interestEntryDO.set("revenuecalamount", (Object)interestAmount);
            interestEntryDO.set("revenuestate", (Object)RevenueStatEnum.NOTDO.getValue());
            interestEntryDO.set("revenueremark", (Object)intBill.getRemark());
            List details = intBill.getDetails();
            DynamicObjectCollection interestSubEntryDC = interestEntryDO.getDynamicObjectCollection("revenue_subentry");
            interestSubEntryDC.clear();
            for (IntBillDetailInfo detail : details) {
                Date beginDate = detail.getBeginDate();
                Date endDate = detail.getEndDate();
                int days = detail.getDays();
                BigDecimal principle = detail.getPrinciple();
                BigDecimal yearRate = detail.getRate();
                BigDecimal rateAmount = detail.getAmount();
                DynamicObject interestSubEntryDO = interestSubEntryDC.addNew();
                interestSubEntryDO.set("seq", (Object)detail.getSeq());
                interestSubEntryDO.set("startdate", (Object)beginDate);
                interestSubEntryDO.set("enddate", (Object)endDate);
                interestSubEntryDO.set("days", (Object)days);
                interestSubEntryDO.set("finamount", (Object)principle);
                interestSubEntryDO.set("eplanrevenue", (Object)yearRate);
                interestSubEntryDO.set("convertdays", (Object)detail.getBasisDay());
                interestSubEntryDO.set("erevenueamount", (Object)rateAmount);
            }
            ++seq;
        }
    }

    public static void finBillWriteBack(Pair<BigDecimal, List<IntBillInfo>> interestCals, DynamicObject finBill) {
        RevenuePlanCalHelper.setPlanRevenueNull(finBill);
        RevenuePlanCalHelper.getRevenueDonePart(finBill);
        if (StringUtils.equals((CharSequence)FinServiceStatusEnum.subscribe_end.getValue(), (CharSequence)finBill.getString("finservicestatus"))) {
            return;
        }
        BigDecimal calculateRateAmount = (BigDecimal)interestCals.getKey();
        finBill.set("futureamount", (Object)calculateRateAmount);
        RevenuePlanCalHelper.finBillWriteBack((List)interestCals.getValue(), finBill);
    }

    public static void writeBackLastPreIntDate(Set<Object> finBillIds) {
        DynamicObject[] finBills;
        for (DynamicObject finBill : finBills = TmcDataServiceHelper.load((Object[])finBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)CimEntityEnum.cim_finsubscribe.getValue()))) {
            RevenuePlanCalHelper.preInterestBillDo(finBill);
        }
        SaveServiceHelper.update((DynamicObject[])finBills);
    }

    public static void writeBackIntBatchBillEntrys(DynamicObjectCollection intBill, DynamicObject intRevBill, Boolean iswriteoff, DynamicObject newRevBill) {
        Long pkid = intRevBill.getLong("id");
        Long intBatchId = intRevBill.getLong("intbatchbillid");
        if (EmptyUtil.isEmpty((Long)intBatchId)) {
            return;
        }
        DynamicObject intBatchBill = TmcDataServiceHelper.loadSingle((Object)intBatchId, (String)"cim_intbill_batch");
        DynamicObjectCollection entrys = intBatchBill.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            if (!pkid.equals(entry.getLong("intbillid"))) continue;
            entry.set("iswriteoff", (Object)iswriteoff);
            entry.set("writeoffbillno", EmptyUtil.isEmpty((DynamicObject)newRevBill) ? null : newRevBill.getString("billno"));
            entry.set("writeoffbillid", EmptyUtil.isEmpty((DynamicObject)newRevBill) ? null : Long.valueOf(newRevBill.getLong("id")));
        }
        intBill.add((Object)intBatchBill);
    }

    public static void setPlanRevenueNull(DynamicObject finBill) {
        finBill.set("futureamount", null);
        DynamicObjectCollection revenueEntry = finBill.getDynamicObjectCollection("revenue_entry");
        revenueEntry.clear();
    }

    public static List<IntBillInfo> calRevenuePlan(Long finBillId, Date startDate, Date endDate) {
        DynamicObject finBill = TmcDataServiceHelper.loadSingle((Object)finBillId, (String)CimEntityEnum.cim_finsubscribe.getValue());
        return RevenuePlanCalHelper.calRevenuePlan(finBill, startDate, endDate, null);
    }

    public static List<IntBillInfo> calRevenuePlan(DynamicObject finBill, Date startDate, Date endDate, List<PlanCallResult> repayPlanList) {
        String redeemWay = finBill.getString("redeemway");
        if (RedeemWayEnum.copies_redeem.getValue().equals(redeemWay)) {
            finBill.set("valuedate", (Object)startDate);
        } else if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            finBill.set("intdate", (Object)startDate);
        }
        finBill.set("expiredate", (Object)DateUtils.getNextDay((Date)endDate, (int)1));
        finBill.set("endinstdate", null);
        if (RedeemWayEnum.amount_redeem.getValue().equals(redeemWay)) {
            Pair<BigDecimal, List<IntBillInfo>> interestCals = RevenueCalcHelper.callIntPlanByPreInt(finBill, false, repayPlanList);
            return (List)interestCals.getValue();
        }
        return Collections.emptyList();
    }

    private static void getRevenueDonePart(DynamicObject finBill) {
        DynamicObjectCollection revenueEntry = finBill.getDynamicObjectCollection("revenue_entry");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and(new QFilter("finbillno", "=", finBill.getPkValue()));
        qFilter.and(new QFilter("datasource", "=", (Object)"revenue"));
        Object[] revenueBills = TmcDataServiceHelper.load((String)"cim_revenue", (String)"id,revenuesort,expiredate,revenuestartdate,revenueenddate,amount,entrys.startdate,entrys.enddate,entrys.days,entrys.finamount,entrys.eplanrevenue,entrys.convertdays,entrys.erevenueamount", (QFilter[])qFilter.toArray(), (String)"expiredate");
        int handCount = 0;
        if (EmptyUtil.isEmpty((Object[])revenueBills)) {
            boolean isInit = finBill.getBoolean("isinit");
            BigDecimal handRevenueAmt = finBill.getBigDecimal("handrevenueamt");
            if (isInit && EmptyUtil.isNoEmpty((BigDecimal)handRevenueAmt)) {
                DynamicObject row = revenueEntry.addNew();
                row.set("seq", (Object)handCount++);
                row.set("revenueseq", (Object)revenueEntry.size());
                Date lastRevenueDate = finBill.getDate("handlastrevenuedate");
                row.set("revenuedate", (Object)lastRevenueDate);
                row.set("revenuecalamount", (Object)finBill.getBigDecimal("handrevenueamt"));
                row.set("revenuestate", (Object)RevenueStatEnum.DONE.getValue());
            }
        }
        for (int i = 0; i < revenueBills.length; ++i) {
            DynamicObject revenueRow = revenueEntry.addNew();
            Object revenuedBill = revenueBills[i];
            revenueRow.set("seq", (Object)(i + handCount + 1));
            revenueRow.set("revenueseq", (Object)(i + handCount + 1));
            revenueRow.set("revenuedate", (Object)revenuedBill.getDate("expiredate"));
            revenueRow.set("revenuecalamount", (Object)revenuedBill.getBigDecimal("amount"));
            revenueRow.set("revenuestate", (Object)RevenueStatEnum.DONE.getValue());
            DynamicObjectCollection revenueSubEntry = revenueRow.getDynamicObjectCollection("revenue_subentry");
            revenueSubEntry.clear();
            DynamicObjectCollection entrys = revenuedBill.getDynamicObjectCollection("entrys");
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject realRevRow = (DynamicObject)entrys.get(j);
                DynamicObject revenueSubRow = revenueSubEntry.addNew();
                revenueSubRow.set("seq", (Object)(j + 1));
                revenueSubRow.set("startdate", (Object)realRevRow.getDate("startdate"));
                revenueSubRow.set("enddate", (Object)realRevRow.getDate("enddate"));
                revenueSubRow.set("days", (Object)realRevRow.getInt("days"));
                revenueSubRow.set("finamount", (Object)realRevRow.getBigDecimal("finamount"));
                revenueSubRow.set("eplanrevenue", (Object)realRevRow.getBigDecimal("eplanrevenue"));
                revenueSubRow.set("convertdays", (Object)realRevRow.getInt("convertdays"));
                revenueSubRow.set("erevenueamount", (Object)realRevRow.getBigDecimal("erevenueamount"));
            }
        }
    }

    private static Date getLastPreIntDate(DynamicObject finBill, Map<String, String> operationVariable) {
        Date lstPayIntDate;
        if (EmptyUtil.isNoEmpty((String)operationVariable.get("FROM_UNAUDIT"))) {
            QFilter preFilter = new QFilter("finbillno", "=", finBill.getPkValue());
            preFilter.and("operatype", "=", (Object)OperaTypeEnum.INTERESTREV.getValue());
            preFilter.and("datasource", "=", (Object)OperaTypeEnum.INTERESTREV.getValue());
            preFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            preFilter.and("writeoffstatus", "!=", (Object)WriteOffStatusEnum.RED_WRITEOFF.getValue());
            Object[] preInterests = TmcDataServiceHelper.load((String)"cim_intbill_revenue", (String)"id,finbillno,operatype,datasource,entrys,entrys.enddate,revenueenddate", (QFilter[])preFilter.toArray(), (String)"revenueenddate  desc", (int)1);
            lstPayIntDate = EmptyUtil.isNoEmpty((Object[])preInterests) ? preInterests[0].getDate("revenueenddate") : finBill.getDate("handendpredate");
        } else {
            lstPayIntDate = finBill.getDate("lastpayinstdate");
        }
        Date minDate = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
        Date lstDate1 = Optional.ofNullable(lstPayIntDate).orElse(minDate);
        Date lstDate2 = Optional.ofNullable(finBill.getDate("endinstdate")).orElse(minDate);
        lstPayIntDate = lstDate1.compareTo(lstDate2) >= 0 ? lstDate1 : lstDate2;
        lstPayIntDate = lstPayIntDate.compareTo(minDate) == 0 ? null : lstPayIntDate;
        return lstPayIntDate;
    }

    private static Date getLastEndInstDate(DynamicObject finBill, Date preInstEndDate) {
        QFilter qFilter = new QFilter("finbillno", "=", finBill.getPkValue());
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("datasource", "=", (Object)"revenue");
        DynamicObjectCollection revenueBills = QueryServiceHelper.query((String)CimEntityEnum.cim_revenue.getValue(), (String)"id,amount,revenuesort,revenueenddate", (QFilter[])qFilter.toArray(), (String)"expiredate desc", (int)1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)revenueBills)) {
            return preInstEndDate;
        }
        Date minDate = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
        Date lstDate1 = preInstEndDate == null ? minDate : preInstEndDate;
        Date lstDate2 = Optional.ofNullable(((DynamicObject)revenueBills.get(0)).getDate("revenueenddate")).orElse(minDate);
        Date lstPayIntDate = lstDate1.compareTo(lstDate2) >= 0 ? lstDate1 : lstDate2;
        lstPayIntDate = lstPayIntDate.compareTo(minDate) == 0 ? null : lstPayIntDate;
        return lstPayIntDate;
    }
}

