/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.service.deposit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.cim.common.enums.ReleaseTypeEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.service.deposit.DepositReleaseHelper;
import kd.tmc.cim.common.util.StringUtils;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.RateSignEnum;
import kd.tmc.fbp.common.enums.RepaymentWayEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.BizBillInfo;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.IntCalRequest;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.model.interest.RateInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.factory.IntCallFactory;
import kd.tmc.fbp.service.inst.interest.IIntCallStragety;
import org.apache.commons.lang3.tuple.Pair;

public class DepositCalcIntService {
    private static final BigDecimal RATE_MAX = BigDecimal.valueOf(Math.pow(10.0, 13.0));
    private static final String RELEASE_ENTITY = "release";
    private static final Map<String, Map<String, String>> entityBizPropMap = new HashMap<String, Map<String, String>>(16);

    public IntBillInfo calcDepositBillInt(DynamicObject releaseBill, boolean isHuge) {
        String currEntity = releaseBill.getDynamicObjectType().getName();
        String entity = "cim_deposit_apply".equals(currEntity) ? "cim_deposit_apply" : RELEASE_ENTITY;
        DynamicObject depositF7 = releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "finbillno"));
        if (EmptyUtil.isEmpty((DynamicObject)depositF7)) {
            return this.buildEmptyIntBill();
        }
        Date beginDate = depositF7.getDate("intdate");
        Date endDate = releaseBill.getDate(DepositCalcIntService.getBizPropName(entity, "redeemdate"));
        if (endDate.compareTo(beginDate) <= 0) {
            return this.buildEmptyIntBill();
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = this.getBizBill(releaseBill);
        request.setBizBill(bizBill);
        Set<RateInfo> rateSet = this.getRateList(releaseBill, bizBill, isHuge);
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return this.buildEmptyIntBill();
        }
        this.calOverDatePartInt(releaseBill, bizBill, request, stragety, intBillInfo);
        this.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    public IntBillInfo calcDepositBillInt(DynamicObject depositBill, Date beginDate, Date endDate) {
        long depositId = depositBill.getLong("id");
        Map<Long, List<PlanCallResult>> repayMap = DepositReleaseHelper.getAllReleaseList(Collections.singletonList(depositId));
        return this.calcDepositBillInt(depositBill, beginDate, endDate, repayMap.get(depositId));
    }

    public IntBillInfo calcDepositBillInt(Long depositId, Date beginDate, Date endDate) {
        DynamicObject depositBill = TmcDataServiceHelper.loadSingleFromCache((Object)depositId, (String)"cim_deposit");
        return this.calcDepositBillInt(depositBill, beginDate, endDate, null);
    }

    public IntBillInfo calcDepositBillInt(DynamicObject depositBill, Date beginDate, Date endDate, List<PlanCallResult> repayList) {
        if (endDate.compareTo(beginDate) <= 0) {
            return this.buildEmptyIntBill(beginDate, endDate);
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = this.getBizBill(depositBill, beginDate, endDate);
        request.setBizBill(bizBill);
        String currEntity = depositBill.getDynamicObjectType().getName();
        if (!"cim_deposit_apply".equals(currEntity)) {
            request.setRepayList(repayList != null ? repayList : DepositReleaseHelper.getAllReleasePlanList(depositBill));
        }
        Set<RateInfo> rateSet = this.getRateList(depositBill, beginDate, bizBill.getEndDate());
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return this.buildEmptyIntBill();
        }
        this.calOverDatePartInt(depositBill, bizBill, request, stragety, intBillInfo, endDate);
        this.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    public IntBillInfo calcDepositBillIntForReport(DynamicObject depositBill, Date beginDate, Date endDate, List<PlanCallResult> repayList) {
        if (endDate.compareTo(beginDate) <= 0) {
            return this.buildEmptyIntBill(beginDate, endDate);
        }
        IntCalRequest request = new IntCalRequest();
        BizBillInfo bizBill = this.getBizBill(depositBill, beginDate, endDate);
        request.setBizBill(bizBill);
        request.setRepayList(repayList);
        Set<RateInfo> rateSet = this.getRateList(depositBill, beginDate, bizBill.getEndDate());
        request.setRateList(rateSet);
        IIntCallStragety stragety = IntCallFactory.getInstance((RepaymentWayEnum)bizBill.getRepayWay());
        IntBillInfo intBillInfo = stragety.callInt(request);
        if (intBillInfo == null) {
            return this.buildEmptyIntBill();
        }
        this.calOverDatePartInt(depositBill, bizBill, request, stragety, intBillInfo, endDate);
        this.validateIntMaxValue(intBillInfo);
        return intBillInfo;
    }

    public Map<Long, IntBillInfo> calcDepositBillInt(List<Long> depositIds, Date beginDate, Date endDate) {
        if (endDate.compareTo(beginDate) <= 0) {
            return Collections.singletonMap(0L, this.buildEmptyIntBill());
        }
        HashMap<Long, IntBillInfo> depositIntBillMap = new HashMap<Long, IntBillInfo>(8);
        Map depositMap = TmcDataServiceHelper.loadFromCache((Object[])depositIds.toArray(), (String)"cim_deposit");
        Map<Long, List<PlanCallResult>> repayMap = DepositReleaseHelper.getAllReleaseList(depositIds);
        for (Map.Entry entry : depositMap.entrySet()) {
            Long depositId = (Long)entry.getKey();
            DynamicObject depositBill = (DynamicObject)entry.getValue();
            List<PlanCallResult> repayList = repayMap.get(depositId);
            IntBillInfo billInfo = this.calcDepositBillInt(depositBill, beginDate, endDate, repayList);
            depositIntBillMap.put(depositId, billInfo);
        }
        return depositIntBillMap;
    }

    private IntBillInfo buildEmptyIntBill() {
        IntBillInfo intBillInfo = new IntBillInfo();
        intBillInfo.setAmount(BigDecimal.ZERO);
        return intBillInfo;
    }

    private IntBillInfo buildEmptyIntBill(Date beginDate, Date endDate) {
        IntBillInfo intBillInfo = this.buildEmptyIntBill();
        intBillInfo.setBeginDate(beginDate);
        intBillInfo.setEndDate(endDate);
        return intBillInfo;
    }

    private void calOverDatePartInt(DynamicObject releaseBill, BizBillInfo bizBill, IntCalRequest request, IIntCallStragety stragety, IntBillInfo intBillInfo) {
        String currEntity = releaseBill.getDynamicObjectType().getName();
        String entity = "cim_deposit_apply".equals(currEntity) ? "cim_deposit_apply" : RELEASE_ENTITY;
        DynamicObject depositF7 = releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "finbillno"));
        String investType = Optional.ofNullable(releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "investvarieties"))).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isFixed((String)investType)) {
            Date expireDate = depositF7.getDate("expiredate");
            Date redeemDate = releaseBill.getDate(DepositCalcIntService.getBizPropName(entity, "redeemdate"));
            if (redeemDate.compareTo(expireDate) > 0) {
                bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
                bizBill.setBeginDate(expireDate);
                bizBill.setEndDate(redeemDate);
                HashSet<RateInfo> set = new HashSet<RateInfo>(2);
                BigDecimal demandRate = "cim_deposit_apply".equals(entity) ? depositF7.getBigDecimal("demandrate") : releaseBill.getBigDecimal("demandrate");
                this.addElementForSet(set, expireDate, demandRate);
                request.setRateList(set);
                IntBillInfo overDateIntBill = stragety.callInt(request);
                if (EmptyUtil.isEmpty((Object)overDateIntBill)) {
                    return;
                }
                List details = overDateIntBill.getDetails();
                if (EmptyUtil.isNoEmpty((Object)details)) {
                    intBillInfo.setEndDate(((IntBillDetailInfo)details.get(details.size() - 1)).getEndDate());
                }
                intBillInfo.getDetails().addAll(details);
                intBillInfo.setAmount(intBillInfo.getAmount().add(overDateIntBill.getAmount()));
            }
        }
    }

    private void calOverDatePartInt(DynamicObject depositBill, BizBillInfo bizBill, IntCalRequest request, IIntCallStragety stragety, IntBillInfo intBillInfo, Date endDate) {
        Date expireDate;
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isFixed((String)investType) && (expireDate = depositBill.getDate("expiredate")) != null && endDate.compareTo(expireDate) > 0) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
            bizBill.setBeginDate(expireDate);
            bizBill.setEndDate(endDate);
            HashSet<RateInfo> set = new HashSet<RateInfo>(2);
            String currEntity = depositBill.getDynamicObjectType().getName();
            BigDecimal demandRate = "cim_deposit_apply".equals(currEntity) ? depositBill.getDynamicObject("deposit").getBigDecimal("demandrate") : depositBill.getBigDecimal("demandrate");
            this.addElementForSet(set, expireDate, demandRate);
            request.setRateList(set);
            IntBillInfo overDateIntBill = stragety.callInt(request);
            if (EmptyUtil.isEmpty((Object)overDateIntBill)) {
                return;
            }
            List details = overDateIntBill.getDetails();
            if (EmptyUtil.isNoEmpty((Object)details)) {
                intBillInfo.setEndDate(((IntBillDetailInfo)details.get(details.size() - 1)).getEndDate());
                intBillInfo.setBizDate(overDateIntBill.getBizDate());
            }
            intBillInfo.getDetails().addAll(details);
            intBillInfo.setAmount(intBillInfo.getAmount().add(overDateIntBill.getAmount()));
        }
    }

    private Set<RateInfo> getRateList(DynamicObject releaseBill, BizBillInfo bizBill, boolean isHuge) {
        BigDecimal demandRate;
        Set<RateInfo> set = new HashSet<RateInfo>(2);
        Date startDate = bizBill.getBeginDate();
        if (isHuge) {
            this.addElementForSet(set, startDate, releaseBill.getBigDecimal("interestrate"));
            return set;
        }
        String currEntity = releaseBill.getDynamicObjectType().getName();
        String entity = "cim_deposit_apply".equals(currEntity) ? "cim_deposit_apply" : RELEASE_ENTITY;
        DynamicObject depositF7 = releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "finbillno"));
        String intType = depositF7.getString("interesttype");
        Date redeemDate = releaseBill.getDate(DepositCalcIntService.getBizPropName(entity, "redeemdate"));
        String investType = Optional.ofNullable(releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "investvarieties"))).map(r -> r.getString("investtype")).orElse("");
        BigDecimal bigDecimal = demandRate = "cim_deposit_apply".equals(entity) ? depositF7.getBigDecimal("demandrate") : releaseBill.getBigDecimal("demandrate");
        if (InvestTypeEnum.isNotice((String)investType)) {
            if (ReleaseTypeEnum.isAgreeon(releaseBill.getString(DepositCalcIntService.getBizPropName(entity, "releasetype")))) {
                if (InterestTypeEnum.isFixed((String)intType)) {
                    this.addElementForSet(set, startDate, releaseBill.getBigDecimal(DepositCalcIntService.getBizPropName(entity, "interestrate")));
                } else if (InterestTypeEnum.isFloat((String)intType)) {
                    set = this.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                }
            } else {
                this.addElementForSet(set, startDate, demandRate);
            }
        } else {
            Date expireDate = depositF7.getDate("expiredate");
            Pair<Date, AdjustMethodEnum> adjustPair = DepositHelper.getAdjustExpireDate(depositF7, expireDate);
            Date adjustExpireDate = (Date)adjustPair.getLeft();
            AdjustMethodEnum adjustMethodEnum = (AdjustMethodEnum)adjustPair.getRight();
            if (expireDate.compareTo(adjustExpireDate) == 0 || adjustMethodEnum == AdjustMethodEnum.forward || adjustMethodEnum == AdjustMethodEnum.ad_forward) {
                if (redeemDate.compareTo(expireDate) < 0) {
                    bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
                    this.addElementForSet(set, startDate, demandRate);
                } else {
                    bizBill.setEndDate(expireDate);
                    if (InterestTypeEnum.isFixed((String)intType)) {
                        this.addElementForSet(set, startDate, releaseBill.getBigDecimal(DepositCalcIntService.getBizPropName(entity, "interestrate")));
                    } else if (InterestTypeEnum.isFloat((String)intType)) {
                        set = this.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                    }
                }
            } else if (adjustMethodEnum == AdjustMethodEnum.backward || adjustMethodEnum == AdjustMethodEnum.ad_backward) {
                if (redeemDate.compareTo(adjustExpireDate) < 0) {
                    bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
                    this.addElementForSet(set, startDate, demandRate);
                } else if (redeemDate.compareTo(adjustExpireDate) >= 0 && redeemDate.compareTo(expireDate) <= 0) {
                    if (InterestTypeEnum.isFixed((String)intType)) {
                        this.addElementForSet(set, startDate, releaseBill.getBigDecimal(DepositCalcIntService.getBizPropName(entity, "interestrate")));
                    } else if (InterestTypeEnum.isFloat((String)intType)) {
                        set = this.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                    }
                } else {
                    bizBill.setEndDate(expireDate);
                    if (InterestTypeEnum.isFixed((String)intType)) {
                        this.addElementForSet(set, startDate, releaseBill.getBigDecimal(DepositCalcIntService.getBizPropName(entity, "interestrate")));
                    } else if (InterestTypeEnum.isFloat((String)intType)) {
                        set = this.getRateInfoWhenFloat(depositF7, startDate, bizBill.getEndDate());
                    }
                }
            }
        }
        return set;
    }

    private Set<RateInfo> getRateList(DynamicObject depositBill, Date beginDate, Date endDate) {
        Set<RateInfo> set = new HashSet<RateInfo>();
        String intType = depositBill.getString("interesttype");
        if (InterestTypeEnum.isFixed((String)intType)) {
            this.addElementForSet(set, beginDate, depositBill.getBigDecimal("interestrate"));
        } else if (InterestTypeEnum.isFloat((String)intType)) {
            set = this.getRateInfoWhenFloat(depositBill, beginDate, endDate);
        }
        return set;
    }

    private Set<RateInfo> getRateInfoWhenFloat(DynamicObject deposit, Date beginDate, Date endDate) {
        String referRateNumber = Optional.ofNullable(deposit.getDynamicObject("referencerate")).map(r -> r.getString("number")).orElse("");
        Map rateDateVal = MarketDataServiceHelper.referRate((String)referRateNumber, (Date)beginDate, (Date)endDate);
        if (CollectionUtils.isEmpty((Map)rateDateVal)) {
            throw this.refferRateNotExistException(referRateNumber, beginDate, endDate);
        }
        String rateSign = deposit.getString("ratesign");
        BigDecimal rateFloatPoint = deposit.getBigDecimal("ratefloatpoint");
        BigDecimal rateFloat = rateFloatPoint.divide(new BigDecimal("100"), 6, RoundingMode.HALF_UP);
        if (RateSignEnum.SUBTRACT.getValue().equals(rateSign)) {
            rateFloat = rateFloat.negate();
        }
        HashSet<RateInfo> rateSet = new HashSet<RateInfo>(rateDateVal.size());
        for (Map.Entry entry : rateDateVal.entrySet()) {
            RateInfo info = new RateInfo();
            info.setEffectiveDate((Date)entry.getKey());
            info.setRate(((BigDecimal)entry.getValue()).add(rateFloat));
            rateSet.add(info);
        }
        return rateSet;
    }

    private KDBizException refferRateNotExistException() {
        return new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u57fa\u7840\u8d44\u6599\u5e94\u7528\u4e0b\u7684\u53c2\u8003\u5229\u7387\u6570\u636e\u3002", (String)"DepositHelper_1", (String)"tmc-cim-common", (Object[])new Object[0]));
    }

    private KDBizException refferRateNotExistException(String referRateNumber, Date beginDate, Date endDate) {
        if (StringUtils.isEmpty((CharSequence)referRateNumber)) {
            return this.refferRateNotExistException();
        }
        return new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u53c2\u8003\u5229\u7387\u6570\u636e\u4e2d\u5f55\u5165%1$s\u5728\u62a5\u4ef7\u65e5\u671f%2$s\u81f3%3$s\u7684\u5229\u7387\u6570\u636e\u3002", (String)"DepositHelper_8", (String)"tmc-cim-common", (Object[])new Object[0]), referRateNumber, DateUtils.formatString((Date)beginDate, (String)"yyyy/MM/dd"), DateUtils.formatString((Date)endDate, (String)"yyyy/MM/dd")));
    }

    private void addElementForSet(Set<RateInfo> set, Date startDate, BigDecimal rate) {
        RateInfo rateInfo = new RateInfo();
        rateInfo.setEffectiveDate(startDate);
        rateInfo.setRate(rate);
        set.add(rateInfo);
    }

    private BizBillInfo getBizBill(DynamicObject releaseBill) {
        DynamicObject depositF7;
        DynamicObject productFactory;
        BizBillInfo bizBill = new BizBillInfo();
        String currEntity = releaseBill.getDynamicObjectType().getName();
        String entity = "cim_deposit_apply".equals(currEntity) ? "cim_deposit_apply" : RELEASE_ENTITY;
        String releaseType = releaseBill.getString(DepositCalcIntService.getBizPropName(entity, "releasetype"));
        if (StringUtils.equals((CharSequence)ReleaseTypeEnum.expire.getValue(), (CharSequence)releaseType)) {
            bizBill.setIntCalMethod(IntCalMethodEnum.periodcallint);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(productFactory = (depositF7 = releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "finbillno"))).getDynamicObject("productfactory")))) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"cim_investmodel");
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
            IntCalMethodEnum intCalMethod = IntCalMethodEnum.valueOf((String)productFactory.getString("intcalmethod"));
            bizBill.setIntCalMethod(intCalMethod);
            String intheadtailrule = productFactory.getString("intheadtailrule");
            bizBill.setHtRule(IntHTRuleEnum.valueOf((String)intheadtailrule));
        }
        Date beginDate = DepositHelper.getIntCalcStartDate(depositF7);
        bizBill.setBeginDate(beginDate);
        bizBill.setEndDate(releaseBill.getDate(DepositCalcIntService.getBizPropName(entity, "redeemdate")));
        bizBill.setBasis(BasisEnum.getEnum((String)depositF7.getString("basis")));
        bizBill.setLoanAmount(releaseBill.getBigDecimal(DepositCalcIntService.getBizPropName(entity, "amount")));
        bizBill.setCurrencyId(releaseBill.getDynamicObject(DepositCalcIntService.getBizPropName(entity, "currency")).getLong("id"));
        BasisEnum basis = bizBill.getBasis();
        if (basis == BasisEnum.Actual_365 || basis == BasisEnum.Actual_360) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        } else if (basis == BasisEnum.DEP_30_360) {
            bizBill.setIntCalMethod(IntCalMethodEnum.periodcallint);
        }
        return bizBill;
    }

    private BizBillInfo getBizBill(DynamicObject depositBill, Date beginDate, Date endDate) {
        DynamicObject productFactory;
        String currEntity;
        BizBillInfo bizBill = new BizBillInfo();
        String investType = Optional.ofNullable(depositBill.getDynamicObject("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isFixed((String)investType)) {
            bizBill.setIntCalMethod(IntCalMethodEnum.periodcallint);
            Date expireDate = depositBill.getDate("expiredate");
            if (EmptyUtil.isNoEmpty((Object)expireDate) && endDate.compareTo(expireDate) > 0) {
                endDate = expireDate;
            }
        }
        if (!"cim_deposit_apply".equals(currEntity = depositBill.getDynamicObjectType().getName()) && EmptyUtil.isNoEmpty((DynamicObject)(productFactory = depositBill.getDynamicObject("productfactory")))) {
            productFactory = TmcDataServiceHelper.loadSingleFromCache((Object)productFactory.getPkValue(), (String)"cim_investmodel", (String)"introundrule,intcalmethod,intheadtailrule");
            bizBill.setRound(RoundRuleEnum.valueOf((String)productFactory.getString("introundrule")));
            bizBill.setIntCalMethod(IntCalMethodEnum.valueOf((String)productFactory.getString("intcalmethod")));
            bizBill.setHtRule(IntHTRuleEnum.valueOf((String)productFactory.getString("intheadtailrule")));
        }
        bizBill.setBeginDate(beginDate);
        bizBill.setEndDate(endDate);
        BasisEnum basis = "cim_deposit_apply".equals(currEntity) ? BasisEnum.DEP_30_360 : BasisEnum.getEnum((String)depositBill.getString("basis"));
        bizBill.setBasis(basis);
        bizBill.setLoanAmount(depositBill.getBigDecimal("amount"));
        DynamicObject currency = depositBill.getDynamicObject("currency");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            bizBill.setCurrencyId(currency.getLong("id"));
        } else {
            bizBill.setScale(Integer.valueOf(2));
        }
        if (basis == BasisEnum.Actual_365 || basis == BasisEnum.Actual_360) {
            bizBill.setIntCalMethod(IntCalMethodEnum.totalcallint);
        } else if (basis == BasisEnum.DEP_30_360) {
            bizBill.setIntCalMethod(IntCalMethodEnum.periodcallint);
        }
        if (!"cim_deposit_apply".equals(currEntity)) {
            Optional.ofNullable(depositBill.getDynamicObject("revenueproject")).ifPresent(r -> bizBill.setIntSchemeId(r.getLong("id")));
        }
        return bizBill;
    }

    private void validateIntMaxValue(IntBillInfo intBillInfo) {
        BigDecimal rateAmt = intBillInfo.getAmount();
        if (EmptyUtil.isNoEmpty((BigDecimal)rateAmt) && rateAmt.compareTo(RATE_MAX) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d4b\u7b97\u672a\u6765\u6536\u76ca\u503c\u8fc7\u5927\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepositHelper_9", (String)"tmc-cim-common", (Object[])new Object[0]));
        }
    }

    private static String getBizPropName(String entity, String prop) {
        Map<String, String> bizPropMap = entityBizPropMap.get(entity);
        if (bizPropMap == null) {
            return null;
        }
        return bizPropMap.get(prop);
    }

    static {
        HashMap<String, String> releasePropMap = new HashMap<String, String>(16);
        releasePropMap.put("finbillno", "finbillno");
        releasePropMap.put("redeemdate", "redeemdate");
        releasePropMap.put("releasetype", "releasetype");
        releasePropMap.put("amount", "amount");
        releasePropMap.put("currency", "currency");
        releasePropMap.put("investvarieties", "investvarieties");
        releasePropMap.put("interestrate", "interestrate");
        entityBizPropMap.put(RELEASE_ENTITY, releasePropMap);
        HashMap<String, String> releaseApplyPropMap = new HashMap<String, String>(16);
        releaseApplyPropMap.put("finbillno", "deposit");
        releaseApplyPropMap.put("redeemdate", "estimatedate");
        releaseApplyPropMap.put("releasetype", "releasetype");
        releaseApplyPropMap.put("amount", "releaseamount");
        releaseApplyPropMap.put("currency", "currency");
        releaseApplyPropMap.put("investvarieties", "investvarieties");
        releaseApplyPropMap.put("interestrate", "interestrate");
        entityBizPropMap.put("cim_deposit_apply", releaseApplyPropMap);
    }
}

