/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.common.service.deposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.cim.common.enums.BebankStatusEnum;
import kd.tmc.cim.common.enums.TradeChannelEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositReleaseHelper {
    private static final String SELECT_FIELDS = "finbillno,isrevenue,redeemdate,amount";

    public static List<PlanCallResult> getAllReleasePlanList(DynamicObject depositBill) {
        return DepositReleaseHelper.getAllReleasePlanMap(Collections.singletonList(depositBill)).get(depositBill.getLong("id"));
    }

    public static Map<Long, List<PlanCallResult>> getAllReleasePlanMap(List<DynamicObject> depositBills) {
        HashMap<Long, List<PlanCallResult>> planListMap = new HashMap<Long, List<PlanCallResult>>(depositBills.size());
        Map<Long, List<DynamicObject>> releaseBillMap = DepositReleaseHelper.getReleaseBills(depositBills);
        for (DynamicObject depositBill : depositBills) {
            long depositId = depositBill.getLong("id");
            List<DynamicObject> releaseBills = releaseBillMap.get(depositId);
            ArrayList<PlanCallResult> planList = new ArrayList<PlanCallResult>(releaseBills.size());
            for (DynamicObject releaseBill : releaseBills) {
                PlanCallResult info = new PlanCallResult();
                info.setPayInt(releaseBill.getBoolean("isrevenue"));
                info.setBizDate(releaseBill.getDate("redeemdate"));
                info.setPrinciple(releaseBill.getBigDecimal("amount"));
                planList.add(info);
            }
            BigDecimal redeemAmount = depositBill.getBigDecimal("handredeemamt");
            if (EmptyUtil.isEmpty(planList) && depositBill.getBoolean("isinit") && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{redeemAmount, depositBill.getDate("handlastredeemdate")})) {
                PlanCallResult info = new PlanCallResult();
                info.setPayInt(false);
                info.setBizDate(depositBill.getDate("handlastredeemdate"));
                info.setPrinciple(redeemAmount);
                planList.add(info);
            }
            planListMap.put(depositId, planList);
        }
        return planListMap;
    }

    public static Map<Long, List<PlanCallResult>> getAllReleaseList(List<Long> depositIds) {
        HashMap<Long, List<PlanCallResult>> planMap = new HashMap<Long, List<PlanCallResult>>(8);
        DynamicObjectCollection repayBills = DepositReleaseHelper.getAuditReleaseBills(depositIds);
        Map<Long, List<DynamicObject>> releaseMap = repayBills.stream().collect(Collectors.groupingBy(r -> r.getLong("finbillno")));
        for (Long depositId : depositIds) {
            List repayPlanList;
            List<DynamicObject> releaseBills = releaseMap.get(depositId);
            if (releaseBills != null) {
                repayPlanList = new ArrayList(releaseBills.size());
                for (DynamicObject releaseBill : releaseBills) {
                    PlanCallResult info = new PlanCallResult();
                    info.setBizDate(releaseBill.getDate("redeemdate"));
                    info.setPrinciple(releaseBill.getBigDecimal("amount"));
                    info.setPayInt(releaseBill.getBoolean("isrevenue"));
                    repayPlanList.add(info);
                }
            } else {
                repayPlanList = Collections.emptyList();
            }
            planMap.put(depositId, repayPlanList);
        }
        return planMap;
    }

    private static DynamicObjectCollection getAuditReleaseBills(List<Long> depositIds) {
        QFilter filter = new QFilter("finbillno", "in", depositIds).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        return QueryServiceHelper.query((String)"cim_release", (String)SELECT_FIELDS, (QFilter[])filter.toArray());
    }

    private static Map<Long, List<DynamicObject>> getReleaseBills(List<DynamicObject> depositBills) {
        List onLineIds = depositBills.stream().filter(d -> TradeChannelEnum.isOnLine(d.getString("tradechannel"))).map(d -> d.getLong("id")).collect(Collectors.toList());
        List offLineIds = depositBills.stream().filter(d -> !TradeChannelEnum.isOnLine(d.getString("tradechannel"))).map(d -> d.getLong("id")).collect(Collectors.toList());
        QFilter filter = null;
        if (!offLineIds.isEmpty()) {
            filter = new QFilter("finbillno", "in", offLineIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        }
        if (!onLineIds.isEmpty()) {
            QFilter filter2 = new QFilter("finbillno", "in", onLineIds).and("bebankstatus", "=", (Object)BebankStatusEnum.TS.getValue());
            QFilter qFilter = filter = filter != null ? filter.or(filter2) : filter2;
        }
        if (filter == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"cim_release", (String)SELECT_FIELDS, (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> map = colls.stream().collect(Collectors.groupingBy(d -> d.getLong("finbillno")));
        depositBills.forEach(d -> map.putIfAbsent(d.getLong("id"), Collections.emptyList()));
        return map;
    }
}

