/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.interest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntHelper;
import kd.tmc.cim.common.service.finsubscribe.FinSubscribeCalcIntService;
import kd.tmc.cim.mservice.api.BatchCalcBillIntReq;
import kd.tmc.cim.mservice.api.CalcBillIntReq;
import kd.tmc.cim.mservice.api.CalcFinsubIntService;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.model.interest.PlanCallResult;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CalcFinsubIntServiceImpl
implements CalcFinsubIntService {
    public static final FinSubscribeCalcIntService finSubscribeCalcIntService = new FinSubscribeCalcIntService();

    public IntBillInfo calcFinsubInt(Long finsubId, Date beginDate, Date endDate) {
        return finSubscribeCalcIntService.calcFinSubBillInt(finsubId, beginDate, endDate);
    }

    public Map<Long, IntBillInfo> batchCalcFinsubInt(List<Long> finsubIds, Date beginDate, Date endDate) {
        return finSubscribeCalcIntService.batchCalcFinSubBillInt(finsubIds, beginDate, endDate);
    }

    public Map<Long, IntBillInfo> batchCalcFinsubInt(BatchCalcBillIntReq request) {
        HashMap<Long, IntBillInfo> intBillMap = new HashMap<Long, IntBillInfo>(8);
        List requests = request.getRequests();
        if (EmptyUtil.isEmpty((Collection)requests)) {
            return intBillMap;
        }
        Map<Long, CalcBillIntReq> requestMap = requests.stream().collect(Collectors.toMap(CalcBillIntReq::getBillId, r -> r, (r1, r2) -> r2));
        ArrayList<Long> finBillIds = new ArrayList<Long>(requestMap.keySet());
        List finBills = FinSubscribeCalcIntHelper.getFinSubBills(finBillIds);
        Map<Object, DynamicObject> finBillMap = finBills.stream().collect(Collectors.toMap(f -> f.getLong("id"), f -> f));
        Map<Long, List<PlanCallResult>> repayMap = this.getAllRepayPlanMap(new ArrayList<DynamicObject>(finBillMap.values()), requests);
        for (CalcBillIntReq intReq : requests) {
            Long finBillId = intReq.getBillId();
            DynamicObject finBill = finBillMap.get(finBillId);
            if (finBill == null) {
                intBillMap.put(finBillId, this.buildEmptyIntBill());
                continue;
            }
            List<PlanCallResult> repayList = repayMap.get(finBillId);
            IntBillInfo billInfo = finSubscribeCalcIntService.calcFinSubBillInt(finBill, intReq.getBeginDate(), intReq.getEndDate(), repayList);
            intBillMap.put(finBillId, billInfo);
        }
        return intBillMap;
    }

    private IntBillInfo buildEmptyIntBill() {
        IntBillInfo intBillInfo = new IntBillInfo();
        intBillInfo.setAmount(BigDecimal.ZERO);
        return intBillInfo;
    }

    private Map<Long, List<PlanCallResult>> getAllRepayPlanMap(List<DynamicObject> finBills, List<CalcBillIntReq> requests) {
        HashMap<Long, List<PlanCallResult>> result = new HashMap<Long, List<PlanCallResult>>(8);
        DynamicObjectCollection redeemBills = FinSubscribeCalcIntHelper.getRedeemBills(finBills);
        Map<Long, Date> idMap = requests.stream().collect(Collectors.toMap(r -> r.getBillId(), r -> r.getEndDate()));
        Map<Long, List<DynamicObject>> redeemBillMap = redeemBills.stream().filter(r -> r.getDate("redeemdate").compareTo((Date)idMap.get(r.getLong("finbillno"))) <= 0).collect(Collectors.groupingBy(r -> r.getLong("finbillno")));
        for (DynamicObject finBill : finBills) {
            long finBillId = finBill.getLong("id");
            List<DynamicObject> redeemBillList = redeemBillMap.get(finBillId);
            if (!EmptyUtil.isNoEmpty(redeemBillList)) continue;
            result.put(finBillId, FinSubscribeCalcIntHelper.getPlanCallResultsForReport(redeemBillList));
        }
        return result;
    }
}

