/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.paybill;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.cim.common.helper.PushPayBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.inst.helper.BizBill2PayBillWriteBackHelper;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class Deposit2PayBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static final String selectProps = "id,billno,currency,paybill,lockpayamt,amount,accepttransfer,transferamount,tradechannel,investvarieties,isredepositgenerate,isinit,eassrcid,bebankstatus,billstatus,bizstatus";

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, param.getPayBill().getPayBillId(), param.getPayBill().getAmount());
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, param.getPayBill().getPayBillId(), param.getPayBill().getAmount());
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.validateBizCore(param, sourceBill);
        BizBill2PayBillWriteBackHelper.checkPayTypeWhenOnline((PayBillWriteBackParam)param, (DynamicObject)sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        this.validateBizCore(param, sourceBill);
        BizBill2PayBillWriteBackHelper.checkPayTypeWhenOnline((PayBillWriteBackParam)param, (DynamicObject)sourceBill);
    }

    protected void doPayValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        super.doPayValidateExecute(param, sourceBill);
        this.validateBizCore(param, sourceBill);
        BizBill2PayBillWriteBackHelper.checkPayTypeWhenOnline((PayBillWriteBackParam)param, (DynamicObject)sourceBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((String)"cim_deposit", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payBillInfo.getSourceBillId())});
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill).map(r -> r.getDynamicObject("currency")).map(r -> r.getLong("id")).orElse(0L);
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        if (sourceBill.getBoolean("accepttransfer")) {
            return sourceBill.getBigDecimal("transferamount");
        }
        return sourceBill.getBigDecimal("amount");
    }

    private void updateBizBill(DynamicObject sourceBill, Long payBillId, BigDecimal lockPayAmt) {
        sourceBill.set("paybill", (Object)payBillId);
        sourceBill.set("lockpayamt", (Object)lockPayAmt);
        this.DBTxBizUpdate(sourceBill);
    }

    private void validateBizCore(PayBillWriteBackParam param, DynamicObject sourceBill) {
        String msg = PushPayBillVerifyHelper.verifyDepositBill((DynamicObject)sourceBill, (BigDecimal)param.getPayBill().getAmount(), (String)"");
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }
}

