/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.recwriteback;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.cim.common.helper.PushRecBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;

public class DepositReleaseRecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SELECT_PROP = "id,billno,billstatus,currency.id,amount,recbillno,realrevenue,combineinst,isinit,tradechannel,bebankstatus";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("recbillno", (Object)param.getRecBill().getRecBillNo());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("recbillno", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitValidateExecute(param, sourceBill);
        this.validateBizCore(sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        return TmcDataServiceHelper.loadSingle((Object)param.getRecBill().getSourceBillId(), (String)"cim_release", (String)SELECT_PROP);
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return sourceBill.getLong("currency.id");
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        BigDecimal amount = sourceBill.getBigDecimal("amount");
        if (sourceBill.getBoolean("combineinst")) {
            amount = amount.add(sourceBill.getBigDecimal("realrevenue"));
        }
        return amount;
    }

    private void validateBizCore(DynamicObject sourceBill) {
        String msg = PushRecBillVerifyHelper.verifyReleaseBill((DynamicObject)sourceBill, (String)"");
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }
}

