/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.cim.common.enums.FinServiceStatusEnum;
import kd.tmc.cim.common.helper.DepositHelper;
import kd.tmc.cim.common.helper.DepositInitHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class DepositInitUpdateHandLastService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(DepositInitUpdateHandLastService.class);
    private List<DynamicObject> releaseBillList = new ArrayList<DynamicObject>(32);
    private List<Long> depositIdList = new ArrayList<Long>(32);
    private List<Object> revenueIdList = new ArrayList<Object>(32);
    private Map<Long, Map<String, Object>> backStatDepIdMap = new HashMap<Long, Map<String, Object>>(32);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        log.info("History Data Update Begins.");
        String sqlStr = "select fid,fbilltype,fhandlastrevenuedate,fhandrevenueamt from t_cim_deposit_e where fid in  (select fid from t_cim_deposit where  fbillstatus='C' and fbillno='TZCK-20230302-0007') and fisinit='1' and fhandlastrevenuedate is not null and fhandrevenueamt>0";
        DataSet depForRevDs = DB.queryDataSet((String)"queryDepositForRevenue", (DBRoute)DBRouteConst.TMC, (String)sqlStr);
        sqlStr = "select fsourcebillid,fbillno from t_cim_dptrevenue where fisinit='1' ";
        DataSet revenueDs = DB.queryDataSet((String)"queryRevenueInit", (DBRoute)DBRouteConst.TMC, (String)sqlStr);
        DataSet joinDs = depForRevDs.leftJoin(revenueDs).on("fid", "fsourcebillid").select(depForRevDs.getRowMeta().getFieldNames(), revenueDs.getRowMeta().getFieldNames()).finish();
        DataSet revenueDealDs = joinDs.filter("fbillno is null");
        sqlStr = "select fid,fbilltype,fhandlastrevenuedate,fhandrevenueamt from t_cim_deposit_e where fid in  (select fid from t_cim_deposit where  fbillstatus='C' and fbillno='TZCK-20230302-0007') and fisinit='1' and fhandredeemamt>0  and fhandlastrevenuedate is not null and fhandlastredeemdate is null";
        DataSet depositInitDs = DB.queryDataSet((String)"queryDepositForRelease", (DBRoute)DBRouteConst.TMC, (String)sqlStr);
        boolean isNoData = depositInitDs.isEmpty();
        if (isNoData && revenueDealDs.isEmpty()) {
            log.info("No DepositInit Bills To Deal!");
            return result;
        }
        log.info("There are {} datas to add release.", (Object)depositInitDs.copy().count("fid", false));
        log.info("There are {} datas to add revenue.", (Object)revenueDealDs.copy().count("fid", false));
        Long currentDealId = 0L;
        try (TXHandle handle = TX.requiresNew();){
            for (Row row : depositInitDs) {
                currentDealId = row.getLong("fid");
                String depositEntity = row.getString("fbilltype");
                DynamicObject depositBill = BusinessDataServiceHelper.loadSingle((Object)currentDealId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)depositEntity));
                this.dealInitReleasePart(row, depositBill);
            }
            log.info("Add Release Data is Success!");
            for (Row row : revenueDealDs) {
                currentDealId = row.getLong("fid");
                String depositEntity = row.getString("fbilltype");
                DynamicObject depositBill = BusinessDataServiceHelper.loadSingle((Object)currentDealId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)depositEntity));
                this.dealInitRevenuePart(row, depositBill);
            }
            this.updateHistoryData(isNoData);
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.error("History Data Update Ends With Exception.");
            log.error("Current DepositId Is {}", (Object)currentDealId);
            throw e;
        }
        log.info("History Data Update Ends Successfully.");
        return result;
    }

    private void updateHistoryData(boolean isNoData) {
        DynamicObject[] depositBills;
        String updateSql = "update t_cim_deposit_e t set fhandlastredeemdate= DATEADD(fhandlastrevenuedate,1*60*60*24) where fid in  (select fid from t_cim_deposit where  fbillstatus='C'  and fbillno='TZCK-20230302-0007') and fisinit='1' and fhandredeemamt>0 and fhandlastrevenuedate is not null and fhandlastredeemdate is null";
        boolean isSuccess = DB.execute((DBRoute)DBRouteConst.TMC, (String)updateSql);
        if (!isNoData && !isSuccess) {
            throw new KDBizException("Update fhandlastredeemdate Error.Please Check!");
        }
        if (EmptyUtil.isNoEmpty(this.releaseBillList)) {
            SaveServiceHelper.save((DynamicObject[])this.releaseBillList.toArray(new DynamicObject[0]));
        }
        if (EmptyUtil.isNoEmpty(this.depositIdList)) {
            for (DynamicObject deposit : depositBills = TmcDataServiceHelper.load((String)"cim_deposit", (String)"lastredeemdate,handlastredeemdate", (QFilter[])new QFilter[]{new QFilter("id", "in", this.depositIdList)})) {
                deposit.set("lastredeemdate", (Object)deposit.getDate("handlastredeemdate"));
            }
            SaveServiceHelper.save((DynamicObject[])depositBills);
        }
        if (this.backStatDepIdMap.size() >= 1) {
            for (DynamicObject depositBill : depositBills = TmcDataServiceHelper.load((String)"cim_deposit", (String)"id,bizstatus,surplusamount", (QFilter[])new QFilter[]{new QFilter("id", "in", this.backStatDepIdMap.keySet())})) {
                Map<String, Object> pairMap = this.backStatDepIdMap.get(depositBill.getLong("id"));
                for (Map.Entry<String, Object> entry : pairMap.entrySet()) {
                    depositBill.set(entry.getKey(), entry.getValue());
                }
            }
            SaveServiceHelper.save((DynamicObject[])depositBills);
        }
        if (EmptyUtil.isNoEmpty(this.revenueIdList)) {
            DynamicObject[] depositBills2;
            DynamicObject[] revenueBills;
            ArrayList<Long> srcIdList = new ArrayList<Long>(this.revenueIdList.size());
            for (DynamicObject revenueBill : revenueBills = TmcDataServiceHelper.load((String)"cim_dptrevenue", (String)"billstatus,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", this.revenueIdList)})) {
                revenueBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                srcIdList.add(revenueBill.getLong("sourcebillid"));
            }
            SaveServiceHelper.save((DynamicObject[])revenueBills);
            for (DynamicObject depositBill : depositBills2 = TmcDataServiceHelper.load((Object[])srcIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cim_deposit"))) {
                DepositHelper.resetRevenueProjectEntry((DynamicObject)depositBill, (String)"add");
            }
            SaveServiceHelper.save((DynamicObject[])depositBills2);
        }
    }

    private void dealInitRevenuePart(Row row, DynamicObject depositBill) {
        BigDecimal handRevenueAmt = row.getBigDecimal("fhandrevenueamt");
        if (EmptyUtil.isEmpty((BigDecimal)handRevenueAmt)) {
            return;
        }
        this.dealForBackUp(depositBill);
        String revenueEntity = this.getTargetRevenueEntity(row.getString("fbilltype"));
        OperateOption option = OperateOption.create();
        List revenueIds = DepositInitHelper.setRevenueInitBill((DynamicObject)depositBill, (BigDecimal)handRevenueAmt, (String)revenueEntity, (OperateOption)option);
        this.revenueIdList.addAll(revenueIds);
    }

    private void dealInitReleasePart(Row row, DynamicObject depositBill) {
        if (EmptyUtil.isEmpty((Object)depositBill.getDate("lastredeemdate"))) {
            this.depositIdList.add(depositBill.getLong("id"));
        }
        this.dealForBackUp(depositBill);
        String depositEntity = row.getString("fbilltype");
        DynamicObject[] targetBills = TmcBotpHelper.push((DynamicObject)depositBill, (String)this.getTargetReleaseEntity(depositEntity));
        DynamicObject releaseBill = targetBills[0];
        Date lastRevenueDate = row.getDate("fhandlastrevenuedate");
        DepositInitHelper.setReleaseInitBill((DynamicObject)releaseBill, (DynamicObject)depositBill, (Date)DateUtils.getNextDay((Date)lastRevenueDate, (int)1), (String)depositEntity);
        releaseBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
        if (EmptyUtil.isEmpty((String)releaseBill.getString("billno"))) {
            String releaseNum = CodeRuleServiceHelper.getNumber((String)releaseBill.getDynamicObjectType().getName(), (DynamicObject)releaseBill, (String)String.valueOf(releaseBill.getLong("org_id")));
            releaseBill.set("billno", (Object)releaseNum);
        }
        releaseBill.set("lastredeemdate", null);
        releaseBill.set("surplusamount", (Object)depositBill.getBigDecimal("amount"));
        this.releaseBillList.add(releaseBill);
        TmcBotpHelper.saveRelation((String)depositEntity, (Long)depositBill.getLong("id"), (String)this.getTargetReleaseEntity(depositEntity), (Long)releaseBill.getLong("id"));
    }

    private void dealForBackUp(DynamicObject depositBill) {
        String bizStatus = depositBill.getString("bizstatus");
        if (FinServiceStatusEnum.isSubscribeEnd((String)bizStatus)) {
            HashMap<String, Object> pairMap = new HashMap<String, Object>(8);
            pairMap.put("bizstatus", bizStatus);
            pairMap.put("surplusamount", depositBill.getBigDecimal("surplusamount"));
            this.backStatDepIdMap.put(depositBill.getLong("id"), pairMap);
            depositBill.set("bizstatus", (Object)FinServiceStatusEnum.subscribe_part.getValue());
            depositBill.set("surplusamount", (Object)depositBill.getBigDecimal("amount"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{depositBill});
        }
    }

    private String getTargetReleaseEntity(String currentEntity) {
        String targetEntity;
        switch (currentEntity) {
            case "cim_noticedeposit": {
                targetEntity = "cim_noticerelease";
                break;
            }
            case "ifm_deposit": {
                targetEntity = "ifm_release";
                break;
            }
            case "ifm_notice_deposit": {
                targetEntity = "ifm_notice_release";
                break;
            }
            default: {
                targetEntity = "cim_release";
            }
        }
        return targetEntity;
    }

    private String getTargetRevenueEntity(String currentEntity) {
        String targetEntity;
        switch (currentEntity) {
            case "cim_noticedeposit": {
                targetEntity = "cim_dptrevenue";
                break;
            }
            case "ifm_deposit": {
                targetEntity = "ifm_dptrevenue";
                break;
            }
            case "ifm_notice_deposit": {
                targetEntity = "ifm_dptrevenue";
                break;
            }
            default: {
                targetEntity = "cim_dptrevenue";
            }
        }
        return targetEntity;
    }
}

