/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cim.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ScOrgUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ScOrgUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try (TXHandle handle = TX.requiresNew();){
            result.setLog("start upgrade depositBill scorg");
            this.upgradeDepositBill();
            this.upgradeReleaseBill();
            this.upgradeRevenueBill();
            result.setLog("end upgrade depositBill scorg");
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
            logger.info(e.getMessage());
            logger.info(result.getErrorInfo());
        }
        return result;
    }

    private void upgradeDepositBill() {
        this.dataUpgrade("t_cim_deposit", "t_cim_deposit_e");
    }

    private void upgradeReleaseBill() {
        this.dataUpgrade("t_cim_release", "t_cim_release");
    }

    private void upgradeRevenueBill() {
        this.dataUpgrade("t_cim_dptrevenue", "t_cim_dptrevenue");
    }

    private void dataUpgrade(String mainTable, String updateTable) {
        String querySql = mainTable.equals(updateTable) ? String.format("select fid,ffinorginfoid from %s where ffinorginfoid > 0 and fscorgid = 0", updateTable) : String.format("select fid,ffinorginfoid from %s where ffinorginfoid > 0 and  fid in (select fid from %s where fscorgid = 0)", mainTable, updateTable);
        DataSet depositBills = DB.queryDataSet((String)"upgradeDepositBill", (DBRoute)DBRouteConst.TMC, (String)querySql);
        if (depositBills.isEmpty()) {
            return;
        }
        ArrayList<Long> finOrgIds = new ArrayList<Long>(16);
        for (Row row : depositBills.copy()) {
            finOrgIds.add(row.getLong("ffinorginfoid"));
        }
        StringJoiner sj = new StringJoiner(",");
        finOrgIds.forEach(v -> sj.add(v.toString()));
        querySql = String.format("select fid,forgid from t_bd_finorginfo where fid in (%s)", sj.toString());
        DataSet finOrgInfos = DB.queryDataSet((String)"queryFinOrg", (DBRoute)DBRouteConst.SYS, (String)querySql);
        if (finOrgInfos.isEmpty()) {
            return;
        }
        HashMap<Long, Long> finOrgInfoMap = new HashMap<Long, Long>(16);
        for (Row row : finOrgInfos) {
            Long orgId = row.getLong("forgid");
            if (!EmptyUtil.isNoEmpty((Long)orgId)) continue;
            finOrgInfoMap.put(row.getLong("fid"), orgId);
        }
        if (finOrgInfoMap.size() == 0) {
            return;
        }
        String updateSql = String.format("update %s set fscorgid = ? where fid = ? and fscorgid = 0", updateTable);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Row depositBill : depositBills) {
            Long finOrgInfoId = depositBill.getLong("ffinorginfoid");
            Long scOrgId = (Long)finOrgInfoMap.get(finOrgInfoId);
            if (EmptyUtil.isEmpty((Long)scOrgId)) continue;
            Object[] params = new Object[]{scOrgId, depositBill.getLong("fid")};
            paramsList.add(params);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)updateSql, paramsList);
        }
    }
}

