/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.CreditStrategyContext;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import org.apache.commons.lang.StringUtils;

public class CreditAmountCheckDataPlugin
extends AbstractTmcListDataPlugin {
    private Set<String> columStrs = new HashSet<String>();
    private Set<String> columRemoveStrs = new HashSet<String>();

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        Map param = this.transQueryParam(queryParam);
        DataSet creditLimitDs = QueryServiceHelper.queryDataSet((String)"", (String)"cfm_creditlimit", (String)"id,org,number,banktype,bank,currency,useamt+preuseamt creditamt,createtime", (QFilter[])new QFilter[]{this.getFilter(param)}, (String)"createtime");
        Set<Long> creditIds = ReportCommonHelper.getDsIds(creditLimitDs, "id");
        if (creditIds.size() == 0) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        creditLimitDs = this.getDsFromBank(creditLimitDs);
        creditLimitDs = this.getOrgNameDs(creditLimitDs, "bos_org");
        creditLimitDs = this.getOrgNameDs(creditLimitDs, "bd_bizpartner");
        DataSet creditUseDs = this.getCreditUseDs(creditIds);
        creditLimitDs = "biz".equals(param.get("filter_way")) ? this.bizBillDataSet(creditLimitDs, creditUseDs, creditIds, param.getOrDefault("filter_creditprop", "fix")) : this.creditBillDataSet(creditLimitDs, creditUseDs, creditIds);
        return this.checkIsPass(creditLimitDs, param);
    }

    private DataSet creditBillDataSet(DataSet creditLimitDs, DataSet creditUseDs, Set<Long> creditIds) {
        DataSet creditUserealamt = creditUseDs.copy().groupBy(new String[]{"creditlimit"}).sum("realamt").finish();
        creditLimitDs = creditLimitDs.leftJoin(creditUserealamt).on("id", "creditlimit").select(creditLimitDs.getRowMeta().getFieldNames(), new String[]{"realamt detailsumamt"}).finish();
        String sql = String.format("select fid id,fentryid,fparententryid pid,fuseamt+fpreamt ouseamt from t_cfm_creditlimit_org where fid in (%s)", StringUtils.join(creditIds, (String)","));
        DataSet creditOrgDs = DB.queryDataSet((String)"getCreditIds_org", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
        DataSet creditOrgPds = creditOrgDs.filter("pid!=0");
        creditLimitDs = !(creditOrgDs = creditOrgDs.leftJoin(creditOrgPds).on("fentryid", "pid").select(creditOrgDs.getRowMeta().getFieldNames(), new String[]{"pid"}).finish().filter("pid=null").groupBy(new String[]{"id"}).sum("ouseamt").finish()).isEmpty() ? creditLimitDs.leftJoin(creditOrgDs).on("id", "id").select(creditLimitDs.getRowMeta().getFieldNames(), new String[]{"ouseamt"}).finish().updateField("ouseamt", "case when ouseamt=null then creditamt else ouseamt end") : creditLimitDs.addField("creditamt", "ouseamt");
        String typeSql = String.format("select fid id,fentryid,fparententryid pid,fuseamt+fpreamt tuseamt from t_cfm_creditlimit_type where fid in (%s)", StringUtils.join(creditIds, (String)","));
        DataSet creditTypeDs = DB.queryDataSet((String)"getCreditIds_type", (DBRoute)DBRouteConst.TMC, (String)typeSql, (Object[])new Object[0]);
        DataSet creditTypePds = creditTypeDs.filter("pid!=0");
        creditTypeDs = creditTypeDs.leftJoin(creditTypePds).on("fentryid", "pid").select(creditTypePds.getRowMeta().getFieldNames(), new String[]{"pid"}).finish().filter("pid=null").groupBy(new String[]{"id"}).sum("tuseamt").finish();
        creditLimitDs = !creditTypeDs.isEmpty() ? creditLimitDs.leftJoin(creditTypeDs).on("id", "id").select(creditLimitDs.getRowMeta().getFieldNames(), new String[]{"tuseamt"}).finish().updateField("tuseamt", "case when tuseamt=null then creditamt else tuseamt end") : creditLimitDs.addField("creditamt", "tuseamt");
        return creditLimitDs;
    }

    private DataSet bizBillDataSet(DataSet creditLimitDs, DataSet creditUseDs, Set<Long> creditIds, String creditProp) {
        DataSet creditUserealamt = creditUseDs.copy().groupBy(new String[]{"creditlimit"}).sum("realamt").finish();
        DataSet creditBizUseDs = this.getBizBillCreditAmtDs(creditIds, creditUseDs, creditProp);
        DataSet creditBizGroupLimitDs = null;
        DataSet bizCollAmtDs = null;
        if (creditBizUseDs != null && !creditBizUseDs.isEmpty()) {
            bizCollAmtDs = this.convertRowToColl(creditBizUseDs);
            this.setColumStrs(creditBizUseDs);
            creditBizGroupLimitDs = creditBizUseDs.copy().groupBy(new String[]{"creditlimit"}).sum("bizamt").finish();
        }
        creditLimitDs = creditLimitDs.leftJoin(creditUserealamt).on("id", "creditlimit").select(creditLimitDs.getRowMeta().getFieldNames(), new String[]{"realamt detailsumamt"}).finish();
        creditLimitDs = creditBizGroupLimitDs != null && !creditBizGroupLimitDs.isEmpty() ? creditLimitDs.leftJoin(creditBizGroupLimitDs).on("id", "creditlimit").select(creditLimitDs.getRowMeta().getFieldNames(), new String[]{"bizamt"}).finish() : creditLimitDs.addField("0", "bizamt");
        if (bizCollAmtDs != null && !bizCollAmtDs.isEmpty()) {
            Set<String> typeFields = Arrays.stream(bizCollAmtDs.getRowMeta().getFieldNames()).collect(Collectors.toSet());
            typeFields.remove("creditlimit");
            creditLimitDs = creditLimitDs.copy().leftJoin(bizCollAmtDs).on("id", "creditlimit").select(creditLimitDs.getRowMeta().getFieldNames(), typeFields.toArray(new String[0])).finish();
        }
        return creditLimitDs;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String columName;
        ArrayList<ReportColumn> bizColums = new ArrayList<ReportColumn>();
        ReportColumn cols = null;
        ReportColumn otherCols = null;
        ReportColumnGroup billGroup = null;
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumnGroup) || !"billgroup".equals(((ReportColumnGroup)column).getFieldKey())) continue;
            billGroup = (ReportColumnGroup)column;
            break;
        }
        String fieldName = columName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CreditAmountCheckDataPlugin_0", (String)"tmc-creditm-report", (Object[])new Object[0]);
        Iterator<String> columIte = this.columStrs.iterator();
        while (columIte.hasNext()) {
            String cmFieldName;
            String colum = columIte.next();
            fieldName = columName;
            cols = new ReportColumn();
            int i = (colum != null ? colum : "").hashCode();
            if (i < 0) {
                i = -1 * i;
            }
            if (this.columRemoveStrs.contains(cmFieldName = "cm_" + i)) {
                columIte.remove();
                continue;
            }
            cols.setFieldKey(cmFieldName);
            cols.setFieldType("amount");
            cols.setZeroShow(true);
            cols.setHyperlink(true);
            cols.setCurrencyField("currency");
            try {
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)colum);
                fieldName = dataEntityType.getDisplayName().getLocaleValue();
                bizColums.add(cols);
            }
            catch (Exception e) {
                otherCols = cols;
            }
            cols.setCaption(new LocaleString(fieldName));
        }
        if (otherCols != null) {
            bizColums.add(otherCols);
        }
        if (billGroup == null) {
            return columns;
        }
        billGroup.getChildren().addAll(bizColums);
        if (this.columStrs.size() == 1) {
            billGroup.setCaption(new LocaleString(fieldName));
        }
        return columns;
    }

    private DataSet convertRowToColl(DataSet creditBizUseDs) {
        creditBizUseDs = creditBizUseDs.copy().select(new String[]{"creditlimit", "biztype", "bizamt count"}).filter("count>0");
        DataSet rows = this.ChangeRowToColDataSet(creditBizUseDs, "biztype", "creditlimit", "cm_");
        return rows;
    }

    private DataSet getBizBillCreditAmtDs(Set<Long> creditIds, DataSet creditUseDs, String creditProp) {
        CreditStrategyContext context = new CreditStrategyContext();
        HashSet<String> billTypes = new HashSet<String>();
        creditUseDs.copy().forEach(o -> billTypes.add(o.getString("sourcetype")));
        billTypes.addAll(ReportCommonHelper.getStrategyMap().keySet());
        DataSet bizCreditAmountDs = null;
        HashMap<Long, Long> mergeMap = new HashMap<Long, Long>();
        ReportCommonHelper.getCreditIdMergeMap(creditIds, mergeMap, creditIds);
        DataSet mergeDs = ReportCommonHelper.getMergeDs(mergeMap);
        boolean isCircle = CreditPropEnum.CIRCLE.getValue().equals(creditProp);
        for (String type : billTypes) {
            ICreditBizStrategy strategy = context.getStrategy(type);
            if (strategy == null) continue;
            DataSet bizAmountDs = strategy.getBizCreditAmountDs(creditIds, creditUseDs.copy().filter("sourcetype='" + type + "'"), mergeDs, type, isCircle);
            bizCreditAmountDs = bizCreditAmountDs == null ? bizAmountDs : bizCreditAmountDs.union(bizAmountDs);
        }
        if (bizCreditAmountDs == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        bizCreditAmountDs = bizCreditAmountDs.groupBy(new String[]{"creditlimit", "biztype"}).sum("bizamt").finish().filter("bizamt!=null and bizamt!=0");
        DataSet curencyAmtprecisionDs = ReportCommonHelper.getCurencyAmtprecisionDs(ReportCommonHelper.getDsIds(bizCreditAmountDs, "creditlimit"));
        bizCreditAmountDs = bizCreditAmountDs.leftJoin(curencyAmtprecisionDs).on("creditlimit", "id").select(new String[]{"creditlimit", "biztype", "round(bizamt, cion) bizamt"}).finish();
        return bizCreditAmountDs;
    }

    private void setColumStrs(DataSet creditBizUseDs) {
        DataSet bizTypeDs = creditBizUseDs.copy().groupBy(new String[]{"biztype"}).finish();
        for (Row bizTypeD : bizTypeDs) {
            String bizType = bizTypeD.getString("biztype");
            this.columStrs.add(bizType);
        }
    }

    private DataSet checkIsPass(DataSet creditLimitDs, Map<String, Object> param) {
        String way = (String)param.get("filter_way");
        boolean isBiz = "biz".equals(way);
        creditLimitDs = creditLimitDs.updateField("creditamt", "case when creditamt=null then 0 else round(creditamt, 6) end").updateField("detailsumamt", "case when detailsumamt=null then 0 else round(detailsumamt, 6) end");
        if (isBiz) {
            DataSet curencyAmtprecisionDs = ReportCommonHelper.getCurencyAmtprecisionDs(ReportCommonHelper.getDsIds(creditLimitDs, "id"));
            creditLimitDs = creditLimitDs.leftJoin(curencyAmtprecisionDs).on("id", "id").select(creditLimitDs.getRowMeta().getFieldNames(), new String[]{"cion"}).finish().updateField("creditamt", "round(creditamt, cion)").updateField("detailsumamt", "round(detailsumamt, cion)").updateField("bizamt", "round(bizamt, cion)");
            creditLimitDs = creditLimitDs.updateField("bizamt", "case when bizamt=null then 0 else round(bizamt, 6) end").addField("case when creditamt=detailsumamt and detailsumamt=bizamt then '1' else '0' end", "ispass");
        } else {
            creditLimitDs = creditLimitDs.updateField("ouseamt", "case when ouseamt=null then 0 else round(ouseamt, 6) end").updateField("tuseamt", "case when tuseamt=null then 0 else round(tuseamt, 6) end").addField("case when creditamt=detailsumamt and detailsumamt=ouseamt and detailsumamt=tuseamt then '1' else '0' end", "ispass");
        }
        boolean isNotPass = (Boolean)param.getOrDefault("filter_ispass", true);
        if (isNotPass) {
            creditLimitDs = creditLimitDs.filter("ispass='0'");
            Set fields = Arrays.stream(creditLimitDs.getRowMeta().getFieldNames()).filter(o -> o.startsWith("cm_")).collect(Collectors.toSet());
            for (String field : fields) {
                DataSet bizSumDs = creditLimitDs.copy().groupBy().sum(field).finish();
                for (Row row : bizSumDs) {
                    if (row.getBigDecimal(field) != null && BigDecimal.ZERO.compareTo(row.getBigDecimal(field)) != 0) continue;
                    this.columRemoveStrs.add(field);
                }
            }
        }
        return creditLimitDs.orderBy(new String[]{"ispass", "org", "createtime desc"});
    }

    private DataSet getCreditUseDs(Set<Long> creditlimitIds) {
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"getCreditUseDs", (String)"cfm_credituse", (String)"creditlimit,sourcetype,sourcebillentryid sourcebillid,sourcebillid sid,realamt,creditratio,creditrate", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", creditlimitIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("isrelease", "=", (Object)"0"), new QFilter("realamt", ">", (Object)BigDecimal.ZERO)}, null);
        return creditUseDs;
    }

    private DataSet getOrgNameDs(DataSet creditLimitDs, String bankType) {
        DataSet finorgDs = creditLimitDs.copy().filter("banktype='" + bankType + "'");
        if (finorgDs.isEmpty()) {
            return creditLimitDs;
        }
        String entityName = "bos_org";
        if ("bd_bizpartner".equals(bankType)) {
            entityName = "bd_bizpartner";
        }
        Set<Long> bankid = ReportCommonHelper.getDsIds(creditLimitDs, "bank");
        DataSet orgDs = QueryServiceHelper.queryDataSet((String)"convertOrgName", (String)entityName, (String)"id tid,name", (QFilter[])new QFilter[]{new QFilter("id", "in", bankid)}, null);
        String org = ResManager.loadKDString((String)"\u5185\u90e8\u7ec4\u7ec7", (String)"CreditAmountCheckDataPlugin_2", (String)"tmc-creditm-report", (Object[])new Object[0]);
        String iner = ResManager.loadKDString((String)"\u5185\u90e8\u5ba2\u5546", (String)"CreditAmountCheckDataPlugin_1", (String)"tmc-creditm-report", (Object[])new Object[0]);
        return creditLimitDs.leftJoin(orgDs).on("bank", "tid").select(new String[]{"id", "org", "number", "banktype", "bank", "case when banktype='bos_org' then '" + org + "' when banktype='bd_bizpartner' then '" + iner + "' else bankname end bankname", "case when name!=null then name else finorgname end finorgname", "currency", "creditamt", "createtime"}).finish();
    }

    private DataSet getDsFromBank(DataSet creditLimitDs) {
        DataSet finorgDs = creditLimitDs.copy().filter("banktype='bd_finorginfo'");
        if (finorgDs.isEmpty()) {
            return creditLimitDs.addNullField(new String[]{"bankname", "finorgname"});
        }
        Set<Long> bankIds = ReportCommonHelper.getDsIds(finorgDs, "bank");
        DataSet bankTypeDs = ReportCommonHelper.getBdFinorgInfo(bankIds, "bank_cate");
        Set<Long> bankTypeIds = ReportCommonHelper.getDsIds(bankTypeDs, "typeid");
        DataSet bdFinorgTypeDs = ReportCommonHelper.getBdFinorgTypeInfo(bankTypeIds);
        bankTypeDs = bankTypeDs.leftJoin(bdFinorgTypeDs).on("typeid", "typeid").select(new String[]{"bankid", "bankname finorgname", "case when typename=null then bankname else typename end bankname"}).finish();
        creditLimitDs = creditLimitDs.leftJoin(bankTypeDs).on("bank", "bankid").select(new String[]{"id", "org", "number", "banktype", "bank", "bankname", "finorgname", "currency", "creditamt", "createtime"}).finish();
        return creditLimitDs;
    }

    private QFilter getFilter(Map<String, Object> param) {
        String creditProp;
        DynamicObjectCollection banks;
        DynamicObjectCollection orgs;
        String bankType;
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isframework", "=", (Object)"0").and("isclose", "=", (Object)"0").and("org", "!=", (Object)0);
        DynamicObjectCollection creditLimits = (DynamicObjectCollection)param.get("filter_creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditLimits)) {
            filter.and(new QFilter("id", "in", creditLimits.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet())));
        }
        if (EmptyUtil.isNoEmpty((String)(bankType = (String)param.get("filter_banktype")))) {
            Set bankTypes = Arrays.stream(bankType.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            filter.and(new QFilter("banktype", "in", bankTypes));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(orgs = (DynamicObjectCollection)param.get("filter_org")))) {
            filter.and(new QFilter("org", "in", orgs.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet())));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(banks = (DynamicObjectCollection)param.get("filter_bank")))) {
            filter.and(new QFilter("bank", "in", banks.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet())));
        }
        if (EmptyUtil.isNoEmpty((String)(creditProp = (String)param.get("filter_creditprop")))) {
            filter.and(new QFilter("creditprop", "=", (Object)creditProp));
        }
        return filter;
    }
}

