/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.CreditFrameWorkHelper;
import kd.tmc.creditm.report.helper.CreditReportFilterParamHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class CreditAmountDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        DataSet creditUseAndReturnDs;
        this.paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String selFields = "id,org.name org, bank bankid, bank.name bank,framework," + CreditAmountDetailDataListPlugin.getSelectFields(this.paramMap);
        DataSet limitOrFrameWorkDs = this.getLimitOrFrameWorkDs(queryParam, selFields);
        if (limitOrFrameWorkDs.isEmpty()) {
            return limitOrFrameWorkDs;
        }
        boolean isFrameWork = (Boolean)this.paramMap.get("filter_isframework");
        DataSet billDataDs = CreditFrameWorkHelper.getLimitDs(limitOrFrameWorkDs.copy(), isFrameWork, selFields);
        String bankType = (String)this.paramMap.get("filter_banktype");
        if (!CreditFinTypeEnum.FINORG.getValue().equals(bankType)) {
            billDataDs = CreditReportFilterParamHelper.convertOrgName(billDataDs, "bankid", "bank", bankType);
        }
        if ((creditUseAndReturnDs = ReportCommonHelper.getCreditUseAndReturnDs(billDataDs.copy(), (Date)this.paramMap.get("filter_date"))) != null) {
            DataSet billDataDsTemp = billDataDs.leftJoin(creditUseAndReturnDs).on("id", "creditlimit").select(billDataDs.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
            billDataDs = billDataDsTemp.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").updateField("useamt", "useamt-tamount").updateField("preuseamt", "preuseamt-tpreamount").updateField("avaramt", "avaramt+tamount+tpreamount");
        }
        billDataDs = CreditFrameWorkHelper.getLimitFrameNotChildren(limitOrFrameWorkDs, billDataDs, isFrameWork);
        return billDataDs;
    }

    private DataSet getLimitOrFrameWorkDs(ReportQueryParam param, String selFields) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        boolean isFrameWork = (Boolean)paramMap.get("filter_isframework");
        QFilter filter = this.getFilter(param).and("isframework", "=", (Object)(isFrameWork ? "1" : "0"));
        DataSet creditLimitDs = QueryServiceHelper.queryDataSet((String)"CreditAmountDetailDataListPlugin", (String)"cfm_creditlimit", (String)selFields, (QFilter[])new QFilter[]{filter}, (String)"");
        return creditLimitDs;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("totalamt", "useamt", "preuseamt", "avaramt");
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("totalamt_report", "useamt_report", "preuseamt_report", "avaramt_report");
    }

    public String sumNameField() {
        String statDim = (String)this.paramMap.get("statdim");
        return "org".equals(statDim) ? "bank" : "org";
    }

    public List<String> groupFields() {
        String statDim = (String)this.paramMap.get("statdim");
        ArrayList<String> groupFields = new ArrayList<String>();
        groupFields.add(statDim);
        return groupFields;
    }

    protected QFilter getFilter(ReportQueryParam param) {
        String bankType = (String)this.paramMap.get("filter_banktype");
        List orgs = this.getQueryOrgIds(param);
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("banktype", "=", (Object)bankType).and("org", "in", (Object)orgs);
        filter = ReportCommonHelper.getBankFilter(this.paramMap, filter);
        filter.and(new QFilter("ismergesrc", "=", (Object)"0"));
        boolean isClose = (Boolean)this.paramMap.get("filter_isclose");
        if (!isClose) {
            filter.and(new QFilter("isclose", "=", (Object)"0"));
        }
        return filter;
    }

    public static String getSelectFields(Map<String, Object> paramMap) {
        Set fields = (Set)paramMap.get("fields");
        Set<String> selectFields = CreditAmountDetailDataListPlugin.getNotSelectField();
        fields.removeAll(selectFields);
        return String.join((CharSequence)",", fields);
    }

    public static Set<String> getNotSelectField() {
        HashSet<String> fields = new HashSet<String>(2);
        fields.add("org");
        fields.add("bank");
        fields.add("totalamt_report");
        fields.add("useamt_report");
        fields.add("preuseamt_report");
        fields.add("avaramt_report");
        fields.add("tarcurrency");
        fields.add("statcurrency");
        fields.add("sumlevel");
        return fields;
    }
}

