/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.CreditFrameWorkHelper;
import kd.tmc.creditm.report.helper.CreditReportFilterParamHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class CreditAmountSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    public static final String LIMIT_SQL = "id,org,bank,currency,framework,currency.name cname,totalamt,useamt,preuseamt,avaramt";
    private String statDim;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        DataSet limitOrFrameWorkDs = this.getLimitOrFrameWorkDs(queryParam, LIMIT_SQL);
        if (limitOrFrameWorkDs.isEmpty()) {
            return limitOrFrameWorkDs;
        }
        boolean isFrameWork = (Boolean)paramMap.get("filter_isframework");
        DataSet creditDs = CreditFrameWorkHelper.getLimitDs(limitOrFrameWorkDs.copy(), isFrameWork, LIMIT_SQL);
        DataSet creditUseAndReturnDs = ReportCommonHelper.getCreditUseAndReturnDs(creditDs.copy(), queryParam.getFilter().getFilterItem("filter_date").getDate());
        if (creditUseAndReturnDs != null) {
            creditDs = creditDs.leftJoin(creditUseAndReturnDs).on("id", "creditlimit").select(creditDs.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
            creditDs = creditDs.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").updateField("useamt", "case when useamt is null then 0 else useamt end").updateField("preuseamt", "case when preuseamt is null then 0 else preuseamt end").updateField("useamt", "useamt-tamount").updateField("preuseamt", "preuseamt-tpreamount");
            creditDs = creditDs.select(creditDs.getRowMeta().getFieldNames()).updateField("avaramt", "totalamt-useamt-preuseamt");
        }
        if (!(creditDs = CreditFrameWorkHelper.getLimitFrameNotChildren(limitOrFrameWorkDs, creditDs, isFrameWork)).isEmpty()) {
            creditDs = creditDs.select(new String[]{"id", "org", "bank", "currency", "cname", "totalamt", "useamt", "preuseamt", "avaramt"});
        }
        this.statDim = (String)paramMap.get("statdim");
        creditDs = "org".equals(this.statDim) ? creditDs.removeFields(new String[]{"id", "bank"}) : ("bank".equals(this.statDim) ? this.getDsByBankAndCurrency(creditDs, paramMap) : creditDs.groupBy(new String[]{"currency", "cname"}).sum("totalamt").sum("useamt").sum("preuseamt").sum("avaramt").finish().addField("cname", "orgname"));
        if (creditDs == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        return creditDs;
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList("totalamt", "useamt", "preuseamt", "avaramt");
    }

    public Pair<String, String> treeGroupField() {
        return Pair.of((Object)"currency", (Object)"cname");
    }

    public List<String> groupFields() {
        ArrayList<String> groupFields = new ArrayList<String>();
        groupFields.add("currency");
        if ("bank".equals(this.statDim)) {
            groupFields.add("orgname");
        } else if ("currency".equals(this.statDim)) {
            groupFields.add("cname");
        }
        return groupFields;
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("totalamt_report", "useamt_report", "preuseamt_report", "avaramt_report");
    }

    public String sumNameField() {
        return "orgname";
    }

    protected boolean isNeedOrgTree() {
        return true;
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    public List<String> amountFields() {
        return Arrays.asList("totalamt", "totalamt_report", "useamt", "useamt_report", "preuseamt", "preuseamt_report", "avaramt", "avaramt_report");
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgname");
    }

    private DataSet getDsByBankAndCurrency(DataSet billDataDs, Map<String, Object> paramMap) {
        String bankType = (String)paramMap.get("filter_banktype");
        boolean isFinOrg = CreditFinTypeEnum.FINORG.getValue().equals(bankType);
        DataSet bankGroupDs = billDataDs.groupBy(new String[]{"bank", "currency"}).sum("totalamt").sum("useamt").sum("preuseamt").sum("avaramt").finish();
        DataSet dateDsByBankType = null;
        if (isFinOrg) {
            dateDsByBankType = this.getDateDsByBankType(bankGroupDs, paramMap);
        } else {
            billDataDs = bankGroupDs.addField("''", "orgname");
            dateDsByBankType = CreditReportFilterParamHelper.convertOrgName(billDataDs, "bank", "orgname", bankType);
        }
        return dateDsByBankType;
    }

    private DataSet getDateDsByBankType(DataSet bankGroupDs, Map<String, Object> paramMap) {
        String bankLevel = (String)paramMap.get("banklevel");
        DataSet bankTypeDs = this.getBankTypeDs(bankGroupDs);
        DataSet bankCurrDs = null;
        if ("1".equals(bankLevel)) {
            DataSet bankDs = bankGroupDs.leftJoin(bankTypeDs).on("bank", "bankid").select(bankGroupDs.getRowMeta().getFieldNames(), new String[]{"case when typename=null then bankname else typename end orgname", "case when typeid=0 then bankid else typeid end typeid"}).finish();
            bankCurrDs = bankDs.groupBy(new String[]{"typeid", "orgname", "currency"}).sum("totalamt").sum("useamt").sum("preuseamt").sum("avaramt").finish();
        } else {
            bankCurrDs = bankGroupDs.leftJoin(bankTypeDs).on("bank", "bankid").select(bankGroupDs.getRowMeta().getFieldNames(), new String[]{"bankname orgname"}).finish();
        }
        return bankCurrDs;
    }

    private DataSet getBankTypeDs(DataSet bankGroupDs) {
        Set<Long> bankIds = ReportCommonHelper.getDsIds(bankGroupDs, "bank");
        DataSet bankTypeDs = ReportCommonHelper.getBdFinorgInfo(bankIds, "bank_cate");
        Set<Long> bankTypeIds = ReportCommonHelper.getDsIds(bankTypeDs, "typeid");
        DataSet bdFinorgTypeDs = ReportCommonHelper.getBdFinorgTypeInfo(bankTypeIds);
        bankTypeDs = bankTypeDs.leftJoin(bdFinorgTypeDs).on("typeid", "typeid").select(new String[]{"bankid", "typeid", "bankname", "typename"}).finish();
        return bankTypeDs;
    }

    private DataSet getLimitOrFrameWorkDs(ReportQueryParam param, String selFields) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        boolean isFrameWork = (Boolean)paramMap.get("filter_isframework");
        QFilter filter = this.getFilter(param).and("isframework", "=", (Object)(isFrameWork ? "1" : "0"));
        DataSet creditLimitDs = QueryServiceHelper.queryDataSet((String)"CreditAmountDetailDataListPlugin", (String)"cfm_creditlimit", (String)selFields, (QFilter[])new QFilter[]{filter}, (String)"");
        return creditLimitDs;
    }

    private QFilter getFilter(ReportQueryParam param) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        List orgs = this.getQueryOrgIds(param);
        String bankType = (String)paramMap.get("filter_banktype");
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("banktype", "=", (Object)bankType).and("org", "in", (Object)orgs);
        filter = ReportCommonHelper.getBankFilter(paramMap, filter);
        filter.and(new QFilter("ismergesrc", "=", (Object)"0"));
        boolean isClose = (Boolean)paramMap.get("filter_isclose");
        if (!isClose) {
            filter.and("isclose", "=", (Object)"0");
        }
        return filter;
    }
}

