/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.report.helper.CreditReportFilterParamHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.StringUtils;

public class CreditAvailAmountDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private static final String[] REPORT_COLUMN = new String[]{"id", "number", "org", "bankid", "bank", "company", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "totalamt", "useamt", "preuseamt", "avaramt"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        this.paramMap = ReportCommonHelper.transQueryParam(queryParam);
        QFilter commonFilter = this.getFilter(queryParam);
        DataSet notGroupLimitDs = this.constructNotGroupLimitDs(commonFilter);
        DataSet appointShareDs = this.constructAppointShareDataSet(commonFilter);
        DataSet downShareDs = this.constructDownShareDataSet(commonFilter);
        notGroupLimitDs = notGroupLimitDs.select(REPORT_COLUMN);
        appointShareDs = appointShareDs.select(REPORT_COLUMN);
        downShareDs = downShareDs.select(REPORT_COLUMN);
        DataSet creditDs = notGroupLimitDs.union(appointShareDs);
        creditDs = creditDs.union(downShareDs);
        String bankType = (String)this.paramMap.get("filter_banktype");
        if (!CreditFinTypeEnum.FINORG.getValue().equals(bankType)) {
            creditDs = CreditReportFilterParamHelper.convertOrgName(creditDs, "bankid", "bank", bankType);
        }
        return creditDs;
    }

    public List<String> orinalAmountField() {
        return Arrays.asList("totalamt", "useamt", "preuseamt", "avaramt");
    }

    public List<String> sumAmountFields() {
        return Collections.singletonList("avaramt_report");
    }

    public String sumNameField() {
        return "bank";
    }

    public List<String> groupFields() {
        String statDim = (String)this.paramMap.get("statdim");
        ArrayList<String> groupFields = new ArrayList<String>();
        groupFields.add(statDim);
        return groupFields;
    }

    protected QFilter getFilter(ReportQueryParam param) {
        List orgs = this.getQueryOrgIds(param);
        QFilter orgFilter = new QFilter("entry_org.o_org.fbasedataid_id", "in", (Object)orgs);
        String bankType = (String)this.paramMap.get("filter_banktype");
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("banktype", "=", (Object)bankType).and(new QFilter("isframework", "=", (Object)"0")).and(orgFilter);
        filter = ReportCommonHelper.getBankFilter(this.paramMap, filter);
        boolean isClose = (Boolean)this.paramMap.get("filter_isclose");
        if (!isClose) {
            filter.and("isclose", "=", (Object)"0");
        }
        return filter;
    }

    private DataSet constructNotGroupLimitDs(QFilter commonFilter) {
        QFilter notGroupLimit = new QFilter("isgrouplimit", "=", (Object)Boolean.FALSE);
        DataSet notGroupLimitDs = QueryServiceHelper.queryDataSet((String)"NotGroupLimitDs_creditlimit", (String)"cfm_creditlimit", (String)"id, number, org.name company, bank bankid, bank.name bank, currency, banktype,credittype,creditprop,isgrouplimit,startdate,enddate,entry_org.o_org.fbasedataid_id org, entry_org.o_totalamt totalamt, entry_org.o_singleamt singleamt, entry_org.o_useamt useamt, entry_org.o_preamt preuseamt, entry_org.o_avaramt avaramt,entry_org.pid as o_pid, entry_org.id as entryid", (QFilter[])new QFilter[]{notGroupLimit, commonFilter}, (String)"id desc");
        if (notGroupLimitDs.isEmpty()) {
            return notGroupLimitDs;
        }
        DataSet notGroupCreditUse = ReportCommonHelper.getCreditUseAndReturnDs(notGroupLimitDs.copy(), (Date)this.paramMap.get("filter_date"));
        notGroupLimitDs = notGroupLimitDs.leftJoin(notGroupCreditUse).on("id", "creditlimit").select(notGroupLimitDs.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
        notGroupLimitDs = notGroupLimitDs.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").updateField("totalamt", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end").updateField("useamt", "useamt-tamount").updateField("preuseamt", "preuseamt-tpreamount").updateField("avaramt", "avaramt+tamount+tpreamount").orderBy(new String[]{"id desc"});
        return notGroupLimitDs;
    }

    private DataSet constructAppointShareDataSet(QFilter commonFilter) {
        QFilter appointLimit = new QFilter("isgrouplimit", "=", (Object)Boolean.TRUE).and("orgsharetype", "=", (Object)OrgShareTypeEnum.APPOINTSHARE.getValue());
        DataSet appointCreditLimitDs = QueryServiceHelper.queryDataSet((String)"GroupAppointLimitDs_creditlimit", (String)"cfm_creditlimit", (String)"id, number, org.name company, bank bankid, bank.name bank, currency, banktype,credittype,creditprop,isgrouplimit,startdate,enddate,totalamt credit_totalamt, useamt credit_useamt, preuseamt credit_preuseamt, avaramt credit_avaramt,entry_org.o_org.fbasedataid_id org, entry_org.pid as o_pid, entry_org.id as entryid,entry_org.o_totalamt totalamt, entry_org.o_singleamt singleamt, entry_org.o_avaramt as o_avaramt, entry_org.o_useamt o_useamt, entry_org.o_preamt o_preuseamt", (QFilter[])new QFilter[]{appointLimit, commonFilter}, (String)"id desc");
        DataSet appointLimitDs = appointCreditLimitDs.copy().select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "totalamt", "singleamt", "o_avaramt", "o_useamt", "o_preuseamt"});
        RowMeta rowMeta = new RowMeta(REPORT_COLUMN, new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.BooleanType, DataType.DateType, DataType.DateType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType});
        if (appointLimitDs.isEmpty()) {
            appointLimitDs = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
            return appointLimitDs;
        }
        String[] fieldNames = appointLimitDs.getRowMeta().getFieldNames();
        HashSet<Long> detailPidSet = new HashSet<Long>();
        HashSet<Long> detailCreditLimitIdSet = new HashSet<Long>();
        for (Row row : appointLimitDs.copy()) {
            if (row.getLong("o_pid") <= 0L) continue;
            detailCreditLimitIdSet.add(row.getLong("id"));
            detailPidSet.add(row.getLong("o_pid"));
        }
        DataSet detailAppointShareDs = null;
        if (EmptyUtil.isNoEmpty(detailPidSet)) {
            DataSet detailChildDS = appointLimitDs.copy().filter("o_pid>0").select(fieldNames);
            Set<Long> org = ReportCommonHelper.getDsIds(detailChildDS, "org");
            DataSet detailCreditUseSet = CreditAvailAmountDetailDataListPlugin.getCreditUseAndReturnDs(detailCreditLimitIdSet, (Date)this.paramMap.get("filter_date"));
            if (detailCreditUseSet != null) {
                DataSet billDataDsTemp = detailChildDS.leftJoin(detailCreditUseSet.copy()).on("id", "creditlimit").on("org", "org").select(detailChildDS.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
                detailChildDS = billDataDsTemp.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").updateField("o_useamt", "o_useamt-tamount").updateField("o_preuseamt", "o_preuseamt-tpreamount").updateField("o_avaramt", "o_avaramt+tamount+tpreamount");
                DataSet appointParentDS = this.getAppointParentCreditUse(detailPidSet, detailCreditLimitIdSet, detailCreditUseSet.copy());
                DataSet appointShareDS = detailChildDS.join(appointParentDS).on("o_pid", "entryid").select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "totalamt", "singleamt", "case when o_avaramt>parent_avaramt then parent_avaramt else o_avaramt end as o_avaramt", "o_useamt", "o_preuseamt"}).finish();
                DataSet appointShareCreditLimit = this.getAppointCreditUse(detailCreditLimitIdSet, detailCreditUseSet.copy());
                detailAppointShareDs = appointShareDS.leftJoin(appointShareCreditLimit).on("id", "id").select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "totalamt", "singleamt", "case when o_avaramt>avaramt then avaramt else o_avaramt end as avaramt", "o_useamt as useamt", "o_preuseamt as preuseamt"}).finish().updateField("totalamt", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end");
            } else {
                detailAppointShareDs = detailChildDS.select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end as totalamt", "singleamt", "o_avaramt as avaramt", "o_useamt as useamt", "o_preuseamt as preuseamt"});
            }
        }
        DataSet parentEntryDS = appointCreditLimitDs.copy().select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "credit_totalamt", "credit_useamt", "credit_preuseamt", "credit_avaramt", "totalamt", "singleamt", "o_avaramt", "o_useamt", "o_preuseamt"}).filter("o_pid=0");
        if (EmptyUtil.isNoEmpty(detailPidSet)) {
            String pids = StringUtils.join(detailPidSet, (String)",");
            parentEntryDS = parentEntryDS.copy().filter("entryid not in (" + pids + ")").select(fieldNames);
        }
        if (!parentEntryDS.isEmpty()) {
            HashSet<Long> parentEntryCreditLimitSet = new HashSet<Long>();
            for (Row row : parentEntryDS.copy()) {
                parentEntryCreditLimitSet.add(row.getLong("id"));
            }
            DataSet creditUseAndReturnDs = CreditAvailAmountDetailDataListPlugin.getCreditUseAndReturnDs(parentEntryCreditLimitSet, (Date)this.paramMap.get("filter_date"));
            if (creditUseAndReturnDs != null) {
                parentEntryDS = parentEntryDS.leftJoin(creditUseAndReturnDs).on("id", "creditlimit").on("org", "org").select(parentEntryDS.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
                parentEntryDS = parentEntryDS.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").updateField("o_useamt", "o_useamt-tamount").updateField("o_preuseamt", "o_preuseamt-tpreamount").updateField("o_avaramt", "o_avaramt+tamount+tpreamount");
                DataSet parentEntryCreditLimit = this.getAppointCreditUse(parentEntryCreditLimitSet, creditUseAndReturnDs.copy());
                parentEntryDS = parentEntryDS.leftJoin(parentEntryCreditLimit).on("id", "id").select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "totalamt", "singleamt", "case when o_avaramt>avaramt then avaramt else o_avaramt end as avaramt", "o_useamt as useamt", "o_preuseamt as preuseamt"}).finish().updateField("totalamt", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end");
            } else {
                parentEntryDS = parentEntryDS.select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end as totalamt", "singleamt", "o_avaramt as avaramt", "o_useamt as useamt", "o_preuseamt as preuseamt"});
            }
        }
        if (detailAppointShareDs != null && parentEntryDS != null && !detailAppointShareDs.isEmpty() && !parentEntryDS.isEmpty()) {
            return detailAppointShareDs.union(parentEntryDS);
        }
        if (parentEntryDS != null && !parentEntryDS.isEmpty()) {
            return parentEntryDS;
        }
        if (detailAppointShareDs != null && !detailAppointShareDs.isEmpty()) {
            return detailAppointShareDs;
        }
        appointLimitDs = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return appointLimitDs;
    }

    private DataSet getAppointParentCreditUse(Set<Long> detailPidSet, Set<Long> detailCreditLimitIdSet, DataSet creditUseAndReturnDs) {
        QFilter creditlimtiId = new QFilter("id", "in", detailCreditLimitIdSet);
        QFilter creditlimitPid = new QFilter("entry_org.pid", "in", detailPidSet);
        DataSet allDetailChildCreditLimitSet = QueryServiceHelper.queryDataSet((String)"CreditAmountDetailDataListPlugin", (String)"cfm_creditlimit", (String)"id, number, entry_org.o_org.fbasedataid_id org, entry_org.pid as o_pid, entry_org.id as entryid,entry_org.o_totalamt totalamt, entry_org.o_singleamt singleamt, entry_org.o_avaramt as o_avaramt", (QFilter[])new QFilter[]{creditlimtiId, creditlimitPid}, (String)"id desc");
        DataSet parentEntryCreditLimit = allDetailChildCreditLimitSet.copy().leftJoin(creditUseAndReturnDs).on("id", "creditlimit").on("org", "org").select(new String[]{"id", "number", "org", "o_pid", "entryid", "totalamt", "singleamt", "o_avaramt"}, new String[]{"tamount", "tpreamount"}).finish();
        DataSet parentUseAmount = parentEntryCreditLimit.copy().groupBy(new String[]{"o_pid"}).sum("tamount").sum("tpreamount").finish();
        QFilter parentFilter = new QFilter("entry_org.id", "in", detailPidSet);
        DataSet parentTotalAmountSet = QueryServiceHelper.queryDataSet((String)"CreditAmountDetailDataListPlugin", (String)"cfm_creditlimit", (String)"id, number, entry_org.id as entryid,entry_org.o_totalamt totalamt, entry_org.o_singleamt singleamt, entry_org.o_avaramt as o_avaramt, entry_org.o_useamt o_useamt, entry_org.o_preamt o_preamt", (QFilter[])new QFilter[]{creditlimtiId, parentFilter}, (String)"id desc");
        DataSet parentAmountSet = parentTotalAmountSet.leftJoin(parentUseAmount).on("entryid", "o_pid").select(parentTotalAmountSet.getRowMeta().getFieldNames(), parentUseAmount.getRowMeta().getFieldNames()).finish();
        parentAmountSet = parentAmountSet.updateField("totalamt", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end").updateField("tamount", "case when tamount is not null then tamount else 0 end tamount").updateField("tpreamount", "case when tpreamount is not null then tpreamount else 0 end tpreamount").addField("o_avaramt+tamount+tpreamount", "parent_avaramt").addField("o_useamt-tamount", "parent_useamt").addField("o_preamt-tpreamount", "parent_preuseamt");
        return parentAmountSet;
    }

    public DataSet getAppointCreditUse(Set<Long> detailCreditLimitIdSet, DataSet creditUseAndReturnDs) {
        QFilter creditlimtiId = new QFilter("id", "in", detailCreditLimitIdSet);
        DataSet creditLimitSet = QueryServiceHelper.queryDataSet((String)"CreditAmountDetailDataListPlugin", (String)"cfm_creditlimit", (String)"id, number, totalamt,useamt,preuseamt,avaramt", (QFilter[])new QFilter[]{creditlimtiId}, (String)"id desc");
        if (creditUseAndReturnDs != null && !creditUseAndReturnDs.isEmpty()) {
            DataSet creditUseSet = creditUseAndReturnDs.groupBy(new String[]{"creditlimit"}).sum("tamount").sum("tpreamount").finish();
            creditLimitSet = creditLimitSet.leftJoin(creditUseSet).on("id", "creditlimit").select(creditLimitSet.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
            creditLimitSet = creditLimitSet.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").updateField("useamt", "useamt-tamount").updateField("preuseamt", "preuseamt-tpreamount").updateField("avaramt", "avaramt+tamount+tpreamount");
        }
        return creditLimitSet;
    }

    public static DataSet getCreditUseAndReturnDs(Set<Long> creditIdSet, Date date) {
        if (creditIdSet.isEmpty()) {
            return null;
        }
        Date endDate = DateUtils.getDataFormat((Date)date, (boolean)false);
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"getCreditUseAndReturnDs_use", (String)"cfm_credituse", (String)"creditlimit,org,case when amount>0 then realamt else 0 end amount, case when preamount>0 then realamt else 0 end preamount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", creditIdSet), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("createtime", ">", (Object)endDate), new QFilter("isrelease", "=", (Object)"0"), new QFilter("realamt", ">", (Object)BigDecimal.ZERO)}, null);
        DataSet creditUseReturnDs = QueryServiceHelper.queryDataSet((String)"getCreditUseAndReturnDs_return", (String)"cfm_credituse", (String)"creditlimit,org,case when amount>0 then 0-returnentry.e_amount else 0 end amount, case when preamount>0 then 0-returnentry.e_amount else 0 end preamount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", creditIdSet), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("createtime", "<=", (Object)endDate), new QFilter("isrelease", "=", (Object)"0"), new QFilter("creditlimit.creditprop", "=", (Object)CreditPropEnum.CIRCLE.getValue()), new QFilter("returnentry.e_returntime", ">", (Object)endDate)}, null);
        DataSet useDs = creditUseDs.union(creditUseReturnDs);
        return useDs.groupBy(new String[]{"creditlimit", "org"}).sum("amount", "tamount").sum("preamount", "tpreamount").finish();
    }

    private DataSet constructDownShareDataSet(QFilter commonFilter) {
        QFilter downLimit = new QFilter("isgrouplimit", "=", (Object)Boolean.TRUE).and("orgsharetype", "=", (Object)OrgShareTypeEnum.DOWNSHARE.getValue());
        DataSet downCreditLimitDs = QueryServiceHelper.queryDataSet((String)"GroupDownLimitDs_creditlimit", (String)"cfm_creditlimit", (String)"id, number, org.name company, bank bankid, bank.name bank, currency, banktype,credittype,creditprop,isgrouplimit,startdate,enddate,totalamt credit_totalamt, useamt credit_useamt, preuseamt credit_preuseamt, avaramt credit_avaramt,entry_org.o_org.fbasedataid_id org, entry_org.pid as o_pid, entry_org.id as entryid,entry_org.o_totalamt totalamt, entry_org.o_singleamt singleamt, entry_org.o_avaramt as o_avaramt, entry_org.o_useamt o_useamt, entry_org.o_preamt o_preuseamt", (QFilter[])new QFilter[]{downLimit, commonFilter}, (String)"id desc");
        DataSet downLimitDs = downCreditLimitDs.copy().select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "org", "o_pid", "entryid", "totalamt", "singleamt", "o_avaramt", "o_useamt", "o_preuseamt"});
        if (downLimitDs.isEmpty()) {
            RowMeta rowMeta = new RowMeta(REPORT_COLUMN, new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.BooleanType, DataType.DateType, DataType.DateType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType});
            downLimitDs = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
            return downLimitDs;
        }
        Set<Long> creditLimitId = ReportCommonHelper.getDsIds(downCreditLimitDs.copy(), "id");
        DataSet subOrgSet = this.expandDownShareDS(downCreditLimitDs.copy());
        RowMeta parentOrgUseDsRowMeta = new RowMeta(new String[]{"creditlimit", "parent_orgid", "tamount", "tpreamount"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType});
        DataSet parentOrgUseDs = Algo.create((String)"EmptyDataSet").createDataSetBuilder(parentOrgUseDsRowMeta).build();
        RowMeta creditUseDsRowMeta = new RowMeta(new String[]{"creditlimit", "tamount", "tpreamount"}, new DataType[]{DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType});
        DataSet creditUseDs = Algo.create((String)"EmptyDataSet").createDataSetBuilder(creditUseDsRowMeta).build();
        DataSet creditUseAndReturnDs = CreditAvailAmountDetailDataListPlugin.getCreditUseAndReturnDs(creditLimitId, (Date)this.paramMap.get("filter_date"));
        if (creditUseAndReturnDs != null) {
            DataSet creditOrgUseDs = creditUseAndReturnDs.leftJoin(subOrgSet).on("org", "sub_orgid").select(creditUseAndReturnDs.getRowMeta().getFieldNames(), new String[]{"parent_orgid"}).finish();
            parentOrgUseDs = creditOrgUseDs.copy().groupBy(new String[]{"creditlimit", "parent_orgid"}).sum("tamount").sum("tpreamount").finish();
            creditUseDs = creditOrgUseDs.copy().groupBy(new String[]{"creditlimit"}).sum("tamount").sum("tpreamount").finish();
        }
        DataSet parentCreditDs = downCreditLimitDs.leftJoin(parentOrgUseDs).on("id", "creditlimit").on("org", "parent_orgid").select(downCreditLimitDs.getRowMeta().getFieldNames(), new String[]{"parent_orgid", "tamount", "tpreamount"}).finish();
        parentCreditDs = parentCreditDs.updateField("totalamt", "case when singleamt is not null and singleamt<>0 then singleamt else totalamt end").updateField("tamount", "case when tamount is not null then tamount else 0 end tamount").updateField("tpreamount", "case when tpreamount is not null then tpreamount else 0 end tpreamount").addField("o_avaramt+tamount+tpreamount", "parent_avaramt").addField("o_useamt-tamount", "parent_useamt").addField("o_preuseamt-tpreamount", "parent_preuseamt");
        DataSet creditLimitDsTemp = downCreditLimitDs.select(new String[]{"id", "number", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "credit_totalamt", "credit_useamt", "credit_preuseamt", "credit_avaramt", "org"});
        DataSet downCreditDs = creditLimitDsTemp.leftJoin(creditUseDs).on("id", "creditlimit").select(creditLimitDsTemp.getRowMeta().getFieldNames(), new String[]{"tamount", "tpreamount"}).finish();
        downCreditDs = downCreditDs.updateField("tamount", "case when tamount=null then 0 else tamount end tamount").updateField("tpreamount", "case when tpreamount is null then 0 else tpreamount end tpreamount").addField("credit_useamt-tamount", "useamt").addField("credit_preuseamt-tpreamount", "preuseamt").addField("credit_avaramt+tamount+tpreamount", "avaramt");
        DataSet downShareReportDs = parentCreditDs.leftJoin(downCreditDs).on("id", "id").on("org", "org").select(new String[]{"id", "number", "org", "company", "bankid", "bank", "currency", "banktype", "credittype", "creditprop", "isgrouplimit", "startdate", "enddate", "parent_avaramt", "parent_useamt as useamt", "parent_preuseamt as preuseamt", "totalamt"}, new String[]{"avaramt"}).finish();
        downShareReportDs = downShareReportDs.updateField("avaramt", "case when avaramt>parent_avaramt then parent_avaramt else avaramt end as o_avaramt");
        return downShareReportDs;
    }

    private DataSet expandDownShareDS(DataSet downCreditLimitDs) {
        Algo algo = Algo.create((String)"");
        RowMeta orgRowMeta = new RowMeta(new String[]{"parent_orgid", "sub_orgid"}, new DataType[]{DataType.LongType, DataType.LongType});
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(orgRowMeta);
        Set<Long> orgSet = ReportCommonHelper.getDsIds(downCreditLimitDs, "org");
        for (Long parentOrg : orgSet) {
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", Collections.singletonList(parentOrg), (boolean)true);
            this.buildSubOrgIdDS(dataSetBuilder, parentOrg, subOrgIds);
        }
        DataSet fullOrgDS = dataSetBuilder.build();
        return fullOrgDS;
    }

    private void buildSubOrgIdDS(DataSetBuilder dataSetBuilder, Long parentOrg, List<Long> subOrgIds) {
        for (Long orgId : subOrgIds) {
            Object[] rowObj = new Object[]{parentOrg, orgId};
            dataSetBuilder.append(rowObj);
        }
    }
}

