/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.report.helper.CreditReportFilterParamHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class CreditDetailDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Map<String, Object> paramMap = null;
    private static final String CREDITlIMIT_BASE = "id as creditlimitid, number, creditprop, isclose, org.id as horgid, orgsharetype, isgrouplimit,";
    private static final String CREDITlIMIT_END = " credittype.id hcredittypeid, credittype.name hcredittypename, currency.id currencyid, currency.name currency, startdate,enddate";
    private static final String CREDITLIMIT_HEAD_PROPS = "id as creditlimitid, number, creditprop, isclose, org.id as horgid, orgsharetype, isgrouplimit, case when bank.bank_cate.id>0 then bank.bank_cate.id else bank.id end as bankid, case when bank.bank_cate.name is null then bank.name else bank.bank_cate.name end as bank, credittype.id hcredittypeid, credittype.name hcredittypename, currency.id currencyid, currency.name currency, startdate,enddate";
    private static final String CREDITLIMIT_HEAD_INNER = "id as creditlimitid, number, creditprop, isclose, org.id as horgid, orgsharetype, isgrouplimit, bank bankid,bank.name bank, credittype.id hcredittypeid, credittype.name hcredittypename, currency.id currencyid, currency.name currency, startdate,enddate";
    private static final String ORG_SHARE_SELECT_PROPS = "creditlimitid,number,creditprop,isclose,horgid,entryid,o_pid,orgid,orgsharetype,bankid,startdate,enddate,bank,hcredittypeid,hcredittypename,currencyid,currency,o_creditamt,o_useamt,o_preamt,o_avaramt";
    private static final String[] PARENT_FIELD = new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "p_avaramt as t_avaramt", "creditypename", "credittypeid"};

    public DataSet queryDataSet(ReportQueryParam param) {
        boolean isAllRelease;
        String bankType;
        boolean ispreuse;
        List qFilterOrgIds;
        DataSet creditUseDS;
        this.paramMap = this.transQueryParam(param);
        String credittypeIdStr = (String)param.getCustomParam().get("credittypeid");
        String bankOrBankCatId = (String)param.getCustomParam().get("bankid");
        Long credittypeId = 0L;
        if (EmptyUtil.isNoEmpty((String)credittypeIdStr)) {
            credittypeId = Long.parseLong(credittypeIdStr);
        }
        QFilter creditFilter = CreditReportFilterParamHelper.initCreditReportFilter(this.paramMap);
        if (EmptyUtil.isNoEmpty((String)bankOrBankCatId)) {
            QFilter bQFilter = new QFilter("bank.bank_cate.id", "=", (Object)Long.parseLong(bankOrBankCatId));
            bQFilter.or(new QFilter("bank.id", "=", (Object)Long.parseLong(bankOrBankCatId)));
            creditFilter.and(bQFilter);
        }
        if ((creditUseDS = this.queryCreditUseDetail(creditFilter, qFilterOrgIds = this.getQueryOrgIds(param), credittypeId, ispreuse = ((Boolean)this.paramMap.get("ispreuse")).booleanValue(), bankType = (String)this.paramMap.get("filter_banktype"), isAllRelease = ((Boolean)this.paramMap.get("isincludeallreleas")).booleanValue())) == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        return creditUseDS;
    }

    private DataSet queryMixCreditDataSet(QFilter filter) {
        QFilter mixQF = new QFilter("entry_mult.id", ">", (Object)0L).and(filter);
        DataSet mixDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)"id as creditlimitid,entry_mult.m_org.fbasedataid_id orgid, entry_mult.m_credittype.fbasedataid_id m_credittypeid, entry_mult.m_totalamt as m_creditamt,  entry_mult.m_useamt as m_useamt,  entry_mult.m_preamt m_preamt, entry_mult.m_avaramt as m_avaramt", (QFilter[])new QFilter[]{mixQF}, (String)null);
        mixDS = mixDS.groupBy(new String[]{"creditlimitid", "orgid", "m_credittypeid"}).min("m_creditamt", "m_creditamt").min("m_avaramt", "m_avaramt").finish();
        return mixDS;
    }

    private DataSet queryCreditOrgDataSet(QFilter filter, List<Long> qFilterOrgIds, boolean isFinorg) {
        String fields = isFinorg ? CREDITLIMIT_HEAD_PROPS : CREDITLIMIT_HEAD_INNER;
        QFilter downShareQF = new QFilter("orgsharetype", "=", (Object)"downshare");
        QFilter specQF = new QFilter("orgsharetype", "=", (Object)"appointshare");
        specQF.or(new QFilter("isgrouplimit", "=", (Object)Boolean.FALSE));
        if (filter != null) {
            downShareQF.and(filter);
            specQF.and(filter);
        }
        DataSet downshareDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)(fields + ",entry_org.id as entryid, entry_org.o_org.fbasedataid_id orgid, entry_org.pid as o_pid, case when entry_org.pid=0 then  entry_org.o_totalamt else entry_org.o_singleamt end as o_creditamt, entry_org.o_useamt as o_useamt, entry_org.o_preamt as o_preamt, entry_org.o_avaramt as o_avaramt"), (QFilter[])downShareQF.toArray(), (String)null);
        boolean hasDownshareDS = false;
        if (!downshareDS.copy().isEmpty()) {
            hasDownshareDS = true;
            downshareDS = this.expandDownShareDS(downshareDS);
            DataSet qFilterOrgDS = this.buildOrgIdDS(qFilterOrgIds);
            downshareDS = downshareDS.join(qFilterOrgDS, JoinType.INNER).on("orgid", "orgid").select(ORG_SHARE_SELECT_PROPS.split(",")).finish();
        }
        specQF.and(new QFilter("entry_org.o_org.fbasedataid_id", "in", qFilterOrgIds));
        DataSet specOrgDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)(fields + ",entry_org.id as entryid, entry_org.o_org.fbasedataid_id orgid, entry_org.pid as o_pid, case when entry_org.pid=0 then  entry_org.o_totalamt else entry_org.o_singleamt end as o_creditamt, entry_org.o_useamt as o_useamt, entry_org.o_preamt as o_preamt, entry_org.o_avaramt as o_avaramt"), (QFilter[])specQF.toArray(), (String)null);
        DataSet specChildDS = specOrgDS.copy().filter("orgsharetype='appointshare' and o_pid>0").select(ORG_SHARE_SELECT_PROPS.split(","));
        String pids = ReportCommonHelper.getFielVals(specChildDS, "o_pid");
        DataSet specParentDS = specOrgDS.copy().filter("orgsharetype='appointshare' and o_pid=0").select("creditlimitid,number,creditprop,isclose,horgid,entryid,o_pid,orgid,orgsharetype,bankid,startdate,enddate,bank,hcredittypeid,hcredittypename,currencyid,currency,o_creditamt,o_useamt,o_preamt,o_avaramt,o_avaramt as p_avaramt".split(",")).distinct();
        DataSet specifyShareDS = specChildDS.join(specParentDS).on("o_pid", "entryid").on("orgid", "orgid").select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "horgid", "entryid", "o_pid", "orgid", "orgsharetype", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "case when o_avaramt>p_avaramt then p_avaramt else o_avaramt end as o_avaramt"}).finish();
        specParentDS = specParentDS.copy().select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "horgid", "entryid", "o_pid", "orgid", "orgsharetype", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "p_avaramt as o_avaramt"});
        if (EmptyUtil.isNoEmpty((String)pids)) {
            specParentDS = specParentDS.copy().filter("entryid not in (" + pids + ")").select(ORG_SHARE_SELECT_PROPS.split(","));
        }
        specifyShareDS = specifyShareDS.union(specParentDS);
        if (hasDownshareDS) {
            return specifyShareDS.union(downshareDS);
        }
        return specifyShareDS;
    }

    private DataSet expandDownShareDS(DataSet downshareDS) {
        Iterator creditRow = downshareDS.copy().iterator();
        Algo algo = Algo.create((String)"");
        Field creditIdFD = new Field("creditlimitid", (DataType)DataType.LongType);
        Field entyorgId = new Field("entyorgid", (DataType)DataType.LongType);
        Field orgIdFD = new Field("suborgid", (DataType)DataType.LongType);
        RowMeta orgRowMeta = new RowMeta(new Field[]{creditIdFD, entyorgId, orgIdFD});
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(orgRowMeta);
        ArrayList downOrgs = new ArrayList();
        while (creditRow.hasNext()) {
            Row credit = (Row)creditRow.next();
            Long orgId = credit.getLong("orgid");
            ArrayList<Long> orgList = new ArrayList<Long>(1);
            orgList.add(orgId);
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", orgList, (boolean)true);
            subOrgIds.removeAll(downOrgs);
            downOrgs.addAll(subOrgIds);
            Long creditLimitId = credit.getLong("creditlimitid");
            this.buildCreditOrgIdDS(dataSetBuilder, creditLimitId, subOrgIds, orgId);
        }
        DataSet fullOrgDS = dataSetBuilder.build();
        downshareDS = downshareDS.join(fullOrgDS, JoinType.INNER).on("creditlimitid", "creditlimitid").on("orgid", "entyorgid").select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "horgid", "o_pid", "suborgid as orgid", "orgsharetype", "bankid", "startdate", "enddate", "entryid", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "o_avaramt"}).finish();
        return downshareDS;
    }

    private void buildCreditOrgIdDS(DataSetBuilder dataSetBuilder, Long creditLimitId, List<Long> orgIds, Long entyorgId) {
        for (Long orgId : orgIds) {
            Object[] rowObj = new Object[]{creditLimitId, entyorgId, orgId};
            dataSetBuilder.append(rowObj);
        }
    }

    private DataSet buildOrgIdDS(List<Long> orgIds) {
        Algo algo = Algo.create((String)"");
        Field orgIdFD = new Field("orgid", (DataType)DataType.LongType);
        RowMeta orgRowMeta = new RowMeta(new Field[]{orgIdFD});
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(orgRowMeta);
        for (Long orgId : orgIds) {
            Object[] rowObj = new Object[]{orgId};
            dataSetBuilder.append(rowObj);
        }
        return dataSetBuilder.build();
    }

    private DataSet queryCreditTypeDataSet(QFilter filter) {
        DataSet creditLimitDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)"id as creditlimitid, credittype.id as h_credittypeid, credittype.iscomprehensive as h_iscomprehensive, totalamt h_totalamt, useamt as h_useamt, preuseamt as h_preuseamt, avaramt as h_avaramt, entry_type.id as t_entryid, entry_type.pid as t_pid, entry_type.t_credittype.fbasedataid_id credittypeid,case when  entry_type.pid=0 then entry_type.t_totalamt else entry_type.t_singleamt end as t_creditamt, entry_type.t_useamt as t_useamt, entry_type.t_preamt as t_preamt, entry_type.t_avaramt as t_avaramt", (QFilter[])filter.toArray(), null);
        DataSet credittypeDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_credittype", (String)"id as credittypeid, name as creditypename, iscomprehensive", null, null).union(CreditReportFilterParamHelper.createTypeEmptyDataSet());
        creditLimitDS = creditLimitDS.join(credittypeDS, JoinType.LEFT).on("credittypeid", "credittypeid").select(new String[]{"creditlimitid", "h_credittypeid", "h_iscomprehensive", "h_totalamt", "h_useamt", "h_preuseamt", "h_avaramt", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt", "credittypeid", "creditypename"}).finish();
        DataSet comprehCreditDS = creditLimitDS.copy();
        DataSet comprehNoSpecifyShareDS = comprehCreditDS.copy().filter("t_entryid=0").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "h_totalamt as t_creditamt", "h_useamt as t_useamt", "h_preuseamt as t_preamt", "h_avaramt as t_avaramt", "creditypename"});
        boolean ctypeFlag = false;
        HashSet<Long> creditTypeIds = new HashSet<Long>();
        DataSet creditTypeAllDs = credittypeDS.copy();
        for (Row row : comprehNoSpecifyShareDS.copy()) {
            Long ctypeid = row.getLong("h_credittypeid");
            if (creditTypeIds.contains(ctypeid)) continue;
            creditTypeIds.add(ctypeid);
            if (creditTypeIds.size() == 1) {
                creditTypeAllDs = credittypeDS.addField("" + ctypeid + "", "h_credittypeid");
                ctypeFlag = true;
                continue;
            }
            DataSet credittypeDsTemp = credittypeDS.addField("" + ctypeid + "", "h_credittypeid");
            creditTypeAllDs = creditTypeAllDs.union(credittypeDsTemp);
        }
        comprehNoSpecifyShareDS = ctypeFlag ? comprehNoSpecifyShareDS.join(creditTypeAllDs).on("h_credittypeid", "h_credittypeid").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt", "creditypename", "credittypeid"}).finish() : comprehNoSpecifyShareDS.addNullField("credittypeid");
        DataSet comprehSpecifyShareDS = comprehCreditDS.copy().filter("t_entryid>0").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt", "creditypename", "credittypeid"});
        DataSet parentDS = comprehSpecifyShareDS.copy().filter("t_pid=0").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt as p_avaramt", "creditypename", "credittypeid"}).distinct();
        DataSet childDS = comprehSpecifyShareDS.copy().filter("t_pid>0");
        comprehSpecifyShareDS = childDS.leftJoin(parentDS).on("t_pid", "t_entryid").on("credittypeid", "credittypeid").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "case when t_avaramt < p_avaramt then t_avaramt else p_avaramt end as t_avaramt", "creditypename", "credittypeid"}).finish();
        String pids = ReportCommonHelper.getFielVals(childDS, "t_pid");
        parentDS = EmptyUtil.isNoEmpty((String)pids) ? parentDS.filter("t_entryid not in ( " + pids + " )").select(PARENT_FIELD) : parentDS.select(PARENT_FIELD);
        return comprehNoSpecifyShareDS.union(comprehSpecifyShareDS).union(parentDS);
    }

    private DataSet queryCreditUse(QFilter qFilter) {
        QFilter creditUseqFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        if (qFilter != null) {
            creditUseqFilter.and(qFilter);
        }
        String props = "id,org.id u_orgid, creditlimit.id as u_creditlimitid,credittype.id u_credittypeid,sourcebillno u_sourcebillno, sourcetype u_sourcetype, case when preamount>0 then preamount-returnamt else 0 end as u_preamt_minus_returnamt, case when amount >0 then amount - returnamt else 0 end as u_useamt_minus_returnamt, preamount+amount as  u_useamt, returnamt as u_returnamt, preamount as u_preamt, realamt as u_realamt";
        DataSet creditUseDS = QueryServiceHelper.queryDataSet((String)"creditUse", (String)"cfm_credituse", (String)props, (QFilter[])creditUseqFilter.toArray(), null);
        return creditUseDS;
    }

    private DataSet queryCreditUseDetail(QFilter filter, List<Long> filterOrgIds, Long creditTypeId, boolean ispreuse, String bankType, boolean isAllRelease) {
        DataSet creditUseDS;
        boolean isFinorg = CreditFinTypeEnum.FINORG.getValue().equals(bankType);
        DataSet orgShareDS = this.queryCreditOrgDataSet(filter, filterOrgIds, isFinorg);
        HashSet<Long> creditlimitIdSet = new HashSet<Long>(10);
        for (Row row : orgShareDS.copy()) {
            creditlimitIdSet.add(row.getLong("creditlimitid"));
        }
        QFilter creditUseQF = new QFilter("creditlimit.id", "in", creditlimitIdSet);
        String fitlerExpr = null;
        if (EmptyUtil.isNoEmpty((Long)creditTypeId)) {
            if (creditTypeId.equals(1L)) {
                creditUseQF.and(new QFilter("credittype.id", "=", (Object)0L));
            } else if (!creditTypeId.equals(-1L)) {
                creditUseQF.and(new QFilter("credittype.id", "=", (Object)creditTypeId));
                fitlerExpr = "credittypeid=" + creditTypeId;
            }
        }
        if (!ispreuse) {
            creditUseQF.and(new QFilter("preamount", "=", (Object)0));
        }
        if (!isAllRelease) {
            creditUseQF.and(new QFilter("realamt", ">", (Object)BigDecimal.ZERO));
        }
        if ((creditUseDS = this.queryCreditUse(creditUseQF)).isEmpty()) {
            return null;
        }
        QFilter shareQF = new QFilter("id", "in", creditlimitIdSet);
        DataSet typeShareDS = this.queryCreditTypeDataSet(shareQF);
        if (EmptyUtil.isNoEmpty(fitlerExpr)) {
            typeShareDS = typeShareDS.filter("credittypeid=" + creditTypeId);
        }
        DataSet orgCreditTypeDS = orgShareDS.join(typeShareDS, JoinType.LEFT).on("creditlimitid", "creditlimitid").select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "case when t_creditamt > o_creditamt then o_creditamt else t_creditamt  end as t_creditamt", "t_useamt", "t_preamt", "t_avaramt"}).finish();
        DataSet mixShareDS = this.queryMixCreditDataSet(shareQF);
        DataSet creditDetailDS = orgCreditTypeDS.join(mixShareDS, JoinType.LEFT).on("creditlimitid", "creditlimitid").on("orgid", "orgid").on("credittypeid", "m_credittypeid").select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "case when m_creditamt is null or  t_creditamt < m_creditamt then t_creditamt else m_creditamt end as creditamt", "t_useamt as useamt", "t_preamt as preamt", "case when m_avaramt is null or  t_avaramt  < m_avaramt  then t_avaramt  else m_avaramt end as  avaramt"}).finish();
        DataSet creditUseSumDS = creditUseDS.copy().groupBy(new String[]{"u_creditlimitid", "u_orgid", "u_credittypeid"}).sum("u_useamt_minus_returnamt", "u_useamt_sum").sum("u_preamt_minus_returnamt", "u_preamt_sum").finish();
        creditDetailDS = creditDetailDS.join(creditUseSumDS, JoinType.INNER).on("creditlimitid", "u_creditlimitid").on("orgid", "u_orgid").on("credittypeid", "u_credittypeid").select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "creditamt", "useamt", "preamt", "avaramt"}, new String[]{"u_useamt_sum", "u_preamt_sum"}).finish().select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "creditamt", "case when u_useamt_sum is null then useamt else u_useamt_sum end as useamt", "case when u_preamt_sum is null then preamt else u_preamt_sum end as preamt"}).addField("creditamt-useamt-preamt", "cal_avaramt");
        creditDetailDS = creditDetailDS.join(creditUseDS, JoinType.INNER).on("creditlimitid", "u_creditlimitid").on("orgid", "u_orgid").on("credittypeid", "u_credittypeid").select(new String[]{"creditlimitid", "number", "creditprop", "isclose", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "creditamt", "useamt", "preamt", "cal_avaramt as avaramt", "u_orgid", "u_credittypeid", "u_sourcebillno", "u_sourcetype", "u_useamt", "u_returnamt", "u_preamt", "u_realamt"}).finish();
        if (!isFinorg) {
            creditDetailDS = CreditReportFilterParamHelper.convertOrgName(creditDetailDS, "bankid", "bank", bankType);
        }
        return creditDetailDS;
    }

    protected String getCurrencyField() {
        return "currencyid";
    }

    protected List<String> orinalAmountField() {
        ArrayList<String> amtFieldList = new ArrayList<String>(10);
        amtFieldList.add("creditamt");
        amtFieldList.add("preamt");
        amtFieldList.add("useamt");
        amtFieldList.add("avaramt");
        amtFieldList.add("u_useamt");
        amtFieldList.add("u_returnamt");
        amtFieldList.add("u_realamt");
        return amtFieldList;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    public List<String> orderByFields() {
        List<String> orderFields = Arrays.asList("bank", "orgid", "number");
        String statdim = (String)this.paramMap.get("statdim");
        if ("companybank".equals(statdim)) {
            orderFields = Arrays.asList("orgid", "bank", "number");
        }
        return orderFields;
    }
}

