/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import org.apache.commons.lang3.tuple.Pair;

public class CreditDistributionDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private Set<String> columStrs = new HashSet<String>(16);
    private static final String ORGNAME = "orgname";
    private static final String TOTALAMT = "totalamt";
    private static final String AVARAMT = "avaramt";
    private DataSet changeBankTotalAvaAmtDs;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        DataSet billDataDs = QueryServiceHelper.queryDataSet((String)"CreditDistributionDataListPlugin", (String)"cfm_creditlimit", (String)"org, currency, bank, totalamt, avaramt", (QFilter[])new QFilter[]{this.getFilter(paramMap, this.getQueryOrgIds(queryParam))}, (String)"");
        if (billDataDs.isEmpty()) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        Long tarCurrencyId = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        String unit = (String)paramMap.get("filter_currencyunit");
        billDataDs = this.addExchangeRateAndCurrencyUnit(billDataDs, paramMap).updateFields(new String[]{TOTALAMT, AVARAMT}, new String[]{String.format("totalamt_report * %s", unit), String.format("avaramt_report * %s", unit)});
        String statim = (String)paramMap.get("filter_statdim");
        DataSet[] billSets = DataSetHelper.copy((DataSet)billDataDs);
        DataSet billGroupOrgAmt = billSets[0].groupBy(new String[]{"org"}).sum(TOTALAMT).sum(AVARAMT).finish();
        DataSet billDataBankTypeDs = this.getBillGroupDs(billSets[1], paramMap);
        DataSet billGroupDs = billDataBankTypeDs.copy().groupBy(new String[]{"org", "bank"}).sum(statim, "count").finish();
        this.changeBankTotalAvaAmtDs = billDataBankTypeDs;
        this.getColumStrs(billGroupDs);
        DataSet changebankOrgRowDs = this.ChangeRowToColDataSet(billGroupDs, "bank", "org", "cm_");
        String[] fieldNames = changebankOrgRowDs.getRowMeta().getFieldNames();
        DataSet bankOrgDs = changebankOrgRowDs.leftJoin(billGroupOrgAmt).on("org", "org").select(fieldNames, new String[]{TOTALAMT, AVARAMT}).finish();
        return bankOrgDs.addField(tarCurrencyId + "L", "currency");
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet.isEmpty()) {
            return dataSet;
        }
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(queryParam);
        String statim = (String)paramMap.get("filter_statdim");
        String unit = (String)paramMap.get("filter_currencyunit");
        Long tarCurrencyId = (Long)((DynamicObject)paramMap.get("filter_statcurrency")).getPkValue();
        List<String> selectFields = this.getCreditTotalFields();
        DataSet bankTotalDs = this.getBankTotalDs(this.changeBankTotalAvaAmtDs, paramMap, selectFields.toArray(new String[0]), TOTALAMT.equals(statim) ? AVARAMT : TOTALAMT);
        String[] fields = (String[])Arrays.stream(bankTotalDs.getRowMeta().getFieldNames()).filter(f -> f.startsWith("cm_")).toArray(String[]::new);
        String[] expr = (String[])Arrays.stream(fields).map(f -> {
            f = f + " / " + unit;
            return f;
        }).toArray(String[]::new);
        bankTotalDs = bankTotalDs.updateFields(fields, expr);
        bankTotalDs = bankTotalDs.select((String[])Arrays.stream(bankTotalDs.getRowMeta().getFieldNames()).map(f -> {
            f = f.startsWith("cm_") || TOTALAMT.equals(f) || AVARAMT.equals(f) ? f + " as " + f + "_report" : f;
            return f;
        }).toArray(String[]::new));
        dataSet = dataSet.select(bankTotalDs.getRowMeta().getFieldNames());
        return dataSet.union(bankTotalDs).addField(tarCurrencyId + "L", "currency");
    }

    private DataSet getBillGroupDs(DataSet billDataDs, Map<String, Object> paramMap) {
        String bankLevel = (String)paramMap.get("banklevel");
        String bankType = (String)paramMap.get("filter_banktype");
        if (CreditFinTypeEnum.FINORG.getValue().equals(bankType) && "1".equals(bankLevel)) {
            DataSet bankGroupDs = billDataDs.copy().groupBy(new String[]{"bank"}).finish();
            Set<Long> bankIds = ReportCommonHelper.getDsIds(bankGroupDs, "bank");
            DataSet bankFinDs = ReportCommonHelper.getBdFinorgInfo(bankIds, "bank_cate");
            billDataDs = billDataDs.leftJoin(bankFinDs).on("bank", "bankid").select(new String[]{"org", "case when typeid=0 or typeid is null then bank else typeid end bank", TOTALAMT, AVARAMT}).finish();
        }
        return billDataDs;
    }

    private DataSet getBankTotalDs(DataSet billDataDs, Map<String, Object> paramMap, String[] fieldNames, String statim) {
        String orgName = TOTALAMT.equals(statim) ? this.getTotalStr() : this.getAvarStr();
        DataSet bankTotalAmtDs = billDataDs.groupBy(new String[]{"bank"}).sum(statim, "count").finish().addField("'" + orgName + "'", ORGNAME);
        long tarCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        String rowId = String.valueOf(DBServiceHelper.genGlobalLongId());
        return this.ChangeRowToColDataSet(bankTotalAmtDs, "bank", ORGNAME, "cm_").addFields(new String[]{"1", "0", "0", "0", "'" + rowId + "'", rowId, "'0'", "'0'", "'0'", "NULL", tarCurrencyId + "L"}, new String[]{this.sumField, "level", TOTALAMT, AVARAMT, "rowid", "org", "pid", "parentid", "isgroupnode", "subsort", "statcurrency"}).select(fieldNames);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ArrayList<AbstractReportColumn> columnsTemp = new ArrayList<AbstractReportColumn>(columns);
        columns.clear();
        columns.addAll(columnsTemp.stream().filter(o -> ORGNAME.equals(((ReportColumn)o).getFieldKey())).collect(Collectors.toList()));
        long[] columArr = this.columStrs.stream().mapToLong(Long::parseLong).toArray();
        String bankLevel = (String)this.getQueryParam().getFilter().getFilterItem("banklevel").getValue();
        String bankType = (String)this.getQueryParam().getFilter().getFilterItem("filter_banktype").getValue();
        Map<Long, String> finorgMap = this.getColumsName(columArr, bankLevel, bankType);
        HashSet<Long> columSet = new HashSet<Long>(columArr.length);
        for (long arr : columArr) {
            columSet.add(arr);
        }
        for (Long colum : columSet) {
            ReportColumn cols = new ReportColumn();
            cols.setFieldKey("cm_" + colum + "_report");
            cols.setFieldType("amount");
            cols.setZeroShow(false);
            cols.setCurrencyField("currency");
            cols.setCaption(new LocaleString(finorgMap.get(colum)));
            columns.add((AbstractReportColumn)cols);
        }
        columns.addAll(columnsTemp.stream().filter(o -> !ORGNAME.equals(((ReportColumn)o).getFieldKey())).collect(Collectors.toList()));
        return columns;
    }

    private Map<Long, String> getColumsName(long[] columArr, String bankLevel, String bankType) {
        Map<Object, Object> finorgMap = new HashMap<Long, String>();
        if (CreditFinTypeEnum.FINORG.getValue().equals(bankType)) {
            if ("1".equals(bankLevel)) {
                finorgMap = ReportCommonHelper.getFinorgInfoMap(columArr, "bd_bankcgsetting");
            }
            if ("2".equals(bankLevel) || finorgMap.size() != columArr.length) {
                finorgMap.putAll(ReportCommonHelper.getFinorgInfoMap(columArr, "bd_finorginfo"));
            }
        } else if (CreditFinTypeEnum.ORG.getValue().equals(bankType)) {
            finorgMap.putAll(ReportCommonHelper.getFinorgInfoMap(columArr, "bos_org"));
        } else {
            finorgMap.putAll(ReportCommonHelper.getFinorgInfoMap(columArr, "bd_bizpartner"));
        }
        return finorgMap;
    }

    private void getColumStrs(DataSet billGroupDs) {
        for (Row billGroupD : billGroupDs.copy()) {
            this.columStrs.add(billGroupD.getString("bank"));
        }
    }

    private List<String> getCreditTotalFields() {
        List<String> selectFields = this.orinalAmountField();
        selectFields.add("statcurrency");
        selectFields.add("org");
        selectFields.add("level");
        selectFields.add("pid");
        selectFields.add("rowid");
        selectFields.add("isgroupnode");
        selectFields.add(this.sumField);
        selectFields.add(ORGNAME);
        selectFields.add("parentid");
        selectFields.add("subsort");
        return selectFields;
    }

    protected List<String> getSumLevelFields() {
        List<String> groupFields = CreditDistributionDataListPlugin.getSumFields();
        this.columStrs.forEach(t -> groupFields.add("cm_" + t));
        return groupFields;
    }

    protected static List<String> getSumFields() {
        ArrayList<String> groupFields = new ArrayList<String>();
        groupFields.add(TOTALAMT);
        groupFields.add(AVARAMT);
        return groupFields;
    }

    protected QFilter getFilter(Map<String, Object> paramMap, List<Long> orgids) {
        String bankType = (String)paramMap.get("filter_banktype");
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("banktype", "=", (Object)bankType)).and(new QFilter("enddate", ">=", (Object)DateUtils.getCurrentDate())).and(new QFilter("org", "in", orgids)).and(new QFilter("isframework", "=", (Object)"0"));
        boolean isClose = (Boolean)paramMap.get("filter_isclose");
        if (!isClose) {
            filter.and(new QFilter("isclose", "=", (Object)"0"));
        }
        return filter;
    }

    private String getTotalStr() {
        return ResManager.loadKDString((String)"\u6388\u4fe1\u603b\u989d\u5ea6", (String)"CreditDistributionDataListPlugin_0", (String)"tmc-creditm-report", (Object[])new Object[0]);
    }

    private String getAvarStr() {
        return ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditDistributionDataListPlugin_1", (String)"tmc-creditm-report", (Object[])new Object[0]);
    }

    protected List<String> orinalAmountField() {
        return this.getSumLevelFields();
    }

    public List<String> sumAmountFields() {
        return this.getSumLevelFields().stream().map(s -> {
            s = s + "_report";
            return s;
        }).collect(Collectors.toList());
    }

    protected boolean isNeedOrgTree() {
        return true;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)ORGNAME);
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    public String sumDisplayName() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        if (TOTALAMT.equals(statdim)) {
            return this.getTotalStr();
        }
        return this.getAvarStr();
    }
}

