/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.report.helper.CreditReportFilterParamHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class CreditSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(CreditSumDataListPlugin.class);
    private Map<String, Object> paramMap = null;
    private static final String CREDIT_BASE = " id as creditlimitid, org.id as horgid, orgsharetype, isgrouplimit, ";
    private static final String CREDIT_BASE_EN = " credittype.id hcredittypeid, credittype.name hcredittypename, currency.id currencyid, currency.name currency, startdate,enddate";
    private static final String CREDITLIMIT_HEAD_PROPS = " id as creditlimitid, org.id as horgid, orgsharetype, isgrouplimit,  case when bank.bank_cate.id>0 then bank.bank_cate.id else bank.id end as bankid, case when bank.bank_cate.name is null then bank.name else bank.bank_cate.name end as bank, credittype.id hcredittypeid, credittype.name hcredittypename, currency.id currencyid, currency.name currency, startdate,enddate";
    private static final String CREDITLIMIT_HEAD_INNER = " id as creditlimitid, org.id as horgid, orgsharetype, isgrouplimit,  bank bankid,bank.name bank, credittype.id hcredittypeid, credittype.name hcredittypename, currency.id currencyid, currency.name currency, startdate,enddate";
    private static final String[] GROUPBY_FIELDS = new String[]{"bank", "bankid", "companyid", "company", "credittype", "credittypeid", "currency", "startdate", "enddate", "sortdate", "currencyid"};
    private static final String[] GROUPBY_FIELDS_FOR_SUM_CREDITYPE = new String[]{"bank", "bankid", "companyid", "company", "currency", "currencyid", "startdate", "enddate", "sortdate"};
    private static final String SELECT_FIELD = "bank, bankid, companyid, company, credittype, credittypeid, currency, currencyid, startdate, enddate, sortdate, totalamt, totalamt_report, preuseamt_report, useamt_report, avaramt_report, statcurrency, sumlevel";
    private static final String[] GROUP_SUM_FIELDS = new String[]{"totalamt", "preuseamt", "useamt", "avaramt"};
    private static final String[] AMOUNT_SUM_FIELDS = new String[]{"totalamt_report", "preuseamt_report", "useamt_report", "avaramt_report"};
    private static final String[] GROUP_SUM_FIELDS_FOR_CREDITYPE = new String[]{"totalamt", "totalamt_report", "preuseamt_report", "useamt_report", "avaramt_report"};
    private static final String[] BANK_DIM_ORDRE_BYS = new String[]{"sort", "bank desc", "sumlevel", "company desc", "currency asc", "sortdate desc", "credittypeid asc"};
    private static final String[] COMPANY_DIM_ORDRE_BYS = new String[]{"sort", "company desc", "sumlevel", "bank desc", "currency asc", "sortdate desc", "credittypeid asc"};
    private static final String[] PARENT_FIELD = new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "p_avaramt as t_avaramt", "creditypename", "credittypeid"};

    private DataSet groupByAndSum(DataSet dataset, String[] groupbys, String[] fieldForSum) {
        GroupbyDataSet gDS = dataset.groupBy(groupbys);
        for (String field : fieldForSum) {
            gDS.sum(field);
        }
        return gDS.finish();
    }

    public DataSet queryDataSet(ReportQueryParam param) {
        logger.info("query start...");
        this.paramMap = this.transQueryParam(param);
        QFilter creditFilter = CreditReportFilterParamHelper.initCreditReportFilter(this.paramMap);
        List qFilterOrgIds = this.getQueryOrgIds(param);
        String bankType = (String)this.paramMap.get("filter_banktype");
        DataSet creditDS = this.queryCreditDataSet(creditFilter, qFilterOrgIds, bankType);
        DataSet orgDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"bos_org", (String)"id as companyid, name as company", null, null);
        creditDS = creditDS.join(orgDS).on("orgid", "companyid").select(new String[]{"creditlimitid", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "creditypename as credittype", "credittypeid", "startdate", "enddate", "totalamt", "useamt", "preuseamt", "avaramt", "company", "companyid", "concat(to_char(startdate,'yyyy-MM-dd'),to_char(enddate,'yyyy-MM-dd')) sortdate"}).finish().updateField("credittypeid", "case when credittypeid=null or credittypeid=0 then 1 else credittypeid end");
        creditDS = this.groupByAndSum(creditDS, GROUPBY_FIELDS, GROUP_SUM_FIELDS);
        return creditDS;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.select(SELECT_FIELD);
        DataSet bizDs = dataSet.copy().filter("sumlevel = 0");
        DataSet creditTypeSumDS = this.groupByAndSum(bizDs, GROUPBY_FIELDS_FOR_SUM_CREDITYPE, GROUP_SUM_FIELDS_FOR_CREDITYPE);
        String totalname = ResManager.loadKDString((String)"\u603b\u989d", (String)"CreditSumDataListPlugin_6", (String)"tmc-creditm-report", (Object[])new Object[0]);
        Long statCurrency = (Long)((DynamicObject)this.paramMap.get("filter_statcurrency")).getPkValue();
        creditTypeSumDS = creditTypeSumDS.addFields(new String[]{"0", "'" + totalname + "'", String.valueOf(statCurrency), "0"}, new String[]{"credittypeid", "credittype", "statcurrency", "sumlevel"}).select(SELECT_FIELD);
        dataSet = dataSet.union(creditTypeSumDS).addField("case when sumlevel = 2 then '1' else '0' end", "sort").orderBy(this.resultOrderFields());
        logger.info("query end...");
        return dataSet;
    }

    private DataSet queryCreditDataSet(QFilter filter, List<Long> qFilterOrgIds, String bankType) {
        logger.info("queryCreditDataSet start...");
        boolean isFinorg = CreditFinTypeEnum.FINORG.getValue().equals(bankType);
        DataSet creditOrgShareDS = this.queryCreditOrgDataSet(filter, qFilterOrgIds, isFinorg);
        DataSet creditlimitDS = creditOrgShareDS.copy().select("creditlimitid as id, horgid as companyid, currencyid, currency").distinct();
        HashSet<Long> creditlimtIds = new HashSet<Long>(10);
        for (Row r : creditlimitDS.copy()) {
            creditlimtIds.add(r.getLong("id"));
        }
        QFilter idFilter = new QFilter("id", "in", creditlimtIds);
        DataSet creditTypeShareDS = this.queryCreditTypeDataSet(idFilter);
        DataSet mixShareDS = this.queryMixCreditDataSet(idFilter);
        DataSet orgCreditTypeDS = creditOrgShareDS.join(creditTypeShareDS, JoinType.LEFT).on("creditlimitid", "creditlimitid").select(new String[]{"creditlimitid", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "case when t_creditamt > o_creditamt then o_creditamt else t_creditamt  end as t_creditamt", "case when t_avaramt > o_avaramt then o_avaramt else t_avaramt end as t_avaramt"}).finish();
        QFilter creditUseQF = new QFilter("creditlimit.id", "in", creditlimtIds);
        DataSet creditUseDS = this.queryCreditUse(creditUseQF);
        orgCreditTypeDS = orgCreditTypeDS.join(creditUseDS, JoinType.LEFT).on("creditlimitid", "u_creditlimitid").on("orgid", "u_orgid").on("credittypeid", "u_credittypeid").select(new String[]{"creditlimitid", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "t_creditamt", "u_useamt as t_useamt", "u_preamt as t_preamt", "t_avaramt", "u_credittypeid"}).finish().filter("u_credittypeid!=null");
        DataSet creditDetailDS = orgCreditTypeDS.join(mixShareDS, JoinType.LEFT).on("creditlimitid", "creditlimitid").on("orgid", "orgid").on("credittypeid", "m_credittypeid").select(new String[]{"creditlimitid", "hcredittypeid", "currencyid", "currency", "orgid", "bankid", "bank", "credittypeid", "creditypename", "startdate", "enddate", "case when m_creditamt is null or  t_creditamt < m_creditamt then t_creditamt else m_creditamt end as totalamt", "t_useamt as useamt", "t_preamt as preuseamt", "case when m_avaramt is null or  t_avaramt  < m_avaramt  then t_avaramt  else m_avaramt end as  avaramt"}).finish();
        if (!isFinorg) {
            creditDetailDS = CreditReportFilterParamHelper.convertOrgName(creditDetailDS, "bankid", "bank", bankType);
        }
        logger.info("queryCreditDataSet end.");
        return creditDetailDS;
    }

    private DataSet queryMixCreditDataSet(QFilter filter) {
        QFilter mixQF = new QFilter("entry_mult.id", ">", (Object)0L);
        if (filter != null) {
            mixQF.and(filter);
        }
        DataSet mixDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)"id as creditlimitid,entry_mult.m_org.fbasedataid_id orgid, entry_mult.m_credittype.fbasedataid_id m_credittypeid, entry_mult.m_totalamt as m_creditamt,  entry_mult.m_useamt as m_useamt,  entry_mult.m_preamt m_preamt, entry_mult.m_avaramt as m_avaramt", (QFilter[])mixQF.toArray(), (String)null);
        mixDS = mixDS.groupBy(new String[]{"creditlimitid", "orgid", "m_credittypeid"}).min("m_creditamt", "m_creditamt").min("m_avaramt", "m_avaramt").finish();
        return mixDS;
    }

    private DataSet queryCreditOrgDataSet(QFilter filter, List<Long> qFilterOrgIds, boolean isFinorg) {
        String baseFields = isFinorg ? CREDITLIMIT_HEAD_PROPS : CREDITLIMIT_HEAD_INNER;
        QFilter downShareQF = new QFilter("orgsharetype", "=", (Object)"downshare");
        QFilter specQF = new QFilter("orgsharetype", "=", (Object)"appointshare");
        specQF.or(new QFilter("isgrouplimit", "=", (Object)Boolean.FALSE));
        if (filter != null) {
            downShareQF.and(filter);
            specQF.and(filter);
        }
        DataSet downshareDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)(baseFields + ",entry_org.id as entryid, entry_org.o_org.fbasedataid_id orgid, entry_org.pid as o_pid, case when entry_org.pid=0 then  entry_org.o_totalamt else entry_org.o_singleamt end as o_creditamt, entry_org.o_useamt as o_useamt, entry_org.o_preamt as o_preamt, entry_org.o_avaramt as o_avaramt"), (QFilter[])downShareQF.toArray(), null);
        boolean hasDownshareDS = false;
        if (!downshareDS.copy().isEmpty()) {
            hasDownshareDS = true;
            downshareDS = this.expandDownShareDS(downshareDS);
            DataSet qFilterOrgDS = this.buildOrgIdDS(qFilterOrgIds);
            downshareDS = downshareDS.join(qFilterOrgDS, JoinType.INNER).on("orgid", "orgid").select(new String[]{"creditlimitid", "horgid", "o_pid", "orgid", "orgsharetype", "entryid", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "o_avaramt"}).finish();
        }
        specQF.and(new QFilter("entry_org.o_org.fbasedataid_id", "in", qFilterOrgIds));
        DataSet specOrgDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)(baseFields + ",entry_org.id as entryid, entry_org.o_org.fbasedataid_id orgid, entry_org.pid as o_pid, case when entry_org.pid=0 then  entry_org.o_totalamt else entry_org.o_singleamt end as o_creditamt, entry_org.o_useamt as o_useamt, entry_org.o_preamt as o_preamt, entry_org.o_avaramt as o_avaramt"), (QFilter[])specQF.toArray(), null);
        DataSet specChildDS = specOrgDS.copy().filter("orgsharetype='appointshare' and o_pid>0").select(new String[]{"creditlimitid", "horgid", "o_pid", "orgid", "orgsharetype", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "o_avaramt"});
        String pids = ReportCommonHelper.getFielVals(specChildDS, "o_pid");
        DataSet specParentDS = specOrgDS.copy().filter("orgsharetype='appointshare' and o_pid=0").select(new String[]{"creditlimitid", "horgid", "o_pid", "orgid", "orgsharetype", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "entryid", "o_avaramt as p_avaramt"}).distinct();
        DataSet specifyShareDS = specChildDS.join(specParentDS).on("o_pid", "entryid").on("orgid", "orgid").select(new String[]{"creditlimitid", "horgid", "o_pid", "orgid", "orgsharetype", "entryid", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "case when o_avaramt>p_avaramt then p_avaramt else o_avaramt end as o_avaramt"}).finish();
        specParentDS = specParentDS.copy().select(new String[]{"creditlimitid", "horgid", "o_pid", "orgid", "orgsharetype", "entryid", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "p_avaramt as o_avaramt"});
        if (EmptyUtil.isNoEmpty((String)pids)) {
            specParentDS = specParentDS.copy().filter("entryid not in (" + pids + ")").select(new String[]{"creditlimitid", "horgid", "o_pid", "orgid", "orgsharetype", "entryid", "bankid", "startdate", "enddate", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "o_avaramt"});
        }
        specifyShareDS = specifyShareDS.union(specParentDS);
        if (hasDownshareDS) {
            return specifyShareDS.union(downshareDS);
        }
        return specifyShareDS;
    }

    private DataSet expandDownShareDS(DataSet downshareDS) {
        Iterator creditRow = downshareDS.copy().iterator();
        Algo algo = Algo.create((String)"");
        Field creditIdFD = new Field("creditlimitid", (DataType)DataType.LongType);
        Field orgIdFD = new Field("suborgid", (DataType)DataType.LongType);
        RowMeta orgRowMeta = new RowMeta(new Field[]{creditIdFD, orgIdFD});
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(orgRowMeta);
        while (creditRow.hasNext()) {
            Row credit = (Row)creditRow.next();
            Long orgId = credit.getLong("orgid");
            ArrayList<Long> orgList = new ArrayList<Long>(1);
            orgList.add(orgId);
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", orgList, (boolean)true);
            Long creditLimitId = credit.getLong("creditlimitid");
            this.buildCreditOrgIdDS(dataSetBuilder, creditLimitId, subOrgIds);
        }
        DataSet fullOrgDS = dataSetBuilder.build();
        downshareDS = downshareDS.join(fullOrgDS, JoinType.INNER).on("creditlimitid", "creditlimitid").select(new String[]{"creditlimitid", "horgid", "o_pid", "suborgid as orgid", "orgsharetype", "bankid", "startdate", "enddate", "entryid", "bank", "hcredittypeid", "hcredittypename", "currencyid", "currency", "o_creditamt", "o_useamt", "o_preamt", "o_avaramt"}).finish();
        return downshareDS;
    }

    private void buildCreditOrgIdDS(DataSetBuilder dataSetBuilder, Long creditLimitId, List<Long> orgIds) {
        for (Long orgId : orgIds) {
            Object[] rowObj = new Object[]{creditLimitId, orgId};
            dataSetBuilder.append(rowObj);
        }
    }

    private DataSet buildOrgIdDS(List<Long> orgIds) {
        Algo algo = Algo.create((String)"");
        Field orgIdFD = new Field("orgid", (DataType)DataType.LongType);
        RowMeta orgRowMeta = new RowMeta(new Field[]{orgIdFD});
        DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(orgRowMeta);
        for (Long orgId : orgIds) {
            Object[] rowObj = new Object[]{orgId};
            dataSetBuilder.append(rowObj);
        }
        return dataSetBuilder.build();
    }

    private DataSet queryCreditTypeDataSet(QFilter filter) {
        DataSet creditLimitDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_creditlimit", (String)"id as creditlimitid, credittype.id as h_credittypeid, credittype.iscomprehensive as h_iscomprehensive, totalamt h_totalamt, useamt as h_useamt, preuseamt as h_preuseamt, avaramt as h_avaramt, entry_type.id as t_entryid, entry_type.pid as t_pid, entry_type.t_credittype.fbasedataid_id credittypeid,case when  entry_type.pid=0 then entry_type.t_totalamt else entry_type.t_singleamt end as t_creditamt, entry_type.t_useamt as t_useamt, entry_type.t_preamt as t_preamt, entry_type.t_avaramt as t_avaramt", (QFilter[])filter.toArray(), null);
        DataSet credittypeDS = QueryServiceHelper.queryDataSet((String)"CreditLimit", (String)"cfm_credittype", (String)"id as credittypeid, name as cretypename, iscomprehensive", null, null).union(CreditReportFilterParamHelper.createTypeEmptyDataSet());
        creditLimitDS = creditLimitDS.join(credittypeDS, JoinType.LEFT).on("credittypeid", "credittypeid").select(new String[]{"creditlimitid", "h_credittypeid", "h_iscomprehensive", "h_totalamt", "h_useamt", "h_preuseamt", "h_avaramt", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt", "credittypeid", "cretypename creditypename"}).finish();
        DataSet comprehCreditDS = creditLimitDS.copy();
        DataSet comprehNoSpecifyShareDS = comprehCreditDS.copy().filter("t_entryid=0").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "h_totalamt as t_creditamt", "h_useamt as t_useamt", "h_preuseamt as t_preamt", "h_avaramt as t_avaramt", "creditypename"});
        boolean ctypeFlag = false;
        HashSet<Long> creditTypeIds = new HashSet<Long>();
        DataSet creditTypeAllDs = credittypeDS.copy();
        for (Row row : comprehNoSpecifyShareDS.copy()) {
            Long ctypeid = row.getLong("h_credittypeid");
            if (creditTypeIds.contains(ctypeid)) continue;
            creditTypeIds.add(ctypeid);
            if (creditTypeIds.size() == 1) {
                creditTypeAllDs = credittypeDS.addField("" + ctypeid + "", "h_credittypeid");
                ctypeFlag = true;
                continue;
            }
            DataSet credittypeDsTemp = credittypeDS.addField("" + ctypeid + "", "h_credittypeid");
            creditTypeAllDs = creditTypeAllDs.union(credittypeDsTemp);
        }
        comprehNoSpecifyShareDS = ctypeFlag ? comprehNoSpecifyShareDS.join(creditTypeAllDs).on("h_credittypeid", "h_credittypeid").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt", "cretypename creditypename", "credittypeid"}).finish() : comprehNoSpecifyShareDS.addNullField("credittypeid");
        DataSet comprehSpecifyShareDS = comprehCreditDS.copy().filter("t_entryid>0").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt", "credittypeid", "creditypename"});
        DataSet parentDS = comprehSpecifyShareDS.copy().filter("t_pid=0").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "t_avaramt as p_avaramt", "credittypeid", "creditypename"}).distinct();
        DataSet childDS = comprehSpecifyShareDS.copy().filter("t_pid>0");
        comprehSpecifyShareDS = childDS.leftJoin(parentDS).on("t_pid", "t_entryid").on("credittypeid", "credittypeid").select(new String[]{"creditlimitid", "h_credittypeid", "t_entryid", "t_pid", "t_creditamt", "t_useamt", "t_preamt", "case when t_avaramt < p_avaramt then t_avaramt else p_avaramt end as t_avaramt", "creditypename", "credittypeid"}).finish();
        String pids = ReportCommonHelper.getFielVals(childDS, "t_pid");
        parentDS = EmptyUtil.isNoEmpty((String)pids) ? parentDS.filter("t_entryid not in ( " + pids + " )").select(PARENT_FIELD) : parentDS.select(PARENT_FIELD);
        return comprehNoSpecifyShareDS.union(comprehSpecifyShareDS).union(parentDS);
    }

    private DataSet queryCreditUse(QFilter qFilter) {
        QFilter creditUseqFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        creditUseqFilter.and(new QFilter("realamt", ">", (Object)BigDecimal.ZERO));
        if (qFilter != null) {
            creditUseqFilter.and(qFilter);
        }
        String props = "id,org.id u_orgid, creditlimit.id as u_creditlimitid,credittype.id u_credittypeid, case when amount >0 then amount - returnamt else 0 end as u_useamt, case when preamount>0 then preamount-returnamt else 0 end as u_preamt";
        DataSet creditUseDS = QueryServiceHelper.queryDataSet((String)"creditUse", (String)"cfm_credituse", (String)props, (QFilter[])creditUseqFilter.toArray(), null);
        creditUseDS = creditUseDS.groupBy(new String[]{"u_creditlimitid", "u_orgid", "u_credittypeid"}).sum("u_useamt").sum("u_preamt").finish();
        return creditUseDS;
    }

    protected String getCurrencyField() {
        return "currencyid";
    }

    protected List<String> orinalAmountField() {
        return Arrays.asList(GROUP_SUM_FIELDS);
    }

    public List<String> groupFields() {
        String statdim;
        ArrayList<String> groupFields = new ArrayList<String>(8);
        switch (statdim = (String)this.paramMap.get("statdim")) {
            case "bank": {
                groupFields.add("bank");
                groupFields.add("bankid");
                break;
            }
            case "companybank": {
                groupFields.add("company");
                groupFields.add("companyid");
                break;
            }
        }
        return groupFields;
    }

    public List<String> sumAmountFields() {
        return Arrays.asList(AMOUNT_SUM_FIELDS);
    }

    public String subNameField() {
        String statdim;
        String sumNameField = null;
        switch (statdim = (String)this.paramMap.get("statdim")) {
            case "bank": {
                sumNameField = "company";
                break;
            }
            case "companybank": {
                sumNameField = "bank";
                break;
            }
        }
        return sumNameField;
    }

    public String sumNameField() {
        String statdim;
        String sumNameField = null;
        switch (statdim = (String)this.paramMap.get("statdim")) {
            case "bank": {
                sumNameField = "bank";
                break;
            }
            case "companybank": {
                sumNameField = "company";
                break;
            }
        }
        return sumNameField;
    }

    private String[] resultOrderFields() {
        String[] orderBys = BANK_DIM_ORDRE_BYS;
        String statdim = (String)this.paramMap.get("statdim");
        if ("companybank".equals(statdim)) {
            orderBys = COMPANY_DIM_ORDRE_BYS;
        }
        return orderBys;
    }
}

