/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditAmountCheckFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit creditF7 = (BasedataEdit)this.getControl("filter_creditlimit");
        creditF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String prop = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (prop) {
            case "filter_creditlimit": {
                DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
                String bankType = (String)this.getModel().getValue("filter_banktype");
                DynamicObjectCollection banks = (DynamicObjectCollection)this.getModel().getValue("filter_bank");
                String creditProp = (String)this.getModel().getValue("filter_creditprop");
                QFilter filter = new QFilter("creditprop", "=", (Object)creditProp).and(new QFilter("isclose", "=", (Object)"0"));
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                    filter.and(new QFilter("org", "in", orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet())));
                }
                if (EmptyUtil.isNoEmpty((String)bankType)) {
                    Set bankTypes = Arrays.stream(bankType.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
                    filter.and(new QFilter("banktype", "in", bankTypes));
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)banks)) {
                    filter.and(new QFilter("bank", "in", banks.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet())));
                }
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
                formShowParameter.setCustomParam("selectF7", (Object)"1");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("filter_banktype".equals(key)) {
            String bankTypes = (String)this.getModel().getValue("filter_banktype");
            boolean isFinorg = EmptyUtil.isNoEmpty((String)bankTypes) && bankTypes.contains("bd_finorginfo");
            this.getView().setVisible(Boolean.valueOf(isFinorg), new String[]{"filter_bank"});
            if (!isFinorg) {
                this.getModel().setValue("filter_bank", null);
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        this.initReportField(queryParam);
    }

    private void initReportField(ReportQueryParam queryParam) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<AbstractReportColumn> removeCol = new ArrayList<AbstractReportColumn>();
        String way = (String)this.getModel().getValue("filter_way");
        boolean isBiz = "biz".equals(way);
        for (AbstractReportColumn column : columns) {
            String columnName = "";
            columnName = column instanceof ReportColumnGroup ? ((ReportColumnGroup)column).getFieldKey() : ((ReportColumn)column).getFieldKey();
            if (isBiz && ("ouseamt".equals(columnName) || "tuseamt".equals(columnName))) {
                removeCol.add(column);
                continue;
            }
            if (isBiz) continue;
            if ("bizamt".equals(columnName) || "billgroup".equals(columnName)) {
                removeCol.add(column);
                continue;
            }
            if (!"limitgroup".equals(columnName)) continue;
            List childrens = ((ReportColumnGroup)column).getChildren();
            List orgFields = childrens.stream().filter(o -> "org".equals(((ReportColumn)o).getFieldKey())).collect(Collectors.toList());
            childrens.removeAll(orgFields);
        }
        columns.removeAll(removeCol);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName = evt.getFieldName()) {
            case "number": {
                this.showCreditlimit(rowData);
                break;
            }
            case "detailsumamt": {
                this.showCreditUseDetails(rowData);
                break;
            }
            case "ispass": {
                this.showDiffResult(rowData);
            }
        }
        if (fieldName != null && fieldName.startsWith("cm_")) {
            this.showBizBills(rowData, fieldName);
        }
    }

    private void showDiffResult(DynamicObject rowData) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("creditm_compare_result");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("number", (Object)rowData.getString("number"));
        parameter.setCustomParam("filter_way", this.getModel().getValue("filter_way"));
        parameter.setCustomParam("filter_creditprop", this.getModel().getValue("filter_creditprop"));
        this.getView().showForm(parameter);
    }

    private void showBizBills(DynamicObject rowData, String fieldName) {
        String number = rowData.getString("number");
        Map<String, ICreditBizStrategy> strategyMap = ReportCommonHelper.getStrategyMap();
        HashMap<String, String> bizTypeMap = new HashMap<String, String>(strategyMap.size());
        for (Map.Entry<String, ICreditBizStrategy> strategy : strategyMap.entrySet()) {
            int code = strategy.getKey().hashCode();
            if (code < 0) {
                code = -1 * code;
            }
            bizTypeMap.put("cm_" + code, strategy.getKey());
        }
        String bizType = (String)bizTypeMap.get(fieldName);
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            ICreditBizStrategy strategy = strategyMap.get(bizType);
            HashSet<Long> limitIds = new HashSet<Long>();
            this.getCreditlimit(number, null, limitIds);
            QFilter qfilter = strategy.getQfilter(limitIds);
            if ("ifm_loanbill".equals(bizType)) {
                qfilter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            } else if ("cim_invest_loanbill".equals(bizType)) {
                qfilter.and(new QFilter("loantype", "in", (Object)new String[]{"entrust", "ec"})).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())).and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
            }
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
            if ("cfm_loancontractbill".equals(bizType)) {
                qfilter.and(new QFilter("loantype", "in", (Object)new String[]{"loan", "sl"}).or(new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"}).and(statusFilter))).and(new QFilter("datasource", "=", (Object)"cfm"));
            } else if ("cim_invest_contract".equals(bizType)) {
                qfilter.and(new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"})).and(new QFilter("datasource", "=", (Object)"invest")).and(statusFilter);
            }
            DynamicObjectCollection bills = QueryServiceHelper.query((String)bizType, (String)"id", (QFilter[])new QFilter[]{qfilter});
            for (DynamicObject bill : bills) {
                parameter.addLinkQueryPkId((Object)bill.getLong("id"));
            }
        } else {
            DynamicObjectCollection creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"id", (QFilter[])new QFilter[]{new QFilter("creditlimit.number", "=", (Object)number), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("sourcetype", "not in", strategyMap.keySet())});
            for (DynamicObject bill : creditUses) {
                parameter.addLinkQueryPkId((Object)bill.getLong("id"));
            }
            bizType = "cfm_credituse";
        }
        parameter.setBillFormId(bizType);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private DynamicObject getCreditlimit(String number, Set<Long> ids, Set<Long> limitIds) {
        DynamicObject limit;
        QFilter filter = new QFilter("number", "=", (Object)number);
        if (ids != null && ids.size() > 0) {
            filter = new QFilter("id", "in", ids);
        }
        if ((limit = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_creditlimit", (String)"id,number,sourcebillids,ismergenew", (QFilter[])new QFilter[]{filter})) != null) {
            limitIds.add(limit.getLong("id"));
            DynamicObjectCollection sourcebillIds = limit.getDynamicObjectCollection("sourcebillids");
            if (limit.getBoolean("ismergenew") && EmptyUtil.isNoEmpty((DynamicObjectCollection)sourcebillIds)) {
                this.getCreditlimit(null, sourcebillIds.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()), limitIds);
            }
        }
        return limit;
    }

    private void showCreditUseDetails(DynamicObject rowData) {
        String number = rowData.getString("number");
        ListShowParameter parameter = new ListShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObjectCollection creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"id", (QFilter[])new QFilter[]{new QFilter("creditlimit.number", "=", (Object)number), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
        for (DynamicObject use : creditUses) {
            parameter.addLinkQueryPkId((Object)use.getLong("id"));
        }
        parameter.setBillFormId("cfm_credituse");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void showCreditlimit(DynamicObject rowData) {
        String number = rowData.getString("number");
        BaseShowParameter parameter = new BaseShowParameter();
        DynamicObjectCollection creditLimit = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditLimit)) {
            Long creditLimitID = ((DynamicObject)creditLimit.get(0)).getLong("id");
            parameter.setPkId((Object)creditLimitID);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId("cfm_creditlimit");
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CreditAmountDetailFormPlugin_0", (String)"tmc-creditm-report", (Object[])new Object[]{number}));
        }
    }
}

