/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.form;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.resource.CreditmReportResourceEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditAmountDetailFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit filterDate = (DateEdit)this.getView().getControl("filter_date");
        filterDate.setMaxDate(DateUtils.getCurrentDate());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_statcurrency", "filter_statdim", "filter_date"});
    }

    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
        param.getFilter().addFilterItem("fields", this.getAllFields());
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("statdim", (Object)statdim);
        this.initQueryColumn();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName = evt.getFieldName()) {
            case "number": {
                this.showCreditlimit(rowData);
            }
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("querydetail")) {
            Object currencyColls;
            Object companyColls;
            Object bankColls;
            this.getModel().setValue("filter_queryway", customParams.get("filter_queryway"));
            Object companyView = customParams.get("filter_orgview");
            this.getModel().setValue("filter_orgview", companyView);
            this.getModel().setValue("filter_banktype", customParams.get("filter_banktype"));
            this.getModel().setValue("filter_date", customParams.get("filter_date"));
            Object orgColls = customParams.get("filter_org");
            if (EmptyUtil.isNoEmpty(orgColls)) {
                this.getModel().setValue("filter_org", (Object)((JSONArray)orgColls).toArray());
            }
            if (EmptyUtil.isNoEmpty(bankColls = customParams.get("filter_bank"))) {
                this.getModel().setValue("filter_bank", (Object)((JSONArray)bankColls).toArray());
            }
            if (EmptyUtil.isNoEmpty(companyColls = customParams.get("filter_company"))) {
                this.getModel().setValue("filter_company", (Object)((JSONArray)companyColls).toArray());
            }
            if (EmptyUtil.isNoEmpty(currencyColls = customParams.get("filter_currency"))) {
                this.getModel().setValue("filter_currency", (Object)((JSONArray)currencyColls).toArray());
            }
            this.getModel().setValue("filter_isclose", customParams.get("filter_isclose"));
            this.getModel().setValue("filter_isframework", customParams.get("filter_isframework"));
            this.getModel().setValue("filter_statdim", customParams.get("filter_statdim"));
            this.getModel().setValue("filter_statcurrency", customParams.get("filter_statcurrency"));
            this.getModel().setValue("filter_currencyunit", customParams.get("filter_currencyunit"));
            ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
            rptFilter.search();
        }
    }

    public void showCreditlimit(DynamicObject rowData) {
        String number = rowData.getString("number");
        BaseShowParameter parameter = new BaseShowParameter();
        DynamicObjectCollection creditLimit = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditLimit)) {
            Long creditLimitID = ((DynamicObject)creditLimit.get(0)).getLong("id");
            parameter.setPkId((Object)creditLimitID);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            boolean isFrameWork = (Boolean)this.getModel().getValue("filter_isframework");
            parameter.setFormId(isFrameWork ? "creditm_limit_framework" : "cfm_creditlimit");
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CreditAmountDetailFormPlugin_0", (String)"tmc-creditm-report", (Object[])new Object[]{number}));
        }
    }

    private Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>(16);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        for (AbstractReportColumn column : columns) {
            fields.add(((ReportColumn)column).getFieldKey());
        }
        return fields;
    }

    private void initQueryColumn() {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(columns.size());
        ReportColumn companyColumn = null;
        ReportColumn bankColumn = null;
        ReportColumn currencyColumn = null;
        List<String> colums = Arrays.asList("useamt", "preuseamt", "avaramt", "avaramt_report", "useamt_report", "preuseamt_report");
        boolean isFrameWork = (Boolean)this.getModel().getValue("filter_isframework");
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)column;
            String fieldKey = reportColumn.getFieldKey();
            if ("org".equals(fieldKey)) {
                companyColumn = reportColumn;
            }
            if ("bank".equals(fieldKey)) {
                bankColumn = reportColumn;
            }
            if ("currency".equals(fieldKey)) {
                currencyColumn = reportColumn;
            }
            if (!isFrameWork || !colums.contains(fieldKey)) continue;
            column.setCaption(new LocaleString(CreditmReportResourceEnum.CreditAmountSumFormPlugin_0.loadKDString() + column.getCaption().getLocaleValue()));
        }
        if ("bank".equals(statdim)) {
            rebuildColumns.add(bankColumn);
            rebuildColumns.add(companyColumn);
        } else if ("org".equals(statdim)) {
            rebuildColumns.add(companyColumn);
            rebuildColumns.add(bankColumn);
        } else {
            rebuildColumns.add(currencyColumn);
        }
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }
}

