/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.form;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.creditm.report.resource.CreditmReportResourceEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditAmountSumFormPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DateEdit filterDate = (DateEdit)this.getView().getControl("filter_date");
        filterDate.setMaxDate(DateUtils.getCurrentDate());
        this.setFilterConditionByStatdim();
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"filter_statcurrency", "filter_statdim", "filter_date"});
    }

    public void beforeQuery(ReportQueryParam param) {
        super.beforeQuery(param);
        param.getFilter().addFilterItem("banklevel", this.getModel().getValue("banklevel"));
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("statdim", (Object)statdim);
        String statDim = (String)this.getModel().getValue("filter_statdim");
        LocaleString caption = new LocaleString(ResManager.loadKDString((String)"\u6388\u4fe1\u4e3b\u4f53", (String)"CreditAmountSumFormPlugin_0", (String)"tmc-creditm-report", (Object[])new Object[0]));
        if ("bank".equals(statDim)) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u6388\u4fe1\u673a\u6784", (String)"CreditAmountSumFormPlugin_1", (String)"tmc-creditm-report", (Object[])new Object[0]));
        } else if ("currency".equals(statDim)) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CreditAmountSumFormPlugin_2", (String)"tmc-creditm-report", (Object[])new Object[0]));
        }
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        Iterator iterator = columns.iterator();
        List<String> colums = Arrays.asList("useamt", "preuseamt", "avaramt", "avaramt_report", "useamt_report", "preuseamt_report");
        boolean isFrameWork = (Boolean)this.getModel().getValue("filter_isframework");
        while (iterator.hasNext()) {
            AbstractReportColumn column = (AbstractReportColumn)iterator.next();
            if (!(column instanceof ReportColumn)) continue;
            String fieldKey = ((ReportColumn)column).getFieldKey();
            if ("orgname".equals(fieldKey)) {
                column.setCaption(caption);
            }
            if (isFrameWork && colums.contains(fieldKey)) {
                column.setCaption(new LocaleString(CreditmReportResourceEnum.CreditAmountSumFormPlugin_0.loadKDString() + column.getCaption().getLocaleValue()));
            }
            if (!"currency".equals(statDim) || !"currency".equals(((ReportColumn)column).getFieldKey())) continue;
            ((ReportColumn)column).setHide(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("querydetail".equals(evt.getItemKey())) {
            DynamicObjectCollection currencys;
            DynamicObjectCollection bankOrgs;
            DynamicObjectCollection banks;
            boolean checkRes = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
            if (!checkRes) {
                return;
            }
            DynamicObject companyView = (DynamicObject)this.getModel().getValue("filter_orgview");
            ReportShowParameter param = new ReportShowParameter();
            param.getCustomParams().put("querydetail", true);
            param.getCustomParams().put("filter_queryway", this.getModel().getValue("filter_queryway"));
            param.getCustomParams().put("filter_orgview", EmptyUtil.isNoEmpty((DynamicObject)companyView) ? companyView.getPkValue() : null);
            param.getCustomParams().put("filter_banktype", this.getModel().getValue("filter_banktype"));
            param.getCustomParams().put("filter_date", this.getModel().getValue("filter_date"));
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs)) {
                Set orgIds = orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                param.getCustomParams().put("filter_org", orgIds);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(banks = (DynamicObjectCollection)this.getModel().getValue("filter_bank")))) {
                Set bankIds = banks.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                param.getCustomParams().put("filter_bank", bankIds);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(bankOrgs = (DynamicObjectCollection)this.getModel().getValue("filter_company")))) {
                Set bankOrgIds = bankOrgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                param.getCustomParams().put("filter_company", bankOrgIds);
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencys = (DynamicObjectCollection)this.getModel().getValue("filter_currency")))) {
                Set currencyIds = currencys.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                param.getCustomParams().put("filter_currency", currencyIds);
            }
            param.getCustomParams().put("filter_isclose", this.getModel().getValue("filter_isclose"));
            param.getCustomParams().put("filter_isframework", this.getModel().getValue("filter_isframework"));
            param.getCustomParams().put("filter_statdim", this.getModel().getValue("filter_statdim"));
            DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                param.getCustomParams().put("filter_statcurrency", currency.getPkValue());
            }
            param.getCustomParams().put("filter_currencyunit", this.getModel().getValue("filter_currencyunit"));
            param.setFormId("creditm_limitdetailrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "filter_statdim": {
                this.setFilterConditionByStatdim();
                break;
            }
        }
    }

    private void setFilterConditionByStatdim() {
        String statdim;
        switch (statdim = (String)this.getModel().getValue("filter_statdim")) {
            case "org": {
                this.getModel().setValue("filter_isshowsubtotal", (Object)true);
                this.getModel().setValue("filter_showttype", (Object)"step");
                break;
            }
            case "bank": 
            case "currency": {
                this.getModel().setValue("filter_isshowsubtotal", (Object)false);
                this.getModel().setValue("filter_showttype", (Object)"tile");
            }
        }
    }
}

