/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditDetailFormListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName = evt.getFieldName()) {
            case "number": {
                this.showCreditlimit(rowData);
                break;
            }
            case "u_sourcebillno": {
                this.showBill(rowData);
                break;
            }
        }
    }

    public void showCreditlimit(DynamicObject rowData) {
        String number = rowData.getString("number");
        if (EmptyUtil.isEmpty((String)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CreditDetailFormListPlugin_4", (String)"tmc-creditm-report", (Object[])new Object[0]));
            return;
        }
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        DynamicObjectCollection creditLimit = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        Long creditLimitID = ((DynamicObject)creditLimit.get(0)).getLong("id");
        parameter.setPkId((Object)creditLimitID);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("cfm_creditlimit");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void showBill(DynamicObject rowData) {
        DynamicObjectCollection bills;
        String sourcebillno = rowData.getString("u_sourcebillno");
        if (EmptyUtil.isEmpty((String)sourcebillno)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CreditDetailFormListPlugin_4", (String)"tmc-creditm-report", (Object[])new Object[0]));
            return;
        }
        DynamicObject creditUse = BusinessDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"sourcetype", (QFilter[])new QFilter("sourcebillno", "=", (Object)sourcebillno).toArray());
        String entity = creditUse.getString("sourcetype");
        StringBuilder fields = new StringBuilder();
        fields.append("id,billno");
        if (entity.equals("cfm_loanbill") || entity.equals("cfm_loancontractbill")) {
            fields.append(",loantype");
        }
        if ((bills = QueryServiceHelper.query((String)entity, (String)fields.toString(), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)sourcebillno)})).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"CreditDetailFormListPlugin_4", (String)"tmc-creditm-report", (Object[])new Object[0]));
            return;
        }
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        DynamicObject bill = (DynamicObject)bills.get(0);
        Long billId = bill.getLong("id");
        parameter.setPkId((Object)billId);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(this.getFormId(bill, entity));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getFormId(DynamicObject bill, String entity) {
        if (!entity.equals("cfm_loanbill") && !entity.equals("cfm_loancontractbill")) {
            return entity;
        }
        String loanType = bill.getString("loantype");
        boolean isLoandBill = entity.equals("cfm_loanbill");
        switch (loanType) {
            case "ec": 
            case "entrust": {
                entity = isLoandBill ? "cfm_loanbill_e_l" : "cfm_loancontract_ic_l";
                break;
            }
            case "loan": 
            case "sl": {
                entity = isLoandBill ? "cfm_loanbill_b_l" : "cfm_loancontract_bl_l";
                break;
            }
        }
        return entity;
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.initQueryParam();
    }

    private void initQueryParam() {
        String statdim;
        boolean isIncludeAllRelease;
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        FilterInfo filter = null;
        if (!EmptyUtil.isEmpty(customParams.get("filter"))) {
            filter = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("filter")));
        }
        if (null == filter) {
            return;
        }
        List filterItems = filter.getFilterItems();
        boolean isincludeclose = (Boolean)customParams.get("isincludeclose");
        if (isincludeclose) {
            this.getModel().setValue("filter_isincludeclose", (Object)isincludeclose);
        }
        if (isIncludeAllRelease = ((Boolean)customParams.get("isincludeallreleas")).booleanValue()) {
            this.getModel().setValue("filter_isincludeallreleas", (Object)isIncludeAllRelease);
        }
        if ((statdim = (String)customParams.get("statdim")).equals("companybank")) {
            this.getModel().setValue("filter_statdim", (Object)statdim);
        }
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            if ("filter_queryway".equals(propName)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{ReportOrgQueryWayEnum.ORG.getValue().equals(value) ? "filter_orgview" : "filter_org"});
            }
            if ((propName.equals("startdateranges") || propName.equals("enddateranges")) && null != value) {
                String controlName = propName.equals("startdateranges") ? "startdefinedate" : "";
                this.getView().setVisible(Boolean.valueOf(RptDateRangeEnum.CUSTOM.getValue().equals(value.toString())), new String[]{controlName});
            }
            if (propName.startsWith("startdateranges_") || propName.startsWith("enddateranges_")) {
                this.getModel().setValue(propName, value);
            }
            if (this.getView().getControl(propName) == null) continue;
            if (value instanceof ArrayList) {
                this.getModel().setValue(propName, (Object)((ArrayList)value).stream().toArray());
                continue;
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)propName, (Object)value);
        }
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    public void beforeQuery(ReportQueryParam param) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("statdim", (Object)statdim);
        param.getCustomParam().put("credittypeid", customParams.get("credittypeid"));
        param.getCustomParam().put("bankid", customParams.get("bankid"));
        boolean ispreuse = (Boolean)this.getModel().getValue("filter_ispreuse");
        param.getFilter().addFilterItem("ispreuse", (Object)ispreuse);
        DynamicObject creditlimitagree = (DynamicObject)this.getModel().getValue("creditlimitagree");
        if (creditlimitagree != null) {
            param.getFilter().addFilterItem("creditlimitagree.id", (Object)creditlimitagree.getLong("id"));
        }
        boolean isAllRelease = (Boolean)this.getModel().getValue("filter_isincludeallreleas");
        param.getFilter().addFilterItem("isincludeallreleas", (Object)isAllRelease);
        this.initQueryColumn(statdim, param);
        param.getCustomParam().put("appid", this.getView().getFormShowParameter().getAppId());
        super.beforeQuery(param);
    }

    public boolean verifyQuery(ReportQueryParam param) {
        return ReportCommonHelper.verifyQueryFilter(param);
    }

    private void reOrderColumn(String statdim, ReportColumnGroup group) {
        ReportColumn companyColumn = null;
        ReportColumn bankColumn = null;
        List children = group.getChildren();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(children.size());
        for (AbstractReportColumn column : children) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)column;
            if (reportColumn.getFieldKey().equals("orgid")) {
                companyColumn = reportColumn;
            }
            if (reportColumn.getFieldKey().equals("bank")) {
                bankColumn = reportColumn;
            }
            if (!reportColumn.getFieldKey().equals("preamt")) continue;
            boolean ispreuse = (Boolean)this.getModel().getValue("filter_ispreuse");
            reportColumn.setHide(!ispreuse);
        }
        if ("bank".equals(statdim)) {
            rebuildColumns.add(bankColumn);
            rebuildColumns.add(companyColumn);
        } else {
            rebuildColumns.add(companyColumn);
            rebuildColumns.add(bankColumn);
        }
        for (AbstractReportColumn column : children) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        children.clear();
        children.addAll(rebuildColumns);
    }

    private void initQueryColumn(String statdim, ReportQueryParam param) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        for (AbstractReportColumn column : columns) {
            ReportColumnGroup group;
            if (!(column instanceof ReportColumnGroup) || !"lineofcredit".equals((group = (ReportColumnGroup)column).getFieldKey())) continue;
            this.reOrderColumn(statdim, group);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ReportFilter rptFilter;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ((propName.equals("filter_statdim") || propName.equals("filter_ispreuse")) && !EmptyUtil.isEmpty((Object)(rptFilter = (ReportFilter)this.getControl("reportfilterap")))) {
            rptFilter.search();
        }
    }
}

