/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.resource.CreditmReportResourceEnum;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditSumFormListPlugin
extends AbstractReportFormPlugin {
    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.defaultCurrency();
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if ("homelink".equals(customParams.get("showtype"))) {
            this.getModel().setValue("filter_statcurrency", customParams.get("filter_currency"));
            this.getModel().setValue("filter_currencyunit", customParams.get("filter_currencyunit"));
        }
    }

    public void beforeQuery(ReportQueryParam param) {
        Object bankIds;
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if ("homelink".equals(customParams.get("showtype")) && !Boolean.TRUE.toString().equals(this.getView().getPageCache().get("fromHome"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_statcurrency", customParams.get("filter_statcurrency"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_currencyunit", customParams.get("filter_currencyunit"));
            FilterItemInfo orgItem = formShowParameter.getReportQueryParam().getFilter().getFilterItem("filter_org");
            this.getView().getPageCache().put("fromHome", Boolean.TRUE.toString());
            this.getModel().setValue("filter_queryway", (Object)ReportOrgQueryWayEnum.ORG.getValue());
            param.getFilter().addFilterItem("filter_queryway", (Object)ReportOrgQueryWayEnum.ORG.getValue());
            DynamicObjectCollection orgs = new DynamicObjectCollection();
            DynamicObject[] objs = TmcDataServiceHelper.load((Object[])new Object[]{orgItem.getValue()}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
            Arrays.stream(objs).forEach(v -> orgs.add(v));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"filter_org", (Object)orgs);
        }
        param.getFilter().addFilterItem("credittype", customParams.get("filter_credittype"));
        Map commFilters = null;
        if (!EmptyUtil.isEmpty(customParams.get("commFilters"))) {
            commFilters = (Map)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("commFilters")));
        }
        if (null != commFilters) {
            param.getFilter().setCommFilter(commFilters);
        }
        if (EmptyUtil.isNoEmpty(bankIds = customParams.get("filter_bank"))) {
            param.getFilter().addFilterItem("bank", bankIds);
        }
        String statdim = (String)this.getModel().getValue("filter_statdim");
        param.getFilter().addFilterItem("statdim", (Object)statdim);
        this.initQueryColumn(statdim);
        param.getCustomParam().put("appid", this.getView().getFormShowParameter().getAppId());
        super.beforeQuery(param);
    }

    private void initQueryColumn(String statdim) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        ArrayList<Object> rebuildColumns = new ArrayList<Object>(columns.size());
        ReportColumn companyColumn = null;
        ReportColumn bankColumn = null;
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)column;
            if (reportColumn.getFieldKey().equals("company")) {
                companyColumn = reportColumn;
            }
            if (!reportColumn.getFieldKey().equals("bank")) continue;
            bankColumn = reportColumn;
        }
        if ("bank".equals(statdim)) {
            rebuildColumns.add(bankColumn);
            rebuildColumns.add(companyColumn);
        } else {
            rebuildColumns.add(companyColumn);
            rebuildColumns.add(bankColumn);
        }
        for (AbstractReportColumn column : columns) {
            if (rebuildColumns.contains(column)) continue;
            rebuildColumns.add(column);
        }
        columns.clear();
        columns.addAll(rebuildColumns);
    }

    public boolean verifyQuery(ReportQueryParam param) {
        ReportCommonHelper.verifyQueryFilter(param);
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("filter_statcurrency"))) {
            this.getView().showTipNotification(CreditmReportResourceEnum.CreditSumFormListPlugin_0.loadKDString());
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "filter_statdim": {
                this.search();
                break;
            }
            case "filter_queryway": 
            case "filter_org": 
            case "filter_orgview": {
                this.defaultCurrency();
                break;
            }
        }
    }

    private void defaultCurrency() {
        DynamicObject baseCurrency;
        Long orgId = null;
        String queryWay = (String)this.getModel().getValue("filter_queryway");
        if (ReportOrgQueryWayEnum.ORG.getValue().equals(queryWay)) {
            DynamicObjectCollection companys = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)companys)) {
                orgId = ((DynamicObject)((DynamicObject)companys.get(0)).get("fbasedataid")).getLong("id");
            }
        } else {
            String orgRootId;
            DynamicObject orgView = (DynamicObject)this.getModel().getValue("filter_orgview");
            if (EmptyUtil.isNoEmpty((DynamicObject)orgView) && EmptyUtil.isNotBlank((CharSequence)(orgRootId = TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id"))))) {
                orgId = Long.valueOf(orgRootId);
            }
        }
        if (EmptyUtil.isNoEmpty(orgId) && EmptyUtil.isNoEmpty((DynamicObject)(baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)orgId)))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"filter_statcurrency", (Object)baseCurrency.getPkValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String opKey = evt.getOperateKey();
        if (opKey.equals("viewdetail") && evt.getOperationResult().isSuccess()) {
            List<String> resetList;
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            IReportListModel reportModel = reportList.getReportModel();
            int rowIdx = this.getView().getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowData = reportModel.getRowData(rowIdx);
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo queryFilter = queryParam.getFilter();
            FilterInfo toDetailFilter = new FilterInfo();
            boolean isincludeclose = (Boolean)this.getModel().getValue("filter_isincludeclose");
            String statdim = (String)this.getModel().getValue("filter_statdim");
            Integer sumlevel = (Integer)rowData.get("sumlevel");
            FilterItemInfo creditCurr = queryFilter.getFilterItem("credit_currency");
            if (creditCurr != null && creditCurr.getValue() != null) {
                DynamicObjectCollection currs = (DynamicObjectCollection)creditCurr.getValue();
                queryFilter.getFilterItems().remove(creditCurr);
                queryFilter.addFilterItem("credit_currency", (Object)currs.stream().map(o -> o.getLong("id")).toArray());
            }
            this.setFilterInfo(queryFilter, "filter_orgview");
            this.setFilterInfo(queryFilter, "filter_statcurrency");
            if (0 == sumlevel) {
                resetList = Arrays.asList("startdateranges", "startdateranges_startdate", "startdateranges_enddate", "filter_statcurrency", "enddateranges", "enddateranges_startdate", "enddateranges_enddate", "credit_currency", "filter_queryway", "filter_org", "filter_orgview");
                for (FilterItemInfo item : queryFilter.getFilterItems()) {
                    if (resetList.contains(item.getPropName())) continue;
                    toDetailFilter.getFilterItems().add(item);
                }
                Date startDate = rowData.getDate("startdate");
                Date endDate = rowData.getDate("enddate");
                toDetailFilter.addFilterItem("startdateranges", (Object)"custom");
                toDetailFilter.addFilterItem("startdateranges_startdate", (Object)startDate);
                toDetailFilter.addFilterItem("startdateranges_enddate", (Object)startDate);
                toDetailFilter.addFilterItem("enddateranges", (Object)"custom");
                toDetailFilter.addFilterItem("enddateranges_startdate", (Object)endDate);
                toDetailFilter.addFilterItem("enddateranges_enddate", (Object)endDate);
                DynamicObject currency = rowData.getDynamicObject("currencyid");
                toDetailFilter.addFilterItem("credit_currency", (Object)new Object[]{currency != null ? currency.getLong("id") : 0L});
                toDetailFilter.addFilterItem("filter_queryway", (Object)ReportOrgQueryWayEnum.ORG.getValue());
                Long companyid = rowData.getLong("companyid");
                toDetailFilter.addFilterItem("filter_org", (Object)new Object[]{companyid});
            }
            if (1 == sumlevel) {
                if ("companybank".equals(statdim)) {
                    resetList = Arrays.asList("filter_queryway", "filter_org", "filter_orgview");
                    toDetailFilter.addFilterItem("filter_queryway", (Object)ReportOrgQueryWayEnum.ORG.getValue());
                    Long companyid = rowData.getLong("companyid");
                    toDetailFilter.addFilterItem("filter_org", (Object)new Object[]{companyid});
                    for (FilterItemInfo item : queryFilter.getFilterItems()) {
                        if (resetList.contains(item.getPropName())) continue;
                        toDetailFilter.getFilterItems().add(item);
                    }
                }
                if ("bank".equals(statdim)) {
                    toDetailFilter = queryFilter;
                }
            }
            if (2 == sumlevel) {
                toDetailFilter = queryFilter;
            }
            for (FilterItemInfo item : toDetailFilter.getFilterItems()) {
                if (!"filter_isshowsubtotal".equals(item.getPropName()) && !"filter_isshowtotal".equals(item.getPropName())) continue;
                item.setValue((Object)Boolean.FALSE);
            }
            ReportShowParameter param = new ReportShowParameter();
            param.getCustomParams().put("isincludeclose", isincludeclose);
            param.getCustomParams().put("isincludeallreleas", false);
            param.getCustomParams().put("statdim", statdim);
            String creditId = rowData.getString("credittypeid");
            param.getCustomParams().put("credittypeid", creditId);
            param.getCustomParams().put("bankid", rowData.getString("bankid"));
            param.getCustomParams().put("filter", SerializationUtils.serializeToBase64((Object)toDetailFilter));
            param.setFormId("cfm_creditdetailrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void setFilterInfo(FilterInfo queryFilter, String column) {
        FilterItemInfo item = queryFilter.getFilterItem(column);
        if (item != null && item.getValue() != null) {
            DynamicObject value = (DynamicObject)item.getValue();
            queryFilter.getFilterItems().remove(item);
            queryFilter.addFilterItem(column, (Object)(value != null ? value.getLong("id") : 0L));
        }
    }

    private void search() {
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }
}

