/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.CreditStrategyContext;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.creditm.report.resource.CreditmReportResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class CreditlimitCompareResultForm
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getCheckResult();
    }

    private void getCheckResult() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String limitNumber = (String)customParams.get("number");
        String way = (String)customParams.get("filter_way");
        boolean isBiz = "biz".equals(way);
        this.getView().setVisible(Boolean.valueOf(isBiz), new String[]{"limitfex"});
        this.getView().setVisible(Boolean.valueOf(!isBiz), new String[]{"sharefex"});
        if (isBiz) {
            DynamicObject limit = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_creditlimit", (String)"id,currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)limitNumber)});
            this.getModel().setValue("creditcurrency", limit.getDynamicObject("currency").getPkValue());
            this.getModel().setValue("limit", limit.getPkValue());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"credituseamtupdate"});
            DataSet creditUseDs = this.getCreditUse(limit.getLong("id"));
            creditUseDs = creditUseDs.updateField("sourcebillid", "case when type='scf_findebtsbill' then sid+sourcebillid else sourcebillid end");
            HashSet<Long> creditIds = new HashSet<Long>(8);
            creditIds.add(limit.getLong("id"));
            String creditProp = customParams.getOrDefault("filter_creditprop", CreditPropEnum.CIRCLE.getValue());
            DataSet bizBillCreditAmtDs = this.getBizBillCreditAmtDs(creditIds, creditProp);
            creditUseDs = creditUseDs.fullJoin(bizBillCreditAmtDs).on("sourcebillid", "id").select(creditUseDs.getRowMeta().getFieldNames(), new String[]{"billno", "sourcetype biztype", "currency bizcurrency", "bizamt"}).finish().updateField("creditrate", "case when creditrate=null or creditrate=0 then 1 else creditrate end").updateField("creditratio", "case when creditratio=null or creditratio=0 then 100 else creditratio end").addField("bizamt*creditrate*creditratio/100", "creditmamount").addField("(case when creditmamount=null then 0 else creditmamount end)-(case when realamt=null then 0 else realamt end)", "diffamount").orderBy(new String[]{"sourcetype"});
            boolean isMatch = (Boolean)this.getModel().getValue("ismatch");
            if (isMatch) {
                creditUseDs = creditUseDs.filter("realamt!=creditmamount");
            }
            this.setDetailEntry(creditUseDs);
        } else {
            this.getOrgAmtDs(limitNumber);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        OperationResult result;
        DynamicObject limit;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("credituseamtupdate".equals(itemKey) && EmptyUtil.isNoEmpty((DynamicObject)(limit = (DynamicObject)this.getModel().getValue("limit"))) && (result = TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])new Object[]{limit.getPkValue()}, (OperateOption)OperateOption.create())) != null && result.isSuccess()) {
            this.getView().showSuccessNotification(CreditmReportResourceEnum.CreditlimitCompareResultForm_0.loadKDString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("ismatch".equals(name)) {
            this.getCheckResult();
        }
    }

    private void getOrgAmtDs(String limitNumber) {
        DynamicObject limit = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_creditlimit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)limitNumber)});
        DynamicObjectCollection orgEntry = limit.getDynamicObjectCollection("entry_org");
        IDataModel model = this.getModel();
        model.setValue("creditcurrency", limit.getDynamicObject("currency").getPkValue());
        model.setValue("limit", limit.getPkValue());
        model.deleteEntryData("entryentity_org");
        model.deleteEntryData("entryentity_type");
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("orgentry_org", new Object[0]);
        vs.addField("orgentry_amount", new Object[0]);
        Set orgPids = orgEntry.parallelStream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("pid"))).map(o -> o.getLong("pid")).collect(Collectors.toSet());
        for (DynamicObject entry : orgEntry) {
            DynamicObjectCollection orgs = entry.getDynamicObjectCollection("o_org");
            if (orgs == null || orgs.size() != 1 || orgPids.contains(entry.getLong("id"))) continue;
            vs.addRow(new Object[]{((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getPkValue(), entry.getBigDecimal("o_useamt").add(entry.getBigDecimal("o_preamt"))});
        }
        DynamicObjectCollection typeEntry = limit.getDynamicObjectCollection("entry_type");
        TableValueSetter vsType = new TableValueSetter(new String[0]);
        vsType.addField("typeentry_type", new Object[0]);
        vsType.addField("typeentry_amount", new Object[0]);
        Set typePids = typeEntry.parallelStream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("pid"))).map(o -> o.getLong("pid")).collect(Collectors.toSet());
        for (DynamicObject entry : typeEntry) {
            DynamicObjectCollection types = entry.getDynamicObjectCollection("t_credittype");
            if (types == null || types.size() != 1 || typePids.contains(entry.getLong("id"))) continue;
            vsType.addRow(new Object[]{((DynamicObject)types.get(0)).getDynamicObject("fbasedataid").getPkValue(), entry.getBigDecimal("t_useamt").add(entry.getBigDecimal("t_preamt"))});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity_org", vs);
        dataModel.batchCreateNewEntryRow("entryentity_type", vsType);
        dataModel.endInit();
        this.getView().updateView("entryentity_org");
        this.getView().updateView("entryentity_type");
    }

    private DataSet getBizBillCreditAmtDs(Set<Long> creditIds, String creditProp) {
        CreditStrategyContext context = new CreditStrategyContext();
        Set<String> billTypes = ReportCommonHelper.getStrategyMap().keySet();
        DataSet bizCreditAmountDs = null;
        HashMap<Long, Long> mergeMap = new HashMap<Long, Long>();
        ReportCommonHelper.getCreditIdMergeMap(creditIds, mergeMap, creditIds);
        boolean isCircle = CreditPropEnum.CIRCLE.getValue().equals(creditProp);
        for (String type : billTypes) {
            ICreditBizStrategy strategy = context.getStrategy(type);
            if (strategy == null) continue;
            DataSet bizAmountDs = strategy.getBizAmountDs(creditIds, type, isCircle).addField("'" + type + "'", "sourcetype");
            bizCreditAmountDs = bizCreditAmountDs == null ? bizAmountDs : bizCreditAmountDs.union(bizAmountDs);
        }
        if (bizCreditAmountDs == null) {
            return ReportCommonHelper.createEmptyDataSet();
        }
        DataSet suretyReturnDs = ReportCommonHelper.getSuretyReturnDs(bizCreditAmountDs);
        bizCreditAmountDs = bizCreditAmountDs.copy().leftJoin(suretyReturnDs).on("id", "sourcebillid").select(bizCreditAmountDs.getRowMeta().getFieldNames(), new String[]{"eamount"}).finish().updateField("bizamt", "bizamt-(case when eamount!=null then eamount else 0 end)");
        return bizCreditAmountDs;
    }

    private void setDetailEntry(DataSet creditUses) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("limitsourcebillno", new Object[0]);
        vs.addField("limitsourcetype", new Object[0]);
        vs.addField("limitsourceid", new Object[0]);
        vs.addField("creditratio", new Object[0]);
        vs.addField("creditrate", new Object[0]);
        vs.addField("limitcurrency", new Object[0]);
        vs.addField("useamount", new Object[0]);
        vs.addField("preamount", new Object[0]);
        vs.addField("returnamt", new Object[0]);
        vs.addField("realamt", new Object[0]);
        vs.addField("isrelease", new Object[0]);
        vs.addField("sourcebillno", new Object[0]);
        vs.addField("sourcetype", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("amount", new Object[0]);
        vs.addField("creditmamount", new Object[0]);
        vs.addField("diffamount", new Object[0]);
        for (Row use : creditUses) {
            vs.addRow(new Object[]{use.getString("sourcebillno"), use.getString("sourcetype"), use.getString("sourcebillid"), use.get("creditratio"), use.get("creditrate"), use.getLong("currency"), use.getBigDecimal("amount"), use.getBigDecimal("preamount"), use.getBigDecimal("returnamt"), use.getBigDecimal("realamt"), use.getBoolean("isrelease"), use.getString("billno"), use.getString("biztype"), use.get("bizcurrency"), use.getBigDecimal("bizamt"), use.getBigDecimal("creditmamount"), use.getBigDecimal("diffamount")});
        }
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity");
    }

    private DataSet getCreditUse(Long limitId) {
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"getCreditUse_check", (String)"cfm_credituse", (String)"id,currency,sourcebillno,sourcetype type,sourcename sourcetype,sourcebillentryid sourcebillid,sourcebillid sid,amount,preamount,returnamt,realamt,creditrate,creditratio,isrelease,modifytime", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)limitId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())}, null);
        if (creditUseDs.copy().isEmpty()) {
            return creditUseDs;
        }
        DataSet sourcebillIdDs = creditUseDs.copy().groupBy(new String[]{"sourcebillid"}).count("srcid").finish().filter("srcid>1");
        if (sourcebillIdDs.isEmpty()) {
            return creditUseDs;
        }
        DataSet mutlDs = creditUseDs.copy().leftJoin(sourcebillIdDs).on("sourcebillid", "sourcebillid").select(creditUseDs.getRowMeta().getFieldNames(), new String[]{"srcid"}).finish().filter("srcid!=null and realamt=0");
        Set<Long> removeIds = ReportCommonHelper.getDsIds(mutlDs, "id");
        if (removeIds.size() > 0) {
            return creditUseDs.filter("id not in (" + StringUtils.join(removeIds, (String)",") + ")");
        }
        return creditUseDs;
    }
}

