/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditFrameWorkHelper {
    public static DataSet getLimitDs(DataSet limitOrFrameWorkDs, boolean isFrameWork, String selFields) {
        Set<Long> frameWorkIds;
        Set limitIds;
        if (isFrameWork && !limitOrFrameWorkDs.isEmpty() && EmptyUtil.isNoEmpty((Object)(limitIds = CreditFrameworkHelper.getFrameWorkUse(frameWorkIds = ReportCommonHelper.getDsIds(limitOrFrameWorkDs, "id"), new HashSet(), (boolean)true)))) {
            QFilter limitFilter = new QFilter("id", "in", (Object)limitIds).and("isframework", "=", (Object)"0");
            limitOrFrameWorkDs = QueryServiceHelper.queryDataSet((String)"CreditAmountDetailDataListPluginFrame", (String)"cfm_creditlimit", (String)selFields, (QFilter[])new QFilter[]{limitFilter}, (String)"");
        }
        return limitOrFrameWorkDs;
    }

    public static DataSet getLimitFrameNotChildren(DataSet limitOrFrameWorkDatas, DataSet creditLimitDs, boolean isFrameWork) {
        if (limitOrFrameWorkDatas == null || limitOrFrameWorkDatas.isEmpty() || creditLimitDs == null || creditLimitDs.isEmpty()) {
            return creditLimitDs;
        }
        if (isFrameWork) {
            Set<Long> sframeWorkIds = ReportCommonHelper.getDsIds(limitOrFrameWorkDatas, "id");
            DataSet frameWorkDs = limitOrFrameWorkDatas.copy().filter("framework=0 or framework not in (" + sframeWorkIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")");
            DataSet chileFrameDs = limitOrFrameWorkDatas.filter("framework in (" + sframeWorkIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")");
            DataSet limitGroupFrame = creditLimitDs.groupBy(new String[]{"framework"}).sum("useamt").sum("preuseamt").finish();
            if (!chileFrameDs.isEmpty()) {
                HashMap<Long, Long> frameToLimitMap = new HashMap<Long, Long>(8);
                for (Row chileFrameD : chileFrameDs) {
                    frameToLimitMap.put(chileFrameD.getLong("id"), chileFrameD.getLong("framework"));
                }
                Set<Long> frameIds = ReportCommonHelper.getDsIds(frameWorkDs, "id");
                DataSet limitGroupFrameTemp = CreditFrameWorkHelper.getCreditLimitDs(limitGroupFrame.copy(), frameToLimitMap, frameIds);
                limitGroupFrame = limitGroupFrame.leftJoin(limitGroupFrameTemp).on("framework", "frameworkid").select(new String[]{"useamt", "preuseamt"}, new String[]{"case when limitid=null then framework else limitid end framework"}).finish();
                limitGroupFrame = limitGroupFrame.groupBy(new String[]{"framework"}).sum("useamt").sum("preuseamt").finish();
            }
            frameWorkDs = frameWorkDs.removeFields(new String[]{"useamt", "preuseamt", "avaramt"});
            creditLimitDs = frameWorkDs.leftJoin(limitGroupFrame).on("id", "framework").select(frameWorkDs.getRowMeta().getFieldNames(), new String[]{"useamt", "preuseamt"}).finish();
        }
        return creditLimitDs.updateField("useamt", "case when useamt is null then 0 else useamt end").updateField("preuseamt", "case when preuseamt is null then 0 else preuseamt end").addField("totalamt-useamt-preuseamt", "avaramt");
    }

    private static DataSet getCreditLimitDs(DataSet limitGroupFrameDs, Map<Long, Long> frameToLimitMap, Set<Long> frameIds) {
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field("frameworkid", (DataType)DataType.LongType));
        field.add(new Field("limitid", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"creditLimitds");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Row row : limitGroupFrameDs) {
            Long frameId = row.getLong("framework");
            Long firstFrameId = CreditFrameWorkHelper.getFirstFrameId(frameToLimitMap, frameIds, frameId);
            dsBuilder.append(new Object[]{frameId, firstFrameId});
        }
        return dsBuilder.build();
    }

    private static Long getFirstFrameId(Map<Long, Long> frameToLimitMap, Set<Long> frameIds, long sframeId) {
        Long frameId = frameToLimitMap.get(sframeId);
        if (EmptyUtil.isEmpty((Long)frameId)) {
            return frameId;
        }
        if (frameIds.contains(frameId)) {
            return frameId;
        }
        return CreditFrameWorkHelper.getFirstFrameId(frameToLimitMap, frameIds, frameId);
    }
}

