/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper;

import com.alibaba.fastjson.JSONArray;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditReportFilterParamHelper
extends AbstractReportFormPlugin {
    public static QFilter initCurrencyFilter(Map<String, Object> paramMap) {
        ArrayList<Long> CnyIist = new ArrayList<Long>();
        if (!EmptyUtil.isEmpty((Object)paramMap.get("credit_currency"))) {
            DynamicObjectCollection currencys = (DynamicObjectCollection)paramMap.get("credit_currency");
            for (DynamicObject currency : currencys) {
                CnyIist.add(currency.getLong("id"));
            }
        }
        QFilter ofilter = null;
        if (CnyIist.size() > 0) {
            ofilter = new QFilter("currency.id", "in", CnyIist);
        }
        return ofilter;
    }

    public static QFilter initCreditReportFilter(Map<String, Object> paramMap) {
        JSONArray arr;
        List credIds;
        Object credittype;
        Object endDate;
        Date startDate;
        Object bankIds;
        QFilter currencyFilter;
        Long creditlimitagreeid;
        String bankType = (String)paramMap.get("filter_banktype");
        QFilter filter = new QFilter("banktype", "=", (Object)bankType).and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("isframework", "=", (Object)"0"));
        boolean isincludeclose = (Boolean)paramMap.get("filter_isincludeclose");
        if (!isincludeclose) {
            filter = filter.and(new QFilter("isclose", "=", (Object)"0"));
        }
        if ((creditlimitagreeid = (Long)paramMap.get("creditlimitagree.id")) != null) {
            filter = filter.and(new QFilter("creditlimitagree.id", "=", (Object)creditlimitagreeid));
        }
        if ((currencyFilter = CreditReportFilterParamHelper.initCurrencyFilter(paramMap)) != null) {
            filter = filter.and(currencyFilter);
        }
        if (EmptyUtil.isNoEmpty((Object)(bankIds = paramMap.get("bank")))) {
            filter = filter.and("bank", "in", bankIds);
        }
        Timestamp currentTime = DateUtils.getCurrentTime();
        if (!EmptyUtil.isEmpty((Object)paramMap.get("startdateranges"))) {
            String startDateDate;
            switch (startDateDate = (String)paramMap.get("startdateranges")) {
                case "thismonth": {
                    filter.and(new QFilter("startdate", ">=", (Object)DateUtils.getMinMonthDate((Date)DateUtils.getCurrentDate())).and(new QFilter("startdate", "<=", (Object)DateUtils.getMaxMonthDate((Date)DateUtils.getCurrentDate()))));
                    break;
                }
                case "threemonth": {
                    filter.and(new QFilter("startdate", ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)3)).and(new QFilter("startdate", "<=", (Object)currentTime)));
                    break;
                }
                case "sixmonth": {
                    filter.and(new QFilter("startdate", ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)6)).and(new QFilter("startdate", "<=", (Object)currentTime)));
                    break;
                }
                case "oneyear": {
                    filter.and(new QFilter("startdate", ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)1)).and(new QFilter("startdate", "<=", (Object)currentTime)));
                    break;
                }
            }
        }
        if (RptDateRangeEnum.CUSTOM.getValue().equals(paramMap.get("startdateranges")) && !EmptyUtil.isEmpty((Object)paramMap.get("startdateranges_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get("startdateranges_enddate"))) {
            startDate = (Date)paramMap.get("startdateranges_startdate");
            endDate = (Date)paramMap.get("startdateranges_enddate");
            filter.and(new QFilter("startdate", ">=", (Object)startDate).and(new QFilter("startdate", "<=", endDate)));
        }
        if (!EmptyUtil.isEmpty((Object)paramMap.get("enddateranges"))) {
            String endDateDate = (String)paramMap.get("enddateranges");
            switch (endDateDate) {
                case "thismonth": {
                    filter.and(new QFilter("enddate", ">=", (Object)DateUtils.getMinMonthDate((Date)new Date())).and(new QFilter("enddate", "<=", (Object)DateUtils.getMaxMonthDate((Date)new Date()))));
                    break;
                }
                case "threemonth": {
                    filter.and(new QFilter("enddate", ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)3)).and(new QFilter("enddate", "<=", (Object)currentTime)));
                    break;
                }
                case "sixmonth": {
                    filter.and(new QFilter("enddate", ">=", (Object)DateUtils.getLastMonth((Date)currentTime, (int)6)).and(new QFilter("enddate", "<=", (Object)currentTime)));
                    break;
                }
                case "oneyear": {
                    filter.and(new QFilter("enddate", ">=", (Object)DateUtils.getLastYear((Date)currentTime, (int)1)).and(new QFilter("enddate", "<=", (Object)currentTime)));
                    break;
                }
            }
        }
        if (RptDateRangeEnum.CUSTOM.getValue().equals(paramMap.get("enddateranges")) && !EmptyUtil.isEmpty((Object)paramMap.get("enddateranges_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get("enddateranges_enddate"))) {
            startDate = (Date)paramMap.get("enddateranges_startdate");
            endDate = (Date)paramMap.get("enddateranges_enddate");
            filter.and(new QFilter("enddate", ">=", (Object)startDate).and(new QFilter("enddate", "<=", endDate)));
        }
        if (Objects.nonNull(credittype = paramMap.get("credittype")) && credittype instanceof JSONArray && CollectionUtils.isNotEmpty(credIds = (arr = (JSONArray)credittype).stream().map(t -> (Long)t).collect(Collectors.toList()))) {
            filter = filter.and(new QFilter("entry_type.t_credittype.fbasedataid", "in", credIds));
        }
        return filter;
    }

    public static DataSet convertOrgName(DataSet creditDetailDS, String prop, String field, String creditType) {
        String entityName = "bos_org";
        if ("bd_bizpartner".equals(creditType)) {
            entityName = "bd_bizpartner";
        }
        Set<Long> bankid = ReportCommonHelper.getDsIds(creditDetailDS, prop);
        DataSet orgDs = QueryServiceHelper.queryDataSet((String)"convertOrgName", (String)entityName, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", bankid)}, null);
        String[] fieldNames = creditDetailDS.getRowMeta().getFieldNames();
        return creditDetailDS.leftJoin(orgDs).on(prop, "id").select(fieldNames, new String[]{"name"}).finish().updateField(field, "name").select(fieldNames);
    }

    public static DataSet createTypeEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new String[]{"credittypeid", "cretypename", "iscomprehensive"}, new DataType[]{DataType.LongType, DataType.StringType, DataType.BooleanType});
        DataSetBuilder buildDs = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta);
        buildDs.append(new Object[]{0L, "", 0});
        DataSet emptyDataSet = buildDs.build();
        return emptyDataSet;
    }
}

