/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.report.helper.bizStrategy.BdimBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.CdmBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.CfmApplyBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.CfmContractBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.CfmInvestLoandBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.CfmLoandBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.CreditmBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.GmApplyBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.GmLettBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.LcApplyBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.LcLettBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.ScfdebBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.ScffincBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.TmforexBillCreditBizStrategy;
import kd.tmc.creditm.report.helper.bizStrategy.TmforexSwapsBillCreditBizStrategy;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.enums.RptDateRangeEnum;
import kd.tmc.fbp.common.errorcode.RptQingErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang.StringUtils;

public class ReportCommonHelper
extends AbstractReportFormPlugin {
    public static Map<String, Object> transQueryParam(ReportQueryParam param) {
        int size = param.getFilter().getFilterItems().size();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(size);
        for (FilterItemInfo filterItem : param.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        return paramMap;
    }

    public static boolean verifyQueryFilter(ReportQueryParam param) {
        TmcBizException tmcBizException = new TmcBizException(new RptQingErrorCode().DEFINEDATE_NULL());
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("ranges") || !RptDateRangeEnum.CUSTOM.getValue().equals(entry.getValue()) || !EmptyUtil.isEmpty((Object)paramMap.get(key + "_startdate")) && !EmptyUtil.isEmpty((Object)paramMap.get(key + "_enddate"))) continue;
            throw tmcBizException;
        }
        return true;
    }

    public static DataSet createEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
        DataSet emptyDataSet = Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        return emptyDataSet;
    }

    public static String getFielVals(DataSet specChildDS, String field) {
        StringBuilder str = new StringBuilder();
        for (Row ite : specChildDS.copy()) {
            str.append(ite.getLong(field)).append(",");
        }
        if (EmptyUtil.isEmpty((CharSequence)str)) {
            return "";
        }
        return str.toString().substring(0, str.length() - 1);
    }

    public static DataSet getBdFinorgInfo(Set<Long> bankIds, String parentField) {
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)"getBdFinorgInfo", (String)"bd_finorginfo", (String)("id bankid,name bankname," + parentField + " typeid"), (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)}, null);
        return finOrgDs;
    }

    public static Map<Long, String> getFinorgInfoMap(long[] finIds, String entityName) {
        Map finOrgs = TmcDataServiceHelper.loadFromCache((String)entityName, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)finIds)});
        HashMap<Long, String> finOrgInfoMap = new HashMap<Long, String>(finOrgs.size());
        for (Map.Entry entry : finOrgs.entrySet()) {
            finOrgInfoMap.put(Long.parseLong(entry.getKey().toString()), ((DynamicObject)entry.getValue()).getString("name"));
        }
        return finOrgInfoMap;
    }

    public static DataSet getBdFinorgTypeInfo(Set<Long> bankTypeIds) {
        DataSet bankSets = QueryServiceHelper.queryDataSet((String)"getBdFinorgInfo", (String)"bd_bankcgsetting", (String)"id typeid,name typename", (QFilter[])new QFilter[]{new QFilter("id", "in", bankTypeIds)}, null);
        return bankSets;
    }

    public static Set<Long> getDsIds(DataSet ds, String prop) {
        HashSet<Long> ids = new HashSet<Long>();
        Iterator ites = ds.copy().iterator();
        while (ites.hasNext()) {
            ids.add(((Row)ites.next()).getLong(prop));
        }
        return ids;
    }

    public static QFilter getBankFilter(Map<String, Object> paramMap, QFilter filter) {
        DynamicObjectCollection currencys;
        String bankType = (String)paramMap.get("filter_banktype");
        String bankField = "filter_bizpartner";
        if (CreditFinTypeEnum.FINORG.getValue().equals(bankType)) {
            bankField = "filter_bank";
        } else if (CreditFinTypeEnum.ORG.getValue().equals(bankType)) {
            bankField = "filter_company";
        }
        DynamicObjectCollection banks = (DynamicObjectCollection)paramMap.get(bankField);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)banks)) {
            Set bankIds = banks.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            filter.and("bank", "in", bankIds);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencys = (DynamicObjectCollection)paramMap.get("filter_currency")))) {
            Set currencyIds = currencys.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            filter.and(new QFilter("currency", "in", currencyIds));
        }
        return filter;
    }

    public static DataSet getCreditUseAndReturnDs(DataSet ds, Date date) {
        if (ds.isEmpty()) {
            return null;
        }
        Set<Long> dsIds = ReportCommonHelper.getDsIds(ds, "id");
        Date endDate = DateUtils.getDataFormat((Date)date, (boolean)false);
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"getCreditUseAndReturnDs_use", (String)"cfm_credituse", (String)"creditlimit,case when amount>0 then realamt else 0 end amount, case when preamount>0 then realamt else 0 end preamount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", dsIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("createtime", ">", (Object)endDate), new QFilter("isrelease", "=", (Object)"0"), new QFilter("realamt", ">", (Object)BigDecimal.ZERO)}, null);
        DataSet creditUseReturnDs = QueryServiceHelper.queryDataSet((String)"getCreditUseAndReturnDs_return", (String)"cfm_credituse", (String)"creditlimit,case when amount>0 then 0-returnentry.e_amount else 0 end amount, case when preamount>0 then 0-returnentry.e_amount else 0 end preamount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", dsIds), new QFilter("creditlimit.creditprop", "=", (Object)CreditPropEnum.CIRCLE.getValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("createtime", "<=", (Object)endDate), new QFilter("isrelease", "=", (Object)"0"), new QFilter("returnentry.e_returntime", ">", (Object)endDate)}, null);
        DataSet useDs = creditUseDs.union(creditUseReturnDs);
        return useDs.groupBy(new String[]{"creditlimit"}).sum("amount", "tamount").sum("preamount", "tpreamount").finish();
    }

    public static DataSet getBizCreditDs(DataSet billDs, DataSet limitUseDs, DataSet mergeDs, String billType) {
        if (billDs.copy().isEmpty()) {
            return billDs.select(new String[]{"creditlimit", "'" + billType + "' biztype", "bizamt"});
        }
        if (!mergeDs.copy().isEmpty()) {
            billDs = billDs.leftJoin(mergeDs.copy()).on("creditlimit", "sid").select(billDs.getRowMeta().getFieldNames(), new String[]{"sid", "tid"}).finish().updateField("creditlimit", "case when tid!=null then tid else creditlimit end");
        }
        DataSet billCreditDs = billDs.leftJoin(limitUseDs).on("id", "sourcebillid").on("creditlimit", "creditlimit").select(new String[]{"creditlimit", "id", "bizamt"}, new String[]{"creditrate", "creditratio"}).finish();
        billCreditDs = billCreditDs.updateField("creditrate", "case when creditrate=null then 1 else creditrate end").updateField("creditratio", "case when creditratio=null then 100 else creditratio end").updateField("bizamt", "bizamt*creditrate*creditratio/100").addField("'" + billType + "'", "biztype");
        DataSet suretyReturnDs = ReportCommonHelper.getSuretyReturnDs(billDs);
        if (suretyReturnDs != null && !suretyReturnDs.isEmpty()) {
            billCreditDs = billCreditDs.leftJoin(suretyReturnDs).on("id", "sourcebillid").select(billCreditDs.getRowMeta().getFieldNames(), new String[]{"eamount"}).finish().updateField("bizamt", "bizamt-(case when eamount!=null then eamount else 0 end)");
        }
        billCreditDs = billCreditDs.groupBy(new String[]{"creditlimit", "biztype"}).sum("bizamt").finish();
        return billCreditDs;
    }

    public static DataSet getCurencyAmtprecisionDs(Set<Long> limitIds) {
        return QueryServiceHelper.queryDataSet((String)"getCurencyAmtprecisionDs", (String)"cfm_creditlimit", (String)"id, currency.amtprecision cion", (QFilter[])new QFilter[]{new QFilter("id", "in", limitIds)}, null);
    }

    public static DataSet getSuretyReturnDs(DataSet billDs) {
        Set<Long> billIds = ReportCommonHelper.getDsIds(billDs, "id");
        Set<Long> creditLimitIds = ReportCommonHelper.getDsIds(billDs, "creditlimit");
        DataSet suretyReturnDs = QueryServiceHelper.queryDataSet((String)"getSuretyReturnDs", (String)"cfm_credituse", (String)"sourcebillid,returnentry.e_amount eamount", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds), new QFilter("creditlimit", "in", creditLimitIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("returnentry.e_billtype", "in", (Object)new String[]{"fbd_surety_append", "fbd_suretybill"})}, null);
        return suretyReturnDs.groupBy(new String[]{"sourcebillid"}).sum("eamount").finish();
    }

    public static Map<String, ICreditBizStrategy> getStrategyMap() {
        HashMap<String, ICreditBizStrategy> strategyMap = new HashMap<String, ICreditBizStrategy>(8);
        strategyMap.put("cfm_loanbill", new CfmLoandBillCreditBizStrategy());
        strategyMap.put("cim_invest_loanbill", new CfmInvestLoandBillCreditBizStrategy());
        strategyMap.put("ifm_loanbill", new CfmInvestLoandBillCreditBizStrategy());
        strategyMap.put("cfm_use_credit", new CreditmBillCreditBizStrategy());
        strategyMap.put("lc_lettercredit", new LcLettBillCreditBizStrategy());
        strategyMap.put("cfm_loan_apply", new CfmApplyBillCreditBizStrategy());
        strategyMap.put("cfm_loancontractbill", new CfmContractBillCreditBizStrategy());
        strategyMap.put("cim_invest_contract", new CfmContractBillCreditBizStrategy());
        strategyMap.put("gm_letterofguarantee", new GmLettBillCreditBizStrategy());
        strategyMap.put("gm_letterofguaapply", new GmApplyBillCreditBizStrategy());
        strategyMap.put("cdm_payablebill", new CdmBillCreditBizStrategy());
        strategyMap.put("cfm_loanbill_bond", new BdimBillCreditBizStrategy());
        strategyMap.put("lc_bizapply", new LcApplyBillCreditBizStrategy());
        strategyMap.put("tm_forex", new TmforexBillCreditBizStrategy());
        strategyMap.put("tm_forex_options", new TmforexBillCreditBizStrategy());
        strategyMap.put("tm_forex_forward", new TmforexBillCreditBizStrategy());
        strategyMap.put("tm_forex_swaps", new TmforexSwapsBillCreditBizStrategy());
        strategyMap.put("scf_fincreditbill", new ScffincBillCreditBizStrategy());
        strategyMap.put("scf_findebtsbill", new ScfdebBillCreditBizStrategy());
        return strategyMap;
    }

    public static QFilter getProductType(String billType) {
        QFilter filter = new QFilter("bill", "=", (Object)billType);
        DynamicObject tradeset = TmcDataServiceHelper.loadSingleFromCache((String)"tbd_tradeset", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)tradeset)) {
            DynamicObject tradetype = tradeset.getDynamicObject("tradetype");
            return tradetype != null ? new QFilter("protecttype", "=", (Object)tradetype.getLong("id")) : null;
        }
        return null;
    }

    public static DataSet getTmBusinessbillDs(Set<Long> tmIds) {
        DataSet businessDs = QueryServiceHelper.queryDataSet((String)"getTmBusinessbillDs", (String)"tm_businessbill", (String)"id,tradebill,bizamt1 amt", (QFilter[])new QFilter[]{new QFilter("tradebill", "in", tmIds), new QFilter("billstatus", "not in", (Object)new String[]{"A", "B"})}, null);
        return businessDs.groupBy(new String[]{"tradebill"}).sum("amt").finish();
    }

    public static DataSet getMergeDs(Map<Long, Long> mergeMap) {
        ArrayList<Field> field = new ArrayList<Field>(8);
        field.add(new Field("sid", (DataType)DataType.LongType));
        field.add(new Field("tid", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"getMergeDs");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry<Long, Long> merge : mergeMap.entrySet()) {
            Object[] obj = new Object[]{merge.getKey(), merge.getValue()};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    public static void getCreditIdMergeMap(Set<Long> creditAllIds, Map<Long, Long> mergeMap, Set<Long> creditIds) {
        if (creditIds == null || creditIds.size() == 0) {
            return;
        }
        String sql = "select fid,fbasedataid from t_cfm_creditlimit_merge where fid in (" + StringUtils.join(creditIds, (String)",") + ")";
        DataSet creditSourceDs = DB.queryDataSet((String)"getCreditIds_merge", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
        if (creditSourceDs.isEmpty()) {
            return;
        }
        boolean isFirst = mergeMap.size() == 0;
        for (Row ds : creditSourceDs.copy()) {
            if (isFirst) {
                mergeMap.put(ds.getLong("fbasedataid"), ds.getLong("fid"));
                continue;
            }
            mergeMap.put(ds.getLong("fbasedataid"), mergeMap.get(ds.getLong("fid")));
        }
        Set<Long> sid = ReportCommonHelper.getDsIds(creditSourceDs, "fbasedataid");
        creditAllIds.addAll(sid);
        ReportCommonHelper.getCreditIdMergeMap(creditAllIds, mergeMap, sid);
    }
}

