/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;

public class BdimBillCreditBizStrategy
implements ICreditBizStrategy {
    private static final String selCircleSql = "billno,currency,investor_entry.id id,investor_entry.e_creditlimit creditlimit,investor_entry.e_investamount bizamt,drawamount,repayamount";
    private static final String selFixSql = "billno,currency,investor_entry.id id,investor_entry.e_creditlimit creditlimit,investor_entry.e_investamount bizamt,drawamount,0 repayamount";

    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet billDs = this.getBizAmountDs(creditIds, billType, isCircle);
        return ReportCommonHelper.getBizCreditDs(billDs, limitUseDs, mergeDs, billType);
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_bdim", (String)billType, (String)(isCircle ? selCircleSql : selFixSql), (QFilter[])new QFilter[]{this.getQfilter(creditIds)}, null);
        return billDs.updateField("bizamt", "bizamt*(1-repayamount/drawamount)").select(new String[]{"id", "billno", "currency", "creditlimit", "bizamt"});
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter filter = new QFilter("investor_entry.e_creditlimit", "in", creditIds).and(new QFilter("loantype", "=", (Object)"bond"));
        return filter;
    }
}

