/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class CfmApplyBillCreditBizStrategy
implements ICreditBizStrategy {
    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet bizAmountDs = this.getBizAmountDs(creditIds, billType, isCircle);
        return ReportCommonHelper.getBizCreditDs(bizAmountDs, limitUseDs, mergeDs, billType);
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet applyDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_cfmapply", (String)billType, (String)"id,billno,currency,creditlimit,amount bizamt", (QFilter[])new QFilter[]{this.getQfilter(creditIds)}, null);
        if (applyDs.copy().isEmpty()) {
            return applyDs;
        }
        Set<Long> billIds = ReportCommonHelper.getDsIds(applyDs, "id");
        QFilter filter = new QFilter("loanapply", "in", billIds);
        filter.and(new QFilter("creditlimit", "!=", (Object)0).or(new QFilter("ishandend", "=", (Object)"1")));
        QFilter loanTypeFilter = new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"}).and("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        QFilter slLoanTypeFilter = new QFilter("loantype", "in", (Object)new String[]{"loan", "sl"});
        filter.and(loanTypeFilter.or(slLoanTypeFilter));
        DataSet loanCreditConDs = QueryServiceHelper.queryDataSet((String)"loanCreditConDs", (String)"cfm_loancontractbill", (String)"id,loanapply", (QFilter[])new QFilter[]{filter}, null);
        applyDs = applyDs.leftJoin(loanCreditConDs).on("id", "loanapply").select(applyDs.getRowMeta().getFieldNames(), new String[]{"loanapply"}).finish().updateField("bizamt", "case when loanapply=null then bizamt else 0 end").select(applyDs.getRowMeta().getFieldNames());
        DataSet applyContractDs = this.getApplyContractDs(applyDs.copy());
        if (applyContractDs != null && !applyContractDs.isEmpty()) {
            applyDs = applyDs.leftJoin(applyContractDs).on("id", "loanapply").select(new String[]{"id", "billno", "currency", "creditlimit", "bizamt-(case when drawamount=null then 0 else drawamount end) bizamt"}).finish();
        }
        return applyDs;
    }

    private DataSet getApplyContractDs(DataSet applyDs) {
        Set<Long> billIds = ReportCommonHelper.getDsIds(applyDs, "id");
        QFilter filter = new QFilter("loanapply", "in", billIds).and(new QFilter("creditlimit", "=", (Object)0)).and(new QFilter("ishandend", "=", (Object)"0"));
        DataSet loanConDs = QueryServiceHelper.queryDataSet((String)"getApplyContractDs_con", (String)"cfm_loancontractbill", (String)"id,loanapply", (QFilter[])new QFilter[]{filter}, null);
        if (loanConDs.isEmpty()) {
            return null;
        }
        Set<Long> conIds = ReportCommonHelper.getDsIds(loanConDs, "id");
        QFilter loanFilter = new QFilter("loancontractbill", "in", conIds).and(new QFilter("drawtype", "!=", (Object)"bitback")).and(new QFilter("creditlimit", "!=", (Object)0));
        QFilter loanTypeFilter = new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"}).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
        QFilter sloanTypeFilter = new QFilter("loantype", "in", (Object)new String[]{"loan", "sl"});
        DataSet loanDs = QueryServiceHelper.queryDataSet((String)"getApplyContractDs_loan", (String)"cfm_loanbill", (String)"convertdrawamt,loancontractbill", (QFilter[])new QFilter[]{loanFilter.and(loanTypeFilter.or(sloanTypeFilter))}, null);
        if (loanDs.isEmpty()) {
            return null;
        }
        DataSet loanConCreditDs = loanDs.groupBy(new String[]{"loancontractbill"}).sum("convertdrawamt").finish();
        return loanConDs.leftJoin(loanConCreditDs).on("id", "loancontractbill").select(new String[]{"loanapply", "convertdrawamt drawamount"}).finish().groupBy(new String[]{"loanapply"}).sum("drawamount").finish();
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter filter = new QFilter("creditlimit", "in", creditIds).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
        return filter;
    }
}

