/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class CfmContractBillCreditBizStrategy
implements ICreditBizStrategy {
    private static final String selCircleSql = "id,billno,currency,creditlimit,case when iscycleloan='0' then amount-repayamount else amount end bizamt";
    private static final String selFixSql = "id,billno,currency,creditlimit,amount bizamt";
    private static final String slSelCircleSql = "banksyndicate_entry.id id,billno,currency,banksyndicate_entry.e_creditlimit creditlimit,banksyndicate_entry.e_shareamount bizamt,amount,case when iscycleloan='0' then repayamount else 0 end repayamount";
    private static final String slSelFixSql = "banksyndicate_entry.id id,billno,currency,banksyndicate_entry.e_creditlimit creditlimit,banksyndicate_entry.e_shareamount bizamt,amount,0 repayamount";

    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet contractDs = this.getBizAmountDs(creditIds, billType, isCircle);
        return ReportCommonHelper.getBizCreditDs(contractDs, limitUseDs, mergeDs, billType);
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet contractDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_contract", (String)billType, (String)(isCircle ? selCircleSql : selFixSql), (QFilter[])new QFilter[]{this.getQfilter(creditIds, billType, false)}, null);
        DataSet contractSlDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_contract_sl", (String)billType, (String)(isCircle ? slSelCircleSql : slSelFixSql), (QFilter[])new QFilter[]{this.getQfilter(creditIds, billType, true)}, null);
        if (!contractSlDs.copy().isEmpty()) {
            contractSlDs = contractSlDs.updateField("bizamt", "bizamt*(1-repayamount/amount)");
        }
        return contractDs.union(contractSlDs.select(new String[]{"id", "billno", "currency", "creditlimit", "bizamt"}));
    }

    private QFilter getQfilter(Set<Long> creditIds, String type, boolean isSl) {
        QFilter filter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
        QFilter endFilter = new QFilter("ishandend", "=", (Object)"0");
        filter = "cfm_loancontractbill".equals(type) ? new QFilter("loantype", "in", (Object)new String[]{"loan", "sl"}).or(new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"}).and(filter)).and(new QFilter("datasource", "=", (Object)"cfm")) : filter.and(new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"})).and(new QFilter("datasource", "=", (Object)"invest"));
        if (isSl) {
            return endFilter.and(filter).and(new QFilter("banksyndicate_entry.e_creditlimit", "in", creditIds).and(new QFilter("loantype", "=", (Object)"sl")));
        }
        return endFilter.and(filter).and(new QFilter("creditlimit", "in", creditIds));
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter creditlimitFilter = new QFilter("ishandend", "=", (Object)"0").and(new QFilter("banksyndicate_entry.e_creditlimit", "in", creditIds).or(new QFilter("creditlimit", "in", creditIds)));
        return creditlimitFilter;
    }
}

