/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;

public class CfmInvestLoandBillCreditBizStrategy
implements ICreditBizStrategy {
    private static final String selCircleSql = "id,billno,currency,creditlimit,notrepayamount bizamt";
    private static final String selFixSql = "id,billno,currency,creditlimit,drawamount bizamt";

    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet billDs = this.getBizAmountDs(creditIds, billType, isCircle);
        DataSet bizCreditDs = ReportCommonHelper.getBizCreditDs(billDs, limitUseDs, mergeDs, billType);
        return bizCreditDs;
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_vlonad", (String)billType, (String)(isCircle ? selCircleSql : selFixSql), (QFilter[])new QFilter[]{this.getQfilter(creditIds, billType)}, null);
        return billDs;
    }

    private QFilter getQfilter(Set<Long> creditIds, String billType) {
        QFilter filter = new QFilter("creditlimit", "in", creditIds).and(new QFilter("lendernature", "=", (Object)"ingroup")).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
        if ("ifm_loanbill".equals(billType)) {
            filter.and(new QFilter("creditortype", "=", (Object)CreditorTypeEnum.SETTLECENTER.getValue()));
        } else {
            filter.and(new QFilter("loantype", "in", (Object)new String[]{"entrust", "ec"})).and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue())).and(new QFilter("datasource", "=", (Object)"invest"));
        }
        return filter;
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        return new QFilter("creditlimit", "in", creditIds).and(new QFilter("drawtype", "!=", (Object)"closeout")).and(new QFilter("lendernature", "=", (Object)"ingroup")).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
    }
}

