/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;

public class CfmLoandBillCreditBizStrategy
implements ICreditBizStrategy {
    private static final String selCircleSql = "id,billno,currency,creditlimit,notrepayamount bizamt";
    private static final String selFixSql = "id,billno,currency,creditlimit,drawamount bizamt";

    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet billDs = this.getBizAmountDs(creditIds, billType, isCircle);
        DataSet bizCreditDs = ReportCommonHelper.getBizCreditDs(billDs, limitUseDs, mergeDs, billType);
        return bizCreditDs;
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_lonad", (String)billType, (String)(isCircle ? selCircleSql : selFixSql), (QFilter[])new QFilter[]{this.getQfilter(creditIds)}, null);
        return billDs;
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter filter = new QFilter("creditlimit", "in", creditIds).and(new QFilter("loantype", "in", (Object)new String[]{"loan", "sl"}).or(new QFilter("loantype", "in", (Object)new String[]{"ec", "entrust"}).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue())))).and(new QFilter("drawtype", "!=", (Object)"closeout")).and(new QFilter("creditortype", "!=", (Object)CreditorTypeEnum.SETTLECENTER.getValue())).and(new QFilter("datasource", "!=", (Object)"invest"));
        return filter;
    }
}

