/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;

public class LcLettBillCreditBizStrategy
implements ICreditBizStrategy {
    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet billDs = this.getBizAmountDs(creditIds, billType, isCircle);
        return ReportCommonHelper.getBizCreditDs(billDs, limitUseDs, mergeDs, billType);
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_lett", (String)billType, (String)"id,billno,currency,creditlimit,amount*(1+amountscaleupper/100) bizamt", (QFilter[])new QFilter[]{this.getQfilter(creditIds)}, null);
        if (!isCircle) {
            return billDs;
        }
        DataSet arrivalPayDs = this.getArrivalPayDs(ReportCommonHelper.getDsIds(billDs, "id"));
        billDs = billDs.leftJoin(arrivalPayDs).on("id", "lettercredit").select(new String[]{"id", "billno", "currency", "creditlimit", "bizamt-(case when doneamount=null then 0 else doneamount end) bizamt"}).finish();
        return billDs;
    }

    private DataSet getArrivalPayDs(Set<Long> lettIds) {
        DataSet arrivalBillDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_arriva", (String)"lc_arrival", (String)"lettercredit,doneamount", (QFilter[])new QFilter[]{new QFilter("lettercredit", "in", lettIds), new QFilter("doneamount", ">", (Object)BigDecimal.ZERO), new QFilter("arrivalstatus", "!=", (Object)"arrival_register")}, null);
        return arrivalBillDs.groupBy(new String[]{"lettercredit"}).sum("doneamount").finish();
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter filter = new QFilter("creditlimit", "in", creditIds).and(new QFilter("creditstatus", "not in", (Object)new String[]{"done_close", "done_repeal"}));
        return filter;
    }
}

