/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class ScfdebBillCreditBizStrategy
implements ICreditBizStrategy {
    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet billDs = this.getBizAmountDs(creditIds, billType, isCircle);
        limitUseDs = limitUseDs.updateField("sourcebillid", "sid+sourcebillid");
        return ReportCommonHelper.getBizCreditDs(billDs, limitUseDs, mergeDs, billType);
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_scf", (String)billType, (String)"id,billno,currency,creditlimit,amount bizamt", (QFilter[])new QFilter[]{this.getQfilter(creditIds)}, null).updateField("id", "id+1");
        HashSet<Long> limitIds = new HashSet<Long>();
        limitIds.addAll(creditIds);
        Set<Long> creditlimitIds = ReportCommonHelper.getDsIds(billDs, "creditlimit");
        limitIds.removeAll(creditlimitIds);
        if (limitIds.size() == 0) {
            return billDs;
        }
        DataSet billOrgDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_scforg", (String)billType, (String)"id+2 id,billno,currency,orgcreditlimit creditlimit,amount bizamt", (QFilter[])new QFilter[]{this.getQfilter(limitIds)}, null).updateField("id", "id+2");
        return billDs.union(billOrgDs).select(new String[]{"id", "billno", "currency", "creditlimit", "bizamt"});
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter filter = new QFilter("creditlimit", "in", creditIds).or(new QFilter("orgcreditlimit", "in", creditIds)).and(new QFilter("bizstatus", "not in", (Object)new String[]{"refunded", "yetrepay"})).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue()));
        return filter;
    }
}

