/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.report.helper.bizStrategy;

import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.report.helper.ReportCommonHelper;
import kd.tmc.creditm.report.helper.bizStrategy.ICreditBizStrategy;

public class TmforexSwapsBillCreditBizStrategy
implements ICreditBizStrategy {
    @Override
    public DataSet getBizCreditAmountDs(Set<Long> creditIds, DataSet limitUseDs, DataSet mergeDs, String billType, boolean isCircle) {
        DataSet billDs = this.getBizAmountDs(creditIds, billType, isCircle);
        return ReportCommonHelper.getBizCreditDs(billDs, limitUseDs, mergeDs, billType);
    }

    @Override
    public DataSet getBizAmountDs(Set<Long> creditIds, String billType, boolean isCircle) {
        QFilter productTypeFilter = ReportCommonHelper.getProductType(billType);
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"getBizAmountDs_tmswa", (String)billType, (String)"id,billno,billstatus,currency,credituse creditlimit,case when nearend='1' and farend='1' then amount*2 else amount end bizamt", (QFilter[])new QFilter[]{this.getQfilter(creditIds), productTypeFilter}, null);
        Set<Long> bussIds = ReportCommonHelper.getDsIds(billDs.copy().filter("billstatus='D'"), "id");
        if (bussIds.size() > 0) {
            DataSet tmBusinessbillDs = ReportCommonHelper.getTmBusinessbillDs(bussIds);
            billDs = billDs.leftJoin(tmBusinessbillDs).on("id", "tradebill").select(new String[]{"id", "billno", "currency", "creditlimit", "(bizamt-case when amt=null then 0 else amt end) bizamt"}).finish();
        } else {
            billDs = billDs.removeFields(new String[]{"billstatus"});
        }
        return billDs;
    }

    @Override
    public QFilter getQfilter(Set<Long> creditIds) {
        QFilter filter = new QFilter("credituse", "in", creditIds).and(new QFilter("nearend", "=", (Object)"1").or(new QFilter("farend", "=", (Object)"1"))).and(new QFilter("billstatus", "not in", (Object)new String[]{"A", "E"}));
        return filter;
    }
}

