/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.apply;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.FieldEdit;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.formplugin.helper.CreditlimitApplyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitApplyChangeEdit
extends AbstractBasePlugIn {
    public void afterCreateNewData(EventObject e) {
        this.createNewData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrgCaption();
        this.changeLock();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "applytype": {
                this.setOrgCaption();
                break;
            }
            case "creditlimit": {
                this.creditLimitChange();
                break;
            }
        }
    }

    private void createNewData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("limitid")) {
            return;
        }
        this.getModel().setValue("applytype", (Object)CreditmApplyTypeEnum.CHANGE.getValue());
        this.getModel().setValue("creditlimit", customParams.get("limitid"));
        this.creditLimitChange();
    }

    private void changeLock() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("limitid")) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"applytype", "org", "banktype", "bank", "currency", "creditlimit"});
    }

    private void setOrgCaption() {
        String applyType = (String)this.getModel().getValue("applytype");
        FieldEdit orgField = (FieldEdit)this.getView().getControl("org");
        FieldEdit totalAmtField = (FieldEdit)this.getView().getControl("totalamt");
        MainEntityType entityType = null;
        entityType = CreditmApplyTypeEnum.isAddChangeRenewal((String)applyType) ? EntityMetadataCache.getDataEntityType((String)"cfm_creditlimit") : EntityMetadataCache.getDataEntityType((String)"creditm_apply");
        if (entityType != null) {
            LocaleString capTion = ((IDataEntityProperty)entityType.getProperties().get((Object)"org")).getDisplayName();
            orgField.setCaption(capTion);
            totalAmtField.setCaption(((IDataEntityProperty)entityType.getProperties().get((Object)"totalamt")).getDisplayName());
            Map allFields = this.getModel().getDataEntityType().getAllFields();
            IDataEntityProperty propertys = (IDataEntityProperty)allFields.get("org");
            propertys.getDisplayName().setLocaleValue(capTion.getLocaleValue());
        }
    }

    private void creditLimitChange() {
        if (!this.isChangeFromLimit()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject limit = (DynamicObject)model.getValue("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String[])new String[]{"credittype", "contractno", "totalamt", "startdate", "enddate"});
            model.setValue("creditprop", (Object)CreditPropEnum.CIRCLE.getValue());
            model.setValue("isgrouplimit", (Object)false);
            model.setValue("isframework", (Object)false);
            model.setValue("framework", null);
            model.setValue("guaranteeorg", null);
            model.setValue("orgsharetype", (Object)OrgShareTypeEnum.APPOINTSHARE.getValue());
            model.deleteEntryData("entry_org");
            model.deleteEntryData("entry_type");
            model.deleteEntryData("entry_mult");
            return;
        }
        if (EmptyUtil.isEmpty((DynamicObject)(limit = TmcDataServiceHelper.loadSingle((Object)limit.getLong("id"), (String)"cfm_creditlimit")))) {
            return;
        }
        model.setValue("org", limit.get("org"));
        model.setValue("banktype", (Object)limit.getString("banktype"));
        model.setValue("bank", limit.get("bank"));
        model.setValue("currency", limit.get("currency"));
        model.setValue("totalamt", (Object)limit.getBigDecimal("totalamt"));
        CreditlimitApplyHelper.setLimitHeadVal(model, limit);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditlimit", (Object)limit.getLong("id"));
        boolean isGroup = (Boolean)this.getModel().getValue("isgrouplimit");
        this.getView().setVisible(Boolean.valueOf(isGroup), new String[]{"o_singleamt", "orgsharetype"});
        this.getView().setEnable(Boolean.valueOf(isGroup), new String[]{"entry_org"});
        this.setLimitOrgAndCreditTypeEntry(limit, "entry_org");
        CreditlimitApplyHelper.refeshOrderNum(model, this.getView(), "entry_org", "ordernumorg");
        this.setLimitOrgAndCreditTypeEntry(limit, "entry_type");
        CreditlimitApplyHelper.refeshOrderNum(model, this.getView(), "entry_type", "ordernumtype");
        this.setLimitMultEntry(limit);
    }

    private void setLimitMultEntry(DynamicObject limit) {
        DynamicObjectCollection multEntrys = limit.getDynamicObjectCollection("entry_mult");
        this.getModel().deleteEntryData("entry_mult");
        for (DynamicObject multEntry : multEntrys) {
            int newEntryRow = this.getModel().createNewEntryRow("entry_mult");
            DynamicObjectCollection colls = multEntry.getDynamicObjectCollection("m_org");
            this.getModel().setValue("m_org", (Object)CreditLimitHelper.getCollIds((DynamicObjectCollection)colls).toArray(), newEntryRow);
            this.getModel().setValue("m_credittype", multEntry.get("m_credittype"), newEntryRow);
            this.getModel().setValue("m_totalamt", multEntry.get("m_totalamt"), newEntryRow);
        }
    }

    private void setLimitOrgAndCreditTypeEntry(DynamicObject limit, String entryName) {
        DynamicObjectCollection entrys = limit.getDynamicObjectCollection(entryName);
        this.getModel().deleteEntryData(entryName);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        this.getModel().beginInit();
        List parentEntrys = entrys.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).collect(Collectors.toList());
        for (DynamicObject parentEntry : parentEntrys) {
            long pid = parentEntry.getLong("id");
            int parentIdx = this.getModel().createNewEntryRow(entryName);
            this.setDefaultEntry(parentEntry, parentIdx, "entry_org".equals(entryName));
            List entryDetails = entrys.stream().filter(o -> pid == o.getLong("pid")).collect(Collectors.toList());
            for (DynamicObject entryDetail : entryDetails) {
                int detailIdx = this.getModel().insertEntryRow(entryName, parentIdx);
                this.setDefaultEntry(entryDetail, detailIdx, "entry_org".equals(entryName));
            }
        }
        this.getModel().endInit();
        this.getView().updateView(entryName);
    }

    private void setDefaultEntry(DynamicObject entry, int idx, boolean isOrgEntry) {
        String orgFiled = isOrgEntry ? "o_org" : "t_credittype";
        DynamicObjectCollection orgColls = entry.getDynamicObjectCollection(orgFiled);
        this.getModel().setValue(orgFiled, (Object)orgColls, idx);
        String orgTextField = isOrgEntry ? "o_orgtext" : "t_credittypetext";
        this.getModel().setValue(orgTextField, (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)entry.getDynamicObjectCollection(orgFiled)), idx);
        String totalAmtField = isOrgEntry ? "o_totalamt" : "t_totalamt";
        this.getModel().setValue(totalAmtField, entry.get(totalAmtField), idx);
        String singleAmtField = isOrgEntry ? "o_singleamt" : "t_singleamt";
        this.getModel().setValue(singleAmtField, entry.get(singleAmtField), idx);
    }

    private boolean isChangeFromLimit() {
        String applyType = (String)this.getModel().getValue("applytype");
        return CreditmApplyTypeEnum.isChange((String)applyType);
    }
}

