/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.apply;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.formplugin.common.AbstracCreditmEdit;
import kd.tmc.creditm.formplugin.helper.CreditlimitApplyHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitApplyEdit
extends AbstracCreditmEdit
implements BeforeF7SelectListener,
TabSelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit guaranteeOrgF7 = (BasedataEdit)this.getControl("guaranteeorg");
        guaranteeOrgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit creditLimitF7 = (BasedataEdit)this.getControl("creditlimit");
        creditLimitF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        super.beforeF7Select(evt);
        switch (key = evt.getProperty().getName()) {
            case "guaranteeorg": {
                this.guaranteeOrgF7(evt);
                break;
            }
            case "creditlimit": {
                this.creditlimitF7(evt);
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String applyType = this.getPageCache().get("applytype");
        if (EmptyUtil.isNoEmpty((String)applyType)) {
            this.getModel().setValue("applytype", (Object)applyType);
        }
        this.registerMustInput();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"o_totalamt"});
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey = event.getTabKey();
        this.getView().setVisible(Boolean.TRUE, new String[]{"insertrow"});
        if ("tabentry_mult".equals(subTabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"insertrow"});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        super.propertyChanged(e);
        switch (prop = e.getProperty().getName()) {
            case "applytype": {
                this.setEmptyOrDefByType();
                break;
            }
            case "creditlimit": {
                this.changeCreditLImit();
                break;
            }
            case "bank": 
            case "currency": {
                this.getModel().setValue("creditlimit", null);
                break;
            }
            case "isframework": {
                boolean isFrame = (Boolean)this.getModel().getValue("isframework");
                if (!isFrame) break;
                this.getModel().setValue("isgrouplimit", (Object)true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (EmptyUtil.isNoEmpty((Object[])e.getRowDataEntities())) {
            String key = e.getEntryProp().getName();
            int insertRow = e.getRowDataEntities()[0].getRowIndex();
            String applyType = (String)this.getModel().getValue("applytype");
            if (CreditmApplyTypeEnum.isAddChange((String)applyType)) {
                if ("entry_org".equals(key)) {
                    this.setSingleAmt("entry_org", insertRow, "o_totalamt", "o_singleamt");
                }
                if ("entry_type".equals(key)) {
                    this.setSingleAmt("entry_type", insertRow, "t_totalamt", "t_singleamt");
                }
            }
        }
    }

    private void changeCreditLImit() {
        DynamicObject limit = (DynamicObject)this.getModel().getValue("creditlimit");
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entry_org");
        if (EmptyUtil.isNoEmpty((DynamicObject)limit)) {
            CreditlimitApplyHelper.setLimitHeadVal(this.getModel(), limit);
            this.controlEntry();
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"o_singleamt"});
            this.getView().updateView("fs_baseinfo");
        }
        this.getView().updateView("entry_org");
        this.getModel().endInit();
    }

    private void controlEntry() {
        String applyType = (String)this.getModel().getValue("applytype");
        if (CreditmApplyTypeEnum.isChange((String)applyType)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"entry_org"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"o_singleamt", "o_totalamt"});
        if (CreditmApplyTypeEnum.JOIN.getValue().equals(applyType)) {
            int newEntryRow = this.getModel().createNewEntryRow("entry_org");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"o_orgtext", (Object)org.getString("name"), (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"o_org", (Object)new Object[]{org.getPkValue()}, (int)newEntryRow);
            this.getView().setEnable(Boolean.valueOf(true), newEntryRow, new String[]{"o_totalamt"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"o_totalamt"});
            this.getView().updateView("entry_org");
        } else if (CreditmApplyTypeEnum.ADJUST.getValue().equals(applyType)) {
            Object pOrgColls;
            DynamicObject limit = (DynamicObject)this.getModel().getValue("creditlimit");
            limit = TmcDataServiceHelper.loadSingle((Object)limit.getPkValue(), (String)"cfm_creditlimit");
            DynamicObjectCollection orgEntrys = limit.getDynamicObjectCollection("entry_org");
            Iterator orgIters = orgEntrys.iterator();
            while (orgIters.hasNext()) {
                DynamicObject orgEntry = (DynamicObject)orgIters.next();
                DynamicObjectCollection orgColls = orgEntry.getDynamicObjectCollection("o_org");
                Set orgs = orgColls.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                if (orgs.contains(org.getPkValue())) continue;
                orgIters.remove();
            }
            DynamicObject pEntry = orgEntrys.stream().filter(o -> o.getBigDecimal("o_totalamt").compareTo(BigDecimal.ZERO) > 0).findFirst().orElse(null);
            if (EmptyUtil.isNoEmpty((DynamicObject)pEntry) && (pOrgColls = pEntry.getDynamicObjectCollection("o_org")).size() == 1) {
                int newEntryRow = this.getModel().createNewEntryRow("entry_org");
                DynamicObject dEntry = orgEntrys.stream().filter(o -> o.getBigDecimal("o_totalamt").compareTo(BigDecimal.ZERO) == 0).findFirst().orElse(pEntry);
                DynamicObjectCollection dOrgColls = dEntry.getDynamicObjectCollection("o_org");
                this.getModel().setValue("o_org", (Object)dOrgColls.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).toArray(), newEntryRow);
                this.getModel().setValue("o_orgtext", (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)dOrgColls), newEntryRow);
                this.getModel().setValue("o_oldsingleamt", (Object)dEntry.getBigDecimal("o_singleamt").add(dEntry.getBigDecimal("o_totalamt")), newEntryRow);
                this.getModel().setValue("o_totalamt", (Object)dEntry.getBigDecimal("o_singleamt").add(dEntry.getBigDecimal("o_totalamt")), newEntryRow);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"o_totalamt"});
                this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"o_orgtext"});
                this.getView().updateView("entry_org");
            }
            if (this.getModel().getEntryRowCount("entry_org") > 0) {
                return;
            }
            for (DynamicObject orgEntry : orgEntrys) {
                int parantIdx = 0;
                int rowIdx = 0;
                BigDecimal totalAmt = orgEntry.getBigDecimal("o_totalamt");
                if (EmptyUtil.isNoEmpty((BigDecimal)totalAmt)) {
                    rowIdx = parantIdx = this.getModel().createNewEntryRow("entry_org");
                    this.getView().setEnable(Boolean.valueOf(false), rowIdx, new String[]{"o_orgtext", "o_singleamt"});
                } else {
                    rowIdx = this.getModel().insertEntryRow("entry_org", parantIdx);
                }
                DynamicObjectCollection orgColls = orgEntry.getDynamicObjectCollection("o_org");
                this.getModel().setValue("o_org", (Object)orgColls.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).toArray(), rowIdx);
                this.getModel().setValue("o_orgtext", (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)orgColls), rowIdx);
                this.getModel().setValue("o_totalamt", (Object)totalAmt, rowIdx);
                this.getModel().setValue("o_oldsingleamt", (Object)orgEntry.getBigDecimal("o_singleamt"), rowIdx);
                this.getModel().setValue("o_singleamt", (Object)orgEntry.getBigDecimal("o_singleamt"), rowIdx);
                this.getView().setEnable(Boolean.valueOf(false), rowIdx, new String[]{"o_orgtext", "o_totalamt"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"o_totalamt", "o_singleamt"});
            }
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl("entry_org");
            treeEntry.expand(new int[]{0});
            this.getView().updateView("entry_org");
        }
    }

    @Override
    protected void refeshOrderNum(String entry, String orderNum) {
        CreditlimitApplyHelper.refeshOrderNum(this.getModel(), this.getView(), entry, orderNum);
    }

    @Override
    protected void checkSingelAmt(String entry, String totalField, String singleField, String useField, String preField, String avaField) {
        String type = (String)this.getModel().getValue("applytype");
        if (CreditmApplyTypeEnum.isAddChange((String)type)) {
            int parentIdx = this.getSelectMainRowIndex(entry);
            int currIdx = this.getSelectedRowIndex(entry);
            BigDecimal totalParenAmt = (BigDecimal)this.getModel().getValue(totalField, parentIdx);
            BigDecimal singleAmt = (BigDecimal)this.getModel().getValue(singleField, currIdx);
            if (singleAmt != null && totalParenAmt != null && singleAmt.compareTo(totalParenAmt) > 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)singleField, (Object)totalParenAmt, (int)currIdx);
            }
        }
    }

    private void setEmptyOrDefByType() {
        String applyType = (String)this.getModel().getValue("applytype");
        this.getModel().setValue("totalamt", (Object)0);
        this.getModel().setValue("contractno", (Object)"");
        this.getModel().setValue("creditlimit", null);
        this.getModel().deleteEntryData("entry_org");
        this.getModel().deleteEntryData("entry_type");
        this.getModel().deleteEntryData("entry_mult");
        if (CreditmApplyTypeEnum.ADD.getValue().equals(applyType)) {
            this.getModel().setValue("startdate", (Object)DateUtils.getCurrentDate());
            this.getModel().setValue("creditprop", (Object)CreditPropEnum.CIRCLE.getValue());
            this.getModel().setValue("isframework", (Object)false);
            this.getModel().setValue("framework", null);
            this.setDetaultOrgEntry();
            this.setDefaultTypeEntry();
        }
        this.getView().setVisible(Boolean.valueOf(!CreditmApplyTypeEnum.JOIN.getValue().equals(applyType)), new String[]{"o_singleamt"});
        if (!CreditmApplyTypeEnum.RENEWAL.getValue().equals(applyType)) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab("tabentry_org");
        }
        this.registerMustInput();
        this.getPageCache().put("applytype", applyType);
    }

    private void registerMustInput() {
        String applyType = (String)this.getModel().getValue("applytype");
        this.getView().setVisible(Boolean.valueOf(!CreditmApplyTypeEnum.JOIN.getValue().equals(applyType)), new String[]{"o_singleamt"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)CreditmApplyTypeEnum.isAddChange((String)applyType), (String[])new String[]{"totalamt", "t_credittypetext"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!CreditmApplyTypeEnum.isAdd((String)applyType) ? 1 : 0) != 0, (String[])new String[]{"creditlimit"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)CreditmApplyTypeEnum.RENEWAL.getValue().equals(applyType), (String[])new String[]{"renewalenddate"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!CreditmApplyTypeEnum.RENEWAL.getValue().equals(applyType) ? 1 : 0) != 0, (String[])new String[]{"o_orgtext"});
    }

    private void guaranteeOrgF7(BeforeF7SelectEvent evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
            parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", org.getPkValue()));
        }
    }

    private QFilter getCustomFilter(DynamicObject org, QFilter baseFilter) {
        String applyType = (String)this.getModel().getValue("applytype");
        QFilter filter = baseFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isclose", "=", (Object)"0");
        if (CreditmApplyTypeEnum.isJoin((String)applyType)) {
            filter.and(new QFilter("isgrouplimit", "=", (Object)true));
            DynamicObjectCollection limits = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id", (QFilter[])new QFilter[]{filter, new QFilter("entry_org.o_org.fbasedataid", "=", org.getPkValue())});
            Object[] limitIds = limits.stream().map(d -> d.get("id")).toArray();
            filter.and(new QFilter("id", "not in", (Object)limitIds));
        } else if (CreditmApplyTypeEnum.isRenewal((String)applyType)) {
            filter.and(new QFilter("org", "=", org.getPkValue()).or(new QFilter("entry_org.o_org.fbasedataid", "=", org.getPkValue())));
        } else if (CreditmApplyTypeEnum.isAdjust((String)applyType)) {
            filter.and(new QFilter("entry_org.o_org.fbasedataid", "=", org.getPkValue()));
        } else if (CreditmApplyTypeEnum.isChange((String)applyType)) {
            filter.and("isframework", "=", (Object)false).and("org", "=", org.getPkValue());
        }
        return filter;
    }

    private void creditlimitF7(BeforeF7SelectEvent evt) {
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        boolean checkRes = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"org", "bank", "currency"});
        if (!checkRes) {
            evt.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject bank = (DynamicObject)this.getModel().getValue("bank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        QFilter filter = new QFilter("currency", "=", currency.getPkValue());
        filter.and(this.getBankFilter(bank));
        QFilter paramFilter = this.getCustomFilter(org, filter);
        parameter.setFormId("bos_listf7");
        parameter.setCustomParam("isframework", (Object)true);
        parameter.getListFilterParameter().getQFilters().add(paramFilter);
    }

    private QFilter getBankFilter(DynamicObject bank) {
        DynamicObject finorg;
        boolean isBank;
        String bankType = (String)this.getModel().getValue("banktype");
        if (CreditFinTypeEnum.FINORG.getValue().equals(bankType) && (isBank = "0".equals((finorg = TmcDataServiceHelper.loadSingleFromCache((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"finorgtype,bank_cate")).getDynamicObject("finorgtype").get("type")))) {
            DynamicObject bankCate = finorg.getDynamicObject("bank_cate");
            return new QFilter("bank.bank_cate", "=", bankCate != null ? bankCate.getPkValue() : Long.valueOf(0L));
        }
        return new QFilter("bank", "=", bank.getPkValue());
    }

    @Override
    protected boolean isCreditLimtBill() {
        return false;
    }
}

